/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.swagger.client.api

import akka.{Done, NotUsed}
import com.lightbend.lagom.scaladsl.api.transport.Method
import com.lightbend.lagom.scaladsl.api.{Service, ServiceCall}
import play.api.libs.json._
import com.lightbend.lagom.scaladsl.api.deser.PathParamSerializer

import io.swagger.client.model.Order

trait StoreApi extends Service {


  final override def descriptor = {
    import Service._
    named("StoreApi").withCalls(
      restCall(Method.DELETE, "/store/order/:orderId", deleteOrder _), 
      restCall(Method.GET, "/store/inventory", getInventory _), 
      restCall(Method.GET, "/store/order/:orderId", getOrderById _), 
      restCall(Method.POST, "/store/order", placeOrder _)
    ).withAutoAcl(true)
  }


  /**
    * Delete purchase order by ID
    * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
    *  
    * @param orderId ID of the order that needs to be deleted 
    * @return void
    */
  def deleteOrder(orderId: String): ServiceCall[NotUsed ,Done]
  
  /**
    * Returns pet inventories by status
    * Returns a map of status codes to quantities
    * 
    * @return Map[String, Int]
    */
  def getInventory(): ServiceCall[NotUsed ,Map[String, Int]]
  
  /**
    * Find purchase order by ID
    * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
    *  
    * @param orderId ID of pet that needs to be fetched 
    * @return Order
    */
  def getOrderById(orderId: Long): ServiceCall[NotUsed ,Order]
  
  /**
    * Place an order for a pet
    * 
    *  
    * @return Order Body Parameter  order placed for purchasing the pet 
    */
  def placeOrder(): ServiceCall[Order ,Order]
  

  }

