// Code generated by main. DO NOT EDIT.

package fake

import (
	hivev1 "github.com/openshift/hive/pkg/apis/hive/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSyncSetInstances implements SyncSetInstanceInterface
type FakeSyncSetInstances struct {
	Fake *FakeHiveV1
	ns   string
}

var syncsetinstancesResource = schema.GroupVersionResource{Group: "hive.openshift.io", Version: "v1", Resource: "syncsetinstances"}

var syncsetinstancesKind = schema.GroupVersionKind{Group: "hive.openshift.io", Version: "v1", Kind: "SyncSetInstance"}

// Get takes name of the syncSetInstance, and returns the corresponding syncSetInstance object, and an error if there is any.
func (c *FakeSyncSetInstances) Get(name string, options v1.GetOptions) (result *hivev1.SyncSetInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(syncsetinstancesResource, c.ns, name), &hivev1.SyncSetInstance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSetInstance), err
}

// List takes label and field selectors, and returns the list of SyncSetInstances that match those selectors.
func (c *FakeSyncSetInstances) List(opts v1.ListOptions) (result *hivev1.SyncSetInstanceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(syncsetinstancesResource, syncsetinstancesKind, c.ns, opts), &hivev1.SyncSetInstanceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &hivev1.SyncSetInstanceList{ListMeta: obj.(*hivev1.SyncSetInstanceList).ListMeta}
	for _, item := range obj.(*hivev1.SyncSetInstanceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested syncSetInstances.
func (c *FakeSyncSetInstances) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(syncsetinstancesResource, c.ns, opts))

}

// Create takes the representation of a syncSetInstance and creates it.  Returns the server's representation of the syncSetInstance, and an error, if there is any.
func (c *FakeSyncSetInstances) Create(syncSetInstance *hivev1.SyncSetInstance) (result *hivev1.SyncSetInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(syncsetinstancesResource, c.ns, syncSetInstance), &hivev1.SyncSetInstance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSetInstance), err
}

// Update takes the representation of a syncSetInstance and updates it. Returns the server's representation of the syncSetInstance, and an error, if there is any.
func (c *FakeSyncSetInstances) Update(syncSetInstance *hivev1.SyncSetInstance) (result *hivev1.SyncSetInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(syncsetinstancesResource, c.ns, syncSetInstance), &hivev1.SyncSetInstance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSetInstance), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSyncSetInstances) UpdateStatus(syncSetInstance *hivev1.SyncSetInstance) (*hivev1.SyncSetInstance, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(syncsetinstancesResource, "status", c.ns, syncSetInstance), &hivev1.SyncSetInstance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSetInstance), err
}

// Delete takes name of the syncSetInstance and deletes it. Returns an error if one occurs.
func (c *FakeSyncSetInstances) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(syncsetinstancesResource, c.ns, name), &hivev1.SyncSetInstance{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSyncSetInstances) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(syncsetinstancesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &hivev1.SyncSetInstanceList{})
	return err
}

// Patch applies the patch and returns the patched syncSetInstance.
func (c *FakeSyncSetInstances) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *hivev1.SyncSetInstance, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(syncsetinstancesResource, c.ns, name, pt, data, subresources...), &hivev1.SyncSetInstance{})

	if obj == nil {
		return nil, err
	}
	return obj.(*hivev1.SyncSetInstance), err
}
