// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1beta1"
	"github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/clientset/scheme"
	rest "k8s.io/client-go/rest"
)

type McmV1beta1Interface interface {
	RESTClient() rest.Interface
	ClusterJoinRequestsGetter
	ClusterStatusesGetter
	ResourceViewsGetter
	WorksGetter
	WorkSetsGetter
}

// McmV1beta1Client is used to interact with features provided by the mcm.ibm.com group.
type McmV1beta1Client struct {
	restClient rest.Interface
}

func (c *McmV1beta1Client) ClusterJoinRequests() ClusterJoinRequestInterface {
	return newClusterJoinRequests(c)
}

func (c *McmV1beta1Client) ClusterStatuses(namespace string) ClusterStatusInterface {
	return newClusterStatuses(c, namespace)
}

func (c *McmV1beta1Client) ResourceViews(namespace string) ResourceViewInterface {
	return newResourceViews(c, namespace)
}

func (c *McmV1beta1Client) Works(namespace string) WorkInterface {
	return newWorks(c, namespace)
}

func (c *McmV1beta1Client) WorkSets(namespace string) WorkSetInterface {
	return newWorkSets(c, namespace)
}

// NewForConfig creates a new McmV1beta1Client for the given config.
func NewForConfig(c *rest.Config) (*McmV1beta1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &McmV1beta1Client{client}, nil
}

// NewForConfigOrDie creates a new McmV1beta1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *McmV1beta1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new McmV1beta1Client for the given RESTClient.
func New(c rest.Interface) *McmV1beta1Client {
	return &McmV1beta1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *McmV1beta1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
