---
id: release-3-0-0
title: Release Notes: 3.0.0
sidebar_label: Release Notes: 3.0.0
---

* ## Docker
* 7dfd94002 Docker: use correct MAVEN_CONFIG (#182)
* b5a0d173d Revise the usage of OpenAPI Generator online (docker image) (#73)
* e58dc2c77 Fix COPY in Dockerfile (#64)
* 9d7feaaeb Fix online generator (docker push) (#58)
* 9247cd01e Changes for Docker
* 64037ee59 update docker-related files to ues jdk8
 
* ## Plug-ins
* b6b8c0db8 \[gradle-plugin] Initial implementation (#162)  
* 0a28aad73 \[MAVEN PLUGIN] Checking for null configOptions before looking for property
* 9c79297d6 \[MAVEN PLUGIN] Use latest version in dependencies snippet
* 9e1bbe0c1 Add maven wrapper
 
* ## API Clients
* ### Ada
* edf6be8c0 \[Ada] bug fix by defining x-is-model-type when property is local to the YML file
* 9ba74f484 \[Ada] Fix GNAT project and server skeleton to avoid sending a response when an error is returned
* ea27924f5 \[Ada] changed default project/package name, to solve circular dependencies
* 6b9d38d40 remove trailing spaces in ada template
* 0de7f972f Fix the Ada server skeleton to check the authsMethods in the Shared_Instance generic package
* 4bd8fc6e8 Fix 7511: \[Ada] Client call is not correct with multiple parameters and application/x-www-urlencoded
* 3035bc629 \[Ada] Hotfix/ada model sort
* 43f0e8692 Ada code generator corrected: "=>" instead of "->".  
* 7d2b49085 \[Ada] wrong order for generated structures in models.ads files
* 2b2b85eec \[Ada] wrong JSON in POST operations

* ### C#
* 0e34bcf4e \[csharp] ctor params should always be camelCase
* 872471996 \[csharp] Support arrays of arrays for properties and models
* 1c4e6b7d4 \[csharp] Fix ToJson to work with composition and polymorphism
* ed7af73f6 \[csharp] Reference this.Configuration in client API template

* ### C++
* e796e4c36 \[C++] Add linux as a reserve keyword
* 36f69a034 remove trailing spaces in qt5 c++ templates
* f192613f1 fix string type in c++ generator
* 409015461 fix file type in qt5cpp
* a4bcb3bc7 fix datetime and map type for qt5cpp
* 23b31aba8 \[qt5cpp] Fix crash when API return a map container
* 3b031ed2b \[qt5cpp] delete callback data allocated before signal emission
* 1bb1e44d1 \[qt5cpp] Remove qt5 pro.user file
* 194722015 Qt5cpp plug memleaks part2
* 12f3661d6 Qt5cpp plug memleaks
* ea4b94842 \[qt5cpp] Add nullptr guard to prevent crash when empty model is being serialized
* 0bf430a80 Qt5cpp Add support for nested containers
* 0b3ec6b1f fix NPE with cpp qt5, add logic to avoid NPE with composed schema
* 7c734445b fix file parameter in header file (cpprest)
* 070b5c00b fix object type declaration in cpprest
* bad1885b4 \[cpprest] add parameterToString for number type with unspecified format (double)
* 73bd24db7 \[cpprest] Add support for nested vectors
* ee2eb74f7 \[qt] update Qt client
* d82499944 Adding qt project generation fix
* 9bd94b4db \[qt] Fix warning message

* ### Clojure
* d7e374504 \[Clojure] Add util method to set the api-context globally (#93)

* ### Dart
* f1638a659 \[Dart] Allow setting an accessToken for OAuth
* a5e26a44f \[Dart] - Rework Dart client generator to be flutter-compatible

* ### Elixir
* f9b2839a3 \[Elixir] Check date value before calling to_iso8601

* ### Elm
* 5a87fe695 \[elm] Fix operations with empty responses (#171)
* a5cf27b60 Fix Petstore example for Elm (#96)
* c522927d5 Fix Elm generator for polymorphism (#78)
* 7d9fb9f51 Add CI test for Elm in travis (#40)
* 769a65c95 \[Elm] Add support for array schemas
* 56a0268e3 \[elm] missing '->' in Main elm template

* ### Erlang
* c73118524 \[erlang-client] Erlang request utils
* 049eef9c5 Test erlang client, server petstore
* bcc7b788e fix erlang client compilation error

* ### Go
* acb63fd5e Fix go readme, remove resty install
* 5d8362d85 Update go client, fix double body read
* 47614bb76 Properly capitalize exported go types
* ee561fcd6 Add withXml option for Go language
* 0f6696089 \[Go] Use consistent indentation in readme  
* 72abb20f2 \[Go] Fix operation files clobbering model files. \[2.4.0]

* ### Haskell
* 34db79b9b \[haskell-http-client] update dependency versions + readme (#81)
* e45b3784f Fix NPE with Haskell client generator with OAS3 spec
* d3401396f \[haskell-http-client] remove duplicates in produces/consumes; fix pathParam paramName issue
* 4bc99b9da minor fixes to haskell http client generator
* 2d0bafb6b \[haskell-http-client] default InlineMimeTypes=true
* 9fba9c325 \[haskell-http-client] add config options: cabalPackage, cabalVersion, baseModule, requestType, configType

* ### Kotlin
* a3322fbf7 \[kotlin] Add OkHttpClient.Builder to ApiClient.
* 3c5fb1d80 \[kotlin] Add json annotation to each enum value.
* 39fa375e3 \[kotlin] Fix NPE for POST/PUT/PATCH with empty request models.
* c599906f1 Kotlin: Correct data_class.mustache to use proper property for inner enum data type
* c69925b53 \[Kotlin] Fix issues with threetenbp  
* a811a48c3 minor fix to kotlin client genrator due to merge conflict
* 914275fe7 \[kotlin] support selection of datelibrary
* a61d23265 Fixed incorrect renaming of header and query param to camel cases for Kotlin Client template

* ### Lua
* dbe78e23e \[Lua] Improve auto-generated test files
* 6c79052ac Add auto-generated Lua spec files for APIs, models
* 38a2c1dde \[Lua] Fix Rockpec
* a2410b210 Add auto-generated rockspec file to Lua API client
* df10c725a Add lua test script, minor fix to Lua API files

* ### Java
* 2e69e6c03 build.gradle should not have commas
* 1a4e5a4e5 Java client: Add constants for libraries (#163)
* 7db0201a8 Fix NPEs in Java generator (#154)
* 4d7ff8cfb JavaDoc fixes for Java/RESTEasy client (#151)
* 072ce070b resteasy: fix outer enum case (#139)
* ccd002966 \[Java] rest-assured: fix javadoc in templates
* e7410d4c8 Allow $ in java var name
* 03490e923 Fix Java binary mapping
* 70b4b55fa Fix performance linting problem with maps in Java ApiClient template
* cddcda0fe \[Java][Jersey2] Make generated client code thread safe
* 298ca8d35 use correct jackson date library when using Java 8
* 53eeb0c04 \[Java] fix connection leak on retrofit OAuth token renewal
* 61c25e711 \[Java] Fixes for retrofit
* f02332755 \[JAVA] 4709: codegen with parcelableMode fails to build if using arrays in swagger.
* 4eeb974cb \[Java][google-api-client] Fix bug with empty POST request not sending content-type
* d4543a99e \[Java][retrofit2] file upload sets filename as baseName instead of a dynamic filename
* 62a930223 \[JAVA][Rest-assured] reqSpec() method has been added into api.mustache for requests custom…
* fec0363f7 \[Java] Add back byte array enhancement
* 59ff4c198 \[Java][library: vertx] Add default value and required parameter support to vertx server temp…
* 3bd2da9a8 \[Java] Fix build warnings
* 429b96ae7 \[JAVA] equals and hashCode for models with byte[] and binary strings
* 495971c2c \[Java] use html entities in javadoc of generated code (#106)
* 82ee8656f \[java] Enum in array of array (#66)
* bf7e4e7df Java gson: add @SerializedName value as constant  (#22)
* 30c1448d7 Fix build.gradle for Java RESTEasy client
* 642c0566d \[Java] Use Rx2 Completalbe for Void Retrofit2 responses
* 72221b1cf Adding @Deprecated to retrofit2 client interfaces.
* 47111b324 \[Java] fix gson deserialize format byte
* 9e06f7063 \[Java] Fix assignment of new object instance to variable
* 006f084b5 \[Java] Allow to set values with setApiPackage(..) and setModelPackage(..)

* ### JavaScript/NodeJS
* d80e29585 Fix JS test using baseName in default value (#5)
* fe15f4690 fix toDefaultValueWithParam in JS
* 90859575e Fixing variable name typo (instane -> instance)

* ### Objective-C
* 9fb2c29a4 7644 objc deprecated afnetworking datataskwithrequest
* 5d1874028 add class as a keyword in objc generator
* 1b8df5c20 Update ObjcClientCodegen.java
* 246ed5754 restore objc reserved word: property

* ### PHP
* 3beeb4e77 \[PHP] Not-required properties now shows as nullable (#129)
* 37df59d6f \[PHP] Adjust the names (script, sample folder, generator) to lang option (#159)
* 4a5d16b23 \[PHP] Fix string length validation
* d58835e57 \[PHP] Improve: Make validation strict
* cf8d8d56f \[PHP] Fix code example from README. Variable name was missing when using Basic auth.
* 0adbf7e51 \[PHP] Improve: update sample tests automatically
* 32cf2f16f \[PHP] Non required enum property
* 3bcf0ff76 \[PHP] Add path & file separator (/) to return the correct path when deserializing a file
* 14e1e1980 \[PHP] Improve validation on empty arrays
* 809e1f4c9 \[PHP] Cleanup tests
* 76907cacd \[PHP] declare property headerSelector

* ### Python
* 7184f1ec6 \[python] asyncio supports _preload_content; remove unused imports (#107)
* d74d2ba03 fix: python clients
* 8e0a0ebd6 Fix python / tornado body handling
* b39c35c76 Fix inconsistency between model name and file name in python client
* dfbef4374 Fixed unicode error and supported allow_nonstandard_methods in tornado based python client
* f6e0e297e \[python-asyncio] tests and fixes

* ### R
* 61e58d649 Add R namespace file

* ### Ruby
* a08164592 fix ruby parameters in documentation, fix reuqiredParams, optionalParams
* 8e34f9a98 update to newer version of ruby
* aa6b217bb \[Ruby] Add auto-generated rubocop config file

* ### Rust
* b44357394 \[Rust] Implement minimal auth support
* 0b845a57e \[Rust] Changes hard coded body to dynamic parameter name -  
* a3c97753f \[Rust] Handles UUID as string
* 027df610b \[Rust] Handle error response statuses
* 66be7a791 \[Rust] Add user agent handling for rust template (master)  
* 3029b7b0f \[Rust] Format example with rustfmt

* ### Scala
* 197b4481e normalize akka-scala and Java README
* 612cfb7af \[Akka-scala] Clean unused dependencies such swagger-core
* 86697fedb \[Scala][Gatling] correct body params filename
* 832919b84 \[Scala][Akka] Remove unused dep when model package is empty

* ### Swift
* 40d5d0990 \[Swift4] accept empty content with default client
* 3b7230b17 \[Swift 4] Fix APIHelper to accept array parameter
* e22faf4cd \[Swift] Add public initializer for modelObject.
* b184fb1d9 \[Swift3] escape URL parameters
* 52f606b8d Fix Swift3 test cases and add pom.xml, travis config for iOS test
* a3d0f1d4b Swift4: make generated models structs instead of classes

* ### TypeScript
* f615d823f update ts node dependencies
* 9ac9bc0dc \[TypeScript] enhance ts import
* 009dcf009 Mark `not required` swagger properties as optional typescript properties
* bdd2c2a4e Misc typescript Angular code generation improvements
* 260375c9e Fix typescript-node generation of array type models
* d1933b5fc Fix a problem in the generation of typescript-jquery when we have enum in a query param
* 20305139b \[Feature][TypeScript] request param enum as literal unions
* 524f162e6 Use supportsES6 flag in ts compilation for language typescript-angular
* 9b8602311 \[TypeScript] Make OpenAPI Generator serialize subclasses properly (#102)
* 4bc5ffe86 \[typescript-angular] add provided in support (#120)
* ef832e715 \[Feature][TS Angular] improve docs angular import
* fc7e08346 \[TS][Fetch] Add interfaces option
* 157e6b7fa \[angular] Add option to generate tagged unions
* 7faaa091c Fix generated module imports in Aurelia APIs
* b5f0b24ba \[TS] fix object declaration in model

* ## API Servers
* ### C++
* 6fef0a7ff fix string issue with restbed generator
* a339422bd move get type declaration method to c++ restbed

* ### C#
* d9d653016 \[aspnetcore] Make the use of Swashbuckle optional (#110)
* 9a8183ab0 \[aspnetcore] Fix openapi.json location rename (#56)
* 12abfb968 \[aspnetcore] Update Dockerfile
* 866817587 \[aspnetcore] Fix string enum generation

* ### Java
* bd50d368e \[JAVA - jaxrs-reasteasy-eap] Add import to models (#179)
* 7efda597c Fix issue with useBeanValidation option in Java server generators (#160)
* 71b5de3ed Do not set contextPath for spring-boot (#104)
* b73ab0260 jaxrs-cxf-cdi: fix outer enum (#131)
* 4d7fc046f \[JaxRS] Add "validation-api" dependency in jetty (#30)
* ce930e7a6 \[Jaxrs-cxf] Add bean-level cascaded beanvalidation for pojos (@Valid)
* 386b9f432 Modify "postProcessOperations" for "jaxrs-cxf-client"  
* 5d92717dc update jaxrs to listent at port 10080
* 7c2031675 update artifict id for jaxrs datelib j8
* 88c5112f2 Adds support for returning response in jaxrs-spec interfaces
* 6bf84d5fa \[JAXRS-SPEC] Fix lowercase enums sent as uppercase
* 3a1922bc9 Fix version for "spring-boot-maven-plugin" (#85)
* 161948657 Add reactive option for Spring Boot (webflux)
* ff1178ad7 \[Java][Spring] fix missing optional query params
* 2103fadab Fix package declaration for play-framework
* 2c6380c84 fix inner item (list, map) for play framework
* e33b350c8 Fix an issue in Play Framework generator where a CSV is empty and transferred to the controllerImp with an empty item.
* 99fc27246 \[JAX-RS][Spec] Removes throws Exception.
* fe2a44339 Fixes issue  (SpringCodeGen dateLibrary "java8-localdatetime" option is ignored).
* d890d733f \[JaxRS][Java] issue with implFolder on windows, and required fields generation for containers (#88)
* c91ce17ae Feature/javaPlayWithAsynchronousControllers
* f00a1ef52 \[JAVA] Correct consumes/produces attributes for Spring Controllers
* d14318cf2 \[JAVA][Spring] Optional params with delegate
* 3f81378d7 \[java resteasy] fix string comparison (#134)
* 5ea3d3bb1 \[JAX-RS][SPEC] Bug fix that prevents generating interfaces when interfaceOnly is false.

* ### Kotlin
* 7cad47dd3 \[kotlin-server] --library=ktor (barebones implementation)
* 752b36e66 \[Kotlin] Sanitize enumeration name to add underscore when it starts with digits (#77)

* ### NodeJS
* 6d88d073c \[NodeJS] make serverPort configurable via CLI option
* e7f4fb3c4 Fix nodejs-server path issue in windows platform

* ### PHP
* d30fcbabb Fixes for php-ze-ph generator
* 60e3339aa \[Feature][PHP] Update for ze-ph generator

* ### Python
* 62b93fc5c \[Python][Flask] Handles UUID format -  
* 9999eac52 fix python flask parameter naming

* ### Scala
* d5c355a59 \[Scalatra] Updated the version of Scalatra to the latest (2.6.2)
* 52322c47c \[finch] Allow finch server to compile for CI checks (#7)

* ### Ruby
* dcad9ae80 \[Rails5] make version of the generated Rails stub server to strict Rails 5.0

* ### Rust
* 37faaf926 \[rust-server] API version constant and composite version support
* 6c7813e79 \[rust-server] asynchronous support via hyper v0.11

* ## Documentation
* 25a6a9d44 html: fix typo in class name  


* ## Miscellaneous
* f04213285 Cli error message improvements (#172)
* 0ece706a4 Remove CodegenConfig.fromModel(String, Schema) method (#90)
* 64f2bea37 Fix getReferenced...() methods in ModelUtils (#157)
* 16ff5174e Update swagger-parser to 2.0.1 (#123)
* 76b7307a6 DefaultGenerator: ignore only form param schemas (#74)
* a3aabd390 Create a default implementation of delegate if none could be autowired (#92)
* ca89af808 Switch to Java 8
* 27426f7b5 Cli generator name option, replaces 'language' options in CLI and Maven Plugin (#57)
* a1ff50241 Rename datatype to dataType in CodegenProperty (#69)
* 3b9a2a7c3 CaseFormatLambda has been added, params for Rest-assured client has been refactored (#91)
* 488910362 Set parameters allowableValues dynamically (#65)
* 2821f18b9 Meta: set version for "build-helper-maven-plugin" (#89)
* 82d9e935e Add CORS configuration to openapi-generator-online (#71)
* e3814f51d Improvements to online codegen (#55)
* 6b8079808 Consider minLength, maxLength and pattern in referenced schema (#45)
* 7c5dfbfa0 Minor improvements to OpenAPI Generator Online (#54)
* 8dd46a3fb Move online gen from jersey to spring boot (#44)
* 803821e21 Fix an issue with example generator when array is too large (#46)
* 673f2bc46 Add CodegenProperty.nameInSnakeCase  (#42)
* 67ebe17dd Fix isPrimitiveType flag for array of form parameters (#38)
* 10ac4024d Code clean-up: remove field declaration hiding existing fields (#35)
* ab9c4b5a6 Code clean-up: Add own private static final LOGGER in each class (#26)
* 41b0ff351 Code clean-up: remove DefaultCodegen#getSimpleRef(String) (#19)
* 13f084e7b Fix dataTypeWithEnum for array of form parameters
* fd3b883e8 \[DefaultCodegen] Fill CodegenOperation::produces with unique media types
* db9a899a0 update getSchemaType variable, remove unused import
* d74b4cdf8 fix map type and collection format for form parameter (array)
* d99f46cff Revise how to obtain the example value
* b1eac05b2 Fix form datatype (array of string)
* 3c666a6d4 Fix array of form parameters
* 1492df6ce Override server port for Jetty configuration
* 622a75b2c Fix data type shadowing
* 861d11d01 use vendor extension in operation to set the body parameter name
* 80c8b92cb add postProcessParamter for body, form parameter
* 7fe555a51 Set collectionFormat default only for array
* 16589de97 default collection format to csv according to the spec
* edbe4902a Consider '$ref' for consumes and produces in CodegenOperation
* e24238a35 Improve getter name handling for boolean properties
* 6e2ca294b update discriminator to discriminatorName
* 74075c087 Primitive datatype in Schema components
* d8abd4a14 support map in body parameter
* 186594115 Update swagger-core to 2.0.1
* 2034f61e5 Add HideGenerationTimestamp getter and setter in the CodegenConfig interface
* d0e2d7684 Getter and Setter for hideGenerationTimestamp
* adbde2fb6 replace fromOperation with postProcessOperations
* 9d1ae0dd2 fix bigdecimal in default codegen
* ffa0e115d fix default value and type declaration
* 0e744adb8 Apply collection format to SIMPLE enum style
* 36ed29852 Tweak tests according to the parameter order changes
* 17b082793 Move 'enum_query_double' to parameters section
* 28fcf48f4 Add a method returns discriminator name
* 7daa2ec5d Fix broken discriminator
* faa901640 Replace with the helper function: `getTypeDeclaration`
* c8650d0e3 Make optional properties in models optional parameters
* 40c30dd2f Fix inputSpec for multi module builds
* 5326152cc add option to reorder form/body parameter
* d1850091a Improve JMeter Template
* fedfb0cda Factorize addOption/addSwitch method
* e73eeb4fd fix for stripping prefix on single enums
* 13e3db59e Add operationIdOriginal to store the original operationId
* 0b2d80569 Expose getter/setter for serverPort to facilitate testing
* 8e270f465 add vendorExtensions field in CodegenSecurity class
* 1ee85de94 Added Intelli J ignore
* 7b8e409cf Added gitignore generation function
