# OpenAPI Petstore
#
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Order
#' @description Order Class
#' @format An \code{R6Class} generator object
#' @field id  integer [optional]
#'
#' @field petId  integer [optional]
#'
#' @field quantity  integer [optional]
#'
#' @field shipDate  character [optional]
#'
#' @field status  character [optional]
#'
#' @field complete  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Order <- R6::R6Class(
  'Order',
  public = list(
    `id` = NULL,
    `petId` = NULL,
    `quantity` = NULL,
    `shipDate` = NULL,
    `status` = NULL,
    `complete` = NULL,
    initialize = function(`id`=NULL, `petId`=NULL, `quantity`=NULL, `shipDate`=NULL, `status`=NULL, `complete`=FALSE, ...){
      local.optional.var <- list(...)
      if (!is.null(`id`)) {
        stopifnot(is.numeric(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!is.null(`petId`)) {
        stopifnot(is.numeric(`petId`), length(`petId`) == 1)
        self$`petId` <- `petId`
      }
      if (!is.null(`quantity`)) {
        stopifnot(is.numeric(`quantity`), length(`quantity`) == 1)
        self$`quantity` <- `quantity`
      }
      if (!is.null(`shipDate`)) {
        stopifnot(is.character(`shipDate`), length(`shipDate`) == 1)
        self$`shipDate` <- `shipDate`
      }
      if (!is.null(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
      if (!is.null(`complete`)) {
        self$`complete` <- `complete`
      }
    },
    toJSON = function() {
      OrderObject <- list()
      if (!is.null(self$`id`)) {
        OrderObject[['id']] <-
          self$`id`
      }
      if (!is.null(self$`petId`)) {
        OrderObject[['petId']] <-
          self$`petId`
      }
      if (!is.null(self$`quantity`)) {
        OrderObject[['quantity']] <-
          self$`quantity`
      }
      if (!is.null(self$`shipDate`)) {
        OrderObject[['shipDate']] <-
          self$`shipDate`
      }
      if (!is.null(self$`status`)) {
        OrderObject[['status']] <-
          self$`status`
      }
      if (!is.null(self$`complete`)) {
        OrderObject[['complete']] <-
          self$`complete`
      }

      OrderObject
    },
    fromJSON = function(OrderJson) {
      OrderObject <- jsonlite::fromJSON(OrderJson)
      if (!is.null(OrderObject$`id`)) {
        self$`id` <- OrderObject$`id`
      }
      if (!is.null(OrderObject$`petId`)) {
        self$`petId` <- OrderObject$`petId`
      }
      if (!is.null(OrderObject$`quantity`)) {
        self$`quantity` <- OrderObject$`quantity`
      }
      if (!is.null(OrderObject$`shipDate`)) {
        self$`shipDate` <- OrderObject$`shipDate`
      }
      if (!is.null(OrderObject$`status`)) {
        self$`status` <- OrderObject$`status`
      }
      if (!is.null(OrderObject$`complete`)) {
        self$`complete` <- OrderObject$`complete`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`id`)) {
        sprintf(
        '"id":
          %d
                ',
        self$`id`
        )},
        if (!is.null(self$`petId`)) {
        sprintf(
        '"petId":
          %d
                ',
        self$`petId`
        )},
        if (!is.null(self$`quantity`)) {
        sprintf(
        '"quantity":
          %d
                ',
        self$`quantity`
        )},
        if (!is.null(self$`shipDate`)) {
        sprintf(
        '"shipDate":
          "%s"
                ',
        self$`shipDate`
        )},
        if (!is.null(self$`status`)) {
        sprintf(
        '"status":
          "%s"
                ',
        self$`status`
        )},
        if (!is.null(self$`complete`)) {
        sprintf(
        '"complete":
          "%s"
                ',
        self$`complete`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(OrderJson) {
      OrderObject <- jsonlite::fromJSON(OrderJson)
      self$`id` <- OrderObject$`id`
      self$`petId` <- OrderObject$`petId`
      self$`quantity` <- OrderObject$`quantity`
      self$`shipDate` <- OrderObject$`shipDate`
      self$`status` <- OrderObject$`status`
      self$`complete` <- OrderObject$`complete`
      self
    }
  )
)
