# OpenAPI Petstore
#
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Store operations
#' @description petstore.Store
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ DeleteOrder } \emph{ Delete purchase order by ID }
#' For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
#'
#' \itemize{
#' \item \emph{ @param } order.id character
#'
#'
#' \item status code : 400 | Invalid ID supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | Order not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ GetInventory } \emph{ Returns pet inventories by status }
#' Returns a map of status codes to quantities
#'
#' \itemize{
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : map(integer) 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ GetOrderById } \emph{ Find purchase order by ID }
#' For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
#'
#' \itemize{
#' \item \emph{ @param } order.id integer
#' \item \emph{ @returnType } \link{Order} \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : Order 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Invalid ID supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | Order not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ PlaceOrder } \emph{ Place an order for a pet }
#' 
#'
#' \itemize{
#' \item \emph{ @param } body \link{Order}
#' \item \emph{ @returnType } \link{Order} \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : Order 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Invalid Order
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \donttest{
#' ####################  DeleteOrder  ####################
#'
#' library(petstore)
#' var.order.id <- 'order.id_example' # character | ID of the order that needs to be deleted
#'
#' #Delete purchase order by ID
#' api.instance <- StoreApi$new()
#'
#' result <- api.instance$DeleteOrder(var.order.id)
#'
#'
#' ####################  GetInventory  ####################
#'
#' library(petstore)
#'
#' #Returns pet inventories by status
#' api.instance <- StoreApi$new()
#'
#' #Configure API key authorization: api_key
#' api.instance$apiClient$apiKeys['api_key'] <- 'TODO_YOUR_API_KEY';
#'
#' result <- api.instance$GetInventory()
#'
#'
#' ####################  GetOrderById  ####################
#'
#' library(petstore)
#' var.order.id <- 56 # integer | ID of pet that needs to be fetched
#'
#' #Find purchase order by ID
#' api.instance <- StoreApi$new()
#'
#' result <- api.instance$GetOrderById(var.order.id)
#'
#'
#' ####################  PlaceOrder  ####################
#'
#' library(petstore)
#' var.body <- Order$new() # Order | order placed for purchasing the pet
#'
#' #Place an order for a pet
#' api.instance <- StoreApi$new()
#'
#' result <- api.instance$PlaceOrder(var.body)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @export
StoreApi <- R6::R6Class(
  'StoreApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    DeleteOrder = function(order.id, ...){
      apiResponse <- self$DeleteOrderWithHttpInfo(order.id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    DeleteOrderWithHttpInfo = function(order.id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`order.id`)) {
        stop("Missing required parameter `order.id`.")
      }

      urlPath <- "/store/order/{orderId}"
      if (!missing(`order.id`)) {
        urlPath <- gsub(paste0("\\{", "orderId", "\\}"), URLencode(as.character(`order.id`), reserved = TRUE), urlPath)
      }


      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "DELETE",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    GetInventory = function(...){
      apiResponse <- self$GetInventoryWithHttpInfo(...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetInventoryWithHttpInfo = function(...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      urlPath <- "/store/inventory"
      # API key authentication
      if ("api_key" %in% names(self$apiClient$apiKeys) && nchar(self$apiClient$apiKeys["api_key"]) > 0) {
        headerParams['api_key'] <- paste(unlist(self$apiClient$apiKeys["api_key"]), collapse='')
      }

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(integer)", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    GetOrderById = function(order.id, ...){
      apiResponse <- self$GetOrderByIdWithHttpInfo(order.id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetOrderByIdWithHttpInfo = function(order.id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`order.id`)) {
        stop("Missing required parameter `order.id`.")
      }

      urlPath <- "/store/order/{orderId}"
      if (!missing(`order.id`)) {
        urlPath <- gsub(paste0("\\{", "orderId", "\\}"), URLencode(as.character(`order.id`), reserved = TRUE), urlPath)
      }


      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "Order", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    PlaceOrder = function(body, ...){
      apiResponse <- self$PlaceOrderWithHttpInfo(body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    PlaceOrderWithHttpInfo = function(body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body <- `body`$toJSONString()
      } else {
        body <- NULL
      }

      urlPath <- "/store/order"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "Order", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    }
  )
)
