#
# OpenAPI Petstore
# 
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech
#

import httpclient
import json
import logging
import marshal
import options
import strformat
import strutils
import tables
import typetraits
import uri

import ../models/model_user

const basepath = "http://petstore.swagger.io/v2"

template constructResult[T](response: Response): untyped =
  if response.code in {Http200, Http201, Http202, Http204, Http206}:
    try:
      when name(stripGenericParams(T.typedesc).typedesc) == name(Table):
        (some(json.to(parseJson(response.body), T.typedesc)), response)
      else:
        (some(marshal.to[T](response.body)), response)
    except JsonParsingError:
      # The server returned a malformed response though the response code is 2XX
      # TODO: need better error handling
      error("JsonParsingError")
      (none(T.typedesc), response)
  else:
    (none(T.typedesc), response)


proc createUser*(httpClient: HttpClient, body: User): Response =
  ## Create user
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.post(basepath & "/user", $(%body))


proc createUsersWithArrayInput*(httpClient: HttpClient, body: seq[User]): Response =
  ## Creates list of users with given input array
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.post(basepath & "/user/createWithArray", $(%body))


proc createUsersWithListInput*(httpClient: HttpClient, body: seq[User]): Response =
  ## Creates list of users with given input array
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.post(basepath & "/user/createWithList", $(%body))


proc deleteUser*(httpClient: HttpClient, username: string): Response =
  ## Delete user
  httpClient.delete(basepath & fmt"/user/{username}")


proc getUserByName*(httpClient: HttpClient, username: string): (Option[User], Response) =
  ## Get user by user name

  let response = httpClient.get(basepath & fmt"/user/{username}")
  constructResult[User](response)


proc loginUser*(httpClient: HttpClient, username: string, password: string): (Option[string], Response) =
  ## Logs user into the system
  let query_for_api_call = encodeQuery([
    ("username", $username), # The user name for login
    ("password", $password), # The password for login in clear text
  ])

  let response = httpClient.get(basepath & "/user/login" & "?" & query_for_api_call)
  constructResult[string](response)


proc logoutUser*(httpClient: HttpClient): Response =
  ## Logs out current logged in user session
  httpClient.get(basepath & "/user/logout")


proc updateUser*(httpClient: HttpClient, username: string, body: User): Response =
  ## Updated user
  httpClient.headers["Content-Type"] = "application/json"
  httpClient.put(basepath & fmt"/user/{username}", $(%body))

