//
// UserAPI.swift
//
// Generated by openapi-generator
// https://openapi-generator.tech
//

import Foundation
import Alamofire
import RxSwift


open class UserAPI: APIBase {
    /**
     Create user
     - parameter user: (body) Created user object 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func createUser(user: User, completion: @escaping ((_ error: ErrorResponse?) -> Void)) {
        createUserWithRequestBuilder(user: user).execute { (response, error) -> Void in
            completion(error)
        }
    }

    /**
     Create user
     - parameter user: (body) Created user object 
     - returns: Observable<Void>
     */
    open class func createUser(user: User) -> Observable<Void> {
        return Observable.create { observer -> Disposable in
            createUser(user: user) { error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next())
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Create user
     - POST /user
     - This can only be done by the logged in user.
     - parameter user: (body) Created user object 
     - returns: RequestBuilder<Void> 
     */
    open class func createUserWithRequestBuilder(user: User) -> RequestBuilder<Void> {
        let path = "/user"
        let URLString = PetstoreClientAPI.basePath + path
        let parameters = user.encodeToJSON()

        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "POST", URLString: (url?.string ?? URLString), parameters: parameters, isBody: true)
    }

    /**
     Creates list of users with given input array
     - parameter user: (body) List of user object 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func createUsersWithArrayInput(user: [User], completion: @escaping ((_ error: ErrorResponse?) -> Void)) {
        createUsersWithArrayInputWithRequestBuilder(user: user).execute { (response, error) -> Void in
            completion(error)
        }
    }

    /**
     Creates list of users with given input array
     - parameter user: (body) List of user object 
     - returns: Observable<Void>
     */
    open class func createUsersWithArrayInput(user: [User]) -> Observable<Void> {
        return Observable.create { observer -> Disposable in
            createUsersWithArrayInput(user: user) { error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next())
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Creates list of users with given input array
     - POST /user/createWithArray
     - parameter user: (body) List of user object 
     - returns: RequestBuilder<Void> 
     */
    open class func createUsersWithArrayInputWithRequestBuilder(user: [User]) -> RequestBuilder<Void> {
        let path = "/user/createWithArray"
        let URLString = PetstoreClientAPI.basePath + path
        let parameters = user.encodeToJSON()

        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "POST", URLString: (url?.string ?? URLString), parameters: parameters, isBody: true)
    }

    /**
     Creates list of users with given input array
     - parameter user: (body) List of user object 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func createUsersWithListInput(user: [User], completion: @escaping ((_ error: ErrorResponse?) -> Void)) {
        createUsersWithListInputWithRequestBuilder(user: user).execute { (response, error) -> Void in
            completion(error)
        }
    }

    /**
     Creates list of users with given input array
     - parameter user: (body) List of user object 
     - returns: Observable<Void>
     */
    open class func createUsersWithListInput(user: [User]) -> Observable<Void> {
        return Observable.create { observer -> Disposable in
            createUsersWithListInput(user: user) { error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next())
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Creates list of users with given input array
     - POST /user/createWithList
     - parameter user: (body) List of user object 
     - returns: RequestBuilder<Void> 
     */
    open class func createUsersWithListInputWithRequestBuilder(user: [User]) -> RequestBuilder<Void> {
        let path = "/user/createWithList"
        let URLString = PetstoreClientAPI.basePath + path
        let parameters = user.encodeToJSON()

        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "POST", URLString: (url?.string ?? URLString), parameters: parameters, isBody: true)
    }

    /**
     Delete user
     - parameter username: (path) The name that needs to be deleted 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func deleteUser(username: String, completion: @escaping ((_ error: ErrorResponse?) -> Void)) {
        deleteUserWithRequestBuilder(username: username).execute { (response, error) -> Void in
            completion(error)
        }
    }

    /**
     Delete user
     - parameter username: (path) The name that needs to be deleted 
     - returns: Observable<Void>
     */
    open class func deleteUser(username: String) -> Observable<Void> {
        return Observable.create { observer -> Disposable in
            deleteUser(username: username) { error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next())
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Delete user
     - DELETE /user/{username}
     - This can only be done by the logged in user.
     - parameter username: (path) The name that needs to be deleted 
     - returns: RequestBuilder<Void> 
     */
    open class func deleteUserWithRequestBuilder(username: String) -> RequestBuilder<Void> {
        var path = "/user/{username}"
        let usernamePreEscape = "\(username)"
        let usernamePostEscape = usernamePreEscape.addingPercentEncoding(withAllowedCharacters: .urlPathAllowed) ?? ""
        path = path.replacingOccurrences(of: "{username}", with: usernamePostEscape, options: .literal, range: nil)
        let URLString = PetstoreClientAPI.basePath + path
        let parameters: [String:Any]? = nil
        
        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "DELETE", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }

    /**
     Get user by user name
     - parameter username: (path) The name that needs to be fetched. Use user1 for testing.  
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func getUserByName(username: String, completion: @escaping ((_ data: User?, _ error: ErrorResponse?) -> Void)) {
        getUserByNameWithRequestBuilder(username: username).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }

    /**
     Get user by user name
     - parameter username: (path) The name that needs to be fetched. Use user1 for testing.  
     - returns: Observable<User>
     */
    open class func getUserByName(username: String) -> Observable<User> {
        return Observable.create { observer -> Disposable in
            getUserByName(username: username) { data, error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next(data!))
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Get user by user name
     - GET /user/{username}
     - parameter username: (path) The name that needs to be fetched. Use user1 for testing.  
     - returns: RequestBuilder<User> 
     */
    open class func getUserByNameWithRequestBuilder(username: String) -> RequestBuilder<User> {
        var path = "/user/{username}"
        let usernamePreEscape = "\(username)"
        let usernamePostEscape = usernamePreEscape.addingPercentEncoding(withAllowedCharacters: .urlPathAllowed) ?? ""
        path = path.replacingOccurrences(of: "{username}", with: usernamePostEscape, options: .literal, range: nil)
        let URLString = PetstoreClientAPI.basePath + path
        let parameters: [String:Any]? = nil
        
        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<User>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "GET", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }

    /**
     Logs user into the system
     - parameter username: (query) The user name for login 
     - parameter password: (query) The password for login in clear text 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func loginUser(username: String, password: String, completion: @escaping ((_ data: String?, _ error: ErrorResponse?) -> Void)) {
        loginUserWithRequestBuilder(username: username, password: password).execute { (response, error) -> Void in
            completion(response?.body, error)
        }
    }

    /**
     Logs user into the system
     - parameter username: (query) The user name for login 
     - parameter password: (query) The password for login in clear text 
     - returns: Observable<String>
     */
    open class func loginUser(username: String, password: String) -> Observable<String> {
        return Observable.create { observer -> Disposable in
            loginUser(username: username, password: password) { data, error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next(data!))
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Logs user into the system
     - GET /user/login
     - responseHeaders: [X-Rate-Limit(Int32), X-Expires-After(Date)]
     - parameter username: (query) The user name for login 
     - parameter password: (query) The password for login in clear text 
     - returns: RequestBuilder<String> 
     */
    open class func loginUserWithRequestBuilder(username: String, password: String) -> RequestBuilder<String> {
        let path = "/user/login"
        let URLString = PetstoreClientAPI.basePath + path
        let parameters: [String:Any]? = nil
        
        var url = URLComponents(string: URLString)
        url?.queryItems = APIHelper.mapValuesToQueryItems(values:[
            "username": username,
            "password": password
        ])

        let requestBuilder: RequestBuilder<String>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "GET", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }

    /**
     Logs out current logged in user session
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func logoutUser(completion: @escaping ((_ error: ErrorResponse?) -> Void)) {
        logoutUserWithRequestBuilder().execute { (response, error) -> Void in
            completion(error)
        }
    }

    /**
     Logs out current logged in user session
     - returns: Observable<Void>
     */
    open class func logoutUser() -> Observable<Void> {
        return Observable.create { observer -> Disposable in
            logoutUser() { error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next())
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Logs out current logged in user session
     - GET /user/logout
     - returns: RequestBuilder<Void> 
     */
    open class func logoutUserWithRequestBuilder() -> RequestBuilder<Void> {
        let path = "/user/logout"
        let URLString = PetstoreClientAPI.basePath + path
        let parameters: [String:Any]? = nil
        
        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "GET", URLString: (url?.string ?? URLString), parameters: parameters, isBody: false)
    }

    /**
     Updated user
     - parameter username: (path) name that need to be deleted 
     - parameter user: (body) Updated user object 
     - parameter completion: completion handler to receive the data and the error objects
     */
    open class func updateUser(username: String, user: User, completion: @escaping ((_ error: ErrorResponse?) -> Void)) {
        updateUserWithRequestBuilder(username: username, user: user).execute { (response, error) -> Void in
            completion(error)
        }
    }

    /**
     Updated user
     - parameter username: (path) name that need to be deleted 
     - parameter user: (body) Updated user object 
     - returns: Observable<Void>
     */
    open class func updateUser(username: String, user: User) -> Observable<Void> {
        return Observable.create { observer -> Disposable in
            updateUser(username: username, user: user) { error in
                if let error = error {
                    observer.on(.error(error as Error))
                } else {
                    observer.on(.next())
                }
                observer.on(.completed)
            }
            return Disposables.create()
        }
    }

    /**
     Updated user
     - PUT /user/{username}
     - This can only be done by the logged in user.
     - parameter username: (path) name that need to be deleted 
     - parameter user: (body) Updated user object 
     - returns: RequestBuilder<Void> 
     */
    open class func updateUserWithRequestBuilder(username: String, user: User) -> RequestBuilder<Void> {
        var path = "/user/{username}"
        let usernamePreEscape = "\(username)"
        let usernamePostEscape = usernamePreEscape.addingPercentEncoding(withAllowedCharacters: .urlPathAllowed) ?? ""
        path = path.replacingOccurrences(of: "{username}", with: usernamePostEscape, options: .literal, range: nil)
        let URLString = PetstoreClientAPI.basePath + path
        let parameters = user.encodeToJSON()

        let url = URLComponents(string: URLString)

        let requestBuilder: RequestBuilder<Void>.Type = PetstoreClientAPI.requestBuilderFactory.getBuilder()

        return requestBuilder.init(method: "PUT", URLString: (url?.string ?? URLString), parameters: parameters, isBody: true)
    }

}
