// tslint:disable
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { Observable } from 'rxjs';
import { BaseAPI, HttpHeaders, HttpQuery, throwIfNullOrUndefined, encodeURI } from '../runtime';
import {
    User,
} from '../models';

export interface CreateUserRequest {
    body: User;
}

export interface CreateUsersWithArrayInputRequest {
    body: Array<User>;
}

export interface CreateUsersWithListInputRequest {
    body: Array<User>;
}

export interface DeleteUserRequest {
    username: string;
}

export interface GetUserByNameRequest {
    username: string;
}

export interface LoginUserRequest {
    username: string;
    password: string;
}

export interface UpdateUserRequest {
    username: string;
    body: User;
}

/**
 * no description
 */
export class UserApi extends BaseAPI {

    /**
     * This can only be done by the logged in user.
     * Create user
     */
    createUser = ({ body }: CreateUserRequest): Observable<void> => {
        throwIfNullOrUndefined(body, 'createUser');

        const headers: HttpHeaders = {
            'Content-Type': 'application/json',
        };

        return this.request<void>({
            path: '/user',
            method: 'POST',
            headers,
            body: body,
        });
    };

    /**
     * Creates list of users with given input array
     */
    createUsersWithArrayInput = ({ body }: CreateUsersWithArrayInputRequest): Observable<void> => {
        throwIfNullOrUndefined(body, 'createUsersWithArrayInput');

        const headers: HttpHeaders = {
            'Content-Type': 'application/json',
        };

        return this.request<void>({
            path: '/user/createWithArray',
            method: 'POST',
            headers,
            body: body,
        });
    };

    /**
     * Creates list of users with given input array
     */
    createUsersWithListInput = ({ body }: CreateUsersWithListInputRequest): Observable<void> => {
        throwIfNullOrUndefined(body, 'createUsersWithListInput');

        const headers: HttpHeaders = {
            'Content-Type': 'application/json',
        };

        return this.request<void>({
            path: '/user/createWithList',
            method: 'POST',
            headers,
            body: body,
        });
    };

    /**
     * This can only be done by the logged in user.
     * Delete user
     */
    deleteUser = ({ username }: DeleteUserRequest): Observable<void> => {
        throwIfNullOrUndefined(username, 'deleteUser');

        return this.request<void>({
            path: '/user/{username}'.replace('{username}', encodeURI(username)),
            method: 'DELETE',
        });
    };

    /**
     * Get user by user name
     */
    getUserByName = ({ username }: GetUserByNameRequest): Observable<User> => {
        throwIfNullOrUndefined(username, 'getUserByName');

        return this.request<User>({
            path: '/user/{username}'.replace('{username}', encodeURI(username)),
            method: 'GET',
        });
    };

    /**
     * Logs user into the system
     */
    loginUser = ({ username, password }: LoginUserRequest): Observable<string> => {
        throwIfNullOrUndefined(username, 'loginUser');
        throwIfNullOrUndefined(password, 'loginUser');

        const query: HttpQuery = { // required parameters are used directly since they are already checked by throwIfNullOrUndefined
            'username': username,
            'password': password,
        };

        return this.request<string>({
            path: '/user/login',
            method: 'GET',
            query,
        });
    };

    /**
     * Logs out current logged in user session
     */
    logoutUser = (): Observable<void> => {
        return this.request<void>({
            path: '/user/logout',
            method: 'GET',
        });
    };

    /**
     * This can only be done by the logged in user.
     * Updated user
     */
    updateUser = ({ username, body }: UpdateUserRequest): Observable<void> => {
        throwIfNullOrUndefined(username, 'updateUser');
        throwIfNullOrUndefined(body, 'updateUser');

        const headers: HttpHeaders = {
            'Content-Type': 'application/json',
        };

        return this.request<void>({
            path: '/user/{username}'.replace('{username}', encodeURI(username)),
            method: 'PUT',
            headers,
            body: body,
        });
    };

}
