# C++ Qt5 Server

## Qt5 HTTP Server based on the Qhttpengine

This server was generated by the [openapi-generator](https://openapi-generator.tech) project.
By using the [OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 1.0.0

## QHTTPEngine

[![Build Status](https://travis-ci.org/nitroshare/qhttpengine.svg?branch=master)](https://travis-ci.org/nitroshare/qhttpengine)
[![MIT License](http://img.shields.io/badge/license-MIT-blue.svg?style=flat)](http://opensource.org/licenses/MIT)

Simple set of classes for developing HTTP server applications in Qt.

### Documentation

To learn more about building and using the library, please visit this page:

[Link](https://ci.quickmediasolutions.com/job/qhttpengine-documentation/doxygen)

### Viewing the code

You can view the code using an editor like Microsoft Visual Studio Code or you can
Use QtCreator and browse for the root CMakeLists.txt and load it as a project

### Build with make

Install the tools [Linux/Debian]

```shell
sudo apt install cmake build-essential libssl-dev qtbase5-dev qtbase5-dev-tools git curl
```

To build, go to the `server` folder

```shell
make
```

To run the server

```shell
./build/src/cpp-qt5-qhttpengine-server &
```

To override the default port via the command line, provide the parameters `port` and `address` like below

```shell
cpp-qt5-qhttpengine-server --port 9080 --address 127.17.0.1
```
or

```shell
cpp-qt5-qhttpengine-server -p 9080 -a 127.17.0.1
```

#### Invoke an API

```shell
curl -X GET    http://localhost:8080/v2/store/inventory
curl -X POST   http://localhost:8080/v2/store/order   -H "Content-Type: application/json" -d "{ \"id\": 22, \"petId\": 1541, \"quantity\": 5, \"shipDate\": \"2018-06-16T18:31:43.870Z\", \"status\": \"placed\", \"complete\": \"true\" }"
curl -X GET    http://localhost:8080/v2/pet/findByStatus
curl -X GET    http://localhost:8080/v2/store/inventory
```

### Run and build with docker

Building with docker multistage
If you dont have docker install [here](https://docs.docker.com/install)
Add yourself to the docker group

```shell
docker build --network=host -t cpp-qt5-qhttpengine-server .
```

Running with docker

```shell
docker run --rm -it --name=server-container cpp-qt5-qhttpengine-server
```

#### Invoking an API

Mind the IP here

```shell
curl -X GET   http://172.17.0.2:8080/v2/store/inventory
curl -X POST  http://172.17.0.2:8080/v2/store/order -H "Content-Type: application/json" -d "{ \"id\": 22, \"petId\": 1541, \"quantity\": 5, \"shipDate\": \"2018-06-16T18:31:43.870Z\", \"status\": \"placed\", \"complete\": \"true\" }"
```

use this command to get the container IP

```shell
docker inspect server-container | grep "IPAddress"
```

To exit from the command line

```shell
Ctrl + p + q
```

To stop container

```shell
docker stop <containername>
```

or to terminate and quit

```shell
Ctrl+C
```
