/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#ifndef OAI_OAIUserApiRequest_H
#define OAI_OAIUserApiRequest_H

#include <QObject>
#include <QStringList>
#include <QMultiMap>
#include <QNetworkReply>
#include <QSharedPointer>

#include <qhttpengine/socket.h>
#include "OAIUser.h"
#include <QList>
#include <QString>
#include "OAIUserApiHandler.h"

namespace OpenAPI {

class OAIUserApiRequest : public QObject
{
    Q_OBJECT

public:
    OAIUserApiRequest(QHttpEngine::Socket *s, QSharedPointer<OAIUserApiHandler> handler);
    virtual ~OAIUserApiRequest();

    void createUserRequest();
    void createUsersWithArrayInputRequest();
    void createUsersWithListInputRequest();
    void deleteUserRequest(const QString& username);
    void getUserByNameRequest(const QString& username);
    void loginUserRequest();
    void logoutUserRequest();
    void updateUserRequest(const QString& username);
    

    void createUserResponse();
    void createUsersWithArrayInputResponse();
    void createUsersWithListInputResponse();
    void deleteUserResponse();
    void getUserByNameResponse(const OAIUser& res);
    void loginUserResponse(const QString& res);
    void logoutUserResponse();
    void updateUserResponse();
    

    void createUserError(QNetworkReply::NetworkError error_type, QString& error_str);
    void createUsersWithArrayInputError(QNetworkReply::NetworkError error_type, QString& error_str);
    void createUsersWithListInputError(QNetworkReply::NetworkError error_type, QString& error_str);
    void deleteUserError(QNetworkReply::NetworkError error_type, QString& error_str);
    void getUserByNameError(const OAIUser& res, QNetworkReply::NetworkError error_type, QString& error_str);
    void loginUserError(const QString& res, QNetworkReply::NetworkError error_type, QString& error_str);
    void logoutUserError(QNetworkReply::NetworkError error_type, QString& error_str);
    void updateUserError(QNetworkReply::NetworkError error_type, QString& error_str);
    

    void sendCustomResponse(QByteArray & res, QNetworkReply::NetworkError error_type);

    void sendCustomResponse(QIODevice *res, QNetworkReply::NetworkError error_type);

    QMap<QString, QString> getRequestHeaders() const;

    QHttpEngine::Socket* getRawSocket();

    void setResponseHeaders(const QMultiMap<QString,QString>& headers);

signals:
    void createUser(OAIUser body);
    void createUsersWithArrayInput(QList<OAIUser> body);
    void createUsersWithListInput(QList<OAIUser> body);
    void deleteUser(QString username);
    void getUserByName(QString username);
    void loginUser(QString username, QString password);
    void logoutUser();
    void updateUser(QString username, OAIUser body);
    

private:
    QMap<QString, QString> requestHeaders;
    QMap<QString, QString> responseHeaders;
    QHttpEngine::Socket  *socket;
    QSharedPointer<OAIUserApiHandler> handler;

    inline void writeResponseHeaders(){
        QHttpEngine::Socket::HeaderMap resHeaders;
        for(auto itr = responseHeaders.begin(); itr != responseHeaders.end(); ++itr) {
            resHeaders.insert(itr.key().toUtf8(), itr.value().toUtf8());
        }
        socket->setHeaders(resHeaders);
        socket->writeHeaders();
    }
};

}

#endif // OAI_OAIUserApiRequest_H
