/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package org.openapitools.server.apis

import com.google.gson.Gson
import io.ktor.application.call
import io.ktor.auth.UserIdPrincipal
import io.ktor.auth.authentication
import io.ktor.auth.authenticate
import io.ktor.auth.OAuthAccessTokenResponse
import io.ktor.auth.OAuthServerSettings
import io.ktor.http.ContentType
import io.ktor.http.HttpStatusCode
import io.ktor.locations.KtorExperimentalLocationsAPI
import io.ktor.locations.delete
import io.ktor.locations.get
import io.ktor.response.respond
import io.ktor.response.respondText
import io.ktor.routing.Route
import io.ktor.routing.post
import io.ktor.routing.put
import io.ktor.routing.route

import org.openapitools.server.Paths
import org.openapitools.server.infrastructure.ApiPrincipal


import org.openapitools.server.models.ApiResponse
import org.openapitools.server.models.Pet

@KtorExperimentalLocationsAPI
fun Route.PetApi() {
    val gson = Gson()
    val empty = mutableMapOf<String, Any?>()

    route("/pet") {
            authenticate("petstore_auth") {
        post {
            val principal = call.authentication.principal<OAuthAccessTokenResponse>()
            
            if (principal == null) {
                call.respond(HttpStatusCode.Unauthorized)
            } else {
                call.respond(HttpStatusCode.NotImplemented)
            }
        }
            }
    }


    delete<Paths.deletePet> {  _: Paths.deletePet ->
        val principal = call.authentication.principal<OAuthAccessTokenResponse>()
        
        if (principal == null) {
            call.respond(HttpStatusCode.Unauthorized)
        } else {
            call.respond(HttpStatusCode.NotImplemented)
        }
    }


    get<Paths.findPetsByStatus> {  _: Paths.findPetsByStatus ->
        val principal = call.authentication.principal<OAuthAccessTokenResponse>()
        
        if (principal == null) {
            call.respond(HttpStatusCode.Unauthorized)
        } else {
            val exampleContentType = "application/json"
            val exampleContentString = """{
              "photoUrls" : [ "photoUrls", "photoUrls" ],
              "name" : "doggie",
              "id" : 0,
              "category" : {
                "name" : "name",
                "id" : 6
              },
              "tags" : [ {
                "name" : "name",
                "id" : 1
              }, {
                "name" : "name",
                "id" : 1
              } ],
              "status" : "available"
            }"""
            
            when(exampleContentType) {
                "application/json" -> call.respond(gson.fromJson(exampleContentString, empty::class.java))
                "application/xml" -> call.respondText(exampleContentString, ContentType.Text.Xml)
                else -> call.respondText(exampleContentString)
            }
        }
    }


    get<Paths.findPetsByTags> {  _: Paths.findPetsByTags ->
        val principal = call.authentication.principal<OAuthAccessTokenResponse>()
        
        if (principal == null) {
            call.respond(HttpStatusCode.Unauthorized)
        } else {
            val exampleContentType = "application/json"
            val exampleContentString = """{
              "photoUrls" : [ "photoUrls", "photoUrls" ],
              "name" : "doggie",
              "id" : 0,
              "category" : {
                "name" : "name",
                "id" : 6
              },
              "tags" : [ {
                "name" : "name",
                "id" : 1
              }, {
                "name" : "name",
                "id" : 1
              } ],
              "status" : "available"
            }"""
            
            when(exampleContentType) {
                "application/json" -> call.respond(gson.fromJson(exampleContentString, empty::class.java))
                "application/xml" -> call.respondText(exampleContentString, ContentType.Text.Xml)
                else -> call.respondText(exampleContentString)
            }
        }
    }


    get<Paths.getPetById> {  _: Paths.getPetById ->
        val principal = call.authentication.principal<ApiPrincipal>()
        
        if (principal == null) {
            call.respond(HttpStatusCode.Unauthorized)
        } else {
            val exampleContentType = "application/json"
            val exampleContentString = """{
              "photoUrls" : [ "photoUrls", "photoUrls" ],
              "name" : "doggie",
              "id" : 0,
              "category" : {
                "name" : "name",
                "id" : 6
              },
              "tags" : [ {
                "name" : "name",
                "id" : 1
              }, {
                "name" : "name",
                "id" : 1
              } ],
              "status" : "available"
            }"""
            
            when(exampleContentType) {
                "application/json" -> call.respond(gson.fromJson(exampleContentString, empty::class.java))
                "application/xml" -> call.respondText(exampleContentString, ContentType.Text.Xml)
                else -> call.respondText(exampleContentString)
            }
        }
    }


    route("/pet") {
            authenticate("petstore_auth") {
        put {
            val principal = call.authentication.principal<OAuthAccessTokenResponse>()
            
            if (principal == null) {
                call.respond(HttpStatusCode.Unauthorized)
            } else {
                call.respond(HttpStatusCode.NotImplemented)
            }
        }
            }
    }


    route("/pet/{petId}") {
            authenticate("petstore_auth") {
        post {
            val principal = call.authentication.principal<OAuthAccessTokenResponse>()
            
            if (principal == null) {
                call.respond(HttpStatusCode.Unauthorized)
            } else {
                call.respond(HttpStatusCode.NotImplemented)
            }
        }
            }
    }


    route("/pet/{petId}/uploadImage") {
            authenticate("petstore_auth") {
        post {
            val principal = call.authentication.principal<OAuthAccessTokenResponse>()
            
            if (principal == null) {
                call.respond(HttpStatusCode.Unauthorized)
            } else {
                val exampleContentType = "application/json"
                val exampleContentString = """{
                  "code" : 0,
                  "type" : "type",
                  "message" : "message"
                }"""
                
                when(exampleContentType) {
                    "application/json" -> call.respond(gson.fromJson(exampleContentString, empty::class.java))
                    "application/xml" -> call.respondText(exampleContentString, ContentType.Text.Xml)
                    else -> call.respondText(exampleContentString)
                }
            }
        }
            }
    }

}
