<?php

/**
 * AbstractFakeApi
 *
 * PHP version 7.1
 *
 * @package OpenAPIServer\Api
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */
namespace OpenAPIServer\Api;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Exception;

/**
 * AbstractFakeApi Class Doc Comment
 *
 * @package OpenAPIServer\Api
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */
abstract class AbstractFakeApi
{

    /**
     * @var ContainerInterface|null Slim app container instance
     */
    protected $container;

    /**
     * Route Controller constructor receives container
     *
     * @param ContainerInterface|null $container Slim app container instance
     */
    public function __construct(ContainerInterface $container = null)
    {
        $this->container = $container;
    }


    /**
     * POST createXmlItem
     * Summary: creates an XmlItem
     * Notes: this route creates an XmlItem
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function createXmlItem(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing createXmlItem as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * POST fakeOuterBooleanSerialize
     * Notes: Test serialization of outer boolean types
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterBooleanSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterBooleanSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * POST fakeOuterCompositeSerialize
     * Notes: Test serialization of object with outer number type
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterCompositeSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterCompositeSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * POST fakeOuterNumberSerialize
     * Notes: Test serialization of outer number types
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterNumberSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterNumberSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * POST fakeOuterStringSerialize
     * Notes: Test serialization of outer string types
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterStringSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterStringSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * PUT testBodyWithFileSchema
     * Notes: For this test, the body for this request much reference a schema named &#x60;File&#x60;.
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testBodyWithFileSchema(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing testBodyWithFileSchema as a PUT method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * PUT testBodyWithQueryParams
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testBodyWithQueryParams(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $queryParams = $request->getQueryParams();
        $query = (key_exists('query', $queryParams)) ? $queryParams['query'] : null;
        $body = $request->getParsedBody();
        $message = "How about implementing testBodyWithQueryParams as a PUT method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * PATCH testClientModel
     * Summary: To test \&quot;client\&quot; model
     * Notes: To test \&quot;client\&quot; model
     * Output-Formats: [application/json]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testClientModel(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing testClientModel as a PATCH method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * POST testEndpointParameters
     * Summary: Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     * Notes: Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testEndpointParameters(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $integer = (isset($body['integer'])) ? $body['integer'] : null;
        $int32 = (isset($body['int32'])) ? $body['int32'] : null;
        $int64 = (isset($body['int64'])) ? $body['int64'] : null;
        $number = (isset($body['number'])) ? $body['number'] : null;
        $float = (isset($body['float'])) ? $body['float'] : null;
        $double = (isset($body['double'])) ? $body['double'] : null;
        $string = (isset($body['string'])) ? $body['string'] : null;
        $patternWithoutDelimiter = (isset($body['pattern_without_delimiter'])) ? $body['pattern_without_delimiter'] : null;
        $byte = (isset($body['byte'])) ? $body['byte'] : null;
        $binary = (isset($body['binary'])) ? $body['binary'] : null;
        $date = (isset($body['date'])) ? $body['date'] : null;
        $dateTime = (isset($body['dateTime'])) ? $body['dateTime'] : null;
        $password = (isset($body['password'])) ? $body['password'] : null;
        $callback = (isset($body['callback'])) ? $body['callback'] : null;
        $message = "How about implementing testEndpointParameters as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * GET testEnumParameters
     * Summary: To test enum parameters
     * Notes: To test enum parameters
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testEnumParameters(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $headers = $request->getHeaders();
        $enumHeaderStringArray = $request->hasHeader('enum_header_string_array') ? $headers['enum_header_string_array'] : null;
        $enumHeaderString = $request->hasHeader('enum_header_string') ? $headers['enum_header_string'] : null;
        $queryParams = $request->getQueryParams();
        $enumQueryStringArray = (key_exists('enum_query_string_array', $queryParams)) ? $queryParams['enum_query_string_array'] : null;
        $enumQueryString = (key_exists('enum_query_string', $queryParams)) ? $queryParams['enum_query_string'] : null;
        $enumQueryInteger = (key_exists('enum_query_integer', $queryParams)) ? $queryParams['enum_query_integer'] : null;
        $enumQueryDouble = (key_exists('enum_query_double', $queryParams)) ? $queryParams['enum_query_double'] : null;
        $body = $request->getParsedBody();
        $enumFormStringArray = (isset($body['enum_form_string_array'])) ? $body['enum_form_string_array'] : null;
        $enumFormString = (isset($body['enum_form_string'])) ? $body['enum_form_string'] : null;
        $message = "How about implementing testEnumParameters as a GET method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * DELETE testGroupParameters
     * Summary: Fake endpoint to test group parameters (optional)
     * Notes: Fake endpoint to test group parameters (optional)
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testGroupParameters(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $headers = $request->getHeaders();
        $requiredBooleanGroup = $request->hasHeader('required_boolean_group') ? $headers['required_boolean_group'] : null;
        $booleanGroup = $request->hasHeader('boolean_group') ? $headers['boolean_group'] : null;
        $queryParams = $request->getQueryParams();
        $requiredStringGroup = (key_exists('required_string_group', $queryParams)) ? $queryParams['required_string_group'] : null;
        $requiredInt64Group = (key_exists('required_int64_group', $queryParams)) ? $queryParams['required_int64_group'] : null;
        $stringGroup = (key_exists('string_group', $queryParams)) ? $queryParams['string_group'] : null;
        $int64Group = (key_exists('int64_group', $queryParams)) ? $queryParams['int64_group'] : null;
        $message = "How about implementing testGroupParameters as a DELETE method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * POST testInlineAdditionalProperties
     * Summary: test inline additionalProperties
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testInlineAdditionalProperties(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing testInlineAdditionalProperties as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * GET testJsonFormData
     * Summary: test json serialization of form data
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testJsonFormData(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $param = (isset($body['param'])) ? $body['param'] : null;
        $param2 = (isset($body['param2'])) ? $body['param2'] : null;
        $message = "How about implementing testJsonFormData as a GET method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }

    /**
     * PUT testQueryParameterCollectionFormat
     * Notes: To test the collection format in query parameters
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testQueryParameterCollectionFormat(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $queryParams = $request->getQueryParams();
        $pipe = (key_exists('pipe', $queryParams)) ? $queryParams['pipe'] : null;
        $ioutil = (key_exists('ioutil', $queryParams)) ? $queryParams['ioutil'] : null;
        $http = (key_exists('http', $queryParams)) ? $queryParams['http'] : null;
        $url = (key_exists('url', $queryParams)) ? $queryParams['url'] : null;
        $context = (key_exists('context', $queryParams)) ? $queryParams['context'] : null;
        $message = "How about implementing testQueryParameterCollectionFormat as a PUT method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        $response->getBody()->write($message);
        return $response->withStatus(501);
    }
}
