<?php

/**
 * FormatTest
 *
 * PHP version 7.1
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 */
namespace OpenAPIServer\Model;

use OpenAPIServer\Interfaces\ModelInterface;

/**
 * FormatTest
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */
class FormatTest implements ModelInterface
{
    private const MODEL_SCHEMA = <<<'SCHEMA'
{
  "required" : [ "byte", "date", "number", "password" ],
  "type" : "object",
  "properties" : {
    "integer" : {
      "maximum" : 1E+2,
      "minimum" : 1E+1,
      "type" : "integer"
    },
    "int32" : {
      "maximum" : 2E+2,
      "minimum" : 2E+1,
      "type" : "integer",
      "format" : "int32"
    },
    "int64" : {
      "type" : "integer",
      "format" : "int64"
    },
    "number" : {
      "maximum" : 543.2,
      "minimum" : 32.1,
      "type" : "number"
    },
    "float" : {
      "maximum" : 987.6,
      "minimum" : 54.3,
      "type" : "number",
      "format" : "float"
    },
    "double" : {
      "maximum" : 123.4,
      "minimum" : 67.8,
      "type" : "number",
      "format" : "double"
    },
    "string" : {
      "pattern" : "/[a-z]/i",
      "type" : "string"
    },
    "byte" : {
      "pattern" : "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$",
      "type" : "string",
      "format" : "byte"
    },
    "binary" : {
      "type" : "string",
      "format" : "binary"
    },
    "date" : {
      "type" : "string",
      "format" : "date"
    },
    "dateTime" : {
      "type" : "string",
      "format" : "date-time"
    },
    "uuid" : {
      "type" : "string",
      "format" : "uuid",
      "example" : "72f98069-206d-4f12-9f12-3d1e525a8e84"
    },
    "password" : {
      "maxLength" : 64,
      "minLength" : 10,
      "type" : "string",
      "format" : "password"
    },
    "BigDecimal" : {
      "type" : "string",
      "format" : "number"
    }
  }
}
SCHEMA;

    /** @var int $integer */
    private $integer;

    /** @var int $int32 */
    private $int32;

    /** @var int $int64 */
    private $int64;

    /** @var float $number */
    private $number;

    /** @var float $float */
    private $float;

    /** @var double $double */
    private $double;

    /** @var string $string */
    private $string;

    /** @var string $byte */
    private $byte;

    /** @var \SplFileObject $binary */
    private $binary;

    /** @var \DateTime $date */
    private $date;

    /** @var \DateTime $dateTime */
    private $dateTime;

    /** @var string $uuid */
    private $uuid;

    /** @var string $password */
    private $password;

    /** @var BigDecimal $bigDecimal */
    private $bigDecimal;

    /**
     * Returns model schema.
     *
     * @param bool $assoc When TRUE, returned objects will be converted into associative arrays. Default FALSE.
     *
     * @return array
     */
    public static function getOpenApiSchema($assoc = false)
    {
        return json_decode(static::MODEL_SCHEMA, $assoc);
    }
}
