/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.swagger.client.api

import akka.{Done, NotUsed}
import com.lightbend.lagom.scaladsl.api.transport.Method
import com.lightbend.lagom.scaladsl.api.{Service, ServiceCall}
import play.api.libs.json._
import com.lightbend.lagom.scaladsl.api.deser.PathParamSerializer

import io.swagger.client.model.ApiResponse
import java.io.File
import io.swagger.client.model.Pet

trait PetApi extends Service {


  final override def descriptor = {
    import Service._
    named("PetApi").withCalls(
      restCall(Method.POST, "/pet", addPet _), 
      restCall(Method.DELETE, "/pet/:petId", deletePet _), 
      restCall(Method.GET, "/pet/findByStatus?status", findPetsByStatus _), 
      restCall(Method.GET, "/pet/findByTags?tags", findPetsByTags _), 
      restCall(Method.GET, "/pet/:petId", getPetById _), 
      restCall(Method.PUT, "/pet", updatePet _), 
      restCall(Method.POST, "/pet/:petId", updatePetWithForm _), 
      restCall(Method.POST, "/pet/:petId/uploadImage", uploadFile _)
    ).withAutoAcl(true)
  }


  /**
    * Add a new pet to the store
    * 
    *  
    * @return void Body Parameter  Pet object that needs to be added to the store 
    */
  def addPet(): ServiceCall[Pet ,Done]
  

  // apiKey:String  -- not yet supported heder params
  /**
    * Deletes a pet
    * 
    *  
    * @param petId Pet id to delete  
    * @param apiKey  (optional)
    * @return void
    */
  def deletePet(petId: Long): ServiceCall[NotUsed ,Done]
        
  // status:Seq[String]  -- not yet supported Seq PathParamSerializers for multi value query parameters https://github.com/lagom/lagom/issues/643
      
  /**
    * Finds Pets by status
    * Multiple status values can be provided with comma separated strings
    *  
    * @param status Status values that need to be considered for filter 
    * @return Seq[Pet]
    */
  def findPetsByStatus(status: Option[PetApiStatusEnum.PetApiStatusEnum]): ServiceCall[NotUsed ,Seq[Pet]]
        
  // tags:Seq[String]  -- not yet supported Seq PathParamSerializers for multi value query parameters https://github.com/lagom/lagom/issues/643
      
  /**
    * Finds Pets by tags
    * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
    *  
    * @param tags Tags to filter by 
    * @return Seq[Pet]
    */
  def findPetsByTags(): ServiceCall[NotUsed ,Seq[Pet]]
  
  /**
    * Find pet by ID
    * Returns a single pet
    *  
    * @param petId ID of pet to return 
    * @return Pet
    */
  def getPetById(petId: Long): ServiceCall[NotUsed ,Pet]
  
  /**
    * Update an existing pet
    * 
    *  
    * @return void Body Parameter  Pet object that needs to be added to the store 
    */
  def updatePet(): ServiceCall[Pet ,Done]
  

  // name:String  -- not yet supported x-www-form-urlencoded
  // status:String  -- not yet supported x-www-form-urlencoded
  /**
    * Updates a pet in the store with form data
    * 
    *  
    * @param petId ID of pet that needs to be updated  
    * @param name Updated name of the pet (optional) 
    * @param status Updated status of the pet (optional)
    * @return void
    */
  def updatePetWithForm(petId: Long): ServiceCall[NotUsed ,Done]
  

  // additionalMetadata:String  -- not yet supported x-www-form-urlencoded
  // file:File  -- not yet supported x-www-form-urlencoded
  /**
    * uploads an image
    * 
    *  
    * @param petId ID of pet to update  
    * @param additionalMetadata Additional data to pass to server (optional) 
    * @param file file to upload (optional)
    * @return ApiResponse
    */
  def uploadFile(petId: Long): ServiceCall[NotUsed ,ApiResponse]
  

        object PetApiStatusEnum extends Enumeration {
        val   available, pending, sold = Value     
        type PetApiStatusEnum = Value
        implicit val format: Format[Value] = Format(Reads.enumNameReads(this), Writes.enumNameWrites[PetApiStatusEnum.type])
        implicit val pathParamSerializer: PathParamSerializer[PetApiStatusEnum] = PathParamSerializer.required("PetApiStatusEnum")(withName)(_.toString)
        }
  }

