/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 */


package org.openapitools.server.api

import org.openapitools.server.model.Order

import java.io.File

import org.scalatra.ScalatraServlet
import org.scalatra.swagger._
import org.json4s._
import org.json4s.JsonDSL._
import org.scalatra.json.{ JValueResult, JacksonJsonSupport }
import org.scalatra.servlet.{ FileUploadSupport, MultipartConfig, SizeConstraintExceededException }

import scala.collection.JavaConverters._

class StoreApi(implicit val swagger: Swagger) extends ScalatraServlet
  with FileUploadSupport
  with JacksonJsonSupport
  with SwaggerSupport {
  protected implicit val jsonFormats: Formats = DefaultFormats

  protected val applicationDescription: String = "StoreApi"

  before() {
    contentType = formats("json")
    response.headers += ("Access-Control-Allow-Origin" -> "*")
  }
  

  val deleteOrderOperation = (apiOperation[Unit]("deleteOrder")
    summary "Delete purchase order by ID"
    parameters(pathParam[String]("orderId").description(""))
  )

  delete("/store/order/:orderId", operation(deleteOrderOperation)) {
    val orderId = params.getOrElse("orderId", halt(400))
    //println("orderId: " + orderId)
  }

  

  val getInventoryOperation = (apiOperation[Map[String, Int]]("getInventory")
    summary "Returns pet inventories by status"
    parameters()
  )

  get("/store/inventory", operation(getInventoryOperation)) {
  }

  

  val getOrderByIdOperation = (apiOperation[Order]("getOrderById")
    summary "Find purchase order by ID"
    parameters(pathParam[Long]("orderId").description(""))
  )

  get("/store/order/:orderId", operation(getOrderByIdOperation)) {
    val orderId = params.getOrElse("orderId", halt(400))
    //println("orderId: " + orderId)
  }

  

  val placeOrderOperation = (apiOperation[Order]("placeOrder")
    summary "Place an order for a pet"
    parameters(bodyParam[Order]("order").description(""))
  )

  post("/store/order", operation(placeOrderOperation)) {
    //println("order: " + order)
  }

}
