// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetPullRequestInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPullRequestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPullRequestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPullRequestInput"}

	if s.PullRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PullRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetPullRequestOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified pull request.
	//
	// PullRequest is a required field
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetPullRequestOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPullRequest = "GetPullRequest"

// GetPullRequestRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Gets information about a pull request in a specified repository.
//
//    // Example sending a request using GetPullRequestRequest.
//    req := client.GetPullRequestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest
func (c *Client) GetPullRequestRequest(input *GetPullRequestInput) GetPullRequestRequest {
	op := &aws.Operation{
		Name:       opGetPullRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPullRequestInput{}
	}

	req := c.newRequest(op, input, &GetPullRequestOutput{})
	return GetPullRequestRequest{Request: req, Input: input, Copy: c.GetPullRequestRequest}
}

// GetPullRequestRequest is the request type for the
// GetPullRequest API operation.
type GetPullRequestRequest struct {
	*aws.Request
	Input *GetPullRequestInput
	Copy  func(*GetPullRequestInput) GetPullRequestRequest
}

// Send marshals and sends the GetPullRequest API request.
func (r GetPullRequestRequest) Send(ctx context.Context) (*GetPullRequestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPullRequestResponse{
		GetPullRequestOutput: r.Request.Data.(*GetPullRequestOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPullRequestResponse is the response type for the
// GetPullRequest API operation.
type GetPullRequestResponse struct {
	*GetPullRequestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPullRequest request.
func (r *GetPullRequestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
