---
title: Config Options for eiffel
sidebar_label: eiffel
---

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|hideGenerationTimestamp|Hides the generation timestamp when files are generated.| |true|
|packageName|Eiffel Cluster name (convention: lowercase).| |openapi|
|packageVersion|Eiffel package version.| |1.0.0|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |
|Array|java.util.List|
|ArrayList|java.util.ArrayList|
|BigDecimal|java.math.BigDecimal|
|Date|java.util.Date|
|DateTime|org.joda.time.*|
|File|java.io.File|
|HashMap|java.util.HashMap|
|List|java.util.*|
|LocalDate|org.joda.time.*|
|LocalDateTime|org.joda.time.*|
|LocalTime|org.joda.time.*|
|Map|java.util.Map|
|Set|java.util.*|
|Timestamp|java.sql.Timestamp|
|URI|java.net.URI|
|UUID|java.util.UUID|


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |
|array|ARRAYED_LIST|
|list|ARRAYED_LIST|
|map|STRING_TABLE|


## LANGUAGE PRIMITIVES

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>BOOLEAN</li>
<li>INTEGER_16</li>
<li>INTEGER_32</li>
<li>INTEGER_64</li>
<li>INTEGER_8</li>
<li>NATURAL_16</li>
<li>NATURAL_32</li>
<li>NATURAL_64</li>
<li>NATURAL_8</li>
<li>REAL_32</li>
<li>REAL_64</li>
</ul>

## RESERVED WORDS

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>across</li>
<li>agent</li>
<li>alias</li>
<li>all</li>
<li>and</li>
<li>as</li>
<li>assign</li>
<li>attribute</li>
<li>check</li>
<li>class</li>
<li>convert</li>
<li>create</li>
<li>current</li>
<li>debug</li>
<li>deferred</li>
<li>do</li>
<li>else</li>
<li>elseif</li>
<li>end</li>
<li>ensure</li>
<li>expanded</li>
<li>export</li>
<li>external</li>
<li>false</li>
<li>feature</li>
<li>from</li>
<li>frozen</li>
<li>if</li>
<li>implies</li>
<li>inherit</li>
<li>inspect</li>
<li>invariant</li>
<li>like</li>
<li>local</li>
<li>loop</li>
<li>not</li>
<li>note</li>
<li>obsolete</li>
<li>old</li>
<li>once</li>
<li>only</li>
<li>or</li>
<li>precursor</li>
<li>redefine</li>
<li>rename</li>
<li>require</li>
<li>rescue</li>
<li>result</li>
<li>retry</li>
<li>select</li>
<li>separate</li>
<li>then</li>
<li>true</li>
<li>tuple</li>
<li>undefine</li>
<li>until</li>
<li>variant</li>
<li>void</li>
<li>when</li>
<li>xor</li>
</ul>
