# Swagger Petstore Ada Client

## Overview

This Ada client uses the Petstore API to demonstrate how to use the generator
and use the generated Ada code.  The following files are generated by
[Swagger Codegen](https://github.com/swagger-api/swagger-codegen):

* src/client/samples-petstore-models.ads
* src/client/samples-petstore-models.adb
* src/client/samples-petstore-clients.ads
* src/client/samples-petstore-clients.adb

The 'Models' package contains the definition of types used by the request or response
in the API operations.   It also provides operations to serialize and deserialize these
objects in JSON, XML or form-based data streams.

The 'Clients' package contains the definition of operations provided by the Petstore API.

## Requirements.

To build this sample, you must have installed the GNAT Ada compiler as well the following libraries:

* Ada Util      (https://github.com/stcarrez/ada-util)
* Swagger Ada   (https://github.com/stcarrez/swagger-ada)
* AWS           (http://libre.adacore.com/libre/tools/aws/)

## Building the petstore client

Build the petstore client by using the following command:
```sh
gprbuild -Ppetstore -p
```

## Using the Swagger Ada code

### Initialization

The HTTP/REST support is provided by [Ada Util](https://github.com/stcarrez/ada-util)
and encapsulated by [Swagger Ada](https://github.com/stcarrez/swagger-ada).  If you want
to use Curl, you should initialize with the following:

```
   Util.Http.Clients.Curl.Register;
```

But if you want to use [AWS](http://libre.adacore.com/libre/tools/aws/), you will initialize with:


```
   Util.Http.Clients.Web.Register;
```

After the initialization is done, you will declare a client instance to access
the API operations:

```
   C : Samples.Petstore.Clients.Client_Type;
```

The 'Client_Type' is the generated type that will implement the operations
described in the OpenAPI description file.

And you should initialize the server base URI you want to connect to:

```
  C.Set_Server ("http://petstore.swagger.io/v2");
```

At this stage, you can use the generated operation.

### Calling an operation

Let's retrieve some pet information by calling the 'Get_Pet_By_Id' operation.
This operation needs an integer as input parameter and returns a 'Pet_Type'
object that contains all the pet information.   You will first declare
the pet instance as follows:

```
  Pet  : Samples.Petstore.Models.Pet_Type;
```

And then call the 'Get_Pet_By_Id' operation:

```
  C.Get_Pet_By_Id (768, Pet);
```

At this stage, you can access information from the 'Pet' instance:

```
  Ada.Text_IO.Put_Line ("Id      : " & Swagger.Long'Image (Pet.Id));
  Ada.Text_IO.Put_Line ("Name    : " & Swagger.To_String (Pet.Name));
  Ada.Text_IO.Put_Line ("Status  : " & Swagger.To_String (Pet.Status));
```
