/*
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the OAS code generator program.
 * https://github.com/OpenAPITools/openapi-generator
 * Do not edit the class manually.
 */

public class OASPetApi {
    OASClient client;

    public OASPetApi(OASClient client) {
        this.client = client;
    }

    public OASPetApi() {
        this.client = new OASClient();
    }

    public OASClient getClient() {
        return this.client;
    }

    /**
     * Add a new pet to the store
     * 
     * @param body Pet object that needs to be added to the store (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void addPet(Map<String, Object> params) {
        client.assertNotNull(params.get('body'), 'body');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'POST', '/pet',
            (OASPet) params.get('body'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/json', 'application/xml' },
            new List<String> { 'petstore_auth' },
            null
        );
    }
    /**
     * Deletes a pet
     * 
     * @param petId Pet id to delete (required)
     * @param apiKey  (optional)
     * @throws OAS.ApiException if fails to make API call
     */
    public void deletePet(Map<String, Object> params) {
        client.assertNotNull(params.get('petId'), 'petId');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'DELETE', '/pet/{petId}', '',
            query, form,
            new Map<String, Object>{
                'petId' => (Long) params.get('petId')
            },
            new Map<String, Object>{
                'api_key' => (String) params.get('apiKey')
            },
            new List<String>(),
            new List<String>(),
            new List<String> { 'petstore_auth' },
            null
        );
    }
    /**
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter (required)
     * @return List<OASPet>
     * @throws OAS.ApiException if fails to make API call
     */
    public List<OASPet> findPetsByStatus(Map<String, Object> params) {
        client.assertNotNull(params.get('status'), 'status');
        List<OAS.Param> query = new List<OAS.Param>();

        // cast query params to verify their expected type
        query.addAll(client.makeParam('status', (List<String>) params.get('status'), 'csv'));

        List<OAS.Param> form = new List<OAS.Param>();

        return (List<OASPet>) client.invoke(
            'GET', '/pet/findByStatus', '',
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>(),
            new List<String> { 'petstore_auth' },
            List<OASPet>.class
        );
    }
    /**
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by (required)
     * @return List<OASPet>
     * @throws OAS.ApiException if fails to make API call
     */
    public List<OASPet> findPetsByTags(Map<String, Object> params) {
        client.assertNotNull(params.get('tags'), 'tags');
        List<OAS.Param> query = new List<OAS.Param>();

        // cast query params to verify their expected type
        query.addAll(client.makeParam('tags', (List<String>) params.get('tags'), 'csv'));

        List<OAS.Param> form = new List<OAS.Param>();

        return (List<OASPet>) client.invoke(
            'GET', '/pet/findByTags', '',
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>(),
            new List<String> { 'petstore_auth' },
            List<OASPet>.class
        );
    }
    /**
     * Find pet by ID
     * Returns a single pet
     * @param petId ID of pet to return (required)
     * @return OASPet
     * @throws OAS.ApiException if fails to make API call
     */
    public OASPet getPetById(Map<String, Object> params) {
        client.assertNotNull(params.get('petId'), 'petId');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        return (OASPet) client.invoke(
            'GET', '/pet/{petId}', '',
            query, form,
            new Map<String, Object>{
                'petId' => (Long) params.get('petId')
            },
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>(),
            new List<String> { 'api_key' },
            OASPet.class
        );
    }
    /**
     * Update an existing pet
     * 
     * @param body Pet object that needs to be added to the store (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void updatePet(Map<String, Object> params) {
        client.assertNotNull(params.get('body'), 'body');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'PUT', '/pet',
            (OASPet) params.get('body'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/json', 'application/xml' },
            new List<String> { 'petstore_auth' },
            null
        );
    }
    /**
     * Updates a pet in the store with form data
     * 
     * @param petId ID of pet that needs to be updated (required)
     * @param name Updated name of the pet (optional)
     * @param status Updated status of the pet (optional)
     * @throws OAS.ApiException if fails to make API call
     */
    public void updatePetWithForm(Map<String, Object> params) {
        client.assertNotNull(params.get('petId'), 'petId');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        // cast form params to verify their expected type
        form.addAll(client.makeParam('name', (String) params.get('name')));
        form.addAll(client.makeParam('status', (String) params.get('status')));

        client.invoke(
            'POST', '/pet/{petId}', '',
            query, form,
            new Map<String, Object>{
                'petId' => (Long) params.get('petId')
            },
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/x-www-form-urlencoded' },
            new List<String> { 'petstore_auth' },
            null
        );
    }
    /**
     * uploads an image
     * 
     * @param petId ID of pet to update (required)
     * @param additionalMetadata Additional data to pass to server (optional)
     * @param file file to upload (optional)
     * @return OASApiResponse
     * @throws OAS.ApiException if fails to make API call
     */
    public OASApiResponse uploadFile(Map<String, Object> params) {
        client.assertNotNull(params.get('petId'), 'petId');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        // cast form params to verify their expected type
        form.addAll(client.makeParam('additionalMetadata', (String) params.get('additionalMetadata')));
        form.addAll(client.makeParam('file', (Blob) params.get('file')));

        return (OASApiResponse) client.invoke(
            'POST', '/pet/{petId}/uploadImage', '',
            query, form,
            new Map<String, Object>{
                'petId' => (Long) params.get('petId')
            },
            new Map<String, Object>(),
            new List<String>{ 'application/json' },
            new List<String>{ 'multipart/form-data' },
            new List<String> { 'petstore_auth' },
            OASApiResponse.class
        );
    }
}
