# openapi
This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

This Dart package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Build package: org.openapitools.codegen.languages.DartDioClientCodegen

## Requirements

Dart 1.20.0 or later OR Flutter 0.0.20 or later

## Installation & Usage

### Github
If this Dart package is published to Github, please include the following in pubspec.yaml
```
name: openapi
version: 1.0.0
description: OpenAPI API client
dependencies:
  openapi:
    git: https://github.com/GIT_USER_ID/GIT_REPO_ID.git
      version: 'any'
```

### Local
To use the package in your local drive, please include the following in pubspec.yaml
```
dependencies:
  openapi:
    path: /path/to/openapi
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```dart
import 'package:openapi/api.dart';


var api_instance = new PetApi();
var body = new Pet(); // Pet | Pet object that needs to be added to the store

try {
    api_instance.addPet(body);
} catch (e) {
    print("Exception when calling PetApi->addPet: $e\n");
}

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApi* | [**addPet**](doc//PetApi.md#addpet) | **post** /pet | Add a new pet to the store
*PetApi* | [**deletePet**](doc//PetApi.md#deletepet) | **delete** /pet/{petId} | Deletes a pet
*PetApi* | [**findPetsByStatus**](doc//PetApi.md#findpetsbystatus) | **get** /pet/findByStatus | Finds Pets by status
*PetApi* | [**findPetsByTags**](doc//PetApi.md#findpetsbytags) | **get** /pet/findByTags | Finds Pets by tags
*PetApi* | [**getPetById**](doc//PetApi.md#getpetbyid) | **get** /pet/{petId} | Find pet by ID
*PetApi* | [**updatePet**](doc//PetApi.md#updatepet) | **put** /pet | Update an existing pet
*PetApi* | [**updatePetWithForm**](doc//PetApi.md#updatepetwithform) | **post** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**uploadFile**](doc//PetApi.md#uploadfile) | **post** /pet/{petId}/uploadImage | uploads an image
*StoreApi* | [**deleteOrder**](doc//StoreApi.md#deleteorder) | **delete** /store/order/{orderId} | Delete purchase order by ID
*StoreApi* | [**getInventory**](doc//StoreApi.md#getinventory) | **get** /store/inventory | Returns pet inventories by status
*StoreApi* | [**getOrderById**](doc//StoreApi.md#getorderbyid) | **get** /store/order/{orderId} | Find purchase order by ID
*StoreApi* | [**placeOrder**](doc//StoreApi.md#placeorder) | **post** /store/order | Place an order for a pet
*UserApi* | [**createUser**](doc//UserApi.md#createuser) | **post** /user | Create user
*UserApi* | [**createUsersWithArrayInput**](doc//UserApi.md#createuserswitharrayinput) | **post** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**createUsersWithListInput**](doc//UserApi.md#createuserswithlistinput) | **post** /user/createWithList | Creates list of users with given input array
*UserApi* | [**deleteUser**](doc//UserApi.md#deleteuser) | **delete** /user/{username} | Delete user
*UserApi* | [**getUserByName**](doc//UserApi.md#getuserbyname) | **get** /user/{username} | Get user by user name
*UserApi* | [**loginUser**](doc//UserApi.md#loginuser) | **get** /user/login | Logs user into the system
*UserApi* | [**logoutUser**](doc//UserApi.md#logoutuser) | **get** /user/logout | Logs out current logged in user session
*UserApi* | [**updateUser**](doc//UserApi.md#updateuser) | **put** /user/{username} | Updated user


## Documentation For Models

 - [ApiResponse](doc//ApiResponse.md)
 - [Category](doc//Category.md)
 - [Order](doc//Order.md)
 - [Pet](doc//Pet.md)
 - [Tag](doc//Tag.md)
 - [User](doc//User.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets


## Author




