{-
   OpenAPI Petstore
   This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

   The version of the OpenAPI document: 1.0.0

   NOTE: This file is auto generated by the openapi-generator.
   https://github.com/openapitools/openapi-generator.git
   Do not edit this file manually.
-}


module Request.Store exposing (deleteOrder, getInventory, getOrderById, placeOrder)

import Data.Order_ as Order_ exposing (Order_)
import Dict
import Http
import Json.Decode as Decode
import Url.Builder as Url


basePath : String
basePath =
    "http://petstore.swagger.io/v2"


{-| For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
-}
deleteOrder :
    { onSend : Result Http.Error () -> msg
    , orderId : String
    }
    -> Cmd msg
deleteOrder params =
    Http.request
        { method = "DELETE"
        , headers = List.filterMap identity []
        , url =
            Url.crossOrigin basePath
                [ "store", "order", identity params.orderId ]
                (List.filterMap identity [])
        , body = Http.emptyBody
        , expect = Http.expectWhatever params.onSend
        , timeout = Just 30000
        , tracker = Nothing
        }


{-| Returns a map of status codes to quantities
-}
getInventory :
    { onSend : Result Http.Error (Dict.Dict String Int) -> msg
    }
    -> Cmd msg
getInventory params =
    Http.request
        { method = "GET"
        , headers = List.filterMap identity []
        , url =
            Url.crossOrigin basePath
                [ "store", "inventory" ]
                (List.filterMap identity [])
        , body = Http.emptyBody
        , expect = Http.expectJson params.onSend (Decode.dict Decode.int)
        , timeout = Just 30000
        , tracker = Nothing
        }


{-| For valid response try integer IDs with value <= 5 or > 10. Other values will generated exceptions
-}
getOrderById :
    { onSend : Result Http.Error Order_ -> msg
    , orderId : Int
    }
    -> Cmd msg
getOrderById params =
    Http.request
        { method = "GET"
        , headers = List.filterMap identity []
        , url =
            Url.crossOrigin basePath
                [ "store", "order", String.fromInt params.orderId ]
                (List.filterMap identity [])
        , body = Http.emptyBody
        , expect = Http.expectJson params.onSend Order_.decoder
        , timeout = Just 30000
        , tracker = Nothing
        }


placeOrder :
    { onSend : Result Http.Error Order_ -> msg
    , body : Order_
    }
    -> Cmd msg
placeOrder params =
    Http.request
        { method = "POST"
        , headers = List.filterMap identity []
        , url =
            Url.crossOrigin basePath
                [ "store", "order" ]
                (List.filterMap identity [])
        , body = Http.jsonBody <| Order_.encode params.body
        , expect = Http.expectJson params.onSend Order_.decoder
        , timeout = Just 30000
        , tracker = Nothing
        }
