{-
   OpenAPI Petstore

   This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

   OpenAPI Version: 3.0.1
   OpenAPI Petstore API version: 1.0.0
   Generated by OpenAPI Generator (https://openapi-generator.tech)
-}

{-|
Module : OpenAPIPetstore.Model
-}

{-# LANGUAGE DeriveDataTypeable #-}
{-# LANGUAGE DeriveFoldable #-}
{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE DeriveTraversable #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}
{-# LANGUAGE LambdaCase #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE NamedFieldPuns #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE RecordWildCards #-}
{-# LANGUAGE TupleSections #-}
{-# LANGUAGE TypeFamilies #-}
{-# OPTIONS_GHC -fno-warn-unused-matches -fno-warn-unused-binds -fno-warn-unused-imports #-}

module OpenAPIPetstore.Model where

import OpenAPIPetstore.Core
import OpenAPIPetstore.MimeTypes

import Data.Aeson ((.:),(.:!),(.:?),(.=))

import qualified Control.Arrow as P (left)
import qualified Data.Aeson as A
import qualified Data.ByteString as B
import qualified Data.ByteString.Base64 as B64
import qualified Data.ByteString.Char8 as BC
import qualified Data.ByteString.Lazy as BL
import qualified Data.Data as P (Typeable, TypeRep, typeOf, typeRep)
import qualified Data.Foldable as P
import qualified Data.HashMap.Lazy as HM
import qualified Data.Map as Map
import qualified Data.Maybe as P
import qualified Data.Set as Set
import qualified Data.Text as T
import qualified Data.Text.Encoding as T
import qualified Data.Time as TI
import qualified Lens.Micro as L
import qualified Web.FormUrlEncoded as WH
import qualified Web.HttpApiData as WH

import Control.Applicative ((<|>))
import Control.Applicative (Alternative)
import Data.Function ((&))
import Data.Monoid ((<>))
import Data.Text (Text)
import Prelude (($),(/=),(.),(<$>),(<*>),(>>=),(=<<),Maybe(..),Bool(..),Char,Double,FilePath,Float,Int,Integer,String,fmap,undefined,mempty,maybe,pure,Monad,Applicative,Functor)

import qualified Prelude as P



-- * Parameter newtypes


-- ** AdditionalMetadata
newtype AdditionalMetadata = AdditionalMetadata { unAdditionalMetadata :: Text } deriving (P.Eq, P.Show)

-- ** ApiKey
newtype ApiKey = ApiKey { unApiKey :: Text } deriving (P.Eq, P.Show)

-- ** Body
newtype Body = Body { unBody :: [User] } deriving (P.Eq, P.Show, A.ToJSON)

-- ** BodyBool
newtype BodyBool = BodyBool { unBodyBool :: Bool } deriving (P.Eq, P.Show, A.ToJSON)

-- ** BodyDouble
newtype BodyDouble = BodyDouble { unBodyDouble :: Double } deriving (P.Eq, P.Show, A.ToJSON)

-- ** BodyText
newtype BodyText = BodyText { unBodyText :: Text } deriving (P.Eq, P.Show, A.ToJSON)

-- ** BooleanGroup
newtype BooleanGroup = BooleanGroup { unBooleanGroup :: Bool } deriving (P.Eq, P.Show)

-- ** Byte
newtype Byte = Byte { unByte :: ByteArray } deriving (P.Eq, P.Show)

-- ** Callback
newtype Callback = Callback { unCallback :: Text } deriving (P.Eq, P.Show)

-- ** Context
newtype Context = Context { unContext :: [Text] } deriving (P.Eq, P.Show)

-- ** EnumFormString
newtype EnumFormString = EnumFormString { unEnumFormString :: E'EnumFormString } deriving (P.Eq, P.Show)

-- ** EnumFormStringArray
newtype EnumFormStringArray = EnumFormStringArray { unEnumFormStringArray :: [E'EnumFormStringArray] } deriving (P.Eq, P.Show)

-- ** EnumHeaderString
newtype EnumHeaderString = EnumHeaderString { unEnumHeaderString :: E'EnumFormString } deriving (P.Eq, P.Show)

-- ** EnumHeaderStringArray
newtype EnumHeaderStringArray = EnumHeaderStringArray { unEnumHeaderStringArray :: [E'EnumFormStringArray] } deriving (P.Eq, P.Show)

-- ** EnumQueryDouble
newtype EnumQueryDouble = EnumQueryDouble { unEnumQueryDouble :: E'EnumNumber } deriving (P.Eq, P.Show)

-- ** EnumQueryInteger
newtype EnumQueryInteger = EnumQueryInteger { unEnumQueryInteger :: E'EnumQueryInteger } deriving (P.Eq, P.Show)

-- ** EnumQueryString
newtype EnumQueryString = EnumQueryString { unEnumQueryString :: E'EnumFormString } deriving (P.Eq, P.Show)

-- ** EnumQueryStringArray
newtype EnumQueryStringArray = EnumQueryStringArray { unEnumQueryStringArray :: [E'EnumFormStringArray] } deriving (P.Eq, P.Show)

-- ** File2
newtype File2 = File2 { unFile2 :: FilePath } deriving (P.Eq, P.Show)

-- ** Http
newtype Http = Http { unHttp :: [Text] } deriving (P.Eq, P.Show)

-- ** Int32
newtype Int32 = Int32 { unInt32 :: Int } deriving (P.Eq, P.Show)

-- ** Int64
newtype Int64 = Int64 { unInt64 :: Integer } deriving (P.Eq, P.Show)

-- ** Int64Group
newtype Int64Group = Int64Group { unInt64Group :: Integer } deriving (P.Eq, P.Show)

-- ** Ioutil
newtype Ioutil = Ioutil { unIoutil :: [Text] } deriving (P.Eq, P.Show)

-- ** Name2
newtype Name2 = Name2 { unName2 :: Text } deriving (P.Eq, P.Show)

-- ** Number
newtype Number = Number { unNumber :: Double } deriving (P.Eq, P.Show)

-- ** OrderId
newtype OrderId = OrderId { unOrderId :: Integer } deriving (P.Eq, P.Show)

-- ** OrderIdText
newtype OrderIdText = OrderIdText { unOrderIdText :: Text } deriving (P.Eq, P.Show)

-- ** Param
newtype Param = Param { unParam :: Text } deriving (P.Eq, P.Show)

-- ** Param2
newtype Param2 = Param2 { unParam2 :: Text } deriving (P.Eq, P.Show)

-- ** ParamBinary
newtype ParamBinary = ParamBinary { unParamBinary :: FilePath } deriving (P.Eq, P.Show)

-- ** ParamDate
newtype ParamDate = ParamDate { unParamDate :: Date } deriving (P.Eq, P.Show)

-- ** ParamDateTime
newtype ParamDateTime = ParamDateTime { unParamDateTime :: DateTime } deriving (P.Eq, P.Show)

-- ** ParamDouble
newtype ParamDouble = ParamDouble { unParamDouble :: Double } deriving (P.Eq, P.Show)

-- ** ParamFloat
newtype ParamFloat = ParamFloat { unParamFloat :: Float } deriving (P.Eq, P.Show)

-- ** ParamInteger
newtype ParamInteger = ParamInteger { unParamInteger :: Int } deriving (P.Eq, P.Show)

-- ** ParamMapMapStringText
newtype ParamMapMapStringText = ParamMapMapStringText { unParamMapMapStringText :: (Map.Map String Text) } deriving (P.Eq, P.Show, A.ToJSON)

-- ** ParamString
newtype ParamString = ParamString { unParamString :: Text } deriving (P.Eq, P.Show)

-- ** Password
newtype Password = Password { unPassword :: Text } deriving (P.Eq, P.Show)

-- ** PatternWithoutDelimiter
newtype PatternWithoutDelimiter = PatternWithoutDelimiter { unPatternWithoutDelimiter :: Text } deriving (P.Eq, P.Show)

-- ** PetId
newtype PetId = PetId { unPetId :: Integer } deriving (P.Eq, P.Show)

-- ** Pipe
newtype Pipe = Pipe { unPipe :: [Text] } deriving (P.Eq, P.Show)

-- ** Query
newtype Query = Query { unQuery :: Text } deriving (P.Eq, P.Show)

-- ** RequiredBooleanGroup
newtype RequiredBooleanGroup = RequiredBooleanGroup { unRequiredBooleanGroup :: Bool } deriving (P.Eq, P.Show)

-- ** RequiredFile
newtype RequiredFile = RequiredFile { unRequiredFile :: FilePath } deriving (P.Eq, P.Show)

-- ** RequiredInt64Group
newtype RequiredInt64Group = RequiredInt64Group { unRequiredInt64Group :: Integer } deriving (P.Eq, P.Show)

-- ** RequiredStringGroup
newtype RequiredStringGroup = RequiredStringGroup { unRequiredStringGroup :: Int } deriving (P.Eq, P.Show)

-- ** Status
newtype Status = Status { unStatus :: [E'Status2] } deriving (P.Eq, P.Show)

-- ** StatusText
newtype StatusText = StatusText { unStatusText :: Text } deriving (P.Eq, P.Show)

-- ** StringGroup
newtype StringGroup = StringGroup { unStringGroup :: Int } deriving (P.Eq, P.Show)

-- ** Tags
newtype Tags = Tags { unTags :: [Text] } deriving (P.Eq, P.Show)

-- ** Url
newtype Url = Url { unUrl :: [Text] } deriving (P.Eq, P.Show)

-- ** Username
newtype Username = Username { unUsername :: Text } deriving (P.Eq, P.Show)

-- * Models


-- ** AdditionalPropertiesAnyType
-- | AdditionalPropertiesAnyType
data AdditionalPropertiesAnyType = AdditionalPropertiesAnyType
  { additionalPropertiesAnyTypeName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesAnyType
instance A.FromJSON AdditionalPropertiesAnyType where
  parseJSON = A.withObject "AdditionalPropertiesAnyType" $ \o ->
    AdditionalPropertiesAnyType
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesAnyType
instance A.ToJSON AdditionalPropertiesAnyType where
  toJSON AdditionalPropertiesAnyType {..} =
   _omitNulls
      [ "name" .= additionalPropertiesAnyTypeName
      ]


-- | Construct a value of type 'AdditionalPropertiesAnyType' (by applying it's required fields, if any)
mkAdditionalPropertiesAnyType
  :: AdditionalPropertiesAnyType
mkAdditionalPropertiesAnyType =
  AdditionalPropertiesAnyType
  { additionalPropertiesAnyTypeName = Nothing
  }

-- ** AdditionalPropertiesArray
-- | AdditionalPropertiesArray
data AdditionalPropertiesArray = AdditionalPropertiesArray
  { additionalPropertiesArrayName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesArray
instance A.FromJSON AdditionalPropertiesArray where
  parseJSON = A.withObject "AdditionalPropertiesArray" $ \o ->
    AdditionalPropertiesArray
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesArray
instance A.ToJSON AdditionalPropertiesArray where
  toJSON AdditionalPropertiesArray {..} =
   _omitNulls
      [ "name" .= additionalPropertiesArrayName
      ]


-- | Construct a value of type 'AdditionalPropertiesArray' (by applying it's required fields, if any)
mkAdditionalPropertiesArray
  :: AdditionalPropertiesArray
mkAdditionalPropertiesArray =
  AdditionalPropertiesArray
  { additionalPropertiesArrayName = Nothing
  }

-- ** AdditionalPropertiesBoolean
-- | AdditionalPropertiesBoolean
data AdditionalPropertiesBoolean = AdditionalPropertiesBoolean
  { additionalPropertiesBooleanName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesBoolean
instance A.FromJSON AdditionalPropertiesBoolean where
  parseJSON = A.withObject "AdditionalPropertiesBoolean" $ \o ->
    AdditionalPropertiesBoolean
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesBoolean
instance A.ToJSON AdditionalPropertiesBoolean where
  toJSON AdditionalPropertiesBoolean {..} =
   _omitNulls
      [ "name" .= additionalPropertiesBooleanName
      ]


-- | Construct a value of type 'AdditionalPropertiesBoolean' (by applying it's required fields, if any)
mkAdditionalPropertiesBoolean
  :: AdditionalPropertiesBoolean
mkAdditionalPropertiesBoolean =
  AdditionalPropertiesBoolean
  { additionalPropertiesBooleanName = Nothing
  }

-- ** AdditionalPropertiesClass
-- | AdditionalPropertiesClass
data AdditionalPropertiesClass = AdditionalPropertiesClass
  { additionalPropertiesClassMapString :: !(Maybe (Map.Map String Text)) -- ^ "map_string"
  , additionalPropertiesClassMapNumber :: !(Maybe (Map.Map String Double)) -- ^ "map_number"
  , additionalPropertiesClassMapInteger :: !(Maybe (Map.Map String Int)) -- ^ "map_integer"
  , additionalPropertiesClassMapBoolean :: !(Maybe (Map.Map String Bool)) -- ^ "map_boolean"
  , additionalPropertiesClassMapArrayInteger :: !(Maybe (Map.Map String [Int])) -- ^ "map_array_integer"
  , additionalPropertiesClassMapArrayAnytype :: !(Maybe (Map.Map String [A.Value])) -- ^ "map_array_anytype"
  , additionalPropertiesClassMapMapString :: !(Maybe (Map.Map String (Map.Map String Text))) -- ^ "map_map_string"
  , additionalPropertiesClassMapMapAnytype :: !(Maybe (Map.Map String (Map.Map String A.Value))) -- ^ "map_map_anytype"
  , additionalPropertiesClassAnytype1 :: !(Maybe A.Value) -- ^ "anytype_1"
  , additionalPropertiesClassAnytype2 :: !(Maybe A.Value) -- ^ "anytype_2"
  , additionalPropertiesClassAnytype3 :: !(Maybe A.Value) -- ^ "anytype_3"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesClass
instance A.FromJSON AdditionalPropertiesClass where
  parseJSON = A.withObject "AdditionalPropertiesClass" $ \o ->
    AdditionalPropertiesClass
      <$> (o .:? "map_string")
      <*> (o .:? "map_number")
      <*> (o .:? "map_integer")
      <*> (o .:? "map_boolean")
      <*> (o .:? "map_array_integer")
      <*> (o .:? "map_array_anytype")
      <*> (o .:? "map_map_string")
      <*> (o .:? "map_map_anytype")
      <*> (o .:? "anytype_1")
      <*> (o .:? "anytype_2")
      <*> (o .:? "anytype_3")

-- | ToJSON AdditionalPropertiesClass
instance A.ToJSON AdditionalPropertiesClass where
  toJSON AdditionalPropertiesClass {..} =
   _omitNulls
      [ "map_string" .= additionalPropertiesClassMapString
      , "map_number" .= additionalPropertiesClassMapNumber
      , "map_integer" .= additionalPropertiesClassMapInteger
      , "map_boolean" .= additionalPropertiesClassMapBoolean
      , "map_array_integer" .= additionalPropertiesClassMapArrayInteger
      , "map_array_anytype" .= additionalPropertiesClassMapArrayAnytype
      , "map_map_string" .= additionalPropertiesClassMapMapString
      , "map_map_anytype" .= additionalPropertiesClassMapMapAnytype
      , "anytype_1" .= additionalPropertiesClassAnytype1
      , "anytype_2" .= additionalPropertiesClassAnytype2
      , "anytype_3" .= additionalPropertiesClassAnytype3
      ]


-- | Construct a value of type 'AdditionalPropertiesClass' (by applying it's required fields, if any)
mkAdditionalPropertiesClass
  :: AdditionalPropertiesClass
mkAdditionalPropertiesClass =
  AdditionalPropertiesClass
  { additionalPropertiesClassMapString = Nothing
  , additionalPropertiesClassMapNumber = Nothing
  , additionalPropertiesClassMapInteger = Nothing
  , additionalPropertiesClassMapBoolean = Nothing
  , additionalPropertiesClassMapArrayInteger = Nothing
  , additionalPropertiesClassMapArrayAnytype = Nothing
  , additionalPropertiesClassMapMapString = Nothing
  , additionalPropertiesClassMapMapAnytype = Nothing
  , additionalPropertiesClassAnytype1 = Nothing
  , additionalPropertiesClassAnytype2 = Nothing
  , additionalPropertiesClassAnytype3 = Nothing
  }

-- ** AdditionalPropertiesInteger
-- | AdditionalPropertiesInteger
data AdditionalPropertiesInteger = AdditionalPropertiesInteger
  { additionalPropertiesIntegerName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesInteger
instance A.FromJSON AdditionalPropertiesInteger where
  parseJSON = A.withObject "AdditionalPropertiesInteger" $ \o ->
    AdditionalPropertiesInteger
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesInteger
instance A.ToJSON AdditionalPropertiesInteger where
  toJSON AdditionalPropertiesInteger {..} =
   _omitNulls
      [ "name" .= additionalPropertiesIntegerName
      ]


-- | Construct a value of type 'AdditionalPropertiesInteger' (by applying it's required fields, if any)
mkAdditionalPropertiesInteger
  :: AdditionalPropertiesInteger
mkAdditionalPropertiesInteger =
  AdditionalPropertiesInteger
  { additionalPropertiesIntegerName = Nothing
  }

-- ** AdditionalPropertiesNumber
-- | AdditionalPropertiesNumber
data AdditionalPropertiesNumber = AdditionalPropertiesNumber
  { additionalPropertiesNumberName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesNumber
instance A.FromJSON AdditionalPropertiesNumber where
  parseJSON = A.withObject "AdditionalPropertiesNumber" $ \o ->
    AdditionalPropertiesNumber
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesNumber
instance A.ToJSON AdditionalPropertiesNumber where
  toJSON AdditionalPropertiesNumber {..} =
   _omitNulls
      [ "name" .= additionalPropertiesNumberName
      ]


-- | Construct a value of type 'AdditionalPropertiesNumber' (by applying it's required fields, if any)
mkAdditionalPropertiesNumber
  :: AdditionalPropertiesNumber
mkAdditionalPropertiesNumber =
  AdditionalPropertiesNumber
  { additionalPropertiesNumberName = Nothing
  }

-- ** AdditionalPropertiesObject
-- | AdditionalPropertiesObject
data AdditionalPropertiesObject = AdditionalPropertiesObject
  { additionalPropertiesObjectName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesObject
instance A.FromJSON AdditionalPropertiesObject where
  parseJSON = A.withObject "AdditionalPropertiesObject" $ \o ->
    AdditionalPropertiesObject
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesObject
instance A.ToJSON AdditionalPropertiesObject where
  toJSON AdditionalPropertiesObject {..} =
   _omitNulls
      [ "name" .= additionalPropertiesObjectName
      ]


-- | Construct a value of type 'AdditionalPropertiesObject' (by applying it's required fields, if any)
mkAdditionalPropertiesObject
  :: AdditionalPropertiesObject
mkAdditionalPropertiesObject =
  AdditionalPropertiesObject
  { additionalPropertiesObjectName = Nothing
  }

-- ** AdditionalPropertiesString
-- | AdditionalPropertiesString
data AdditionalPropertiesString = AdditionalPropertiesString
  { additionalPropertiesStringName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON AdditionalPropertiesString
instance A.FromJSON AdditionalPropertiesString where
  parseJSON = A.withObject "AdditionalPropertiesString" $ \o ->
    AdditionalPropertiesString
      <$> (o .:? "name")

-- | ToJSON AdditionalPropertiesString
instance A.ToJSON AdditionalPropertiesString where
  toJSON AdditionalPropertiesString {..} =
   _omitNulls
      [ "name" .= additionalPropertiesStringName
      ]


-- | Construct a value of type 'AdditionalPropertiesString' (by applying it's required fields, if any)
mkAdditionalPropertiesString
  :: AdditionalPropertiesString
mkAdditionalPropertiesString =
  AdditionalPropertiesString
  { additionalPropertiesStringName = Nothing
  }

-- ** Animal
-- | Animal
data Animal = Animal
  { animalClassName :: !(Text) -- ^ /Required/ "className"
  , animalColor :: !(Maybe Text) -- ^ "color"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Animal
instance A.FromJSON Animal where
  parseJSON = A.withObject "Animal" $ \o ->
    Animal
      <$> (o .:  "className")
      <*> (o .:? "color")

-- | ToJSON Animal
instance A.ToJSON Animal where
  toJSON Animal {..} =
   _omitNulls
      [ "className" .= animalClassName
      , "color" .= animalColor
      ]


-- | Construct a value of type 'Animal' (by applying it's required fields, if any)
mkAnimal
  :: Text -- ^ 'animalClassName' 
  -> Animal
mkAnimal animalClassName =
  Animal
  { animalClassName
  , animalColor = Nothing
  }

-- ** ApiResponse
-- | ApiResponse
data ApiResponse = ApiResponse
  { apiResponseCode :: !(Maybe Int) -- ^ "code"
  , apiResponseType :: !(Maybe Text) -- ^ "type"
  , apiResponseMessage :: !(Maybe Text) -- ^ "message"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ApiResponse
instance A.FromJSON ApiResponse where
  parseJSON = A.withObject "ApiResponse" $ \o ->
    ApiResponse
      <$> (o .:? "code")
      <*> (o .:? "type")
      <*> (o .:? "message")

-- | ToJSON ApiResponse
instance A.ToJSON ApiResponse where
  toJSON ApiResponse {..} =
   _omitNulls
      [ "code" .= apiResponseCode
      , "type" .= apiResponseType
      , "message" .= apiResponseMessage
      ]


-- | Construct a value of type 'ApiResponse' (by applying it's required fields, if any)
mkApiResponse
  :: ApiResponse
mkApiResponse =
  ApiResponse
  { apiResponseCode = Nothing
  , apiResponseType = Nothing
  , apiResponseMessage = Nothing
  }

-- ** ArrayOfArrayOfNumberOnly
-- | ArrayOfArrayOfNumberOnly
data ArrayOfArrayOfNumberOnly = ArrayOfArrayOfNumberOnly
  { arrayOfArrayOfNumberOnlyArrayArrayNumber :: !(Maybe [[Double]]) -- ^ "ArrayArrayNumber"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ArrayOfArrayOfNumberOnly
instance A.FromJSON ArrayOfArrayOfNumberOnly where
  parseJSON = A.withObject "ArrayOfArrayOfNumberOnly" $ \o ->
    ArrayOfArrayOfNumberOnly
      <$> (o .:? "ArrayArrayNumber")

-- | ToJSON ArrayOfArrayOfNumberOnly
instance A.ToJSON ArrayOfArrayOfNumberOnly where
  toJSON ArrayOfArrayOfNumberOnly {..} =
   _omitNulls
      [ "ArrayArrayNumber" .= arrayOfArrayOfNumberOnlyArrayArrayNumber
      ]


-- | Construct a value of type 'ArrayOfArrayOfNumberOnly' (by applying it's required fields, if any)
mkArrayOfArrayOfNumberOnly
  :: ArrayOfArrayOfNumberOnly
mkArrayOfArrayOfNumberOnly =
  ArrayOfArrayOfNumberOnly
  { arrayOfArrayOfNumberOnlyArrayArrayNumber = Nothing
  }

-- ** ArrayOfNumberOnly
-- | ArrayOfNumberOnly
data ArrayOfNumberOnly = ArrayOfNumberOnly
  { arrayOfNumberOnlyArrayNumber :: !(Maybe [Double]) -- ^ "ArrayNumber"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ArrayOfNumberOnly
instance A.FromJSON ArrayOfNumberOnly where
  parseJSON = A.withObject "ArrayOfNumberOnly" $ \o ->
    ArrayOfNumberOnly
      <$> (o .:? "ArrayNumber")

-- | ToJSON ArrayOfNumberOnly
instance A.ToJSON ArrayOfNumberOnly where
  toJSON ArrayOfNumberOnly {..} =
   _omitNulls
      [ "ArrayNumber" .= arrayOfNumberOnlyArrayNumber
      ]


-- | Construct a value of type 'ArrayOfNumberOnly' (by applying it's required fields, if any)
mkArrayOfNumberOnly
  :: ArrayOfNumberOnly
mkArrayOfNumberOnly =
  ArrayOfNumberOnly
  { arrayOfNumberOnlyArrayNumber = Nothing
  }

-- ** ArrayTest
-- | ArrayTest
data ArrayTest = ArrayTest
  { arrayTestArrayOfString :: !(Maybe [Text]) -- ^ "array_of_string"
  , arrayTestArrayArrayOfInteger :: !(Maybe [[Integer]]) -- ^ "array_array_of_integer"
  , arrayTestArrayArrayOfModel :: !(Maybe [[ReadOnlyFirst]]) -- ^ "array_array_of_model"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ArrayTest
instance A.FromJSON ArrayTest where
  parseJSON = A.withObject "ArrayTest" $ \o ->
    ArrayTest
      <$> (o .:? "array_of_string")
      <*> (o .:? "array_array_of_integer")
      <*> (o .:? "array_array_of_model")

-- | ToJSON ArrayTest
instance A.ToJSON ArrayTest where
  toJSON ArrayTest {..} =
   _omitNulls
      [ "array_of_string" .= arrayTestArrayOfString
      , "array_array_of_integer" .= arrayTestArrayArrayOfInteger
      , "array_array_of_model" .= arrayTestArrayArrayOfModel
      ]


-- | Construct a value of type 'ArrayTest' (by applying it's required fields, if any)
mkArrayTest
  :: ArrayTest
mkArrayTest =
  ArrayTest
  { arrayTestArrayOfString = Nothing
  , arrayTestArrayArrayOfInteger = Nothing
  , arrayTestArrayArrayOfModel = Nothing
  }

-- ** BigCat
-- | BigCat
data BigCat = BigCat
  { bigCatClassName :: !(Text) -- ^ /Required/ "className"
  , bigCatColor :: !(Maybe Text) -- ^ "color"
  , bigCatDeclawed :: !(Maybe Bool) -- ^ "declawed"
  , bigCatKind :: !(Maybe E'Kind) -- ^ "kind"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON BigCat
instance A.FromJSON BigCat where
  parseJSON = A.withObject "BigCat" $ \o ->
    BigCat
      <$> (o .:  "className")
      <*> (o .:? "color")
      <*> (o .:? "declawed")
      <*> (o .:? "kind")

-- | ToJSON BigCat
instance A.ToJSON BigCat where
  toJSON BigCat {..} =
   _omitNulls
      [ "className" .= bigCatClassName
      , "color" .= bigCatColor
      , "declawed" .= bigCatDeclawed
      , "kind" .= bigCatKind
      ]


-- | Construct a value of type 'BigCat' (by applying it's required fields, if any)
mkBigCat
  :: Text -- ^ 'bigCatClassName' 
  -> BigCat
mkBigCat bigCatClassName =
  BigCat
  { bigCatClassName
  , bigCatColor = Nothing
  , bigCatDeclawed = Nothing
  , bigCatKind = Nothing
  }

-- ** BigCatAllOf
-- | BigCatAllOf
data BigCatAllOf = BigCatAllOf
  { bigCatAllOfKind :: !(Maybe E'Kind) -- ^ "kind"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON BigCatAllOf
instance A.FromJSON BigCatAllOf where
  parseJSON = A.withObject "BigCatAllOf" $ \o ->
    BigCatAllOf
      <$> (o .:? "kind")

-- | ToJSON BigCatAllOf
instance A.ToJSON BigCatAllOf where
  toJSON BigCatAllOf {..} =
   _omitNulls
      [ "kind" .= bigCatAllOfKind
      ]


-- | Construct a value of type 'BigCatAllOf' (by applying it's required fields, if any)
mkBigCatAllOf
  :: BigCatAllOf
mkBigCatAllOf =
  BigCatAllOf
  { bigCatAllOfKind = Nothing
  }

-- ** Capitalization
-- | Capitalization
data Capitalization = Capitalization
  { capitalizationSmallCamel :: !(Maybe Text) -- ^ "smallCamel"
  , capitalizationCapitalCamel :: !(Maybe Text) -- ^ "CapitalCamel"
  , capitalizationSmallSnake :: !(Maybe Text) -- ^ "small_Snake"
  , capitalizationCapitalSnake :: !(Maybe Text) -- ^ "Capital_Snake"
  , capitalizationScaEthFlowPoints :: !(Maybe Text) -- ^ "SCA_ETH_Flow_Points"
  , capitalizationAttName :: !(Maybe Text) -- ^ "ATT_NAME" - Name of the pet 
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Capitalization
instance A.FromJSON Capitalization where
  parseJSON = A.withObject "Capitalization" $ \o ->
    Capitalization
      <$> (o .:? "smallCamel")
      <*> (o .:? "CapitalCamel")
      <*> (o .:? "small_Snake")
      <*> (o .:? "Capital_Snake")
      <*> (o .:? "SCA_ETH_Flow_Points")
      <*> (o .:? "ATT_NAME")

-- | ToJSON Capitalization
instance A.ToJSON Capitalization where
  toJSON Capitalization {..} =
   _omitNulls
      [ "smallCamel" .= capitalizationSmallCamel
      , "CapitalCamel" .= capitalizationCapitalCamel
      , "small_Snake" .= capitalizationSmallSnake
      , "Capital_Snake" .= capitalizationCapitalSnake
      , "SCA_ETH_Flow_Points" .= capitalizationScaEthFlowPoints
      , "ATT_NAME" .= capitalizationAttName
      ]


-- | Construct a value of type 'Capitalization' (by applying it's required fields, if any)
mkCapitalization
  :: Capitalization
mkCapitalization =
  Capitalization
  { capitalizationSmallCamel = Nothing
  , capitalizationCapitalCamel = Nothing
  , capitalizationSmallSnake = Nothing
  , capitalizationCapitalSnake = Nothing
  , capitalizationScaEthFlowPoints = Nothing
  , capitalizationAttName = Nothing
  }

-- ** Cat
-- | Cat
data Cat = Cat
  { catClassName :: !(Text) -- ^ /Required/ "className"
  , catColor :: !(Maybe Text) -- ^ "color"
  , catDeclawed :: !(Maybe Bool) -- ^ "declawed"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Cat
instance A.FromJSON Cat where
  parseJSON = A.withObject "Cat" $ \o ->
    Cat
      <$> (o .:  "className")
      <*> (o .:? "color")
      <*> (o .:? "declawed")

-- | ToJSON Cat
instance A.ToJSON Cat where
  toJSON Cat {..} =
   _omitNulls
      [ "className" .= catClassName
      , "color" .= catColor
      , "declawed" .= catDeclawed
      ]


-- | Construct a value of type 'Cat' (by applying it's required fields, if any)
mkCat
  :: Text -- ^ 'catClassName' 
  -> Cat
mkCat catClassName =
  Cat
  { catClassName
  , catColor = Nothing
  , catDeclawed = Nothing
  }

-- ** CatAllOf
-- | CatAllOf
data CatAllOf = CatAllOf
  { catAllOfDeclawed :: !(Maybe Bool) -- ^ "declawed"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON CatAllOf
instance A.FromJSON CatAllOf where
  parseJSON = A.withObject "CatAllOf" $ \o ->
    CatAllOf
      <$> (o .:? "declawed")

-- | ToJSON CatAllOf
instance A.ToJSON CatAllOf where
  toJSON CatAllOf {..} =
   _omitNulls
      [ "declawed" .= catAllOfDeclawed
      ]


-- | Construct a value of type 'CatAllOf' (by applying it's required fields, if any)
mkCatAllOf
  :: CatAllOf
mkCatAllOf =
  CatAllOf
  { catAllOfDeclawed = Nothing
  }

-- ** Category
-- | Category
data Category = Category
  { categoryId :: !(Maybe Integer) -- ^ "id"
  , categoryName :: !(Text) -- ^ /Required/ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Category
instance A.FromJSON Category where
  parseJSON = A.withObject "Category" $ \o ->
    Category
      <$> (o .:? "id")
      <*> (o .:  "name")

-- | ToJSON Category
instance A.ToJSON Category where
  toJSON Category {..} =
   _omitNulls
      [ "id" .= categoryId
      , "name" .= categoryName
      ]


-- | Construct a value of type 'Category' (by applying it's required fields, if any)
mkCategory
  :: Text -- ^ 'categoryName' 
  -> Category
mkCategory categoryName =
  Category
  { categoryId = Nothing
  , categoryName
  }

-- ** ClassModel
-- | ClassModel
-- Model for testing model with \"_class\" property
data ClassModel = ClassModel
  { classModelClass :: !(Maybe Text) -- ^ "_class"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ClassModel
instance A.FromJSON ClassModel where
  parseJSON = A.withObject "ClassModel" $ \o ->
    ClassModel
      <$> (o .:? "_class")

-- | ToJSON ClassModel
instance A.ToJSON ClassModel where
  toJSON ClassModel {..} =
   _omitNulls
      [ "_class" .= classModelClass
      ]


-- | Construct a value of type 'ClassModel' (by applying it's required fields, if any)
mkClassModel
  :: ClassModel
mkClassModel =
  ClassModel
  { classModelClass = Nothing
  }

-- ** Client
-- | Client
data Client = Client
  { clientClient :: !(Maybe Text) -- ^ "client"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Client
instance A.FromJSON Client where
  parseJSON = A.withObject "Client" $ \o ->
    Client
      <$> (o .:? "client")

-- | ToJSON Client
instance A.ToJSON Client where
  toJSON Client {..} =
   _omitNulls
      [ "client" .= clientClient
      ]


-- | Construct a value of type 'Client' (by applying it's required fields, if any)
mkClient
  :: Client
mkClient =
  Client
  { clientClient = Nothing
  }

-- ** Dog
-- | Dog
data Dog = Dog
  { dogClassName :: !(Text) -- ^ /Required/ "className"
  , dogColor :: !(Maybe Text) -- ^ "color"
  , dogBreed :: !(Maybe Text) -- ^ "breed"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Dog
instance A.FromJSON Dog where
  parseJSON = A.withObject "Dog" $ \o ->
    Dog
      <$> (o .:  "className")
      <*> (o .:? "color")
      <*> (o .:? "breed")

-- | ToJSON Dog
instance A.ToJSON Dog where
  toJSON Dog {..} =
   _omitNulls
      [ "className" .= dogClassName
      , "color" .= dogColor
      , "breed" .= dogBreed
      ]


-- | Construct a value of type 'Dog' (by applying it's required fields, if any)
mkDog
  :: Text -- ^ 'dogClassName' 
  -> Dog
mkDog dogClassName =
  Dog
  { dogClassName
  , dogColor = Nothing
  , dogBreed = Nothing
  }

-- ** DogAllOf
-- | DogAllOf
data DogAllOf = DogAllOf
  { dogAllOfBreed :: !(Maybe Text) -- ^ "breed"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON DogAllOf
instance A.FromJSON DogAllOf where
  parseJSON = A.withObject "DogAllOf" $ \o ->
    DogAllOf
      <$> (o .:? "breed")

-- | ToJSON DogAllOf
instance A.ToJSON DogAllOf where
  toJSON DogAllOf {..} =
   _omitNulls
      [ "breed" .= dogAllOfBreed
      ]


-- | Construct a value of type 'DogAllOf' (by applying it's required fields, if any)
mkDogAllOf
  :: DogAllOf
mkDogAllOf =
  DogAllOf
  { dogAllOfBreed = Nothing
  }

-- ** EnumArrays
-- | EnumArrays
data EnumArrays = EnumArrays
  { enumArraysJustSymbol :: !(Maybe E'JustSymbol) -- ^ "just_symbol"
  , enumArraysArrayEnum :: !(Maybe [E'ArrayEnum]) -- ^ "array_enum"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON EnumArrays
instance A.FromJSON EnumArrays where
  parseJSON = A.withObject "EnumArrays" $ \o ->
    EnumArrays
      <$> (o .:? "just_symbol")
      <*> (o .:? "array_enum")

-- | ToJSON EnumArrays
instance A.ToJSON EnumArrays where
  toJSON EnumArrays {..} =
   _omitNulls
      [ "just_symbol" .= enumArraysJustSymbol
      , "array_enum" .= enumArraysArrayEnum
      ]


-- | Construct a value of type 'EnumArrays' (by applying it's required fields, if any)
mkEnumArrays
  :: EnumArrays
mkEnumArrays =
  EnumArrays
  { enumArraysJustSymbol = Nothing
  , enumArraysArrayEnum = Nothing
  }

-- ** EnumTest
-- | EnumTest
data EnumTest = EnumTest
  { enumTestEnumString :: !(Maybe E'EnumString) -- ^ "enum_string"
  , enumTestEnumStringRequired :: !(E'EnumString) -- ^ /Required/ "enum_string_required"
  , enumTestEnumInteger :: !(Maybe E'EnumInteger) -- ^ "enum_integer"
  , enumTestEnumNumber :: !(Maybe E'EnumNumber) -- ^ "enum_number"
  , enumTestOuterEnum :: !(Maybe OuterEnum) -- ^ "outerEnum"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON EnumTest
instance A.FromJSON EnumTest where
  parseJSON = A.withObject "EnumTest" $ \o ->
    EnumTest
      <$> (o .:? "enum_string")
      <*> (o .:  "enum_string_required")
      <*> (o .:? "enum_integer")
      <*> (o .:? "enum_number")
      <*> (o .:? "outerEnum")

-- | ToJSON EnumTest
instance A.ToJSON EnumTest where
  toJSON EnumTest {..} =
   _omitNulls
      [ "enum_string" .= enumTestEnumString
      , "enum_string_required" .= enumTestEnumStringRequired
      , "enum_integer" .= enumTestEnumInteger
      , "enum_number" .= enumTestEnumNumber
      , "outerEnum" .= enumTestOuterEnum
      ]


-- | Construct a value of type 'EnumTest' (by applying it's required fields, if any)
mkEnumTest
  :: E'EnumString -- ^ 'enumTestEnumStringRequired' 
  -> EnumTest
mkEnumTest enumTestEnumStringRequired =
  EnumTest
  { enumTestEnumString = Nothing
  , enumTestEnumStringRequired
  , enumTestEnumInteger = Nothing
  , enumTestEnumNumber = Nothing
  , enumTestOuterEnum = Nothing
  }

-- ** File
-- | File
-- Must be named `File` for test.
data File = File
  { fileSourceUri :: !(Maybe Text) -- ^ "sourceURI" - Test capitalization
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON File
instance A.FromJSON File where
  parseJSON = A.withObject "File" $ \o ->
    File
      <$> (o .:? "sourceURI")

-- | ToJSON File
instance A.ToJSON File where
  toJSON File {..} =
   _omitNulls
      [ "sourceURI" .= fileSourceUri
      ]


-- | Construct a value of type 'File' (by applying it's required fields, if any)
mkFile
  :: File
mkFile =
  File
  { fileSourceUri = Nothing
  }

-- ** FileSchemaTestClass
-- | FileSchemaTestClass
data FileSchemaTestClass = FileSchemaTestClass
  { fileSchemaTestClassFile :: !(Maybe File) -- ^ "file"
  , fileSchemaTestClassFiles :: !(Maybe [File]) -- ^ "files"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON FileSchemaTestClass
instance A.FromJSON FileSchemaTestClass where
  parseJSON = A.withObject "FileSchemaTestClass" $ \o ->
    FileSchemaTestClass
      <$> (o .:? "file")
      <*> (o .:? "files")

-- | ToJSON FileSchemaTestClass
instance A.ToJSON FileSchemaTestClass where
  toJSON FileSchemaTestClass {..} =
   _omitNulls
      [ "file" .= fileSchemaTestClassFile
      , "files" .= fileSchemaTestClassFiles
      ]


-- | Construct a value of type 'FileSchemaTestClass' (by applying it's required fields, if any)
mkFileSchemaTestClass
  :: FileSchemaTestClass
mkFileSchemaTestClass =
  FileSchemaTestClass
  { fileSchemaTestClassFile = Nothing
  , fileSchemaTestClassFiles = Nothing
  }

-- ** FormatTest
-- | FormatTest
data FormatTest = FormatTest
  { formatTestInteger :: !(Maybe Int) -- ^ "integer"
  , formatTestInt32 :: !(Maybe Int) -- ^ "int32"
  , formatTestInt64 :: !(Maybe Integer) -- ^ "int64"
  , formatTestNumber :: !(Double) -- ^ /Required/ "number"
  , formatTestFloat :: !(Maybe Float) -- ^ "float"
  , formatTestDouble :: !(Maybe Double) -- ^ "double"
  , formatTestString :: !(Maybe Text) -- ^ "string"
  , formatTestByte :: !(ByteArray) -- ^ /Required/ "byte"
  , formatTestBinary :: !(Maybe FilePath) -- ^ "binary"
  , formatTestDate :: !(Date) -- ^ /Required/ "date"
  , formatTestDateTime :: !(Maybe DateTime) -- ^ "dateTime"
  , formatTestUuid :: !(Maybe Text) -- ^ "uuid"
  , formatTestPassword :: !(Text) -- ^ /Required/ "password"
  , formatTestBigDecimal :: !(Maybe Double) -- ^ "BigDecimal"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON FormatTest
instance A.FromJSON FormatTest where
  parseJSON = A.withObject "FormatTest" $ \o ->
    FormatTest
      <$> (o .:? "integer")
      <*> (o .:? "int32")
      <*> (o .:? "int64")
      <*> (o .:  "number")
      <*> (o .:? "float")
      <*> (o .:? "double")
      <*> (o .:? "string")
      <*> (o .:  "byte")
      <*> (o .:? "binary")
      <*> (o .:  "date")
      <*> (o .:? "dateTime")
      <*> (o .:? "uuid")
      <*> (o .:  "password")
      <*> (o .:? "BigDecimal")

-- | ToJSON FormatTest
instance A.ToJSON FormatTest where
  toJSON FormatTest {..} =
   _omitNulls
      [ "integer" .= formatTestInteger
      , "int32" .= formatTestInt32
      , "int64" .= formatTestInt64
      , "number" .= formatTestNumber
      , "float" .= formatTestFloat
      , "double" .= formatTestDouble
      , "string" .= formatTestString
      , "byte" .= formatTestByte
      , "binary" .= formatTestBinary
      , "date" .= formatTestDate
      , "dateTime" .= formatTestDateTime
      , "uuid" .= formatTestUuid
      , "password" .= formatTestPassword
      , "BigDecimal" .= formatTestBigDecimal
      ]


-- | Construct a value of type 'FormatTest' (by applying it's required fields, if any)
mkFormatTest
  :: Double -- ^ 'formatTestNumber' 
  -> ByteArray -- ^ 'formatTestByte' 
  -> Date -- ^ 'formatTestDate' 
  -> Text -- ^ 'formatTestPassword' 
  -> FormatTest
mkFormatTest formatTestNumber formatTestByte formatTestDate formatTestPassword =
  FormatTest
  { formatTestInteger = Nothing
  , formatTestInt32 = Nothing
  , formatTestInt64 = Nothing
  , formatTestNumber
  , formatTestFloat = Nothing
  , formatTestDouble = Nothing
  , formatTestString = Nothing
  , formatTestByte
  , formatTestBinary = Nothing
  , formatTestDate
  , formatTestDateTime = Nothing
  , formatTestUuid = Nothing
  , formatTestPassword
  , formatTestBigDecimal = Nothing
  }

-- ** HasOnlyReadOnly
-- | HasOnlyReadOnly
data HasOnlyReadOnly = HasOnlyReadOnly
  { hasOnlyReadOnlyBar :: !(Maybe Text) -- ^ /ReadOnly/ "bar"
  , hasOnlyReadOnlyFoo :: !(Maybe Text) -- ^ /ReadOnly/ "foo"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON HasOnlyReadOnly
instance A.FromJSON HasOnlyReadOnly where
  parseJSON = A.withObject "HasOnlyReadOnly" $ \o ->
    HasOnlyReadOnly
      <$> (o .:? "bar")
      <*> (o .:? "foo")

-- | ToJSON HasOnlyReadOnly
instance A.ToJSON HasOnlyReadOnly where
  toJSON HasOnlyReadOnly {..} =
   _omitNulls
      [ "bar" .= hasOnlyReadOnlyBar
      , "foo" .= hasOnlyReadOnlyFoo
      ]


-- | Construct a value of type 'HasOnlyReadOnly' (by applying it's required fields, if any)
mkHasOnlyReadOnly
  :: HasOnlyReadOnly
mkHasOnlyReadOnly =
  HasOnlyReadOnly
  { hasOnlyReadOnlyBar = Nothing
  , hasOnlyReadOnlyFoo = Nothing
  }

-- ** MapTest
-- | MapTest
data MapTest = MapTest
  { mapTestMapMapOfString :: !(Maybe (Map.Map String (Map.Map String Text))) -- ^ "map_map_of_string"
  , mapTestMapOfEnumString :: !(Maybe (Map.Map String E'Inner)) -- ^ "map_of_enum_string"
  , mapTestDirectMap :: !(Maybe (Map.Map String Bool)) -- ^ "direct_map"
  , mapTestIndirectMap :: !(Maybe (Map.Map String Bool)) -- ^ "indirect_map"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON MapTest
instance A.FromJSON MapTest where
  parseJSON = A.withObject "MapTest" $ \o ->
    MapTest
      <$> (o .:? "map_map_of_string")
      <*> (o .:? "map_of_enum_string")
      <*> (o .:? "direct_map")
      <*> (o .:? "indirect_map")

-- | ToJSON MapTest
instance A.ToJSON MapTest where
  toJSON MapTest {..} =
   _omitNulls
      [ "map_map_of_string" .= mapTestMapMapOfString
      , "map_of_enum_string" .= mapTestMapOfEnumString
      , "direct_map" .= mapTestDirectMap
      , "indirect_map" .= mapTestIndirectMap
      ]


-- | Construct a value of type 'MapTest' (by applying it's required fields, if any)
mkMapTest
  :: MapTest
mkMapTest =
  MapTest
  { mapTestMapMapOfString = Nothing
  , mapTestMapOfEnumString = Nothing
  , mapTestDirectMap = Nothing
  , mapTestIndirectMap = Nothing
  }

-- ** MixedPropertiesAndAdditionalPropertiesClass
-- | MixedPropertiesAndAdditionalPropertiesClass
data MixedPropertiesAndAdditionalPropertiesClass = MixedPropertiesAndAdditionalPropertiesClass
  { mixedPropertiesAndAdditionalPropertiesClassUuid :: !(Maybe Text) -- ^ "uuid"
  , mixedPropertiesAndAdditionalPropertiesClassDateTime :: !(Maybe DateTime) -- ^ "dateTime"
  , mixedPropertiesAndAdditionalPropertiesClassMap :: !(Maybe (Map.Map String Animal)) -- ^ "map"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON MixedPropertiesAndAdditionalPropertiesClass
instance A.FromJSON MixedPropertiesAndAdditionalPropertiesClass where
  parseJSON = A.withObject "MixedPropertiesAndAdditionalPropertiesClass" $ \o ->
    MixedPropertiesAndAdditionalPropertiesClass
      <$> (o .:? "uuid")
      <*> (o .:? "dateTime")
      <*> (o .:? "map")

-- | ToJSON MixedPropertiesAndAdditionalPropertiesClass
instance A.ToJSON MixedPropertiesAndAdditionalPropertiesClass where
  toJSON MixedPropertiesAndAdditionalPropertiesClass {..} =
   _omitNulls
      [ "uuid" .= mixedPropertiesAndAdditionalPropertiesClassUuid
      , "dateTime" .= mixedPropertiesAndAdditionalPropertiesClassDateTime
      , "map" .= mixedPropertiesAndAdditionalPropertiesClassMap
      ]


-- | Construct a value of type 'MixedPropertiesAndAdditionalPropertiesClass' (by applying it's required fields, if any)
mkMixedPropertiesAndAdditionalPropertiesClass
  :: MixedPropertiesAndAdditionalPropertiesClass
mkMixedPropertiesAndAdditionalPropertiesClass =
  MixedPropertiesAndAdditionalPropertiesClass
  { mixedPropertiesAndAdditionalPropertiesClassUuid = Nothing
  , mixedPropertiesAndAdditionalPropertiesClassDateTime = Nothing
  , mixedPropertiesAndAdditionalPropertiesClassMap = Nothing
  }

-- ** Model200Response
-- | Model200Response
-- Model for testing model name starting with number
data Model200Response = Model200Response
  { model200ResponseName :: !(Maybe Int) -- ^ "name"
  , model200ResponseClass :: !(Maybe Text) -- ^ "class"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Model200Response
instance A.FromJSON Model200Response where
  parseJSON = A.withObject "Model200Response" $ \o ->
    Model200Response
      <$> (o .:? "name")
      <*> (o .:? "class")

-- | ToJSON Model200Response
instance A.ToJSON Model200Response where
  toJSON Model200Response {..} =
   _omitNulls
      [ "name" .= model200ResponseName
      , "class" .= model200ResponseClass
      ]


-- | Construct a value of type 'Model200Response' (by applying it's required fields, if any)
mkModel200Response
  :: Model200Response
mkModel200Response =
  Model200Response
  { model200ResponseName = Nothing
  , model200ResponseClass = Nothing
  }

-- ** ModelList
-- | ModelList
data ModelList = ModelList
  { modelList123list :: !(Maybe Text) -- ^ "123-list"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ModelList
instance A.FromJSON ModelList where
  parseJSON = A.withObject "ModelList" $ \o ->
    ModelList
      <$> (o .:? "123-list")

-- | ToJSON ModelList
instance A.ToJSON ModelList where
  toJSON ModelList {..} =
   _omitNulls
      [ "123-list" .= modelList123list
      ]


-- | Construct a value of type 'ModelList' (by applying it's required fields, if any)
mkModelList
  :: ModelList
mkModelList =
  ModelList
  { modelList123list = Nothing
  }

-- ** ModelReturn
-- | ModelReturn
-- Model for testing reserved words
data ModelReturn = ModelReturn
  { modelReturnReturn :: !(Maybe Int) -- ^ "return"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ModelReturn
instance A.FromJSON ModelReturn where
  parseJSON = A.withObject "ModelReturn" $ \o ->
    ModelReturn
      <$> (o .:? "return")

-- | ToJSON ModelReturn
instance A.ToJSON ModelReturn where
  toJSON ModelReturn {..} =
   _omitNulls
      [ "return" .= modelReturnReturn
      ]


-- | Construct a value of type 'ModelReturn' (by applying it's required fields, if any)
mkModelReturn
  :: ModelReturn
mkModelReturn =
  ModelReturn
  { modelReturnReturn = Nothing
  }

-- ** Name
-- | Name
-- Model for testing model name same as property name
data Name = Name
  { nameName :: !(Int) -- ^ /Required/ "name"
  , nameSnakeCase :: !(Maybe Int) -- ^ /ReadOnly/ "snake_case"
  , nameProperty :: !(Maybe Text) -- ^ "property"
  , name123number :: !(Maybe Int) -- ^ /ReadOnly/ "123Number"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Name
instance A.FromJSON Name where
  parseJSON = A.withObject "Name" $ \o ->
    Name
      <$> (o .:  "name")
      <*> (o .:? "snake_case")
      <*> (o .:? "property")
      <*> (o .:? "123Number")

-- | ToJSON Name
instance A.ToJSON Name where
  toJSON Name {..} =
   _omitNulls
      [ "name" .= nameName
      , "snake_case" .= nameSnakeCase
      , "property" .= nameProperty
      , "123Number" .= name123number
      ]


-- | Construct a value of type 'Name' (by applying it's required fields, if any)
mkName
  :: Int -- ^ 'nameName' 
  -> Name
mkName nameName =
  Name
  { nameName
  , nameSnakeCase = Nothing
  , nameProperty = Nothing
  , name123number = Nothing
  }

-- ** NumberOnly
-- | NumberOnly
data NumberOnly = NumberOnly
  { numberOnlyJustNumber :: !(Maybe Double) -- ^ "JustNumber"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON NumberOnly
instance A.FromJSON NumberOnly where
  parseJSON = A.withObject "NumberOnly" $ \o ->
    NumberOnly
      <$> (o .:? "JustNumber")

-- | ToJSON NumberOnly
instance A.ToJSON NumberOnly where
  toJSON NumberOnly {..} =
   _omitNulls
      [ "JustNumber" .= numberOnlyJustNumber
      ]


-- | Construct a value of type 'NumberOnly' (by applying it's required fields, if any)
mkNumberOnly
  :: NumberOnly
mkNumberOnly =
  NumberOnly
  { numberOnlyJustNumber = Nothing
  }

-- ** Order
-- | Order
data Order = Order
  { orderId :: !(Maybe Integer) -- ^ "id"
  , orderPetId :: !(Maybe Integer) -- ^ "petId"
  , orderQuantity :: !(Maybe Int) -- ^ "quantity"
  , orderShipDate :: !(Maybe DateTime) -- ^ "shipDate"
  , orderStatus :: !(Maybe E'Status) -- ^ "status" - Order Status
  , orderComplete :: !(Maybe Bool) -- ^ "complete"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Order
instance A.FromJSON Order where
  parseJSON = A.withObject "Order" $ \o ->
    Order
      <$> (o .:? "id")
      <*> (o .:? "petId")
      <*> (o .:? "quantity")
      <*> (o .:? "shipDate")
      <*> (o .:? "status")
      <*> (o .:? "complete")

-- | ToJSON Order
instance A.ToJSON Order where
  toJSON Order {..} =
   _omitNulls
      [ "id" .= orderId
      , "petId" .= orderPetId
      , "quantity" .= orderQuantity
      , "shipDate" .= orderShipDate
      , "status" .= orderStatus
      , "complete" .= orderComplete
      ]


-- | Construct a value of type 'Order' (by applying it's required fields, if any)
mkOrder
  :: Order
mkOrder =
  Order
  { orderId = Nothing
  , orderPetId = Nothing
  , orderQuantity = Nothing
  , orderShipDate = Nothing
  , orderStatus = Nothing
  , orderComplete = Nothing
  }

-- ** OuterComposite
-- | OuterComposite
data OuterComposite = OuterComposite
  { outerCompositeMyNumber :: !(Maybe Double) -- ^ "my_number"
  , outerCompositeMyString :: !(Maybe Text) -- ^ "my_string"
  , outerCompositeMyBoolean :: !(Maybe Bool) -- ^ "my_boolean"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON OuterComposite
instance A.FromJSON OuterComposite where
  parseJSON = A.withObject "OuterComposite" $ \o ->
    OuterComposite
      <$> (o .:? "my_number")
      <*> (o .:? "my_string")
      <*> (o .:? "my_boolean")

-- | ToJSON OuterComposite
instance A.ToJSON OuterComposite where
  toJSON OuterComposite {..} =
   _omitNulls
      [ "my_number" .= outerCompositeMyNumber
      , "my_string" .= outerCompositeMyString
      , "my_boolean" .= outerCompositeMyBoolean
      ]


-- | Construct a value of type 'OuterComposite' (by applying it's required fields, if any)
mkOuterComposite
  :: OuterComposite
mkOuterComposite =
  OuterComposite
  { outerCompositeMyNumber = Nothing
  , outerCompositeMyString = Nothing
  , outerCompositeMyBoolean = Nothing
  }

-- ** Pet
-- | Pet
data Pet = Pet
  { petId :: !(Maybe Integer) -- ^ "id"
  , petCategory :: !(Maybe Category) -- ^ "category"
  , petName :: !(Text) -- ^ /Required/ "name"
  , petPhotoUrls :: !([Text]) -- ^ /Required/ "photoUrls"
  , petTags :: !(Maybe [Tag]) -- ^ "tags"
  , petStatus :: !(Maybe E'Status2) -- ^ "status" - pet status in the store
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Pet
instance A.FromJSON Pet where
  parseJSON = A.withObject "Pet" $ \o ->
    Pet
      <$> (o .:? "id")
      <*> (o .:? "category")
      <*> (o .:  "name")
      <*> (o .:  "photoUrls")
      <*> (o .:? "tags")
      <*> (o .:? "status")

-- | ToJSON Pet
instance A.ToJSON Pet where
  toJSON Pet {..} =
   _omitNulls
      [ "id" .= petId
      , "category" .= petCategory
      , "name" .= petName
      , "photoUrls" .= petPhotoUrls
      , "tags" .= petTags
      , "status" .= petStatus
      ]


-- | Construct a value of type 'Pet' (by applying it's required fields, if any)
mkPet
  :: Text -- ^ 'petName' 
  -> [Text] -- ^ 'petPhotoUrls' 
  -> Pet
mkPet petName petPhotoUrls =
  Pet
  { petId = Nothing
  , petCategory = Nothing
  , petName
  , petPhotoUrls
  , petTags = Nothing
  , petStatus = Nothing
  }

-- ** ReadOnlyFirst
-- | ReadOnlyFirst
data ReadOnlyFirst = ReadOnlyFirst
  { readOnlyFirstBar :: !(Maybe Text) -- ^ /ReadOnly/ "bar"
  , readOnlyFirstBaz :: !(Maybe Text) -- ^ "baz"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON ReadOnlyFirst
instance A.FromJSON ReadOnlyFirst where
  parseJSON = A.withObject "ReadOnlyFirst" $ \o ->
    ReadOnlyFirst
      <$> (o .:? "bar")
      <*> (o .:? "baz")

-- | ToJSON ReadOnlyFirst
instance A.ToJSON ReadOnlyFirst where
  toJSON ReadOnlyFirst {..} =
   _omitNulls
      [ "bar" .= readOnlyFirstBar
      , "baz" .= readOnlyFirstBaz
      ]


-- | Construct a value of type 'ReadOnlyFirst' (by applying it's required fields, if any)
mkReadOnlyFirst
  :: ReadOnlyFirst
mkReadOnlyFirst =
  ReadOnlyFirst
  { readOnlyFirstBar = Nothing
  , readOnlyFirstBaz = Nothing
  }

-- ** SpecialModelName
-- | SpecialModelName
data SpecialModelName = SpecialModelName
  { specialModelNameSpecialPropertyName :: !(Maybe Integer) -- ^ "$special[property.name]"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON SpecialModelName
instance A.FromJSON SpecialModelName where
  parseJSON = A.withObject "SpecialModelName" $ \o ->
    SpecialModelName
      <$> (o .:? "$special[property.name]")

-- | ToJSON SpecialModelName
instance A.ToJSON SpecialModelName where
  toJSON SpecialModelName {..} =
   _omitNulls
      [ "$special[property.name]" .= specialModelNameSpecialPropertyName
      ]


-- | Construct a value of type 'SpecialModelName' (by applying it's required fields, if any)
mkSpecialModelName
  :: SpecialModelName
mkSpecialModelName =
  SpecialModelName
  { specialModelNameSpecialPropertyName = Nothing
  }

-- ** Tag
-- | Tag
data Tag = Tag
  { tagId :: !(Maybe Integer) -- ^ "id"
  , tagName :: !(Maybe Text) -- ^ "name"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON Tag
instance A.FromJSON Tag where
  parseJSON = A.withObject "Tag" $ \o ->
    Tag
      <$> (o .:? "id")
      <*> (o .:? "name")

-- | ToJSON Tag
instance A.ToJSON Tag where
  toJSON Tag {..} =
   _omitNulls
      [ "id" .= tagId
      , "name" .= tagName
      ]


-- | Construct a value of type 'Tag' (by applying it's required fields, if any)
mkTag
  :: Tag
mkTag =
  Tag
  { tagId = Nothing
  , tagName = Nothing
  }

-- ** TypeHolderDefault
-- | TypeHolderDefault
data TypeHolderDefault = TypeHolderDefault
  { typeHolderDefaultStringItem :: !(Text) -- ^ /Required/ "string_item"
  , typeHolderDefaultNumberItem :: !(Double) -- ^ /Required/ "number_item"
  , typeHolderDefaultIntegerItem :: !(Int) -- ^ /Required/ "integer_item"
  , typeHolderDefaultBoolItem :: !(Bool) -- ^ /Required/ "bool_item"
  , typeHolderDefaultArrayItem :: !([Int]) -- ^ /Required/ "array_item"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON TypeHolderDefault
instance A.FromJSON TypeHolderDefault where
  parseJSON = A.withObject "TypeHolderDefault" $ \o ->
    TypeHolderDefault
      <$> (o .:  "string_item")
      <*> (o .:  "number_item")
      <*> (o .:  "integer_item")
      <*> (o .:  "bool_item")
      <*> (o .:  "array_item")

-- | ToJSON TypeHolderDefault
instance A.ToJSON TypeHolderDefault where
  toJSON TypeHolderDefault {..} =
   _omitNulls
      [ "string_item" .= typeHolderDefaultStringItem
      , "number_item" .= typeHolderDefaultNumberItem
      , "integer_item" .= typeHolderDefaultIntegerItem
      , "bool_item" .= typeHolderDefaultBoolItem
      , "array_item" .= typeHolderDefaultArrayItem
      ]


-- | Construct a value of type 'TypeHolderDefault' (by applying it's required fields, if any)
mkTypeHolderDefault
  :: Text -- ^ 'typeHolderDefaultStringItem' 
  -> Double -- ^ 'typeHolderDefaultNumberItem' 
  -> Int -- ^ 'typeHolderDefaultIntegerItem' 
  -> Bool -- ^ 'typeHolderDefaultBoolItem' 
  -> [Int] -- ^ 'typeHolderDefaultArrayItem' 
  -> TypeHolderDefault
mkTypeHolderDefault typeHolderDefaultStringItem typeHolderDefaultNumberItem typeHolderDefaultIntegerItem typeHolderDefaultBoolItem typeHolderDefaultArrayItem =
  TypeHolderDefault
  { typeHolderDefaultStringItem
  , typeHolderDefaultNumberItem
  , typeHolderDefaultIntegerItem
  , typeHolderDefaultBoolItem
  , typeHolderDefaultArrayItem
  }

-- ** TypeHolderExample
-- | TypeHolderExample
data TypeHolderExample = TypeHolderExample
  { typeHolderExampleStringItem :: !(Text) -- ^ /Required/ "string_item"
  , typeHolderExampleNumberItem :: !(Double) -- ^ /Required/ "number_item"
  , typeHolderExampleFloatItem :: !(Float) -- ^ /Required/ "float_item"
  , typeHolderExampleIntegerItem :: !(Int) -- ^ /Required/ "integer_item"
  , typeHolderExampleBoolItem :: !(Bool) -- ^ /Required/ "bool_item"
  , typeHolderExampleArrayItem :: !([Int]) -- ^ /Required/ "array_item"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON TypeHolderExample
instance A.FromJSON TypeHolderExample where
  parseJSON = A.withObject "TypeHolderExample" $ \o ->
    TypeHolderExample
      <$> (o .:  "string_item")
      <*> (o .:  "number_item")
      <*> (o .:  "float_item")
      <*> (o .:  "integer_item")
      <*> (o .:  "bool_item")
      <*> (o .:  "array_item")

-- | ToJSON TypeHolderExample
instance A.ToJSON TypeHolderExample where
  toJSON TypeHolderExample {..} =
   _omitNulls
      [ "string_item" .= typeHolderExampleStringItem
      , "number_item" .= typeHolderExampleNumberItem
      , "float_item" .= typeHolderExampleFloatItem
      , "integer_item" .= typeHolderExampleIntegerItem
      , "bool_item" .= typeHolderExampleBoolItem
      , "array_item" .= typeHolderExampleArrayItem
      ]


-- | Construct a value of type 'TypeHolderExample' (by applying it's required fields, if any)
mkTypeHolderExample
  :: Text -- ^ 'typeHolderExampleStringItem' 
  -> Double -- ^ 'typeHolderExampleNumberItem' 
  -> Float -- ^ 'typeHolderExampleFloatItem' 
  -> Int -- ^ 'typeHolderExampleIntegerItem' 
  -> Bool -- ^ 'typeHolderExampleBoolItem' 
  -> [Int] -- ^ 'typeHolderExampleArrayItem' 
  -> TypeHolderExample
mkTypeHolderExample typeHolderExampleStringItem typeHolderExampleNumberItem typeHolderExampleFloatItem typeHolderExampleIntegerItem typeHolderExampleBoolItem typeHolderExampleArrayItem =
  TypeHolderExample
  { typeHolderExampleStringItem
  , typeHolderExampleNumberItem
  , typeHolderExampleFloatItem
  , typeHolderExampleIntegerItem
  , typeHolderExampleBoolItem
  , typeHolderExampleArrayItem
  }

-- ** User
-- | User
data User = User
  { userId :: !(Maybe Integer) -- ^ "id"
  , userUsername :: !(Maybe Text) -- ^ "username"
  , userFirstName :: !(Maybe Text) -- ^ "firstName"
  , userLastName :: !(Maybe Text) -- ^ "lastName"
  , userEmail :: !(Maybe Text) -- ^ "email"
  , userPassword :: !(Maybe Text) -- ^ "password"
  , userPhone :: !(Maybe Text) -- ^ "phone"
  , userUserStatus :: !(Maybe Int) -- ^ "userStatus" - User Status
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON User
instance A.FromJSON User where
  parseJSON = A.withObject "User" $ \o ->
    User
      <$> (o .:? "id")
      <*> (o .:? "username")
      <*> (o .:? "firstName")
      <*> (o .:? "lastName")
      <*> (o .:? "email")
      <*> (o .:? "password")
      <*> (o .:? "phone")
      <*> (o .:? "userStatus")

-- | ToJSON User
instance A.ToJSON User where
  toJSON User {..} =
   _omitNulls
      [ "id" .= userId
      , "username" .= userUsername
      , "firstName" .= userFirstName
      , "lastName" .= userLastName
      , "email" .= userEmail
      , "password" .= userPassword
      , "phone" .= userPhone
      , "userStatus" .= userUserStatus
      ]


-- | Construct a value of type 'User' (by applying it's required fields, if any)
mkUser
  :: User
mkUser =
  User
  { userId = Nothing
  , userUsername = Nothing
  , userFirstName = Nothing
  , userLastName = Nothing
  , userEmail = Nothing
  , userPassword = Nothing
  , userPhone = Nothing
  , userUserStatus = Nothing
  }

-- ** XmlItem
-- | XmlItem
data XmlItem = XmlItem
  { xmlItemAttributeString :: !(Maybe Text) -- ^ "attribute_string"
  , xmlItemAttributeNumber :: !(Maybe Double) -- ^ "attribute_number"
  , xmlItemAttributeInteger :: !(Maybe Int) -- ^ "attribute_integer"
  , xmlItemAttributeBoolean :: !(Maybe Bool) -- ^ "attribute_boolean"
  , xmlItemWrappedArray :: !(Maybe [Int]) -- ^ "wrapped_array"
  , xmlItemNameString :: !(Maybe Text) -- ^ "name_string"
  , xmlItemNameNumber :: !(Maybe Double) -- ^ "name_number"
  , xmlItemNameInteger :: !(Maybe Int) -- ^ "name_integer"
  , xmlItemNameBoolean :: !(Maybe Bool) -- ^ "name_boolean"
  , xmlItemNameArray :: !(Maybe [Int]) -- ^ "name_array"
  , xmlItemNameWrappedArray :: !(Maybe [Int]) -- ^ "name_wrapped_array"
  , xmlItemPrefixString :: !(Maybe Text) -- ^ "prefix_string"
  , xmlItemPrefixNumber :: !(Maybe Double) -- ^ "prefix_number"
  , xmlItemPrefixInteger :: !(Maybe Int) -- ^ "prefix_integer"
  , xmlItemPrefixBoolean :: !(Maybe Bool) -- ^ "prefix_boolean"
  , xmlItemPrefixArray :: !(Maybe [Int]) -- ^ "prefix_array"
  , xmlItemPrefixWrappedArray :: !(Maybe [Int]) -- ^ "prefix_wrapped_array"
  , xmlItemNamespaceString :: !(Maybe Text) -- ^ "namespace_string"
  , xmlItemNamespaceNumber :: !(Maybe Double) -- ^ "namespace_number"
  , xmlItemNamespaceInteger :: !(Maybe Int) -- ^ "namespace_integer"
  , xmlItemNamespaceBoolean :: !(Maybe Bool) -- ^ "namespace_boolean"
  , xmlItemNamespaceArray :: !(Maybe [Int]) -- ^ "namespace_array"
  , xmlItemNamespaceWrappedArray :: !(Maybe [Int]) -- ^ "namespace_wrapped_array"
  , xmlItemPrefixNsString :: !(Maybe Text) -- ^ "prefix_ns_string"
  , xmlItemPrefixNsNumber :: !(Maybe Double) -- ^ "prefix_ns_number"
  , xmlItemPrefixNsInteger :: !(Maybe Int) -- ^ "prefix_ns_integer"
  , xmlItemPrefixNsBoolean :: !(Maybe Bool) -- ^ "prefix_ns_boolean"
  , xmlItemPrefixNsArray :: !(Maybe [Int]) -- ^ "prefix_ns_array"
  , xmlItemPrefixNsWrappedArray :: !(Maybe [Int]) -- ^ "prefix_ns_wrapped_array"
  } deriving (P.Show, P.Eq, P.Typeable)

-- | FromJSON XmlItem
instance A.FromJSON XmlItem where
  parseJSON = A.withObject "XmlItem" $ \o ->
    XmlItem
      <$> (o .:? "attribute_string")
      <*> (o .:? "attribute_number")
      <*> (o .:? "attribute_integer")
      <*> (o .:? "attribute_boolean")
      <*> (o .:? "wrapped_array")
      <*> (o .:? "name_string")
      <*> (o .:? "name_number")
      <*> (o .:? "name_integer")
      <*> (o .:? "name_boolean")
      <*> (o .:? "name_array")
      <*> (o .:? "name_wrapped_array")
      <*> (o .:? "prefix_string")
      <*> (o .:? "prefix_number")
      <*> (o .:? "prefix_integer")
      <*> (o .:? "prefix_boolean")
      <*> (o .:? "prefix_array")
      <*> (o .:? "prefix_wrapped_array")
      <*> (o .:? "namespace_string")
      <*> (o .:? "namespace_number")
      <*> (o .:? "namespace_integer")
      <*> (o .:? "namespace_boolean")
      <*> (o .:? "namespace_array")
      <*> (o .:? "namespace_wrapped_array")
      <*> (o .:? "prefix_ns_string")
      <*> (o .:? "prefix_ns_number")
      <*> (o .:? "prefix_ns_integer")
      <*> (o .:? "prefix_ns_boolean")
      <*> (o .:? "prefix_ns_array")
      <*> (o .:? "prefix_ns_wrapped_array")

-- | ToJSON XmlItem
instance A.ToJSON XmlItem where
  toJSON XmlItem {..} =
   _omitNulls
      [ "attribute_string" .= xmlItemAttributeString
      , "attribute_number" .= xmlItemAttributeNumber
      , "attribute_integer" .= xmlItemAttributeInteger
      , "attribute_boolean" .= xmlItemAttributeBoolean
      , "wrapped_array" .= xmlItemWrappedArray
      , "name_string" .= xmlItemNameString
      , "name_number" .= xmlItemNameNumber
      , "name_integer" .= xmlItemNameInteger
      , "name_boolean" .= xmlItemNameBoolean
      , "name_array" .= xmlItemNameArray
      , "name_wrapped_array" .= xmlItemNameWrappedArray
      , "prefix_string" .= xmlItemPrefixString
      , "prefix_number" .= xmlItemPrefixNumber
      , "prefix_integer" .= xmlItemPrefixInteger
      , "prefix_boolean" .= xmlItemPrefixBoolean
      , "prefix_array" .= xmlItemPrefixArray
      , "prefix_wrapped_array" .= xmlItemPrefixWrappedArray
      , "namespace_string" .= xmlItemNamespaceString
      , "namespace_number" .= xmlItemNamespaceNumber
      , "namespace_integer" .= xmlItemNamespaceInteger
      , "namespace_boolean" .= xmlItemNamespaceBoolean
      , "namespace_array" .= xmlItemNamespaceArray
      , "namespace_wrapped_array" .= xmlItemNamespaceWrappedArray
      , "prefix_ns_string" .= xmlItemPrefixNsString
      , "prefix_ns_number" .= xmlItemPrefixNsNumber
      , "prefix_ns_integer" .= xmlItemPrefixNsInteger
      , "prefix_ns_boolean" .= xmlItemPrefixNsBoolean
      , "prefix_ns_array" .= xmlItemPrefixNsArray
      , "prefix_ns_wrapped_array" .= xmlItemPrefixNsWrappedArray
      ]


-- | Construct a value of type 'XmlItem' (by applying it's required fields, if any)
mkXmlItem
  :: XmlItem
mkXmlItem =
  XmlItem
  { xmlItemAttributeString = Nothing
  , xmlItemAttributeNumber = Nothing
  , xmlItemAttributeInteger = Nothing
  , xmlItemAttributeBoolean = Nothing
  , xmlItemWrappedArray = Nothing
  , xmlItemNameString = Nothing
  , xmlItemNameNumber = Nothing
  , xmlItemNameInteger = Nothing
  , xmlItemNameBoolean = Nothing
  , xmlItemNameArray = Nothing
  , xmlItemNameWrappedArray = Nothing
  , xmlItemPrefixString = Nothing
  , xmlItemPrefixNumber = Nothing
  , xmlItemPrefixInteger = Nothing
  , xmlItemPrefixBoolean = Nothing
  , xmlItemPrefixArray = Nothing
  , xmlItemPrefixWrappedArray = Nothing
  , xmlItemNamespaceString = Nothing
  , xmlItemNamespaceNumber = Nothing
  , xmlItemNamespaceInteger = Nothing
  , xmlItemNamespaceBoolean = Nothing
  , xmlItemNamespaceArray = Nothing
  , xmlItemNamespaceWrappedArray = Nothing
  , xmlItemPrefixNsString = Nothing
  , xmlItemPrefixNsNumber = Nothing
  , xmlItemPrefixNsInteger = Nothing
  , xmlItemPrefixNsBoolean = Nothing
  , xmlItemPrefixNsArray = Nothing
  , xmlItemPrefixNsWrappedArray = Nothing
  }


-- * Enums


-- ** E'ArrayEnum

-- | Enum of 'Text'
data E'ArrayEnum
  = E'ArrayEnum'Fish -- ^ @"fish"@
  | E'ArrayEnum'Crab -- ^ @"crab"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'ArrayEnum where toJSON = A.toJSON . fromE'ArrayEnum
instance A.FromJSON E'ArrayEnum where parseJSON o = P.either P.fail (pure . P.id) . toE'ArrayEnum =<< A.parseJSON o
instance WH.ToHttpApiData E'ArrayEnum where toQueryParam = WH.toQueryParam . fromE'ArrayEnum
instance WH.FromHttpApiData E'ArrayEnum where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'ArrayEnum
instance MimeRender MimeMultipartFormData E'ArrayEnum where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'ArrayEnum' enum
fromE'ArrayEnum :: E'ArrayEnum -> Text
fromE'ArrayEnum = \case
  E'ArrayEnum'Fish -> "fish"
  E'ArrayEnum'Crab -> "crab"

-- | parse 'E'ArrayEnum' enum
toE'ArrayEnum :: Text -> P.Either String E'ArrayEnum
toE'ArrayEnum = \case
  "fish" -> P.Right E'ArrayEnum'Fish
  "crab" -> P.Right E'ArrayEnum'Crab
  s -> P.Left $ "toE'ArrayEnum: enum parse failure: " P.++ P.show s


-- ** E'EnumFormString

-- | Enum of 'Text' . 
-- Form parameter enum test (string)
data E'EnumFormString
  = E'EnumFormString'_abc -- ^ @"_abc"@
  | E'EnumFormString'_efg -- ^ @"-efg"@
  | E'EnumFormString'_xyz -- ^ @"(xyz)"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumFormString where toJSON = A.toJSON . fromE'EnumFormString
instance A.FromJSON E'EnumFormString where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumFormString =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumFormString where toQueryParam = WH.toQueryParam . fromE'EnumFormString
instance WH.FromHttpApiData E'EnumFormString where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumFormString
instance MimeRender MimeMultipartFormData E'EnumFormString where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumFormString' enum
fromE'EnumFormString :: E'EnumFormString -> Text
fromE'EnumFormString = \case
  E'EnumFormString'_abc -> "_abc"
  E'EnumFormString'_efg -> "-efg"
  E'EnumFormString'_xyz -> "(xyz)"

-- | parse 'E'EnumFormString' enum
toE'EnumFormString :: Text -> P.Either String E'EnumFormString
toE'EnumFormString = \case
  "_abc" -> P.Right E'EnumFormString'_abc
  "-efg" -> P.Right E'EnumFormString'_efg
  "(xyz)" -> P.Right E'EnumFormString'_xyz
  s -> P.Left $ "toE'EnumFormString: enum parse failure: " P.++ P.show s


-- ** E'EnumFormStringArray

-- | Enum of 'Text'
data E'EnumFormStringArray
  = E'EnumFormStringArray'GreaterThan -- ^ @">"@
  | E'EnumFormStringArray'Dollar -- ^ @"$"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumFormStringArray where toJSON = A.toJSON . fromE'EnumFormStringArray
instance A.FromJSON E'EnumFormStringArray where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumFormStringArray =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumFormStringArray where toQueryParam = WH.toQueryParam . fromE'EnumFormStringArray
instance WH.FromHttpApiData E'EnumFormStringArray where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumFormStringArray
instance MimeRender MimeMultipartFormData E'EnumFormStringArray where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumFormStringArray' enum
fromE'EnumFormStringArray :: E'EnumFormStringArray -> Text
fromE'EnumFormStringArray = \case
  E'EnumFormStringArray'GreaterThan -> ">"
  E'EnumFormStringArray'Dollar -> "$"

-- | parse 'E'EnumFormStringArray' enum
toE'EnumFormStringArray :: Text -> P.Either String E'EnumFormStringArray
toE'EnumFormStringArray = \case
  ">" -> P.Right E'EnumFormStringArray'GreaterThan
  "$" -> P.Right E'EnumFormStringArray'Dollar
  s -> P.Left $ "toE'EnumFormStringArray: enum parse failure: " P.++ P.show s


-- ** E'EnumInteger

-- | Enum of 'Int'
data E'EnumInteger
  = E'EnumInteger'Num1 -- ^ @1@
  | E'EnumInteger'NumMinus_1 -- ^ @-1@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumInteger where toJSON = A.toJSON . fromE'EnumInteger
instance A.FromJSON E'EnumInteger where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumInteger =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumInteger where toQueryParam = WH.toQueryParam . fromE'EnumInteger
instance WH.FromHttpApiData E'EnumInteger where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumInteger
instance MimeRender MimeMultipartFormData E'EnumInteger where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumInteger' enum
fromE'EnumInteger :: E'EnumInteger -> Int
fromE'EnumInteger = \case
  E'EnumInteger'Num1 -> 1
  E'EnumInteger'NumMinus_1 -> -1

-- | parse 'E'EnumInteger' enum
toE'EnumInteger :: Int -> P.Either String E'EnumInteger
toE'EnumInteger = \case
  1 -> P.Right E'EnumInteger'Num1
  -1 -> P.Right E'EnumInteger'NumMinus_1
  s -> P.Left $ "toE'EnumInteger: enum parse failure: " P.++ P.show s


-- ** E'EnumNumber

-- | Enum of 'Double'
data E'EnumNumber
  = E'EnumNumber'Num1_Dot_1 -- ^ @1.1@
  | E'EnumNumber'NumMinus_1_Dot_2 -- ^ @-1.2@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumNumber where toJSON = A.toJSON . fromE'EnumNumber
instance A.FromJSON E'EnumNumber where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumNumber =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumNumber where toQueryParam = WH.toQueryParam . fromE'EnumNumber
instance WH.FromHttpApiData E'EnumNumber where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumNumber
instance MimeRender MimeMultipartFormData E'EnumNumber where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumNumber' enum
fromE'EnumNumber :: E'EnumNumber -> Double
fromE'EnumNumber = \case
  E'EnumNumber'Num1_Dot_1 -> 1.1
  E'EnumNumber'NumMinus_1_Dot_2 -> -1.2

-- | parse 'E'EnumNumber' enum
toE'EnumNumber :: Double -> P.Either String E'EnumNumber
toE'EnumNumber = \case
  1.1 -> P.Right E'EnumNumber'Num1_Dot_1
  -1.2 -> P.Right E'EnumNumber'NumMinus_1_Dot_2
  s -> P.Left $ "toE'EnumNumber: enum parse failure: " P.++ P.show s


-- ** E'EnumQueryInteger

-- | Enum of 'Int'
data E'EnumQueryInteger
  = E'EnumQueryInteger'Num1 -- ^ @1@
  | E'EnumQueryInteger'NumMinus_2 -- ^ @-2@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumQueryInteger where toJSON = A.toJSON . fromE'EnumQueryInteger
instance A.FromJSON E'EnumQueryInteger where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumQueryInteger =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumQueryInteger where toQueryParam = WH.toQueryParam . fromE'EnumQueryInteger
instance WH.FromHttpApiData E'EnumQueryInteger where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumQueryInteger
instance MimeRender MimeMultipartFormData E'EnumQueryInteger where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumQueryInteger' enum
fromE'EnumQueryInteger :: E'EnumQueryInteger -> Int
fromE'EnumQueryInteger = \case
  E'EnumQueryInteger'Num1 -> 1
  E'EnumQueryInteger'NumMinus_2 -> -2

-- | parse 'E'EnumQueryInteger' enum
toE'EnumQueryInteger :: Int -> P.Either String E'EnumQueryInteger
toE'EnumQueryInteger = \case
  1 -> P.Right E'EnumQueryInteger'Num1
  -2 -> P.Right E'EnumQueryInteger'NumMinus_2
  s -> P.Left $ "toE'EnumQueryInteger: enum parse failure: " P.++ P.show s


-- ** E'EnumString

-- | Enum of 'Text'
data E'EnumString
  = E'EnumString'UPPER -- ^ @"UPPER"@
  | E'EnumString'Lower -- ^ @"lower"@
  | E'EnumString'Empty -- ^ @""@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'EnumString where toJSON = A.toJSON . fromE'EnumString
instance A.FromJSON E'EnumString where parseJSON o = P.either P.fail (pure . P.id) . toE'EnumString =<< A.parseJSON o
instance WH.ToHttpApiData E'EnumString where toQueryParam = WH.toQueryParam . fromE'EnumString
instance WH.FromHttpApiData E'EnumString where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'EnumString
instance MimeRender MimeMultipartFormData E'EnumString where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'EnumString' enum
fromE'EnumString :: E'EnumString -> Text
fromE'EnumString = \case
  E'EnumString'UPPER -> "UPPER"
  E'EnumString'Lower -> "lower"
  E'EnumString'Empty -> ""

-- | parse 'E'EnumString' enum
toE'EnumString :: Text -> P.Either String E'EnumString
toE'EnumString = \case
  "UPPER" -> P.Right E'EnumString'UPPER
  "lower" -> P.Right E'EnumString'Lower
  "" -> P.Right E'EnumString'Empty
  s -> P.Left $ "toE'EnumString: enum parse failure: " P.++ P.show s


-- ** E'Inner

-- | Enum of 'Text'
data E'Inner
  = E'Inner'UPPER -- ^ @"UPPER"@
  | E'Inner'Lower -- ^ @"lower"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Inner where toJSON = A.toJSON . fromE'Inner
instance A.FromJSON E'Inner where parseJSON o = P.either P.fail (pure . P.id) . toE'Inner =<< A.parseJSON o
instance WH.ToHttpApiData E'Inner where toQueryParam = WH.toQueryParam . fromE'Inner
instance WH.FromHttpApiData E'Inner where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Inner
instance MimeRender MimeMultipartFormData E'Inner where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Inner' enum
fromE'Inner :: E'Inner -> Text
fromE'Inner = \case
  E'Inner'UPPER -> "UPPER"
  E'Inner'Lower -> "lower"

-- | parse 'E'Inner' enum
toE'Inner :: Text -> P.Either String E'Inner
toE'Inner = \case
  "UPPER" -> P.Right E'Inner'UPPER
  "lower" -> P.Right E'Inner'Lower
  s -> P.Left $ "toE'Inner: enum parse failure: " P.++ P.show s


-- ** E'JustSymbol

-- | Enum of 'Text'
data E'JustSymbol
  = E'JustSymbol'Greater_Than_Or_Equal_To -- ^ @">="@
  | E'JustSymbol'Dollar -- ^ @"$"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'JustSymbol where toJSON = A.toJSON . fromE'JustSymbol
instance A.FromJSON E'JustSymbol where parseJSON o = P.either P.fail (pure . P.id) . toE'JustSymbol =<< A.parseJSON o
instance WH.ToHttpApiData E'JustSymbol where toQueryParam = WH.toQueryParam . fromE'JustSymbol
instance WH.FromHttpApiData E'JustSymbol where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'JustSymbol
instance MimeRender MimeMultipartFormData E'JustSymbol where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'JustSymbol' enum
fromE'JustSymbol :: E'JustSymbol -> Text
fromE'JustSymbol = \case
  E'JustSymbol'Greater_Than_Or_Equal_To -> ">="
  E'JustSymbol'Dollar -> "$"

-- | parse 'E'JustSymbol' enum
toE'JustSymbol :: Text -> P.Either String E'JustSymbol
toE'JustSymbol = \case
  ">=" -> P.Right E'JustSymbol'Greater_Than_Or_Equal_To
  "$" -> P.Right E'JustSymbol'Dollar
  s -> P.Left $ "toE'JustSymbol: enum parse failure: " P.++ P.show s


-- ** E'Kind

-- | Enum of 'Text'
data E'Kind
  = E'Kind'Lions -- ^ @"lions"@
  | E'Kind'Tigers -- ^ @"tigers"@
  | E'Kind'Leopards -- ^ @"leopards"@
  | E'Kind'Jaguars -- ^ @"jaguars"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Kind where toJSON = A.toJSON . fromE'Kind
instance A.FromJSON E'Kind where parseJSON o = P.either P.fail (pure . P.id) . toE'Kind =<< A.parseJSON o
instance WH.ToHttpApiData E'Kind where toQueryParam = WH.toQueryParam . fromE'Kind
instance WH.FromHttpApiData E'Kind where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Kind
instance MimeRender MimeMultipartFormData E'Kind where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Kind' enum
fromE'Kind :: E'Kind -> Text
fromE'Kind = \case
  E'Kind'Lions -> "lions"
  E'Kind'Tigers -> "tigers"
  E'Kind'Leopards -> "leopards"
  E'Kind'Jaguars -> "jaguars"

-- | parse 'E'Kind' enum
toE'Kind :: Text -> P.Either String E'Kind
toE'Kind = \case
  "lions" -> P.Right E'Kind'Lions
  "tigers" -> P.Right E'Kind'Tigers
  "leopards" -> P.Right E'Kind'Leopards
  "jaguars" -> P.Right E'Kind'Jaguars
  s -> P.Left $ "toE'Kind: enum parse failure: " P.++ P.show s


-- ** E'Status

-- | Enum of 'Text' . 
-- Order Status
data E'Status
  = E'Status'Placed -- ^ @"placed"@
  | E'Status'Approved -- ^ @"approved"@
  | E'Status'Delivered -- ^ @"delivered"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Status where toJSON = A.toJSON . fromE'Status
instance A.FromJSON E'Status where parseJSON o = P.either P.fail (pure . P.id) . toE'Status =<< A.parseJSON o
instance WH.ToHttpApiData E'Status where toQueryParam = WH.toQueryParam . fromE'Status
instance WH.FromHttpApiData E'Status where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Status
instance MimeRender MimeMultipartFormData E'Status where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Status' enum
fromE'Status :: E'Status -> Text
fromE'Status = \case
  E'Status'Placed -> "placed"
  E'Status'Approved -> "approved"
  E'Status'Delivered -> "delivered"

-- | parse 'E'Status' enum
toE'Status :: Text -> P.Either String E'Status
toE'Status = \case
  "placed" -> P.Right E'Status'Placed
  "approved" -> P.Right E'Status'Approved
  "delivered" -> P.Right E'Status'Delivered
  s -> P.Left $ "toE'Status: enum parse failure: " P.++ P.show s


-- ** E'Status2

-- | Enum of 'Text' . 
-- pet status in the store
data E'Status2
  = E'Status2'Available -- ^ @"available"@
  | E'Status2'Pending -- ^ @"pending"@
  | E'Status2'Sold -- ^ @"sold"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON E'Status2 where toJSON = A.toJSON . fromE'Status2
instance A.FromJSON E'Status2 where parseJSON o = P.either P.fail (pure . P.id) . toE'Status2 =<< A.parseJSON o
instance WH.ToHttpApiData E'Status2 where toQueryParam = WH.toQueryParam . fromE'Status2
instance WH.FromHttpApiData E'Status2 where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toE'Status2
instance MimeRender MimeMultipartFormData E'Status2 where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'E'Status2' enum
fromE'Status2 :: E'Status2 -> Text
fromE'Status2 = \case
  E'Status2'Available -> "available"
  E'Status2'Pending -> "pending"
  E'Status2'Sold -> "sold"

-- | parse 'E'Status2' enum
toE'Status2 :: Text -> P.Either String E'Status2
toE'Status2 = \case
  "available" -> P.Right E'Status2'Available
  "pending" -> P.Right E'Status2'Pending
  "sold" -> P.Right E'Status2'Sold
  s -> P.Left $ "toE'Status2: enum parse failure: " P.++ P.show s


-- ** EnumClass

-- | Enum of 'Text'
data EnumClass
  = EnumClass'_abc -- ^ @"_abc"@
  | EnumClass'_efg -- ^ @"-efg"@
  | EnumClass'_xyz -- ^ @"(xyz)"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON EnumClass where toJSON = A.toJSON . fromEnumClass
instance A.FromJSON EnumClass where parseJSON o = P.either P.fail (pure . P.id) . toEnumClass =<< A.parseJSON o
instance WH.ToHttpApiData EnumClass where toQueryParam = WH.toQueryParam . fromEnumClass
instance WH.FromHttpApiData EnumClass where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toEnumClass
instance MimeRender MimeMultipartFormData EnumClass where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'EnumClass' enum
fromEnumClass :: EnumClass -> Text
fromEnumClass = \case
  EnumClass'_abc -> "_abc"
  EnumClass'_efg -> "-efg"
  EnumClass'_xyz -> "(xyz)"

-- | parse 'EnumClass' enum
toEnumClass :: Text -> P.Either String EnumClass
toEnumClass = \case
  "_abc" -> P.Right EnumClass'_abc
  "-efg" -> P.Right EnumClass'_efg
  "(xyz)" -> P.Right EnumClass'_xyz
  s -> P.Left $ "toEnumClass: enum parse failure: " P.++ P.show s


-- ** OuterEnum

-- | Enum of 'Text'
data OuterEnum
  = OuterEnum'Placed -- ^ @"placed"@
  | OuterEnum'Approved -- ^ @"approved"@
  | OuterEnum'Delivered -- ^ @"delivered"@
  deriving (P.Show, P.Eq, P.Typeable, P.Ord, P.Bounded, P.Enum)

instance A.ToJSON OuterEnum where toJSON = A.toJSON . fromOuterEnum
instance A.FromJSON OuterEnum where parseJSON o = P.either P.fail (pure . P.id) . toOuterEnum =<< A.parseJSON o
instance WH.ToHttpApiData OuterEnum where toQueryParam = WH.toQueryParam . fromOuterEnum
instance WH.FromHttpApiData OuterEnum where parseQueryParam o = WH.parseQueryParam o >>= P.left T.pack . toOuterEnum
instance MimeRender MimeMultipartFormData OuterEnum where mimeRender _ = mimeRenderDefaultMultipartFormData

-- | unwrap 'OuterEnum' enum
fromOuterEnum :: OuterEnum -> Text
fromOuterEnum = \case
  OuterEnum'Placed -> "placed"
  OuterEnum'Approved -> "approved"
  OuterEnum'Delivered -> "delivered"

-- | parse 'OuterEnum' enum
toOuterEnum :: Text -> P.Either String OuterEnum
toOuterEnum = \case
  "placed" -> P.Right OuterEnum'Placed
  "approved" -> P.Right OuterEnum'Approved
  "delivered" -> P.Right OuterEnum'Delivered
  s -> P.Left $ "toOuterEnum: enum parse failure: " P.++ P.show s


-- * Auth Methods

-- ** AuthApiKeyApiKey
data AuthApiKeyApiKey =
  AuthApiKeyApiKey Text -- ^ secret
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthApiKeyApiKey where
  applyAuthMethod _ a@(AuthApiKeyApiKey secret) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setHeader` toHeader ("api_key", secret)
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req

-- ** AuthApiKeyApiKeyQuery
data AuthApiKeyApiKeyQuery =
  AuthApiKeyApiKeyQuery Text -- ^ secret
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthApiKeyApiKeyQuery where
  applyAuthMethod _ a@(AuthApiKeyApiKeyQuery secret) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setQuery` toQuery ("api_key_query", Just secret)
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req

-- ** AuthBasicHttpBasicTest
data AuthBasicHttpBasicTest =
  AuthBasicHttpBasicTest B.ByteString B.ByteString -- ^ username password
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthBasicHttpBasicTest where
  applyAuthMethod _ a@(AuthBasicHttpBasicTest user pw) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setHeader` toHeader ("Authorization", T.decodeUtf8 cred)
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req
    where cred = BC.append "Basic " (B64.encode $ BC.concat [ user, ":", pw ])

-- ** AuthOAuthPetstoreAuth
data AuthOAuthPetstoreAuth =
  AuthOAuthPetstoreAuth Text -- ^ secret
  deriving (P.Eq, P.Show, P.Typeable)

instance AuthMethod AuthOAuthPetstoreAuth where
  applyAuthMethod _ a@(AuthOAuthPetstoreAuth secret) req =
    P.pure $
    if (P.typeOf a `P.elem` rAuthTypes req)
      then req `setHeader` toHeader ("Authorization", "Bearer " <> secret) 
           & L.over rAuthTypesL (P.filter (/= P.typeOf a))
      else req


