# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import
import six

import unittest
if six.PY3:
    from unittest.mock import patch
else:
    from mock import patch

import petstore_api
from petstore_api.api.fake_api import FakeApi  # noqa: E501
from petstore_api.rest import ApiException


class TestFakeApi(unittest.TestCase):
    """FakeApi unit test stubs"""

    def setUp(self):
        self.api = petstore_api.api.fake_api.FakeApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_xml_item(self):
        """Test case for create_xml_item

        creates an XmlItem  # noqa: E501
        """
        pass

    def test_fake_outer_boolean_serialize(self):
        """Test case for fake_outer_boolean_serialize

        """
        pass

    def test_fake_outer_composite_serialize(self):
        """Test case for fake_outer_composite_serialize

        """
        pass

    def test_fake_outer_enum_serialize(self):
        """Test case for fake_outer_enum_serialize

        """
        # verify that the input and output are type OuterEnum
        endpoint = self.api.fake_outer_enum_serialize
        assert endpoint.openapi_types['body'] == (petstore_api.OuterEnum,)
        assert endpoint.settings['response_type'] == (petstore_api.OuterEnum,)

    def test_fake_outer_number_serialize(self):
        """Test case for fake_outer_number_serialize

        """
        # verify that the input and output are the correct type
        endpoint = self.api.fake_outer_number_serialize
        assert endpoint.openapi_types['body'] == (petstore_api.OuterNumber,)
        assert endpoint.settings['response_type'] == (petstore_api.OuterNumber,)

    def test_fake_outer_string_serialize(self):
        """Test case for fake_outer_string_serialize

        """
        pass

    def test_test_body_with_file_schema(self):
        """Test case for test_body_with_file_schema

        """
        pass

    def test_test_body_with_query_params(self):
        """Test case for test_body_with_query_params

        """
        pass

    def test_test_client_model(self):
        """Test case for test_client_model

        To test \"client\" model  # noqa: E501
        """
        pass

    def test_test_endpoint_enums_length_one(self):
        """Test case for test_endpoint_enums_length_one

        """
        # when we omit the required enums of length one, they are still set
        endpoint = self.api.test_endpoint_enums_length_one
        with patch.object(endpoint, 'call_with_http_info') as call_with_http_info:
            endpoint()
            call_with_http_info.assert_called_with(
                _check_input_type=True,
                _check_return_type=True,
                _host_index=0,
                _preload_content=True,
                _request_timeout=None,
                _return_http_data_only=True,
                async_req=False,
                header_number=1.234,
                path_integer=34,
                path_string='hello',
                query_integer=3,
                query_string='brillig'
            )

    def test_test_endpoint_parameters(self):
        """Test case for test_endpoint_parameters

        Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트   # noqa: E501
        """
        # check that we can access the endpoint's validations
        endpoint = self.api.test_endpoint_parameters
        assert endpoint.validations[('number',)] == {
            'inclusive_maximum': 543.2,
            'inclusive_minimum': 32.1,
        }
        # make sure that an exception is thrown on an invalid value
        keyword_args = dict(
            number=544,  # invalid
            double=100,
            pattern_without_delimiter="abc",
            byte='sample string'
        )
        with self.assertRaises(petstore_api.ApiValueError):
            self.api.test_endpoint_parameters(**keyword_args)

    def test_test_enum_parameters(self):
        """Test case for test_enum_parameters

        To test enum parameters  # noqa: E501
        """
        # check that we can access the endpoint's allowed_values
        endpoint = self.api.test_enum_parameters
        assert endpoint.allowed_values[('enum_query_string',)] == {
            "_ABC": "_abc",
            "-EFG": "-efg",
            "(XYZ)": "(xyz)"
        }
        # make sure that an exception is thrown on an invalid value
        keyword_args = dict(enum_query_string="bad value")
        with self.assertRaises(petstore_api.ApiValueError):
            self.api.test_enum_parameters(**keyword_args)

    def test_test_group_parameters(self):
        """Test case for test_group_parameters

        Fake endpoint to test group parameters (optional)  # noqa: E501
        """
        pass

    def test_test_inline_additional_properties(self):
        """Test case for test_inline_additional_properties

        test inline additionalProperties  # noqa: E501
        """
        pass

    def test_test_json_form_data(self):
        """Test case for test_json_form_data

        test json serialization of form data  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
