/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct UserApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> UserApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> UserApiClient<C> {
        UserApiClient {
            configuration,
        }
    }
}

pub trait UserApi {
    fn create_user(&self, body: crate::models::User) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>>;
    fn create_users_with_array_input(&self, body: Vec<crate::models::User>) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>>;
    fn create_users_with_list_input(&self, body: Vec<crate::models::User>) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>>;
    fn delete_user(&self, username: &str) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>>;
    fn get_user_by_name(&self, username: &str) -> Box<dyn Future<Item = crate::models::User, Error = Error<serde_json::Value>>>;
    fn login_user(&self, username: &str, password: &str) -> Box<dyn Future<Item = String, Error = Error<serde_json::Value>>>;
    fn logout_user(&self, ) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>>;
    fn update_user(&self, username: &str, body: crate::models::User) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>UserApi for UserApiClient<C> {
    fn create_user(&self, body: crate::models::User) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/user".to_string())
        ;
        req = req.with_body_param(body);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    fn create_users_with_array_input(&self, body: Vec<crate::models::User>) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/user/createWithArray".to_string())
        ;
        req = req.with_body_param(body);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    fn create_users_with_list_input(&self, body: Vec<crate::models::User>) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/user/createWithList".to_string())
        ;
        req = req.with_body_param(body);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    fn delete_user(&self, username: &str) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Delete, "/user/{username}".to_string())
        ;
        req = req.with_path_param("username".to_string(), username.to_string());
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    fn get_user_by_name(&self, username: &str) -> Box<dyn Future<Item = crate::models::User, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/user/{username}".to_string())
        ;
        req = req.with_path_param("username".to_string(), username.to_string());

        req.execute(self.configuration.borrow())
    }

    fn login_user(&self, username: &str, password: &str) -> Box<dyn Future<Item = String, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/user/login".to_string())
        ;
        req = req.with_query_param("username".to_string(), username.to_string());
        req = req.with_query_param("password".to_string(), password.to_string());

        req.execute(self.configuration.borrow())
    }

    fn logout_user(&self, ) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/user/logout".to_string())
        ;
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    fn update_user(&self, username: &str, body: crate::models::User) -> Box<dyn Future<Item = (), Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Put, "/user/{username}".to_string())
        ;
        req = req.with_path_param("username".to_string(), username.to_string());
        req = req.with_body_param(body);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

}
