/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Animal from './Animal';
import DogAllOf from './DogAllOf';

/**
 * The Dog model module.
 * @module model/Dog
 * @version 1.0.0
 */
class Dog {
    /**
     * Constructs a new <code>Dog</code>.
     * @alias module:model/Dog
     * @extends module:model/Animal
     * @implements module:model/Animal
     * @implements module:model/DogAllOf
     * @param className {String} 
     */
    constructor(className) { 
        Animal.initialize(this, className);DogAllOf.initialize(this);
        Dog.initialize(this, className);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, className) { 
    }

    /**
     * Constructs a <code>Dog</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Dog} obj Optional instance to populate.
     * @return {module:model/Dog} The populated <code>Dog</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Dog();
            Animal.constructFromObject(data, obj);
            Animal.constructFromObject(data, obj);
            DogAllOf.constructFromObject(data, obj);

            if (data.hasOwnProperty('breed')) {
                obj['breed'] = ApiClient.convertToType(data['breed'], 'String');
            }
        }
        return obj;
    }


}

/**
 * @member {String} breed
 */
Dog.prototype['breed'] = undefined;


// Implement Animal interface:
/**
 * @member {String} className
 */
Animal.prototype['className'] = undefined;
/**
 * @member {String} color
 * @default 'red'
 */
Animal.prototype['color'] = 'red';
// Implement DogAllOf interface:
/**
 * @member {String} breed
 */
DogAllOf.prototype['breed'] = undefined;




export default Dog;

