# petstore-api
This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientExperimentalCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import petstore_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import petstore_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import petstore_api
from pprint import pprint


# Defining host is optional and default to http://petstore.swagger.io:80/v2
configuration.host = "http://petstore.swagger.io:80/v2"
# Enter a context with an instance of the API client
with petstore_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = petstore_api.AnotherFakeApi(api_client)
    client_client = petstore_api.Client() # client.Client | client model

    try:
        # To test special tags
        api_response = api_instance.call_123_test_special_tags(client_client)
        pprint(api_response)
    except petstore_api.ApiException as e:
        print("Exception when calling AnotherFakeApi->call_123_test_special_tags: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io:80/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnotherFakeApi* | [**call_123_test_special_tags**](docs/AnotherFakeApi.md#call_123_test_special_tags) | **PATCH** /another-fake/dummy | To test special tags
*DefaultApi* | [**foo_get**](docs/DefaultApi.md#foo_get) | **GET** /foo | 
*FakeApi* | [**fake_health_get**](docs/FakeApi.md#fake_health_get) | **GET** /fake/health | Health check endpoint
*FakeApi* | [**fake_outer_boolean_serialize**](docs/FakeApi.md#fake_outer_boolean_serialize) | **POST** /fake/outer/boolean | 
*FakeApi* | [**fake_outer_composite_serialize**](docs/FakeApi.md#fake_outer_composite_serialize) | **POST** /fake/outer/composite | 
*FakeApi* | [**fake_outer_number_serialize**](docs/FakeApi.md#fake_outer_number_serialize) | **POST** /fake/outer/number | 
*FakeApi* | [**fake_outer_string_serialize**](docs/FakeApi.md#fake_outer_string_serialize) | **POST** /fake/outer/string | 
*FakeApi* | [**test_body_with_file_schema**](docs/FakeApi.md#test_body_with_file_schema) | **PUT** /fake/body-with-file-schema | 
*FakeApi* | [**test_body_with_query_params**](docs/FakeApi.md#test_body_with_query_params) | **PUT** /fake/body-with-query-params | 
*FakeApi* | [**test_client_model**](docs/FakeApi.md#test_client_model) | **PATCH** /fake | To test \&quot;client\&quot; model
*FakeApi* | [**test_endpoint_parameters**](docs/FakeApi.md#test_endpoint_parameters) | **POST** /fake | Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
*FakeApi* | [**test_enum_parameters**](docs/FakeApi.md#test_enum_parameters) | **GET** /fake | To test enum parameters
*FakeApi* | [**test_group_parameters**](docs/FakeApi.md#test_group_parameters) | **DELETE** /fake | Fake endpoint to test group parameters (optional)
*FakeApi* | [**test_inline_additional_properties**](docs/FakeApi.md#test_inline_additional_properties) | **POST** /fake/inline-additionalProperties | test inline additionalProperties
*FakeApi* | [**test_json_form_data**](docs/FakeApi.md#test_json_form_data) | **GET** /fake/jsonFormData | test json serialization of form data
*FakeApi* | [**test_query_parameter_collection_format**](docs/FakeApi.md#test_query_parameter_collection_format) | **PUT** /fake/test-query-paramters | 
*FakeClassnameTags123Api* | [**test_classname**](docs/FakeClassnameTags123Api.md#test_classname) | **PATCH** /fake_classname_test | To test class name in snake case
*PetApi* | [**add_pet**](docs/PetApi.md#add_pet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**delete_pet**](docs/PetApi.md#delete_pet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**find_pets_by_status**](docs/PetApi.md#find_pets_by_status) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**find_pets_by_tags**](docs/PetApi.md#find_pets_by_tags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**get_pet_by_id**](docs/PetApi.md#get_pet_by_id) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**update_pet**](docs/PetApi.md#update_pet) | **PUT** /pet | Update an existing pet
*PetApi* | [**update_pet_with_form**](docs/PetApi.md#update_pet_with_form) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**upload_file**](docs/PetApi.md#upload_file) | **POST** /pet/{petId}/uploadImage | uploads an image
*PetApi* | [**upload_file_with_required_file**](docs/PetApi.md#upload_file_with_required_file) | **POST** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*StoreApi* | [**delete_order**](docs/StoreApi.md#delete_order) | **DELETE** /store/order/{order_id} | Delete purchase order by ID
*StoreApi* | [**get_inventory**](docs/StoreApi.md#get_inventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**get_order_by_id**](docs/StoreApi.md#get_order_by_id) | **GET** /store/order/{order_id} | Find purchase order by ID
*StoreApi* | [**place_order**](docs/StoreApi.md#place_order) | **POST** /store/order | Place an order for a pet
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user | Create user
*UserApi* | [**create_users_with_array_input**](docs/UserApi.md#create_users_with_array_input) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**create_users_with_list_input**](docs/UserApi.md#create_users_with_list_input) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{username} | Delete user
*UserApi* | [**get_user_by_name**](docs/UserApi.md#get_user_by_name) | **GET** /user/{username} | Get user by user name
*UserApi* | [**login_user**](docs/UserApi.md#login_user) | **GET** /user/login | Logs user into the system
*UserApi* | [**logout_user**](docs/UserApi.md#logout_user) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [additional_properties_class.AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [animal.Animal](docs/Animal.md)
 - [api_response.ApiResponse](docs/ApiResponse.md)
 - [array_of_array_of_number_only.ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [array_of_number_only.ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [array_test.ArrayTest](docs/ArrayTest.md)
 - [capitalization.Capitalization](docs/Capitalization.md)
 - [cat.Cat](docs/Cat.md)
 - [cat_all_of.CatAllOf](docs/CatAllOf.md)
 - [category.Category](docs/Category.md)
 - [class_model.ClassModel](docs/ClassModel.md)
 - [client.Client](docs/Client.md)
 - [dog.Dog](docs/Dog.md)
 - [dog_all_of.DogAllOf](docs/DogAllOf.md)
 - [enum_arrays.EnumArrays](docs/EnumArrays.md)
 - [enum_class.EnumClass](docs/EnumClass.md)
 - [enum_test.EnumTest](docs/EnumTest.md)
 - [file.File](docs/File.md)
 - [file_schema_test_class.FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [foo.Foo](docs/Foo.md)
 - [format_test.FormatTest](docs/FormatTest.md)
 - [has_only_read_only.HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [health_check_result.HealthCheckResult](docs/HealthCheckResult.md)
 - [inline_object.InlineObject](docs/InlineObject.md)
 - [inline_object1.InlineObject1](docs/InlineObject1.md)
 - [inline_object2.InlineObject2](docs/InlineObject2.md)
 - [inline_object3.InlineObject3](docs/InlineObject3.md)
 - [inline_object4.InlineObject4](docs/InlineObject4.md)
 - [inline_object5.InlineObject5](docs/InlineObject5.md)
 - [inline_response_default.InlineResponseDefault](docs/InlineResponseDefault.md)
 - [list.List](docs/List.md)
 - [map_test.MapTest](docs/MapTest.md)
 - [mixed_properties_and_additional_properties_class.MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [model200_response.Model200Response](docs/Model200Response.md)
 - [model_return.ModelReturn](docs/ModelReturn.md)
 - [name.Name](docs/Name.md)
 - [nullable_class.NullableClass](docs/NullableClass.md)
 - [number_only.NumberOnly](docs/NumberOnly.md)
 - [order.Order](docs/Order.md)
 - [outer_composite.OuterComposite](docs/OuterComposite.md)
 - [outer_enum.OuterEnum](docs/OuterEnum.md)
 - [outer_enum_default_value.OuterEnumDefaultValue](docs/OuterEnumDefaultValue.md)
 - [outer_enum_integer.OuterEnumInteger](docs/OuterEnumInteger.md)
 - [outer_enum_integer_default_value.OuterEnumIntegerDefaultValue](docs/OuterEnumIntegerDefaultValue.md)
 - [pet.Pet](docs/Pet.md)
 - [read_only_first.ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [special_model_name.SpecialModelName](docs/SpecialModelName.md)
 - [string_boolean_map.StringBooleanMap](docs/StringBooleanMap.md)
 - [tag.Tag](docs/Tag.md)
 - [user.User](docs/User.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## api_key_query

- **Type**: API key
- **API key parameter name**: api_key_query
- **Location**: URL query string


## bearer_test

- **Type**: Bearer authentication (JWT)


## http_basic_test

- **Type**: HTTP basic authentication


## http_signature_test

- **Type**: HTTP signature authentication


## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets


## Author




