# OpenAPI server library for Erlang

## Overview

An Erlang server stub generated by [OpenAPI Generator](https://openapi-generator.tech) given an OpenAPI spec.

Dependency: [Cowboy](https://github.com/ninenines/cowboy)

## Prerequisites

TODO

## Getting started
Use erlang-server with erlang.mk

	1, Create an application by using erlang.mk
		$ mkdir http_server
		$ cd http_server
		$ wget https://erlang.mk/erlang.mk
		$ make -f erlang.mk bootstrap bootstrap-rel
		$ make run

	2, Modify the Makefile in the http_server directory to the following to introduce the dependency library:
		PROJECT = http_server
		PROJECT_DESCRIPTION = New project
		PROJECT_VERSION = 0.1.0

		DEPS = cowboy jesse jsx
		dep_cowboy_commit = 2.5.0
		dep_jesse_commit = 1.5.2
		dep_jsx_commit = 2.9.0
		DEP_PLUGINS = cowboy jesse jsx

		PACKAGES += rfc3339
		pkg_rfc3339_name = rfc3339
		pkg_rfc3339_description = an erlang/elixir rfc3339 lib
		pkg_rfc3339_homepage = https://github.com/talentdeficit/rfc3339
		pkg_rfc3339_fetch = git
		pkg_rfc3339_repo = https://github.com/talentdeficit/rfc3339
		pkg_rfc3339_commit = master

		 include erlang.mk

	3, Generate erlang-server project using openapi-generator
		https://github.com/OpenAPITools/openapi-generator#2---getting-started

	4, Copy erlang-server file to http_server project,Don't forget the 'priv' folder.

	5, Start in the http_server project:
		1, Introduce the following line in the http_server_app:start(_Type, _Args) function
			openapi_server:start(http_server, #{ip=>{127,0,0,1}, port=>8080, net_opts=>[]})
		2, Compilation http_server project
			$ make
		3, Start erlang virtual machine
			$erl -pa ./deps/cowboy/ebin -pa ./deps/cowlib/ebin -pa ./deps/ranch/ebin -pa ./deps/jsx/ebin -pa ./deps/jesse/ebin -pa ./deps/rfc3339/ebin -pa ./ebin
		4, Start project
			application:ensure_all_started(http_server).

