/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package org.openapitools.server

import io.ktor.locations.KtorExperimentalLocationsAPI
import io.ktor.locations.Location

object Paths {
    /**
     * Deletes a pet
     * 
     * @param petId Pet id to delete 
     * @param apiKey  (optional)
     */
    @KtorExperimentalLocationsAPI
    @Location("/pet/{petId}") class deletePet(val petId: kotlin.Long, val apiKey: kotlin.String)

    /**
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter 
     */
    @KtorExperimentalLocationsAPI
    @Location("/pet/findByStatus") class findPetsByStatus(val status: kotlin.Array<kotlin.String>)

    /**
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by 
     */
    @KtorExperimentalLocationsAPI
    @Location("/pet/findByTags") class findPetsByTags(val tags: kotlin.Array<kotlin.String>)

    /**
     * Find pet by ID
     * Returns a single pet
     * @param petId ID of pet to return 
     */
    @KtorExperimentalLocationsAPI
    @Location("/pet/{petId}") class getPetById(val petId: kotlin.Long)

    /**
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted 
     */
    @KtorExperimentalLocationsAPI
    @Location("/store/order/{orderId}") class deleteOrder(val orderId: kotlin.String)

    /**
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     */
    @KtorExperimentalLocationsAPI
    @Location("/store/inventory") class getInventory()

    /**
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
     * @param orderId ID of pet that needs to be fetched 
     */
    @KtorExperimentalLocationsAPI
    @Location("/store/order/{orderId}") class getOrderById(val orderId: kotlin.Long)

    /**
     * Delete user
     * This can only be done by the logged in user.
     * @param username The name that needs to be deleted 
     */
    @KtorExperimentalLocationsAPI
    @Location("/user/{username}") class deleteUser(val username: kotlin.String)

    /**
     * Get user by user name
     * 
     * @param username The name that needs to be fetched. Use user1 for testing. 
     */
    @KtorExperimentalLocationsAPI
    @Location("/user/{username}") class getUserByName(val username: kotlin.String)

    /**
     * Logs user into the system
     * 
     * @param username The user name for login 
     * @param password The password for login in clear text 
     */
    @KtorExperimentalLocationsAPI
    @Location("/user/login") class loginUser(val username: kotlin.String, val password: kotlin.String)

    /**
     * Logs out current logged in user session
     * 
     */
    @KtorExperimentalLocationsAPI
    @Location("/user/logout") class logoutUser()

}
