// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1alpha1"
	scheme "github.com/open-cluster-management/multicloud-operators-foundation/pkg/client/clientset_generated/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// WorksGetter has a method to return a WorkInterface.
// A group's client should implement this interface.
type WorksGetter interface {
	Works(namespace string) WorkInterface
}

// WorkInterface has methods to work with Work resources.
type WorkInterface interface {
	Create(*v1alpha1.Work) (*v1alpha1.Work, error)
	Update(*v1alpha1.Work) (*v1alpha1.Work, error)
	UpdateStatus(*v1alpha1.Work) (*v1alpha1.Work, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.Work, error)
	List(opts v1.ListOptions) (*v1alpha1.WorkList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Work, err error)
	WorkExpansion
}

// works implements WorkInterface
type works struct {
	client rest.Interface
	ns     string
}

// newWorks returns a Works
func newWorks(c *McmV1alpha1Client, namespace string) *works {
	return &works{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the work, and returns the corresponding work object, and an error if there is any.
func (c *works) Get(name string, options v1.GetOptions) (result *v1alpha1.Work, err error) {
	result = &v1alpha1.Work{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("works").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Works that match those selectors.
func (c *works) List(opts v1.ListOptions) (result *v1alpha1.WorkList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.WorkList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("works").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested works.
func (c *works) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("works").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a work and creates it.  Returns the server's representation of the work, and an error, if there is any.
func (c *works) Create(work *v1alpha1.Work) (result *v1alpha1.Work, err error) {
	result = &v1alpha1.Work{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("works").
		Body(work).
		Do().
		Into(result)
	return
}

// Update takes the representation of a work and updates it. Returns the server's representation of the work, and an error, if there is any.
func (c *works) Update(work *v1alpha1.Work) (result *v1alpha1.Work, err error) {
	result = &v1alpha1.Work{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("works").
		Name(work.Name).
		Body(work).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *works) UpdateStatus(work *v1alpha1.Work) (result *v1alpha1.Work, err error) {
	result = &v1alpha1.Work{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("works").
		Name(work.Name).
		SubResource("status").
		Body(work).
		Do().
		Into(result)
	return
}

// Delete takes name of the work and deletes it. Returns an error if one occurs.
func (c *works) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("works").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *works) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("works").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched work.
func (c *works) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Work, err error) {
	result = &v1alpha1.Work{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("works").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
