// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterStatusLister helps list ClusterStatuses.
type ClusterStatusLister interface {
	// List lists all ClusterStatuses in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.ClusterStatus, err error)
	// ClusterStatuses returns an object that can list and get ClusterStatuses.
	ClusterStatuses(namespace string) ClusterStatusNamespaceLister
	ClusterStatusListerExpansion
}

// clusterStatusLister implements the ClusterStatusLister interface.
type clusterStatusLister struct {
	indexer cache.Indexer
}

// NewClusterStatusLister returns a new ClusterStatusLister.
func NewClusterStatusLister(indexer cache.Indexer) ClusterStatusLister {
	return &clusterStatusLister{indexer: indexer}
}

// List lists all ClusterStatuses in the indexer.
func (s *clusterStatusLister) List(selector labels.Selector) (ret []*v1beta1.ClusterStatus, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ClusterStatus))
	})
	return ret, err
}

// ClusterStatuses returns an object that can list and get ClusterStatuses.
func (s *clusterStatusLister) ClusterStatuses(namespace string) ClusterStatusNamespaceLister {
	return clusterStatusNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterStatusNamespaceLister helps list and get ClusterStatuses.
type ClusterStatusNamespaceLister interface {
	// List lists all ClusterStatuses in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.ClusterStatus, err error)
	// Get retrieves the ClusterStatus from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.ClusterStatus, error)
	ClusterStatusNamespaceListerExpansion
}

// clusterStatusNamespaceLister implements the ClusterStatusNamespaceLister
// interface.
type clusterStatusNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterStatuses in the indexer for a given namespace.
func (s clusterStatusNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.ClusterStatus, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.ClusterStatus))
	})
	return ret, err
}

// Get retrieves the ClusterStatus from the indexer for a given namespace and name.
func (s clusterStatusNamespaceLister) Get(name string) (*v1beta1.ClusterStatus, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("clusterstatus"), name)
	}
	return obj.(*v1beta1.ClusterStatus), nil
}
