// +build !ignore_autogenerated

// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*ClusterConditionFilter)(nil), (*mcm.ClusterConditionFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterConditionFilter_To_mcm_ClusterConditionFilter(a.(*ClusterConditionFilter), b.(*mcm.ClusterConditionFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterConditionFilter)(nil), (*ClusterConditionFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterConditionFilter_To_v1alpha1_ClusterConditionFilter(a.(*mcm.ClusterConditionFilter), b.(*ClusterConditionFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinRequest)(nil), (*mcm.ClusterJoinRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(a.(*ClusterJoinRequest), b.(*mcm.ClusterJoinRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinRequest)(nil), (*ClusterJoinRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinRequest_To_v1alpha1_ClusterJoinRequest(a.(*mcm.ClusterJoinRequest), b.(*ClusterJoinRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinRequestList)(nil), (*mcm.ClusterJoinRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(a.(*ClusterJoinRequestList), b.(*mcm.ClusterJoinRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinRequestList)(nil), (*ClusterJoinRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinRequestList_To_v1alpha1_ClusterJoinRequestList(a.(*mcm.ClusterJoinRequestList), b.(*ClusterJoinRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinRequestSpec)(nil), (*mcm.ClusterJoinRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(a.(*ClusterJoinRequestSpec), b.(*mcm.ClusterJoinRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinRequestSpec)(nil), (*ClusterJoinRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinRequestSpec_To_v1alpha1_ClusterJoinRequestSpec(a.(*mcm.ClusterJoinRequestSpec), b.(*ClusterJoinRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterJoinStatus)(nil), (*mcm.ClusterJoinStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(a.(*ClusterJoinStatus), b.(*mcm.ClusterJoinStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterJoinStatus)(nil), (*ClusterJoinStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterJoinStatus_To_v1alpha1_ClusterJoinStatus(a.(*mcm.ClusterJoinStatus), b.(*ClusterJoinStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterRestOptions)(nil), (*mcm.ClusterRestOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterRestOptions_To_mcm_ClusterRestOptions(a.(*ClusterRestOptions), b.(*mcm.ClusterRestOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterRestOptions)(nil), (*ClusterRestOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterRestOptions_To_v1alpha1_ClusterRestOptions(a.(*mcm.ClusterRestOptions), b.(*ClusterRestOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatus)(nil), (*mcm.ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterStatus_To_mcm_ClusterStatus(a.(*ClusterStatus), b.(*mcm.ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterStatus)(nil), (*ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterStatus_To_v1alpha1_ClusterStatus(a.(*mcm.ClusterStatus), b.(*ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatusList)(nil), (*mcm.ClusterStatusList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterStatusList_To_mcm_ClusterStatusList(a.(*ClusterStatusList), b.(*mcm.ClusterStatusList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterStatusList)(nil), (*ClusterStatusList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterStatusList_To_v1alpha1_ClusterStatusList(a.(*mcm.ClusterStatusList), b.(*ClusterStatusList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatusSpec)(nil), (*mcm.ClusterStatusSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(a.(*ClusterStatusSpec), b.(*mcm.ClusterStatusSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ClusterStatusSpec)(nil), (*ClusterStatusSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ClusterStatusSpec_To_v1alpha1_ClusterStatusSpec(a.(*mcm.ClusterStatusSpec), b.(*ClusterStatusSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HelmRelease)(nil), (*mcm.HelmRelease)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HelmRelease_To_mcm_HelmRelease(a.(*HelmRelease), b.(*mcm.HelmRelease), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.HelmRelease)(nil), (*HelmRelease)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_HelmRelease_To_v1alpha1_HelmRelease(a.(*mcm.HelmRelease), b.(*HelmRelease), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HelmReleaseSpec)(nil), (*mcm.HelmReleaseSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HelmReleaseSpec_To_mcm_HelmReleaseSpec(a.(*HelmReleaseSpec), b.(*mcm.HelmReleaseSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.HelmReleaseSpec)(nil), (*HelmReleaseSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_HelmReleaseSpec_To_v1alpha1_HelmReleaseSpec(a.(*mcm.HelmReleaseSpec), b.(*HelmReleaseSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HelmWorkSpec)(nil), (*mcm.HelmWorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HelmWorkSpec_To_mcm_HelmWorkSpec(a.(*HelmWorkSpec), b.(*mcm.HelmWorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.HelmWorkSpec)(nil), (*HelmWorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_HelmWorkSpec_To_v1alpha1_HelmWorkSpec(a.(*mcm.HelmWorkSpec), b.(*HelmWorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubeWorkSpec)(nil), (*mcm.KubeWorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubeWorkSpec_To_mcm_KubeWorkSpec(a.(*KubeWorkSpec), b.(*mcm.KubeWorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.KubeWorkSpec)(nil), (*KubeWorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_KubeWorkSpec_To_v1alpha1_KubeWorkSpec(a.(*mcm.KubeWorkSpec), b.(*KubeWorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*KubernetesAPIEndpoints)(nil), (*mcm.KubernetesAPIEndpoints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_KubernetesAPIEndpoints_To_mcm_KubernetesAPIEndpoints(a.(*KubernetesAPIEndpoints), b.(*mcm.KubernetesAPIEndpoints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.KubernetesAPIEndpoints)(nil), (*KubernetesAPIEndpoints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_KubernetesAPIEndpoints_To_v1alpha1_KubernetesAPIEndpoints(a.(*mcm.KubernetesAPIEndpoints), b.(*KubernetesAPIEndpoints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LeaderVote)(nil), (*mcm.LeaderVote)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LeaderVote_To_mcm_LeaderVote(a.(*LeaderVote), b.(*mcm.LeaderVote), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.LeaderVote)(nil), (*LeaderVote)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_LeaderVote_To_v1alpha1_LeaderVote(a.(*mcm.LeaderVote), b.(*LeaderVote), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LeaderVoteList)(nil), (*mcm.LeaderVoteList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LeaderVoteList_To_mcm_LeaderVoteList(a.(*LeaderVoteList), b.(*mcm.LeaderVoteList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.LeaderVoteList)(nil), (*LeaderVoteList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_LeaderVoteList_To_v1alpha1_LeaderVoteList(a.(*mcm.LeaderVoteList), b.(*LeaderVoteList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LeaderVoteSpec)(nil), (*mcm.LeaderVoteSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LeaderVoteSpec_To_mcm_LeaderVoteSpec(a.(*LeaderVoteSpec), b.(*mcm.LeaderVoteSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.LeaderVoteSpec)(nil), (*LeaderVoteSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_LeaderVoteSpec_To_v1alpha1_LeaderVoteSpec(a.(*mcm.LeaderVoteSpec), b.(*LeaderVoteSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LeaderVoteStatus)(nil), (*mcm.LeaderVoteStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LeaderVoteStatus_To_mcm_LeaderVoteStatus(a.(*LeaderVoteStatus), b.(*mcm.LeaderVoteStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.LeaderVoteStatus)(nil), (*LeaderVoteStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_LeaderVoteStatus_To_v1alpha1_LeaderVoteStatus(a.(*mcm.LeaderVoteStatus), b.(*LeaderVoteStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementBinding)(nil), (*mcm.PlacementBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementBinding_To_mcm_PlacementBinding(a.(*PlacementBinding), b.(*mcm.PlacementBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementBinding)(nil), (*PlacementBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementBinding_To_v1alpha1_PlacementBinding(a.(*mcm.PlacementBinding), b.(*PlacementBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementBindingList)(nil), (*mcm.PlacementBindingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementBindingList_To_mcm_PlacementBindingList(a.(*PlacementBindingList), b.(*mcm.PlacementBindingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementBindingList)(nil), (*PlacementBindingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementBindingList_To_v1alpha1_PlacementBindingList(a.(*mcm.PlacementBindingList), b.(*PlacementBindingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementPolicy)(nil), (*mcm.PlacementPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementPolicy_To_mcm_PlacementPolicy(a.(*PlacementPolicy), b.(*mcm.PlacementPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementPolicy)(nil), (*PlacementPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementPolicy_To_v1alpha1_PlacementPolicy(a.(*mcm.PlacementPolicy), b.(*PlacementPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementPolicyDecision)(nil), (*mcm.PlacementPolicyDecision)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementPolicyDecision_To_mcm_PlacementPolicyDecision(a.(*PlacementPolicyDecision), b.(*mcm.PlacementPolicyDecision), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementPolicyDecision)(nil), (*PlacementPolicyDecision)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementPolicyDecision_To_v1alpha1_PlacementPolicyDecision(a.(*mcm.PlacementPolicyDecision), b.(*PlacementPolicyDecision), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementPolicyList)(nil), (*mcm.PlacementPolicyList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementPolicyList_To_mcm_PlacementPolicyList(a.(*PlacementPolicyList), b.(*mcm.PlacementPolicyList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementPolicyList)(nil), (*PlacementPolicyList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementPolicyList_To_v1alpha1_PlacementPolicyList(a.(*mcm.PlacementPolicyList), b.(*PlacementPolicyList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementPolicyRef)(nil), (*mcm.PlacementPolicyRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementPolicyRef_To_mcm_PlacementPolicyRef(a.(*PlacementPolicyRef), b.(*mcm.PlacementPolicyRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementPolicyRef)(nil), (*PlacementPolicyRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementPolicyRef_To_v1alpha1_PlacementPolicyRef(a.(*mcm.PlacementPolicyRef), b.(*PlacementPolicyRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementPolicySpec)(nil), (*mcm.PlacementPolicySpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementPolicySpec_To_mcm_PlacementPolicySpec(a.(*PlacementPolicySpec), b.(*mcm.PlacementPolicySpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementPolicySpec)(nil), (*PlacementPolicySpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementPolicySpec_To_v1alpha1_PlacementPolicySpec(a.(*mcm.PlacementPolicySpec), b.(*PlacementPolicySpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlacementPolicyStatus)(nil), (*mcm.PlacementPolicyStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlacementPolicyStatus_To_mcm_PlacementPolicyStatus(a.(*PlacementPolicyStatus), b.(*mcm.PlacementPolicyStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.PlacementPolicyStatus)(nil), (*PlacementPolicyStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_PlacementPolicyStatus_To_v1alpha1_PlacementPolicyStatus(a.(*mcm.PlacementPolicyStatus), b.(*PlacementPolicyStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceFilter)(nil), (*mcm.ResourceFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceFilter_To_mcm_ResourceFilter(a.(*ResourceFilter), b.(*mcm.ResourceFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceFilter)(nil), (*ResourceFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceFilter_To_v1alpha1_ResourceFilter(a.(*mcm.ResourceFilter), b.(*ResourceFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceHint)(nil), (*mcm.ResourceHint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceHint_To_mcm_ResourceHint(a.(*ResourceHint), b.(*mcm.ResourceHint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceHint)(nil), (*ResourceHint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceHint_To_v1alpha1_ResourceHint(a.(*mcm.ResourceHint), b.(*ResourceHint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceView)(nil), (*mcm.ResourceView)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceView_To_mcm_ResourceView(a.(*ResourceView), b.(*mcm.ResourceView), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceView)(nil), (*ResourceView)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceView_To_v1alpha1_ResourceView(a.(*mcm.ResourceView), b.(*ResourceView), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewList)(nil), (*mcm.ResourceViewList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceViewList_To_mcm_ResourceViewList(a.(*ResourceViewList), b.(*mcm.ResourceViewList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewList)(nil), (*ResourceViewList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewList_To_v1alpha1_ResourceViewList(a.(*mcm.ResourceViewList), b.(*ResourceViewList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewResult)(nil), (*mcm.ResourceViewResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceViewResult_To_mcm_ResourceViewResult(a.(*ResourceViewResult), b.(*mcm.ResourceViewResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewResult)(nil), (*ResourceViewResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewResult_To_v1alpha1_ResourceViewResult(a.(*mcm.ResourceViewResult), b.(*ResourceViewResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewResultList)(nil), (*mcm.ResourceViewResultList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceViewResultList_To_mcm_ResourceViewResultList(a.(*ResourceViewResultList), b.(*mcm.ResourceViewResultList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewResultList)(nil), (*ResourceViewResultList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewResultList_To_v1alpha1_ResourceViewResultList(a.(*mcm.ResourceViewResultList), b.(*ResourceViewResultList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewSpec)(nil), (*mcm.ResourceViewSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceViewSpec_To_mcm_ResourceViewSpec(a.(*ResourceViewSpec), b.(*mcm.ResourceViewSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewSpec)(nil), (*ResourceViewSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewSpec_To_v1alpha1_ResourceViewSpec(a.(*mcm.ResourceViewSpec), b.(*ResourceViewSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceViewStatus)(nil), (*mcm.ResourceViewStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceViewStatus_To_mcm_ResourceViewStatus(a.(*ResourceViewStatus), b.(*mcm.ResourceViewStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResourceViewStatus)(nil), (*ResourceViewStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResourceViewStatus_To_v1alpha1_ResourceViewStatus(a.(*mcm.ResourceViewStatus), b.(*ResourceViewStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResultHelmList)(nil), (*mcm.ResultHelmList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResultHelmList_To_mcm_ResultHelmList(a.(*ResultHelmList), b.(*mcm.ResultHelmList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ResultHelmList)(nil), (*ResultHelmList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ResultHelmList_To_v1alpha1_ResultHelmList(a.(*mcm.ResultHelmList), b.(*ResultHelmList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServerAddressByClientCIDR)(nil), (*mcm.ServerAddressByClientCIDR)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ServerAddressByClientCIDR_To_mcm_ServerAddressByClientCIDR(a.(*ServerAddressByClientCIDR), b.(*mcm.ServerAddressByClientCIDR), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ServerAddressByClientCIDR)(nil), (*ServerAddressByClientCIDR)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ServerAddressByClientCIDR_To_v1alpha1_ServerAddressByClientCIDR(a.(*mcm.ServerAddressByClientCIDR), b.(*ServerAddressByClientCIDR), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Subject)(nil), (*mcm.Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Subject_To_mcm_Subject(a.(*Subject), b.(*mcm.Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.Subject)(nil), (*Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_Subject_To_v1alpha1_Subject(a.(*mcm.Subject), b.(*Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ViewCondition)(nil), (*mcm.ViewCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ViewCondition_To_mcm_ViewCondition(a.(*ViewCondition), b.(*mcm.ViewCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ViewCondition)(nil), (*ViewCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ViewCondition_To_v1alpha1_ViewCondition(a.(*mcm.ViewCondition), b.(*ViewCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ViewFilter)(nil), (*mcm.ViewFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ViewFilter_To_mcm_ViewFilter(a.(*ViewFilter), b.(*mcm.ViewFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.ViewFilter)(nil), (*ViewFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_ViewFilter_To_v1alpha1_ViewFilter(a.(*mcm.ViewFilter), b.(*ViewFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Work)(nil), (*mcm.Work)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Work_To_mcm_Work(a.(*Work), b.(*mcm.Work), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.Work)(nil), (*Work)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_Work_To_v1alpha1_Work(a.(*mcm.Work), b.(*Work), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkList)(nil), (*mcm.WorkList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkList_To_mcm_WorkList(a.(*WorkList), b.(*mcm.WorkList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkList)(nil), (*WorkList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkList_To_v1alpha1_WorkList(a.(*mcm.WorkList), b.(*WorkList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSet)(nil), (*mcm.WorkSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkSet_To_mcm_WorkSet(a.(*WorkSet), b.(*mcm.WorkSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSet)(nil), (*WorkSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSet_To_v1alpha1_WorkSet(a.(*mcm.WorkSet), b.(*WorkSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSetList)(nil), (*mcm.WorkSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkSetList_To_mcm_WorkSetList(a.(*WorkSetList), b.(*mcm.WorkSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSetList)(nil), (*WorkSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSetList_To_v1alpha1_WorkSetList(a.(*mcm.WorkSetList), b.(*WorkSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSetSpec)(nil), (*mcm.WorkSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkSetSpec_To_mcm_WorkSetSpec(a.(*WorkSetSpec), b.(*mcm.WorkSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSetSpec)(nil), (*WorkSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSetSpec_To_v1alpha1_WorkSetSpec(a.(*mcm.WorkSetSpec), b.(*WorkSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSetStatus)(nil), (*mcm.WorkSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkSetStatus_To_mcm_WorkSetStatus(a.(*WorkSetStatus), b.(*mcm.WorkSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSetStatus)(nil), (*WorkSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSetStatus_To_v1alpha1_WorkSetStatus(a.(*mcm.WorkSetStatus), b.(*WorkSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkSpec)(nil), (*mcm.WorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkSpec_To_mcm_WorkSpec(a.(*WorkSpec), b.(*mcm.WorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkSpec)(nil), (*WorkSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkSpec_To_v1alpha1_WorkSpec(a.(*mcm.WorkSpec), b.(*WorkSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkStatus)(nil), (*mcm.WorkStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkStatus_To_mcm_WorkStatus(a.(*WorkStatus), b.(*mcm.WorkStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkStatus)(nil), (*WorkStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkStatus_To_v1alpha1_WorkStatus(a.(*mcm.WorkStatus), b.(*WorkStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkTemplateSpec)(nil), (*mcm.WorkTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(a.(*WorkTemplateSpec), b.(*mcm.WorkTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*mcm.WorkTemplateSpec)(nil), (*WorkTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_mcm_WorkTemplateSpec_To_v1alpha1_WorkTemplateSpec(a.(*mcm.WorkTemplateSpec), b.(*WorkTemplateSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_ClusterConditionFilter_To_mcm_ClusterConditionFilter(in *ClusterConditionFilter, out *mcm.ClusterConditionFilter, s conversion.Scope) error {
	out.Type = mcm.ClusterConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	return nil
}

// Convert_v1alpha1_ClusterConditionFilter_To_mcm_ClusterConditionFilter is an autogenerated conversion function.
func Convert_v1alpha1_ClusterConditionFilter_To_mcm_ClusterConditionFilter(in *ClusterConditionFilter, out *mcm.ClusterConditionFilter, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterConditionFilter_To_mcm_ClusterConditionFilter(in, out, s)
}

func autoConvert_mcm_ClusterConditionFilter_To_v1alpha1_ClusterConditionFilter(in *mcm.ClusterConditionFilter, out *ClusterConditionFilter, s conversion.Scope) error {
	out.Type = ClusterConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	return nil
}

// Convert_mcm_ClusterConditionFilter_To_v1alpha1_ClusterConditionFilter is an autogenerated conversion function.
func Convert_mcm_ClusterConditionFilter_To_v1alpha1_ClusterConditionFilter(in *mcm.ClusterConditionFilter, out *ClusterConditionFilter, s conversion.Scope) error {
	return autoConvert_mcm_ClusterConditionFilter_To_v1alpha1_ClusterConditionFilter(in, out, s)
}

func autoConvert_v1alpha1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(in *ClusterJoinRequest, out *mcm.ClusterJoinRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ClusterJoinRequest_To_mcm_ClusterJoinRequest is an autogenerated conversion function.
func Convert_v1alpha1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(in *ClusterJoinRequest, out *mcm.ClusterJoinRequest, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterJoinRequest_To_mcm_ClusterJoinRequest(in, out, s)
}

func autoConvert_mcm_ClusterJoinRequest_To_v1alpha1_ClusterJoinRequest(in *mcm.ClusterJoinRequest, out *ClusterJoinRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_ClusterJoinRequestSpec_To_v1alpha1_ClusterJoinRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_ClusterJoinStatus_To_v1alpha1_ClusterJoinStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_ClusterJoinRequest_To_v1alpha1_ClusterJoinRequest is an autogenerated conversion function.
func Convert_mcm_ClusterJoinRequest_To_v1alpha1_ClusterJoinRequest(in *mcm.ClusterJoinRequest, out *ClusterJoinRequest, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinRequest_To_v1alpha1_ClusterJoinRequest(in, out, s)
}

func autoConvert_v1alpha1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(in *ClusterJoinRequestList, out *mcm.ClusterJoinRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.ClusterJoinRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList is an autogenerated conversion function.
func Convert_v1alpha1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(in *ClusterJoinRequestList, out *mcm.ClusterJoinRequestList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterJoinRequestList_To_mcm_ClusterJoinRequestList(in, out, s)
}

func autoConvert_mcm_ClusterJoinRequestList_To_v1alpha1_ClusterJoinRequestList(in *mcm.ClusterJoinRequestList, out *ClusterJoinRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ClusterJoinRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ClusterJoinRequestList_To_v1alpha1_ClusterJoinRequestList is an autogenerated conversion function.
func Convert_mcm_ClusterJoinRequestList_To_v1alpha1_ClusterJoinRequestList(in *mcm.ClusterJoinRequestList, out *ClusterJoinRequestList, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinRequestList_To_v1alpha1_ClusterJoinRequestList(in, out, s)
}

func autoConvert_v1alpha1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(in *ClusterJoinRequestSpec, out *mcm.ClusterJoinRequestSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.ClusterNamespace = in.ClusterNamespace
	out.CSR = in.CSR
	return nil
}

// Convert_v1alpha1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec is an autogenerated conversion function.
func Convert_v1alpha1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(in *ClusterJoinRequestSpec, out *mcm.ClusterJoinRequestSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterJoinRequestSpec_To_mcm_ClusterJoinRequestSpec(in, out, s)
}

func autoConvert_mcm_ClusterJoinRequestSpec_To_v1alpha1_ClusterJoinRequestSpec(in *mcm.ClusterJoinRequestSpec, out *ClusterJoinRequestSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.ClusterNamespace = in.ClusterNamespace
	out.CSR = in.CSR
	return nil
}

// Convert_mcm_ClusterJoinRequestSpec_To_v1alpha1_ClusterJoinRequestSpec is an autogenerated conversion function.
func Convert_mcm_ClusterJoinRequestSpec_To_v1alpha1_ClusterJoinRequestSpec(in *mcm.ClusterJoinRequestSpec, out *ClusterJoinRequestSpec, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinRequestSpec_To_v1alpha1_ClusterJoinRequestSpec(in, out, s)
}

func autoConvert_v1alpha1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(in *ClusterJoinStatus, out *mcm.ClusterJoinStatus, s conversion.Scope) error {
	out.Phase = mcm.JoinRequestPhase(in.Phase)
	out.CSRStatus = in.CSRStatus
	return nil
}

// Convert_v1alpha1_ClusterJoinStatus_To_mcm_ClusterJoinStatus is an autogenerated conversion function.
func Convert_v1alpha1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(in *ClusterJoinStatus, out *mcm.ClusterJoinStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterJoinStatus_To_mcm_ClusterJoinStatus(in, out, s)
}

func autoConvert_mcm_ClusterJoinStatus_To_v1alpha1_ClusterJoinStatus(in *mcm.ClusterJoinStatus, out *ClusterJoinStatus, s conversion.Scope) error {
	out.Phase = JoinRequestPhase(in.Phase)
	out.CSRStatus = in.CSRStatus
	return nil
}

// Convert_mcm_ClusterJoinStatus_To_v1alpha1_ClusterJoinStatus is an autogenerated conversion function.
func Convert_mcm_ClusterJoinStatus_To_v1alpha1_ClusterJoinStatus(in *mcm.ClusterJoinStatus, out *ClusterJoinStatus, s conversion.Scope) error {
	return autoConvert_mcm_ClusterJoinStatus_To_v1alpha1_ClusterJoinStatus(in, out, s)
}

func autoConvert_v1alpha1_ClusterRestOptions_To_mcm_ClusterRestOptions(in *ClusterRestOptions, out *mcm.ClusterRestOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_v1alpha1_ClusterRestOptions_To_mcm_ClusterRestOptions is an autogenerated conversion function.
func Convert_v1alpha1_ClusterRestOptions_To_mcm_ClusterRestOptions(in *ClusterRestOptions, out *mcm.ClusterRestOptions, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterRestOptions_To_mcm_ClusterRestOptions(in, out, s)
}

func autoConvert_mcm_ClusterRestOptions_To_v1alpha1_ClusterRestOptions(in *mcm.ClusterRestOptions, out *ClusterRestOptions, s conversion.Scope) error {
	out.Path = in.Path
	return nil
}

// Convert_mcm_ClusterRestOptions_To_v1alpha1_ClusterRestOptions is an autogenerated conversion function.
func Convert_mcm_ClusterRestOptions_To_v1alpha1_ClusterRestOptions(in *mcm.ClusterRestOptions, out *ClusterRestOptions, s conversion.Scope) error {
	return autoConvert_mcm_ClusterRestOptions_To_v1alpha1_ClusterRestOptions(in, out, s)
}

func autoConvert_v1alpha1_ClusterStatus_To_mcm_ClusterStatus(in *ClusterStatus, out *mcm.ClusterStatus, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ClusterStatus_To_mcm_ClusterStatus is an autogenerated conversion function.
func Convert_v1alpha1_ClusterStatus_To_mcm_ClusterStatus(in *ClusterStatus, out *mcm.ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterStatus_To_mcm_ClusterStatus(in, out, s)
}

func autoConvert_mcm_ClusterStatus_To_v1alpha1_ClusterStatus(in *mcm.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_ClusterStatusSpec_To_v1alpha1_ClusterStatusSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_ClusterStatus_To_v1alpha1_ClusterStatus is an autogenerated conversion function.
func Convert_mcm_ClusterStatus_To_v1alpha1_ClusterStatus(in *mcm.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	return autoConvert_mcm_ClusterStatus_To_v1alpha1_ClusterStatus(in, out, s)
}

func autoConvert_v1alpha1_ClusterStatusList_To_mcm_ClusterStatusList(in *ClusterStatusList, out *mcm.ClusterStatusList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]mcm.ClusterStatus, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_ClusterStatus_To_mcm_ClusterStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_ClusterStatusList_To_mcm_ClusterStatusList is an autogenerated conversion function.
func Convert_v1alpha1_ClusterStatusList_To_mcm_ClusterStatusList(in *ClusterStatusList, out *mcm.ClusterStatusList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterStatusList_To_mcm_ClusterStatusList(in, out, s)
}

func autoConvert_mcm_ClusterStatusList_To_v1alpha1_ClusterStatusList(in *mcm.ClusterStatusList, out *ClusterStatusList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterStatus, len(*in))
		for i := range *in {
			if err := Convert_mcm_ClusterStatus_To_v1alpha1_ClusterStatus(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_mcm_ClusterStatusList_To_v1alpha1_ClusterStatusList is an autogenerated conversion function.
func Convert_mcm_ClusterStatusList_To_v1alpha1_ClusterStatusList(in *mcm.ClusterStatusList, out *ClusterStatusList, s conversion.Scope) error {
	return autoConvert_mcm_ClusterStatusList_To_v1alpha1_ClusterStatusList(in, out, s)
}

func autoConvert_v1alpha1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(in *ClusterStatusSpec, out *mcm.ClusterStatusSpec, s conversion.Scope) error {
	out.MasterAddresses = *(*[]v1.EndpointAddress)(unsafe.Pointer(&in.MasterAddresses))
	out.ConsoleURL = in.ConsoleURL
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Usage = *(*v1.ResourceList)(unsafe.Pointer(&in.Usage))
	out.KlusterletEndpoint = in.KlusterletEndpoint
	out.KlusterletPort = in.KlusterletPort
	out.MonitoringScrapeTarget = in.MonitoringScrapeTarget
	out.KlusterletVersion = in.KlusterletVersion
	out.Version = in.Version
	out.KlusterletCA = *(*[]byte)(unsafe.Pointer(&in.KlusterletCA))
	out.EndpointVersion = in.EndpointVersion
	out.EndpointOperatorVersion = in.EndpointOperatorVersion
	return nil
}

// Convert_v1alpha1_ClusterStatusSpec_To_mcm_ClusterStatusSpec is an autogenerated conversion function.
func Convert_v1alpha1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(in *ClusterStatusSpec, out *mcm.ClusterStatusSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterStatusSpec_To_mcm_ClusterStatusSpec(in, out, s)
}

func autoConvert_mcm_ClusterStatusSpec_To_v1alpha1_ClusterStatusSpec(in *mcm.ClusterStatusSpec, out *ClusterStatusSpec, s conversion.Scope) error {
	out.MasterAddresses = *(*[]v1.EndpointAddress)(unsafe.Pointer(&in.MasterAddresses))
	out.ConsoleURL = in.ConsoleURL
	out.Capacity = *(*v1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Usage = *(*v1.ResourceList)(unsafe.Pointer(&in.Usage))
	out.KlusterletEndpoint = in.KlusterletEndpoint
	out.KlusterletPort = in.KlusterletPort
	out.KlusterletVersion = in.KlusterletVersion
	out.KlusterletCA = *(*[]byte)(unsafe.Pointer(&in.KlusterletCA))
	out.MonitoringScrapeTarget = in.MonitoringScrapeTarget
	out.Version = in.Version
	out.EndpointVersion = in.EndpointVersion
	out.EndpointOperatorVersion = in.EndpointOperatorVersion
	return nil
}

// Convert_mcm_ClusterStatusSpec_To_v1alpha1_ClusterStatusSpec is an autogenerated conversion function.
func Convert_mcm_ClusterStatusSpec_To_v1alpha1_ClusterStatusSpec(in *mcm.ClusterStatusSpec, out *ClusterStatusSpec, s conversion.Scope) error {
	return autoConvert_mcm_ClusterStatusSpec_To_v1alpha1_ClusterStatusSpec(in, out, s)
}

func autoConvert_v1alpha1_HelmRelease_To_mcm_HelmRelease(in *HelmRelease, out *mcm.HelmRelease, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_HelmReleaseSpec_To_mcm_HelmReleaseSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_HelmRelease_To_mcm_HelmRelease is an autogenerated conversion function.
func Convert_v1alpha1_HelmRelease_To_mcm_HelmRelease(in *HelmRelease, out *mcm.HelmRelease, s conversion.Scope) error {
	return autoConvert_v1alpha1_HelmRelease_To_mcm_HelmRelease(in, out, s)
}

func autoConvert_mcm_HelmRelease_To_v1alpha1_HelmRelease(in *mcm.HelmRelease, out *HelmRelease, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_HelmReleaseSpec_To_v1alpha1_HelmReleaseSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_HelmRelease_To_v1alpha1_HelmRelease is an autogenerated conversion function.
func Convert_mcm_HelmRelease_To_v1alpha1_HelmRelease(in *mcm.HelmRelease, out *HelmRelease, s conversion.Scope) error {
	return autoConvert_mcm_HelmRelease_To_v1alpha1_HelmRelease(in, out, s)
}

func autoConvert_v1alpha1_HelmReleaseSpec_To_mcm_HelmReleaseSpec(in *HelmReleaseSpec, out *mcm.HelmReleaseSpec, s conversion.Scope) error {
	out.ReleaseName = in.ReleaseName
	out.Description = in.Description
	out.FirstDeployed = in.FirstDeployed
	out.LastDeployed = in.LastDeployed
	out.Manifest = in.Manifest
	out.ChartName = in.ChartName
	out.ChartVersion = in.ChartVersion
	out.Namespace = in.Namespace
	out.Version = in.Version
	out.Status = in.Status
	return nil
}

// Convert_v1alpha1_HelmReleaseSpec_To_mcm_HelmReleaseSpec is an autogenerated conversion function.
func Convert_v1alpha1_HelmReleaseSpec_To_mcm_HelmReleaseSpec(in *HelmReleaseSpec, out *mcm.HelmReleaseSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_HelmReleaseSpec_To_mcm_HelmReleaseSpec(in, out, s)
}

func autoConvert_mcm_HelmReleaseSpec_To_v1alpha1_HelmReleaseSpec(in *mcm.HelmReleaseSpec, out *HelmReleaseSpec, s conversion.Scope) error {
	out.ReleaseName = in.ReleaseName
	out.Description = in.Description
	out.FirstDeployed = in.FirstDeployed
	out.LastDeployed = in.LastDeployed
	out.Manifest = in.Manifest
	out.ChartName = in.ChartName
	out.ChartVersion = in.ChartVersion
	out.Namespace = in.Namespace
	out.Version = in.Version
	out.Status = in.Status
	return nil
}

// Convert_mcm_HelmReleaseSpec_To_v1alpha1_HelmReleaseSpec is an autogenerated conversion function.
func Convert_mcm_HelmReleaseSpec_To_v1alpha1_HelmReleaseSpec(in *mcm.HelmReleaseSpec, out *HelmReleaseSpec, s conversion.Scope) error {
	return autoConvert_mcm_HelmReleaseSpec_To_v1alpha1_HelmReleaseSpec(in, out, s)
}

func autoConvert_v1alpha1_HelmWorkSpec_To_mcm_HelmWorkSpec(in *HelmWorkSpec, out *mcm.HelmWorkSpec, s conversion.Scope) error {
	out.ReleaseName = in.ReleaseName
	out.InSecureSkipVerify = in.InSecureSkipVerify
	out.ChartName = in.ChartName
	out.Version = in.Version
	out.ChartURL = in.ChartURL
	out.Namespace = in.Namespace
	out.Values = *(*[]byte)(unsafe.Pointer(&in.Values))
	out.ValuesURL = in.ValuesURL
	return nil
}

// Convert_v1alpha1_HelmWorkSpec_To_mcm_HelmWorkSpec is an autogenerated conversion function.
func Convert_v1alpha1_HelmWorkSpec_To_mcm_HelmWorkSpec(in *HelmWorkSpec, out *mcm.HelmWorkSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_HelmWorkSpec_To_mcm_HelmWorkSpec(in, out, s)
}

func autoConvert_mcm_HelmWorkSpec_To_v1alpha1_HelmWorkSpec(in *mcm.HelmWorkSpec, out *HelmWorkSpec, s conversion.Scope) error {
	out.ReleaseName = in.ReleaseName
	out.InSecureSkipVerify = in.InSecureSkipVerify
	out.ChartName = in.ChartName
	out.Version = in.Version
	out.ChartURL = in.ChartURL
	out.Namespace = in.Namespace
	out.Values = *(*[]byte)(unsafe.Pointer(&in.Values))
	out.ValuesURL = in.ValuesURL
	return nil
}

// Convert_mcm_HelmWorkSpec_To_v1alpha1_HelmWorkSpec is an autogenerated conversion function.
func Convert_mcm_HelmWorkSpec_To_v1alpha1_HelmWorkSpec(in *mcm.HelmWorkSpec, out *HelmWorkSpec, s conversion.Scope) error {
	return autoConvert_mcm_HelmWorkSpec_To_v1alpha1_HelmWorkSpec(in, out, s)
}

func autoConvert_v1alpha1_KubeWorkSpec_To_mcm_KubeWorkSpec(in *KubeWorkSpec, out *mcm.KubeWorkSpec, s conversion.Scope) error {
	out.Resource = in.Resource
	out.Name = in.Name
	out.Namespace = in.Namespace
	out.ObjectTemplate = in.ObjectTemplate
	return nil
}

// Convert_v1alpha1_KubeWorkSpec_To_mcm_KubeWorkSpec is an autogenerated conversion function.
func Convert_v1alpha1_KubeWorkSpec_To_mcm_KubeWorkSpec(in *KubeWorkSpec, out *mcm.KubeWorkSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubeWorkSpec_To_mcm_KubeWorkSpec(in, out, s)
}

func autoConvert_mcm_KubeWorkSpec_To_v1alpha1_KubeWorkSpec(in *mcm.KubeWorkSpec, out *KubeWorkSpec, s conversion.Scope) error {
	out.Resource = in.Resource
	out.Name = in.Name
	out.Namespace = in.Namespace
	out.ObjectTemplate = in.ObjectTemplate
	return nil
}

// Convert_mcm_KubeWorkSpec_To_v1alpha1_KubeWorkSpec is an autogenerated conversion function.
func Convert_mcm_KubeWorkSpec_To_v1alpha1_KubeWorkSpec(in *mcm.KubeWorkSpec, out *KubeWorkSpec, s conversion.Scope) error {
	return autoConvert_mcm_KubeWorkSpec_To_v1alpha1_KubeWorkSpec(in, out, s)
}

func autoConvert_v1alpha1_KubernetesAPIEndpoints_To_mcm_KubernetesAPIEndpoints(in *KubernetesAPIEndpoints, out *mcm.KubernetesAPIEndpoints, s conversion.Scope) error {
	out.ServerEndpoints = *(*[]mcm.ServerAddressByClientCIDR)(unsafe.Pointer(&in.ServerEndpoints))
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	return nil
}

// Convert_v1alpha1_KubernetesAPIEndpoints_To_mcm_KubernetesAPIEndpoints is an autogenerated conversion function.
func Convert_v1alpha1_KubernetesAPIEndpoints_To_mcm_KubernetesAPIEndpoints(in *KubernetesAPIEndpoints, out *mcm.KubernetesAPIEndpoints, s conversion.Scope) error {
	return autoConvert_v1alpha1_KubernetesAPIEndpoints_To_mcm_KubernetesAPIEndpoints(in, out, s)
}

func autoConvert_mcm_KubernetesAPIEndpoints_To_v1alpha1_KubernetesAPIEndpoints(in *mcm.KubernetesAPIEndpoints, out *KubernetesAPIEndpoints, s conversion.Scope) error {
	out.ServerEndpoints = *(*[]ServerAddressByClientCIDR)(unsafe.Pointer(&in.ServerEndpoints))
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	return nil
}

// Convert_mcm_KubernetesAPIEndpoints_To_v1alpha1_KubernetesAPIEndpoints is an autogenerated conversion function.
func Convert_mcm_KubernetesAPIEndpoints_To_v1alpha1_KubernetesAPIEndpoints(in *mcm.KubernetesAPIEndpoints, out *KubernetesAPIEndpoints, s conversion.Scope) error {
	return autoConvert_mcm_KubernetesAPIEndpoints_To_v1alpha1_KubernetesAPIEndpoints(in, out, s)
}

func autoConvert_v1alpha1_LeaderVote_To_mcm_LeaderVote(in *LeaderVote, out *mcm.LeaderVote, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_LeaderVoteSpec_To_mcm_LeaderVoteSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_LeaderVoteStatus_To_mcm_LeaderVoteStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_LeaderVote_To_mcm_LeaderVote is an autogenerated conversion function.
func Convert_v1alpha1_LeaderVote_To_mcm_LeaderVote(in *LeaderVote, out *mcm.LeaderVote, s conversion.Scope) error {
	return autoConvert_v1alpha1_LeaderVote_To_mcm_LeaderVote(in, out, s)
}

func autoConvert_mcm_LeaderVote_To_v1alpha1_LeaderVote(in *mcm.LeaderVote, out *LeaderVote, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_LeaderVoteSpec_To_v1alpha1_LeaderVoteSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_LeaderVoteStatus_To_v1alpha1_LeaderVoteStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_LeaderVote_To_v1alpha1_LeaderVote is an autogenerated conversion function.
func Convert_mcm_LeaderVote_To_v1alpha1_LeaderVote(in *mcm.LeaderVote, out *LeaderVote, s conversion.Scope) error {
	return autoConvert_mcm_LeaderVote_To_v1alpha1_LeaderVote(in, out, s)
}

func autoConvert_v1alpha1_LeaderVoteList_To_mcm_LeaderVoteList(in *LeaderVoteList, out *mcm.LeaderVoteList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.LeaderVote)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_LeaderVoteList_To_mcm_LeaderVoteList is an autogenerated conversion function.
func Convert_v1alpha1_LeaderVoteList_To_mcm_LeaderVoteList(in *LeaderVoteList, out *mcm.LeaderVoteList, s conversion.Scope) error {
	return autoConvert_v1alpha1_LeaderVoteList_To_mcm_LeaderVoteList(in, out, s)
}

func autoConvert_mcm_LeaderVoteList_To_v1alpha1_LeaderVoteList(in *mcm.LeaderVoteList, out *LeaderVoteList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]LeaderVote)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_LeaderVoteList_To_v1alpha1_LeaderVoteList is an autogenerated conversion function.
func Convert_mcm_LeaderVoteList_To_v1alpha1_LeaderVoteList(in *mcm.LeaderVoteList, out *LeaderVoteList, s conversion.Scope) error {
	return autoConvert_mcm_LeaderVoteList_To_v1alpha1_LeaderVoteList(in, out, s)
}

func autoConvert_v1alpha1_LeaderVoteSpec_To_mcm_LeaderVoteSpec(in *LeaderVoteSpec, out *mcm.LeaderVoteSpec, s conversion.Scope) error {
	out.Vote = in.Vote
	if err := Convert_v1alpha1_KubernetesAPIEndpoints_To_mcm_KubernetesAPIEndpoints(&in.KubernetesAPIEndpoints, &out.KubernetesAPIEndpoints, s); err != nil {
		return err
	}
	out.Identity = in.Identity
	return nil
}

// Convert_v1alpha1_LeaderVoteSpec_To_mcm_LeaderVoteSpec is an autogenerated conversion function.
func Convert_v1alpha1_LeaderVoteSpec_To_mcm_LeaderVoteSpec(in *LeaderVoteSpec, out *mcm.LeaderVoteSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_LeaderVoteSpec_To_mcm_LeaderVoteSpec(in, out, s)
}

func autoConvert_mcm_LeaderVoteSpec_To_v1alpha1_LeaderVoteSpec(in *mcm.LeaderVoteSpec, out *LeaderVoteSpec, s conversion.Scope) error {
	out.Vote = in.Vote
	if err := Convert_mcm_KubernetesAPIEndpoints_To_v1alpha1_KubernetesAPIEndpoints(&in.KubernetesAPIEndpoints, &out.KubernetesAPIEndpoints, s); err != nil {
		return err
	}
	out.Identity = in.Identity
	return nil
}

// Convert_mcm_LeaderVoteSpec_To_v1alpha1_LeaderVoteSpec is an autogenerated conversion function.
func Convert_mcm_LeaderVoteSpec_To_v1alpha1_LeaderVoteSpec(in *mcm.LeaderVoteSpec, out *LeaderVoteSpec, s conversion.Scope) error {
	return autoConvert_mcm_LeaderVoteSpec_To_v1alpha1_LeaderVoteSpec(in, out, s)
}

func autoConvert_v1alpha1_LeaderVoteStatus_To_mcm_LeaderVoteStatus(in *LeaderVoteStatus, out *mcm.LeaderVoteStatus, s conversion.Scope) error {
	out.Role = in.Role
	out.ReadyToServe = in.ReadyToServe
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_v1alpha1_LeaderVoteStatus_To_mcm_LeaderVoteStatus is an autogenerated conversion function.
func Convert_v1alpha1_LeaderVoteStatus_To_mcm_LeaderVoteStatus(in *LeaderVoteStatus, out *mcm.LeaderVoteStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_LeaderVoteStatus_To_mcm_LeaderVoteStatus(in, out, s)
}

func autoConvert_mcm_LeaderVoteStatus_To_v1alpha1_LeaderVoteStatus(in *mcm.LeaderVoteStatus, out *LeaderVoteStatus, s conversion.Scope) error {
	out.Role = in.Role
	out.ReadyToServe = in.ReadyToServe
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_mcm_LeaderVoteStatus_To_v1alpha1_LeaderVoteStatus is an autogenerated conversion function.
func Convert_mcm_LeaderVoteStatus_To_v1alpha1_LeaderVoteStatus(in *mcm.LeaderVoteStatus, out *LeaderVoteStatus, s conversion.Scope) error {
	return autoConvert_mcm_LeaderVoteStatus_To_v1alpha1_LeaderVoteStatus(in, out, s)
}

func autoConvert_v1alpha1_PlacementBinding_To_mcm_PlacementBinding(in *PlacementBinding, out *mcm.PlacementBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Subjects = *(*[]mcm.Subject)(unsafe.Pointer(&in.Subjects))
	if err := Convert_v1alpha1_PlacementPolicyRef_To_mcm_PlacementPolicyRef(&in.PlacementPolicyRef, &out.PlacementPolicyRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_PlacementBinding_To_mcm_PlacementBinding is an autogenerated conversion function.
func Convert_v1alpha1_PlacementBinding_To_mcm_PlacementBinding(in *PlacementBinding, out *mcm.PlacementBinding, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementBinding_To_mcm_PlacementBinding(in, out, s)
}

func autoConvert_mcm_PlacementBinding_To_v1alpha1_PlacementBinding(in *mcm.PlacementBinding, out *PlacementBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Subjects = *(*[]Subject)(unsafe.Pointer(&in.Subjects))
	if err := Convert_mcm_PlacementPolicyRef_To_v1alpha1_PlacementPolicyRef(&in.PlacementPolicyRef, &out.PlacementPolicyRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_PlacementBinding_To_v1alpha1_PlacementBinding is an autogenerated conversion function.
func Convert_mcm_PlacementBinding_To_v1alpha1_PlacementBinding(in *mcm.PlacementBinding, out *PlacementBinding, s conversion.Scope) error {
	return autoConvert_mcm_PlacementBinding_To_v1alpha1_PlacementBinding(in, out, s)
}

func autoConvert_v1alpha1_PlacementBindingList_To_mcm_PlacementBindingList(in *PlacementBindingList, out *mcm.PlacementBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.PlacementBinding)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_PlacementBindingList_To_mcm_PlacementBindingList is an autogenerated conversion function.
func Convert_v1alpha1_PlacementBindingList_To_mcm_PlacementBindingList(in *PlacementBindingList, out *mcm.PlacementBindingList, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementBindingList_To_mcm_PlacementBindingList(in, out, s)
}

func autoConvert_mcm_PlacementBindingList_To_v1alpha1_PlacementBindingList(in *mcm.PlacementBindingList, out *PlacementBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]PlacementBinding)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_PlacementBindingList_To_v1alpha1_PlacementBindingList is an autogenerated conversion function.
func Convert_mcm_PlacementBindingList_To_v1alpha1_PlacementBindingList(in *mcm.PlacementBindingList, out *PlacementBindingList, s conversion.Scope) error {
	return autoConvert_mcm_PlacementBindingList_To_v1alpha1_PlacementBindingList(in, out, s)
}

func autoConvert_v1alpha1_PlacementPolicy_To_mcm_PlacementPolicy(in *PlacementPolicy, out *mcm.PlacementPolicy, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_PlacementPolicySpec_To_mcm_PlacementPolicySpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_PlacementPolicyStatus_To_mcm_PlacementPolicyStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_PlacementPolicy_To_mcm_PlacementPolicy is an autogenerated conversion function.
func Convert_v1alpha1_PlacementPolicy_To_mcm_PlacementPolicy(in *PlacementPolicy, out *mcm.PlacementPolicy, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementPolicy_To_mcm_PlacementPolicy(in, out, s)
}

func autoConvert_mcm_PlacementPolicy_To_v1alpha1_PlacementPolicy(in *mcm.PlacementPolicy, out *PlacementPolicy, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_PlacementPolicySpec_To_v1alpha1_PlacementPolicySpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_PlacementPolicyStatus_To_v1alpha1_PlacementPolicyStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_PlacementPolicy_To_v1alpha1_PlacementPolicy is an autogenerated conversion function.
func Convert_mcm_PlacementPolicy_To_v1alpha1_PlacementPolicy(in *mcm.PlacementPolicy, out *PlacementPolicy, s conversion.Scope) error {
	return autoConvert_mcm_PlacementPolicy_To_v1alpha1_PlacementPolicy(in, out, s)
}

func autoConvert_v1alpha1_PlacementPolicyDecision_To_mcm_PlacementPolicyDecision(in *PlacementPolicyDecision, out *mcm.PlacementPolicyDecision, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.ClusterNamespace = in.ClusterNamespace
	return nil
}

// Convert_v1alpha1_PlacementPolicyDecision_To_mcm_PlacementPolicyDecision is an autogenerated conversion function.
func Convert_v1alpha1_PlacementPolicyDecision_To_mcm_PlacementPolicyDecision(in *PlacementPolicyDecision, out *mcm.PlacementPolicyDecision, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementPolicyDecision_To_mcm_PlacementPolicyDecision(in, out, s)
}

func autoConvert_mcm_PlacementPolicyDecision_To_v1alpha1_PlacementPolicyDecision(in *mcm.PlacementPolicyDecision, out *PlacementPolicyDecision, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.ClusterNamespace = in.ClusterNamespace
	return nil
}

// Convert_mcm_PlacementPolicyDecision_To_v1alpha1_PlacementPolicyDecision is an autogenerated conversion function.
func Convert_mcm_PlacementPolicyDecision_To_v1alpha1_PlacementPolicyDecision(in *mcm.PlacementPolicyDecision, out *PlacementPolicyDecision, s conversion.Scope) error {
	return autoConvert_mcm_PlacementPolicyDecision_To_v1alpha1_PlacementPolicyDecision(in, out, s)
}

func autoConvert_v1alpha1_PlacementPolicyList_To_mcm_PlacementPolicyList(in *PlacementPolicyList, out *mcm.PlacementPolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.PlacementPolicy)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_PlacementPolicyList_To_mcm_PlacementPolicyList is an autogenerated conversion function.
func Convert_v1alpha1_PlacementPolicyList_To_mcm_PlacementPolicyList(in *PlacementPolicyList, out *mcm.PlacementPolicyList, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementPolicyList_To_mcm_PlacementPolicyList(in, out, s)
}

func autoConvert_mcm_PlacementPolicyList_To_v1alpha1_PlacementPolicyList(in *mcm.PlacementPolicyList, out *PlacementPolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]PlacementPolicy)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_PlacementPolicyList_To_v1alpha1_PlacementPolicyList is an autogenerated conversion function.
func Convert_mcm_PlacementPolicyList_To_v1alpha1_PlacementPolicyList(in *mcm.PlacementPolicyList, out *PlacementPolicyList, s conversion.Scope) error {
	return autoConvert_mcm_PlacementPolicyList_To_v1alpha1_PlacementPolicyList(in, out, s)
}

func autoConvert_v1alpha1_PlacementPolicyRef_To_mcm_PlacementPolicyRef(in *PlacementPolicyRef, out *mcm.PlacementPolicyRef, s conversion.Scope) error {
	out.Name = in.Name
	out.Kind = in.Kind
	out.APIGroup = in.APIGroup
	return nil
}

// Convert_v1alpha1_PlacementPolicyRef_To_mcm_PlacementPolicyRef is an autogenerated conversion function.
func Convert_v1alpha1_PlacementPolicyRef_To_mcm_PlacementPolicyRef(in *PlacementPolicyRef, out *mcm.PlacementPolicyRef, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementPolicyRef_To_mcm_PlacementPolicyRef(in, out, s)
}

func autoConvert_mcm_PlacementPolicyRef_To_v1alpha1_PlacementPolicyRef(in *mcm.PlacementPolicyRef, out *PlacementPolicyRef, s conversion.Scope) error {
	out.Name = in.Name
	out.Kind = in.Kind
	out.APIGroup = in.APIGroup
	return nil
}

// Convert_mcm_PlacementPolicyRef_To_v1alpha1_PlacementPolicyRef is an autogenerated conversion function.
func Convert_mcm_PlacementPolicyRef_To_v1alpha1_PlacementPolicyRef(in *mcm.PlacementPolicyRef, out *PlacementPolicyRef, s conversion.Scope) error {
	return autoConvert_mcm_PlacementPolicyRef_To_v1alpha1_PlacementPolicyRef(in, out, s)
}

func autoConvert_v1alpha1_PlacementPolicySpec_To_mcm_PlacementPolicySpec(in *PlacementPolicySpec, out *mcm.PlacementPolicySpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	if err := Convert_v1alpha1_ResourceHint_To_mcm_ResourceHint(&in.ResourceSelector, &out.ResourceSelector, s); err != nil {
		return err
	}
	out.ClustersSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClustersSelector))
	out.ClusterReplicas = (*int32)(unsafe.Pointer(in.ClusterReplicas))
	out.ClusterNames = *(*[]string)(unsafe.Pointer(&in.ClusterNames))
	out.ClusterLabels = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterLabels))
	out.ClusterConditions = *(*[]mcm.ClusterConditionFilter)(unsafe.Pointer(&in.ClusterConditions))
	if err := Convert_v1alpha1_ResourceHint_To_mcm_ResourceHint(&in.ResourceHint, &out.ResourceHint, s); err != nil {
		return err
	}
	out.ComplianceNames = *(*[]string)(unsafe.Pointer(&in.ComplianceNames))
	return nil
}

// Convert_v1alpha1_PlacementPolicySpec_To_mcm_PlacementPolicySpec is an autogenerated conversion function.
func Convert_v1alpha1_PlacementPolicySpec_To_mcm_PlacementPolicySpec(in *PlacementPolicySpec, out *mcm.PlacementPolicySpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementPolicySpec_To_mcm_PlacementPolicySpec(in, out, s)
}

func autoConvert_mcm_PlacementPolicySpec_To_v1alpha1_PlacementPolicySpec(in *mcm.PlacementPolicySpec, out *PlacementPolicySpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	if err := Convert_mcm_ResourceHint_To_v1alpha1_ResourceHint(&in.ResourceSelector, &out.ResourceSelector, s); err != nil {
		return err
	}
	out.ClustersSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClustersSelector))
	out.ClusterReplicas = (*int32)(unsafe.Pointer(in.ClusterReplicas))
	out.ClusterNames = *(*[]string)(unsafe.Pointer(&in.ClusterNames))
	out.ClusterLabels = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterLabels))
	out.ClusterConditions = *(*[]ClusterConditionFilter)(unsafe.Pointer(&in.ClusterConditions))
	if err := Convert_mcm_ResourceHint_To_v1alpha1_ResourceHint(&in.ResourceHint, &out.ResourceHint, s); err != nil {
		return err
	}
	out.ComplianceNames = *(*[]string)(unsafe.Pointer(&in.ComplianceNames))
	return nil
}

// Convert_mcm_PlacementPolicySpec_To_v1alpha1_PlacementPolicySpec is an autogenerated conversion function.
func Convert_mcm_PlacementPolicySpec_To_v1alpha1_PlacementPolicySpec(in *mcm.PlacementPolicySpec, out *PlacementPolicySpec, s conversion.Scope) error {
	return autoConvert_mcm_PlacementPolicySpec_To_v1alpha1_PlacementPolicySpec(in, out, s)
}

func autoConvert_v1alpha1_PlacementPolicyStatus_To_mcm_PlacementPolicyStatus(in *PlacementPolicyStatus, out *mcm.PlacementPolicyStatus, s conversion.Scope) error {
	out.Decisions = *(*[]mcm.PlacementPolicyDecision)(unsafe.Pointer(&in.Decisions))
	return nil
}

// Convert_v1alpha1_PlacementPolicyStatus_To_mcm_PlacementPolicyStatus is an autogenerated conversion function.
func Convert_v1alpha1_PlacementPolicyStatus_To_mcm_PlacementPolicyStatus(in *PlacementPolicyStatus, out *mcm.PlacementPolicyStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlacementPolicyStatus_To_mcm_PlacementPolicyStatus(in, out, s)
}

func autoConvert_mcm_PlacementPolicyStatus_To_v1alpha1_PlacementPolicyStatus(in *mcm.PlacementPolicyStatus, out *PlacementPolicyStatus, s conversion.Scope) error {
	out.Decisions = *(*[]PlacementPolicyDecision)(unsafe.Pointer(&in.Decisions))
	return nil
}

// Convert_mcm_PlacementPolicyStatus_To_v1alpha1_PlacementPolicyStatus is an autogenerated conversion function.
func Convert_mcm_PlacementPolicyStatus_To_v1alpha1_PlacementPolicyStatus(in *mcm.PlacementPolicyStatus, out *PlacementPolicyStatus, s conversion.Scope) error {
	return autoConvert_mcm_PlacementPolicyStatus_To_v1alpha1_PlacementPolicyStatus(in, out, s)
}

func autoConvert_v1alpha1_ResourceFilter_To_mcm_ResourceFilter(in *ResourceFilter, out *mcm.ResourceFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.ResourceType = in.ResourceType
	out.Name = in.Name
	out.NameSpace = in.NameSpace
	out.Version = in.Version
	out.ServerPrint = in.ServerPrint
	out.Mode = mcm.ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_v1alpha1_ResourceFilter_To_mcm_ResourceFilter is an autogenerated conversion function.
func Convert_v1alpha1_ResourceFilter_To_mcm_ResourceFilter(in *ResourceFilter, out *mcm.ResourceFilter, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceFilter_To_mcm_ResourceFilter(in, out, s)
}

func autoConvert_mcm_ResourceFilter_To_v1alpha1_ResourceFilter(in *mcm.ResourceFilter, out *ResourceFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.ResourceType = in.ResourceType
	out.Name = in.Name
	out.NameSpace = in.NameSpace
	out.Version = in.Version
	out.ServerPrint = in.ServerPrint
	out.Mode = ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_mcm_ResourceFilter_To_v1alpha1_ResourceFilter is an autogenerated conversion function.
func Convert_mcm_ResourceFilter_To_v1alpha1_ResourceFilter(in *mcm.ResourceFilter, out *ResourceFilter, s conversion.Scope) error {
	return autoConvert_mcm_ResourceFilter_To_v1alpha1_ResourceFilter(in, out, s)
}

func autoConvert_v1alpha1_ResourceHint_To_mcm_ResourceHint(in *ResourceHint, out *mcm.ResourceHint, s conversion.Scope) error {
	out.Type = mcm.ResourceType(in.Type)
	out.Order = mcm.SelectionOrder(in.Order)
	return nil
}

// Convert_v1alpha1_ResourceHint_To_mcm_ResourceHint is an autogenerated conversion function.
func Convert_v1alpha1_ResourceHint_To_mcm_ResourceHint(in *ResourceHint, out *mcm.ResourceHint, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceHint_To_mcm_ResourceHint(in, out, s)
}

func autoConvert_mcm_ResourceHint_To_v1alpha1_ResourceHint(in *mcm.ResourceHint, out *ResourceHint, s conversion.Scope) error {
	out.Type = ResourceType(in.Type)
	out.Order = SelectionOrder(in.Order)
	return nil
}

// Convert_mcm_ResourceHint_To_v1alpha1_ResourceHint is an autogenerated conversion function.
func Convert_mcm_ResourceHint_To_v1alpha1_ResourceHint(in *mcm.ResourceHint, out *ResourceHint, s conversion.Scope) error {
	return autoConvert_mcm_ResourceHint_To_v1alpha1_ResourceHint(in, out, s)
}

func autoConvert_v1alpha1_ResourceView_To_mcm_ResourceView(in *ResourceView, out *mcm.ResourceView, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ResourceViewSpec_To_mcm_ResourceViewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ResourceViewStatus_To_mcm_ResourceViewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ResourceView_To_mcm_ResourceView is an autogenerated conversion function.
func Convert_v1alpha1_ResourceView_To_mcm_ResourceView(in *ResourceView, out *mcm.ResourceView, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceView_To_mcm_ResourceView(in, out, s)
}

func autoConvert_mcm_ResourceView_To_v1alpha1_ResourceView(in *mcm.ResourceView, out *ResourceView, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_ResourceViewSpec_To_v1alpha1_ResourceViewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_ResourceViewStatus_To_v1alpha1_ResourceViewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_ResourceView_To_v1alpha1_ResourceView is an autogenerated conversion function.
func Convert_mcm_ResourceView_To_v1alpha1_ResourceView(in *mcm.ResourceView, out *ResourceView, s conversion.Scope) error {
	return autoConvert_mcm_ResourceView_To_v1alpha1_ResourceView(in, out, s)
}

func autoConvert_v1alpha1_ResourceViewList_To_mcm_ResourceViewList(in *ResourceViewList, out *mcm.ResourceViewList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.ResourceView)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ResourceViewList_To_mcm_ResourceViewList is an autogenerated conversion function.
func Convert_v1alpha1_ResourceViewList_To_mcm_ResourceViewList(in *ResourceViewList, out *mcm.ResourceViewList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceViewList_To_mcm_ResourceViewList(in, out, s)
}

func autoConvert_mcm_ResourceViewList_To_v1alpha1_ResourceViewList(in *mcm.ResourceViewList, out *ResourceViewList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ResourceView)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ResourceViewList_To_v1alpha1_ResourceViewList is an autogenerated conversion function.
func Convert_mcm_ResourceViewList_To_v1alpha1_ResourceViewList(in *mcm.ResourceViewList, out *ResourceViewList, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewList_To_v1alpha1_ResourceViewList(in, out, s)
}

func autoConvert_v1alpha1_ResourceViewResult_To_mcm_ResourceViewResult(in *ResourceViewResult, out *mcm.ResourceViewResult, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*[]byte)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_v1alpha1_ResourceViewResult_To_mcm_ResourceViewResult is an autogenerated conversion function.
func Convert_v1alpha1_ResourceViewResult_To_mcm_ResourceViewResult(in *ResourceViewResult, out *mcm.ResourceViewResult, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceViewResult_To_mcm_ResourceViewResult(in, out, s)
}

func autoConvert_mcm_ResourceViewResult_To_v1alpha1_ResourceViewResult(in *mcm.ResourceViewResult, out *ResourceViewResult, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.Data = *(*[]byte)(unsafe.Pointer(&in.Data))
	return nil
}

// Convert_mcm_ResourceViewResult_To_v1alpha1_ResourceViewResult is an autogenerated conversion function.
func Convert_mcm_ResourceViewResult_To_v1alpha1_ResourceViewResult(in *mcm.ResourceViewResult, out *ResourceViewResult, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewResult_To_v1alpha1_ResourceViewResult(in, out, s)
}

func autoConvert_v1alpha1_ResourceViewResultList_To_mcm_ResourceViewResultList(in *ResourceViewResultList, out *mcm.ResourceViewResultList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.ResourceViewResult)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ResourceViewResultList_To_mcm_ResourceViewResultList is an autogenerated conversion function.
func Convert_v1alpha1_ResourceViewResultList_To_mcm_ResourceViewResultList(in *ResourceViewResultList, out *mcm.ResourceViewResultList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceViewResultList_To_mcm_ResourceViewResultList(in, out, s)
}

func autoConvert_mcm_ResourceViewResultList_To_v1alpha1_ResourceViewResultList(in *mcm.ResourceViewResultList, out *ResourceViewResultList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ResourceViewResult)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ResourceViewResultList_To_v1alpha1_ResourceViewResultList is an autogenerated conversion function.
func Convert_mcm_ResourceViewResultList_To_v1alpha1_ResourceViewResultList(in *mcm.ResourceViewResultList, out *ResourceViewResultList, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewResultList_To_v1alpha1_ResourceViewResultList(in, out, s)
}

func autoConvert_v1alpha1_ResourceViewSpec_To_mcm_ResourceViewSpec(in *ResourceViewSpec, out *mcm.ResourceViewSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	if err := Convert_v1alpha1_ViewFilter_To_mcm_ViewFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.SummaryOnly = in.SummaryOnly
	out.Mode = mcm.ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_v1alpha1_ResourceViewSpec_To_mcm_ResourceViewSpec is an autogenerated conversion function.
func Convert_v1alpha1_ResourceViewSpec_To_mcm_ResourceViewSpec(in *ResourceViewSpec, out *mcm.ResourceViewSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceViewSpec_To_mcm_ResourceViewSpec(in, out, s)
}

func autoConvert_mcm_ResourceViewSpec_To_v1alpha1_ResourceViewSpec(in *mcm.ResourceViewSpec, out *ResourceViewSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	if err := Convert_mcm_ViewFilter_To_v1alpha1_ViewFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.SummaryOnly = in.SummaryOnly
	out.Mode = ResourceFilterMode(in.Mode)
	out.UpdateIntervalSeconds = in.UpdateIntervalSeconds
	return nil
}

// Convert_mcm_ResourceViewSpec_To_v1alpha1_ResourceViewSpec is an autogenerated conversion function.
func Convert_mcm_ResourceViewSpec_To_v1alpha1_ResourceViewSpec(in *mcm.ResourceViewSpec, out *ResourceViewSpec, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewSpec_To_v1alpha1_ResourceViewSpec(in, out, s)
}

func autoConvert_v1alpha1_ResourceViewStatus_To_mcm_ResourceViewStatus(in *ResourceViewStatus, out *mcm.ResourceViewStatus, s conversion.Scope) error {
	out.Conditions = *(*[]mcm.ViewCondition)(unsafe.Pointer(&in.Conditions))
	out.Results = *(*map[string]runtime.RawExtension)(unsafe.Pointer(&in.Results))
	return nil
}

// Convert_v1alpha1_ResourceViewStatus_To_mcm_ResourceViewStatus is an autogenerated conversion function.
func Convert_v1alpha1_ResourceViewStatus_To_mcm_ResourceViewStatus(in *ResourceViewStatus, out *mcm.ResourceViewStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceViewStatus_To_mcm_ResourceViewStatus(in, out, s)
}

func autoConvert_mcm_ResourceViewStatus_To_v1alpha1_ResourceViewStatus(in *mcm.ResourceViewStatus, out *ResourceViewStatus, s conversion.Scope) error {
	out.Conditions = *(*[]ViewCondition)(unsafe.Pointer(&in.Conditions))
	out.Results = *(*map[string]runtime.RawExtension)(unsafe.Pointer(&in.Results))
	return nil
}

// Convert_mcm_ResourceViewStatus_To_v1alpha1_ResourceViewStatus is an autogenerated conversion function.
func Convert_mcm_ResourceViewStatus_To_v1alpha1_ResourceViewStatus(in *mcm.ResourceViewStatus, out *ResourceViewStatus, s conversion.Scope) error {
	return autoConvert_mcm_ResourceViewStatus_To_v1alpha1_ResourceViewStatus(in, out, s)
}

func autoConvert_v1alpha1_ResultHelmList_To_mcm_ResultHelmList(in *ResultHelmList, out *mcm.ResultHelmList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.HelmRelease)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ResultHelmList_To_mcm_ResultHelmList is an autogenerated conversion function.
func Convert_v1alpha1_ResultHelmList_To_mcm_ResultHelmList(in *ResultHelmList, out *mcm.ResultHelmList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResultHelmList_To_mcm_ResultHelmList(in, out, s)
}

func autoConvert_mcm_ResultHelmList_To_v1alpha1_ResultHelmList(in *mcm.ResultHelmList, out *ResultHelmList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]HelmRelease)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_ResultHelmList_To_v1alpha1_ResultHelmList is an autogenerated conversion function.
func Convert_mcm_ResultHelmList_To_v1alpha1_ResultHelmList(in *mcm.ResultHelmList, out *ResultHelmList, s conversion.Scope) error {
	return autoConvert_mcm_ResultHelmList_To_v1alpha1_ResultHelmList(in, out, s)
}

func autoConvert_v1alpha1_ServerAddressByClientCIDR_To_mcm_ServerAddressByClientCIDR(in *ServerAddressByClientCIDR, out *mcm.ServerAddressByClientCIDR, s conversion.Scope) error {
	out.ClientCIDR = in.ClientCIDR
	out.ServerAddress = in.ServerAddress
	return nil
}

// Convert_v1alpha1_ServerAddressByClientCIDR_To_mcm_ServerAddressByClientCIDR is an autogenerated conversion function.
func Convert_v1alpha1_ServerAddressByClientCIDR_To_mcm_ServerAddressByClientCIDR(in *ServerAddressByClientCIDR, out *mcm.ServerAddressByClientCIDR, s conversion.Scope) error {
	return autoConvert_v1alpha1_ServerAddressByClientCIDR_To_mcm_ServerAddressByClientCIDR(in, out, s)
}

func autoConvert_mcm_ServerAddressByClientCIDR_To_v1alpha1_ServerAddressByClientCIDR(in *mcm.ServerAddressByClientCIDR, out *ServerAddressByClientCIDR, s conversion.Scope) error {
	out.ClientCIDR = in.ClientCIDR
	out.ServerAddress = in.ServerAddress
	return nil
}

// Convert_mcm_ServerAddressByClientCIDR_To_v1alpha1_ServerAddressByClientCIDR is an autogenerated conversion function.
func Convert_mcm_ServerAddressByClientCIDR_To_v1alpha1_ServerAddressByClientCIDR(in *mcm.ServerAddressByClientCIDR, out *ServerAddressByClientCIDR, s conversion.Scope) error {
	return autoConvert_mcm_ServerAddressByClientCIDR_To_v1alpha1_ServerAddressByClientCIDR(in, out, s)
}

func autoConvert_v1alpha1_Subject_To_mcm_Subject(in *Subject, out *mcm.Subject, s conversion.Scope) error {
	out.Kind = in.Kind
	out.APIGroup = in.APIGroup
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_Subject_To_mcm_Subject is an autogenerated conversion function.
func Convert_v1alpha1_Subject_To_mcm_Subject(in *Subject, out *mcm.Subject, s conversion.Scope) error {
	return autoConvert_v1alpha1_Subject_To_mcm_Subject(in, out, s)
}

func autoConvert_mcm_Subject_To_v1alpha1_Subject(in *mcm.Subject, out *Subject, s conversion.Scope) error {
	out.Kind = in.Kind
	out.APIGroup = in.APIGroup
	out.Name = in.Name
	return nil
}

// Convert_mcm_Subject_To_v1alpha1_Subject is an autogenerated conversion function.
func Convert_mcm_Subject_To_v1alpha1_Subject(in *mcm.Subject, out *Subject, s conversion.Scope) error {
	return autoConvert_mcm_Subject_To_v1alpha1_Subject(in, out, s)
}

func autoConvert_v1alpha1_ViewCondition_To_mcm_ViewCondition(in *ViewCondition, out *mcm.ViewCondition, s conversion.Scope) error {
	out.Type = mcm.WorkStatusType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.Reason = in.Reason
	return nil
}

// Convert_v1alpha1_ViewCondition_To_mcm_ViewCondition is an autogenerated conversion function.
func Convert_v1alpha1_ViewCondition_To_mcm_ViewCondition(in *ViewCondition, out *mcm.ViewCondition, s conversion.Scope) error {
	return autoConvert_v1alpha1_ViewCondition_To_mcm_ViewCondition(in, out, s)
}

func autoConvert_mcm_ViewCondition_To_v1alpha1_ViewCondition(in *mcm.ViewCondition, out *ViewCondition, s conversion.Scope) error {
	out.Type = WorkStatusType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.Reason = in.Reason
	return nil
}

// Convert_mcm_ViewCondition_To_v1alpha1_ViewCondition is an autogenerated conversion function.
func Convert_mcm_ViewCondition_To_v1alpha1_ViewCondition(in *mcm.ViewCondition, out *ViewCondition, s conversion.Scope) error {
	return autoConvert_mcm_ViewCondition_To_v1alpha1_ViewCondition(in, out, s)
}

func autoConvert_v1alpha1_ViewFilter_To_mcm_ViewFilter(in *ViewFilter, out *mcm.ViewFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	out.NameSpace = in.NameSpace
	return nil
}

// Convert_v1alpha1_ViewFilter_To_mcm_ViewFilter is an autogenerated conversion function.
func Convert_v1alpha1_ViewFilter_To_mcm_ViewFilter(in *ViewFilter, out *mcm.ViewFilter, s conversion.Scope) error {
	return autoConvert_v1alpha1_ViewFilter_To_mcm_ViewFilter(in, out, s)
}

func autoConvert_mcm_ViewFilter_To_v1alpha1_ViewFilter(in *mcm.ViewFilter, out *ViewFilter, s conversion.Scope) error {
	out.LabelSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.LabelSelector))
	out.FieldSelector = in.FieldSelector
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	out.NameSpace = in.NameSpace
	return nil
}

// Convert_mcm_ViewFilter_To_v1alpha1_ViewFilter is an autogenerated conversion function.
func Convert_mcm_ViewFilter_To_v1alpha1_ViewFilter(in *mcm.ViewFilter, out *ViewFilter, s conversion.Scope) error {
	return autoConvert_mcm_ViewFilter_To_v1alpha1_ViewFilter(in, out, s)
}

func autoConvert_v1alpha1_Work_To_mcm_Work(in *Work, out *mcm.Work, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_WorkSpec_To_mcm_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_WorkStatus_To_mcm_WorkStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_Work_To_mcm_Work is an autogenerated conversion function.
func Convert_v1alpha1_Work_To_mcm_Work(in *Work, out *mcm.Work, s conversion.Scope) error {
	return autoConvert_v1alpha1_Work_To_mcm_Work(in, out, s)
}

func autoConvert_mcm_Work_To_v1alpha1_Work(in *mcm.Work, out *Work, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_WorkSpec_To_v1alpha1_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_WorkStatus_To_v1alpha1_WorkStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_Work_To_v1alpha1_Work is an autogenerated conversion function.
func Convert_mcm_Work_To_v1alpha1_Work(in *mcm.Work, out *Work, s conversion.Scope) error {
	return autoConvert_mcm_Work_To_v1alpha1_Work(in, out, s)
}

func autoConvert_v1alpha1_WorkList_To_mcm_WorkList(in *WorkList, out *mcm.WorkList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.Work)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_WorkList_To_mcm_WorkList is an autogenerated conversion function.
func Convert_v1alpha1_WorkList_To_mcm_WorkList(in *WorkList, out *mcm.WorkList, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkList_To_mcm_WorkList(in, out, s)
}

func autoConvert_mcm_WorkList_To_v1alpha1_WorkList(in *mcm.WorkList, out *WorkList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]Work)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_WorkList_To_v1alpha1_WorkList is an autogenerated conversion function.
func Convert_mcm_WorkList_To_v1alpha1_WorkList(in *mcm.WorkList, out *WorkList, s conversion.Scope) error {
	return autoConvert_mcm_WorkList_To_v1alpha1_WorkList(in, out, s)
}

func autoConvert_v1alpha1_WorkSet_To_mcm_WorkSet(in *WorkSet, out *mcm.WorkSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_WorkSetSpec_To_mcm_WorkSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_WorkSetStatus_To_mcm_WorkSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_WorkSet_To_mcm_WorkSet is an autogenerated conversion function.
func Convert_v1alpha1_WorkSet_To_mcm_WorkSet(in *WorkSet, out *mcm.WorkSet, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkSet_To_mcm_WorkSet(in, out, s)
}

func autoConvert_mcm_WorkSet_To_v1alpha1_WorkSet(in *mcm.WorkSet, out *WorkSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_WorkSetSpec_To_v1alpha1_WorkSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_mcm_WorkSetStatus_To_v1alpha1_WorkSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_WorkSet_To_v1alpha1_WorkSet is an autogenerated conversion function.
func Convert_mcm_WorkSet_To_v1alpha1_WorkSet(in *mcm.WorkSet, out *WorkSet, s conversion.Scope) error {
	return autoConvert_mcm_WorkSet_To_v1alpha1_WorkSet(in, out, s)
}

func autoConvert_v1alpha1_WorkSetList_To_mcm_WorkSetList(in *WorkSetList, out *mcm.WorkSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]mcm.WorkSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_WorkSetList_To_mcm_WorkSetList is an autogenerated conversion function.
func Convert_v1alpha1_WorkSetList_To_mcm_WorkSetList(in *WorkSetList, out *mcm.WorkSetList, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkSetList_To_mcm_WorkSetList(in, out, s)
}

func autoConvert_mcm_WorkSetList_To_v1alpha1_WorkSetList(in *mcm.WorkSetList, out *WorkSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]WorkSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_mcm_WorkSetList_To_v1alpha1_WorkSetList is an autogenerated conversion function.
func Convert_mcm_WorkSetList_To_v1alpha1_WorkSetList(in *mcm.WorkSetList, out *WorkSetList, s conversion.Scope) error {
	return autoConvert_mcm_WorkSetList_To_v1alpha1_WorkSetList(in, out, s)
}

func autoConvert_v1alpha1_WorkSetSpec_To_mcm_WorkSetSpec(in *WorkSetSpec, out *mcm.WorkSetSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := Convert_v1alpha1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_WorkSetSpec_To_mcm_WorkSetSpec is an autogenerated conversion function.
func Convert_v1alpha1_WorkSetSpec_To_mcm_WorkSetSpec(in *WorkSetSpec, out *mcm.WorkSetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkSetSpec_To_mcm_WorkSetSpec(in, out, s)
}

func autoConvert_mcm_WorkSetSpec_To_v1alpha1_WorkSetSpec(in *mcm.WorkSetSpec, out *WorkSetSpec, s conversion.Scope) error {
	out.ClusterSelector = (*metav1.LabelSelector)(unsafe.Pointer(in.ClusterSelector))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	if err := Convert_mcm_WorkTemplateSpec_To_v1alpha1_WorkTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_WorkSetSpec_To_v1alpha1_WorkSetSpec is an autogenerated conversion function.
func Convert_mcm_WorkSetSpec_To_v1alpha1_WorkSetSpec(in *mcm.WorkSetSpec, out *WorkSetSpec, s conversion.Scope) error {
	return autoConvert_mcm_WorkSetSpec_To_v1alpha1_WorkSetSpec(in, out, s)
}

func autoConvert_v1alpha1_WorkSetStatus_To_mcm_WorkSetStatus(in *WorkSetStatus, out *mcm.WorkSetStatus, s conversion.Scope) error {
	out.Status = mcm.WorkStatusType(in.Status)
	out.Reason = in.Reason
	return nil
}

// Convert_v1alpha1_WorkSetStatus_To_mcm_WorkSetStatus is an autogenerated conversion function.
func Convert_v1alpha1_WorkSetStatus_To_mcm_WorkSetStatus(in *WorkSetStatus, out *mcm.WorkSetStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkSetStatus_To_mcm_WorkSetStatus(in, out, s)
}

func autoConvert_mcm_WorkSetStatus_To_v1alpha1_WorkSetStatus(in *mcm.WorkSetStatus, out *WorkSetStatus, s conversion.Scope) error {
	out.Status = WorkStatusType(in.Status)
	out.Reason = in.Reason
	return nil
}

// Convert_mcm_WorkSetStatus_To_v1alpha1_WorkSetStatus is an autogenerated conversion function.
func Convert_mcm_WorkSetStatus_To_v1alpha1_WorkSetStatus(in *mcm.WorkSetStatus, out *WorkSetStatus, s conversion.Scope) error {
	return autoConvert_mcm_WorkSetStatus_To_v1alpha1_WorkSetStatus(in, out, s)
}

func autoConvert_v1alpha1_WorkSpec_To_mcm_WorkSpec(in *WorkSpec, out *mcm.WorkSpec, s conversion.Scope) error {
	out.Cluster = in.Cluster
	out.Type = mcm.WorkType(in.Type)
	if err := Convert_v1alpha1_ResourceFilter_To_mcm_ResourceFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.ActionType = mcm.ActionType(in.ActionType)
	out.HelmWork = (*mcm.HelmWorkSpec)(unsafe.Pointer(in.HelmWork))
	out.KubeWork = (*mcm.KubeWorkSpec)(unsafe.Pointer(in.KubeWork))
	return nil
}

// Convert_v1alpha1_WorkSpec_To_mcm_WorkSpec is an autogenerated conversion function.
func Convert_v1alpha1_WorkSpec_To_mcm_WorkSpec(in *WorkSpec, out *mcm.WorkSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkSpec_To_mcm_WorkSpec(in, out, s)
}

func autoConvert_mcm_WorkSpec_To_v1alpha1_WorkSpec(in *mcm.WorkSpec, out *WorkSpec, s conversion.Scope) error {
	out.Cluster = in.Cluster
	out.Type = WorkType(in.Type)
	if err := Convert_mcm_ResourceFilter_To_v1alpha1_ResourceFilter(&in.Scope, &out.Scope, s); err != nil {
		return err
	}
	out.ActionType = ActionType(in.ActionType)
	out.HelmWork = (*HelmWorkSpec)(unsafe.Pointer(in.HelmWork))
	out.KubeWork = (*KubeWorkSpec)(unsafe.Pointer(in.KubeWork))
	return nil
}

// Convert_mcm_WorkSpec_To_v1alpha1_WorkSpec is an autogenerated conversion function.
func Convert_mcm_WorkSpec_To_v1alpha1_WorkSpec(in *mcm.WorkSpec, out *WorkSpec, s conversion.Scope) error {
	return autoConvert_mcm_WorkSpec_To_v1alpha1_WorkSpec(in, out, s)
}

func autoConvert_v1alpha1_WorkStatus_To_mcm_WorkStatus(in *WorkStatus, out *mcm.WorkStatus, s conversion.Scope) error {
	out.Type = mcm.WorkStatusType(in.Type)
	out.Reason = in.Reason
	out.Result = in.Result
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_v1alpha1_WorkStatus_To_mcm_WorkStatus is an autogenerated conversion function.
func Convert_v1alpha1_WorkStatus_To_mcm_WorkStatus(in *WorkStatus, out *mcm.WorkStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkStatus_To_mcm_WorkStatus(in, out, s)
}

func autoConvert_mcm_WorkStatus_To_v1alpha1_WorkStatus(in *mcm.WorkStatus, out *WorkStatus, s conversion.Scope) error {
	out.Type = WorkStatusType(in.Type)
	out.Reason = in.Reason
	out.Result = in.Result
	out.LastUpdateTime = in.LastUpdateTime
	return nil
}

// Convert_mcm_WorkStatus_To_v1alpha1_WorkStatus is an autogenerated conversion function.
func Convert_mcm_WorkStatus_To_v1alpha1_WorkStatus(in *mcm.WorkStatus, out *WorkStatus, s conversion.Scope) error {
	return autoConvert_mcm_WorkStatus_To_v1alpha1_WorkStatus(in, out, s)
}

func autoConvert_v1alpha1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(in *WorkTemplateSpec, out *mcm.WorkTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_WorkSpec_To_mcm_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_WorkTemplateSpec_To_mcm_WorkTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(in *WorkTemplateSpec, out *mcm.WorkTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_WorkTemplateSpec_To_mcm_WorkTemplateSpec(in, out, s)
}

func autoConvert_mcm_WorkTemplateSpec_To_v1alpha1_WorkTemplateSpec(in *mcm.WorkTemplateSpec, out *WorkTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_mcm_WorkSpec_To_v1alpha1_WorkSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_mcm_WorkTemplateSpec_To_v1alpha1_WorkTemplateSpec is an autogenerated conversion function.
func Convert_mcm_WorkTemplateSpec_To_v1alpha1_WorkTemplateSpec(in *mcm.WorkTemplateSpec, out *WorkTemplateSpec, s conversion.Scope) error {
	return autoConvert_mcm_WorkTemplateSpec_To_v1alpha1_WorkTemplateSpec(in, out, s)
}
