// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeResourceViews implements ResourceViewInterface
type FakeResourceViews struct {
	Fake *FakeMcm
	ns   string
}

var resourceviewsResource = schema.GroupVersionResource{Group: "mcm.ibm.com", Version: "", Resource: "resourceviews"}

var resourceviewsKind = schema.GroupVersionKind{Group: "mcm.ibm.com", Version: "", Kind: "ResourceView"}

// Get takes name of the resourceView, and returns the corresponding resourceView object, and an error if there is any.
func (c *FakeResourceViews) Get(name string, options v1.GetOptions) (result *mcm.ResourceView, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(resourceviewsResource, c.ns, name), &mcm.ResourceView{})

	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.ResourceView), err
}

// List takes label and field selectors, and returns the list of ResourceViews that match those selectors.
func (c *FakeResourceViews) List(opts v1.ListOptions) (result *mcm.ResourceViewList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(resourceviewsResource, resourceviewsKind, c.ns, opts), &mcm.ResourceViewList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &mcm.ResourceViewList{ListMeta: obj.(*mcm.ResourceViewList).ListMeta}
	for _, item := range obj.(*mcm.ResourceViewList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested resourceViews.
func (c *FakeResourceViews) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(resourceviewsResource, c.ns, opts))

}

// Create takes the representation of a resourceView and creates it.  Returns the server's representation of the resourceView, and an error, if there is any.
func (c *FakeResourceViews) Create(resourceView *mcm.ResourceView) (result *mcm.ResourceView, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(resourceviewsResource, c.ns, resourceView), &mcm.ResourceView{})

	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.ResourceView), err
}

// Update takes the representation of a resourceView and updates it. Returns the server's representation of the resourceView, and an error, if there is any.
func (c *FakeResourceViews) Update(resourceView *mcm.ResourceView) (result *mcm.ResourceView, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(resourceviewsResource, c.ns, resourceView), &mcm.ResourceView{})

	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.ResourceView), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeResourceViews) UpdateStatus(resourceView *mcm.ResourceView) (*mcm.ResourceView, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(resourceviewsResource, "status", c.ns, resourceView), &mcm.ResourceView{})

	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.ResourceView), err
}

// Delete takes name of the resourceView and deletes it. Returns an error if one occurs.
func (c *FakeResourceViews) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(resourceviewsResource, c.ns, name), &mcm.ResourceView{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeResourceViews) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(resourceviewsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &mcm.ResourceViewList{})
	return err
}

// Patch applies the patch and returns the patched resourceView.
func (c *FakeResourceViews) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *mcm.ResourceView, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(resourceviewsResource, c.ns, name, pt, data, subresources...), &mcm.ResourceView{})

	if obj == nil {
		return nil, err
	}
	return obj.(*mcm.ResourceView), err
}
