// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v6/resources/invoice.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v6/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v6/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// An invoice. All invoice information is snapshotted to match the PDF invoice.
// For invoices older than the launch of InvoiceService, the snapshotted
// information may not match the PDF invoice.
type Invoice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the invoice. Multiple customers can share a given
	// invoice, so multiple resource names may point to the same invoice.
	// Invoice resource names have the form:
	//
	// `customers/{customer_id}/invoices/{invoice_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the invoice. It appears on the invoice PDF as "Invoice number".
	Id *string `protobuf:"bytes,25,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// Output only. The type of invoice.
	Type enums.InvoiceTypeEnum_InvoiceType `protobuf:"varint,3,opt,name=type,proto3,enum=google.ads.googleads.v6.enums.InvoiceTypeEnum_InvoiceType" json:"type,omitempty"`
	// Output only. The resource name of this invoice’s billing setup.
	//
	// `customers/{customer_id}/billingSetups/{billing_setup_id}`
	BillingSetup *string `protobuf:"bytes,26,opt,name=billing_setup,json=billingSetup,proto3,oneof" json:"billing_setup,omitempty"`
	// Output only. A 16 digit ID used to identify the payments account associated with the
	// billing setup, e.g. "1234-5678-9012-3456". It appears on the invoice PDF as
	// "Billing Account Number".
	PaymentsAccountId *string `protobuf:"bytes,27,opt,name=payments_account_id,json=paymentsAccountId,proto3,oneof" json:"payments_account_id,omitempty"`
	// Output only. A 12 digit ID used to identify the payments profile associated with the
	// billing setup, e.g. "1234-5678-9012". It appears on the invoice PDF as
	// "Billing ID".
	PaymentsProfileId *string `protobuf:"bytes,28,opt,name=payments_profile_id,json=paymentsProfileId,proto3,oneof" json:"payments_profile_id,omitempty"`
	// Output only. The issue date in yyyy-mm-dd format. It appears on the invoice PDF as
	// either "Issue date" or "Invoice date".
	IssueDate *string `protobuf:"bytes,29,opt,name=issue_date,json=issueDate,proto3,oneof" json:"issue_date,omitempty"`
	// Output only. The due date in yyyy-mm-dd format.
	DueDate *string `protobuf:"bytes,30,opt,name=due_date,json=dueDate,proto3,oneof" json:"due_date,omitempty"`
	// Output only. The service period date range of this invoice. The end date is inclusive.
	ServiceDateRange *common.DateRange `protobuf:"bytes,9,opt,name=service_date_range,json=serviceDateRange,proto3" json:"service_date_range,omitempty"`
	// Output only. The currency code. All costs are returned in this currency. A subset of the
	// currency codes derived from the ISO 4217 standard is supported.
	CurrencyCode *string `protobuf:"bytes,31,opt,name=currency_code,json=currencyCode,proto3,oneof" json:"currency_code,omitempty"`
	// Output only. The pretax subtotal amount of invoice level adjustments, in micros.
	AdjustmentsSubtotalAmountMicros int64 `protobuf:"varint,19,opt,name=adjustments_subtotal_amount_micros,json=adjustmentsSubtotalAmountMicros,proto3" json:"adjustments_subtotal_amount_micros,omitempty"`
	// Output only. The sum of taxes on the invoice level adjustments, in micros.
	AdjustmentsTaxAmountMicros int64 `protobuf:"varint,20,opt,name=adjustments_tax_amount_micros,json=adjustmentsTaxAmountMicros,proto3" json:"adjustments_tax_amount_micros,omitempty"`
	// Output only. The total amount of invoice level adjustments, in micros.
	AdjustmentsTotalAmountMicros int64 `protobuf:"varint,21,opt,name=adjustments_total_amount_micros,json=adjustmentsTotalAmountMicros,proto3" json:"adjustments_total_amount_micros,omitempty"`
	// Output only. The pretax subtotal amount of invoice level regulatory costs, in micros.
	RegulatoryCostsSubtotalAmountMicros int64 `protobuf:"varint,22,opt,name=regulatory_costs_subtotal_amount_micros,json=regulatoryCostsSubtotalAmountMicros,proto3" json:"regulatory_costs_subtotal_amount_micros,omitempty"`
	// Output only. The sum of taxes on the invoice level regulatory costs, in micros.
	RegulatoryCostsTaxAmountMicros int64 `protobuf:"varint,23,opt,name=regulatory_costs_tax_amount_micros,json=regulatoryCostsTaxAmountMicros,proto3" json:"regulatory_costs_tax_amount_micros,omitempty"`
	// Output only. The total amount of invoice level regulatory costs, in micros.
	RegulatoryCostsTotalAmountMicros int64 `protobuf:"varint,24,opt,name=regulatory_costs_total_amount_micros,json=regulatoryCostsTotalAmountMicros,proto3" json:"regulatory_costs_total_amount_micros,omitempty"`
	// Output only. The pretax subtotal amount, in micros. This equals the
	// sum of the AccountBudgetSummary subtotal amounts,
	// Invoice.adjustments_subtotal_amount_micros, and
	// Invoice.regulatory_costs_subtotal_amount_micros.
	// Starting with v6, the Invoice.regulatory_costs_subtotal_amount_micros is no
	// longer included.
	SubtotalAmountMicros *int64 `protobuf:"varint,33,opt,name=subtotal_amount_micros,json=subtotalAmountMicros,proto3,oneof" json:"subtotal_amount_micros,omitempty"`
	// Output only. The sum of all taxes on the invoice, in micros. This equals the sum of the
	// AccountBudgetSummary tax amounts, plus taxes not associated with a specific
	// account budget.
	TaxAmountMicros *int64 `protobuf:"varint,34,opt,name=tax_amount_micros,json=taxAmountMicros,proto3,oneof" json:"tax_amount_micros,omitempty"`
	// Output only. The total amount, in micros. This equals the sum of
	// Invoice.subtotal_amount_micros and Invoice.tax_amount_micros.
	// Starting with v6, Invoice.regulatory_costs_subtotal_amount_micros is
	// also added as it is no longer already included in
	// Invoice.tax_amount_micros.
	TotalAmountMicros *int64 `protobuf:"varint,35,opt,name=total_amount_micros,json=totalAmountMicros,proto3,oneof" json:"total_amount_micros,omitempty"`
	// Output only. The resource name of the original invoice corrected, wrote off, or canceled
	// by this invoice, if applicable. If `corrected_invoice` is set,
	// `replaced_invoices` will not be set.
	// Invoice resource names have the form:
	//
	// `customers/{customer_id}/invoices/{invoice_id}`
	CorrectedInvoice *string `protobuf:"bytes,36,opt,name=corrected_invoice,json=correctedInvoice,proto3,oneof" json:"corrected_invoice,omitempty"`
	// Output only. The resource name of the original invoice(s) being rebilled or replaced by
	// this invoice, if applicable. There might be multiple replaced invoices due
	// to invoice consolidation. The replaced invoices may not belong to the same
	// payments account. If `replaced_invoices` is set, `corrected_invoice` will
	// not be set.
	// Invoice resource names have the form:
	//
	// `customers/{customer_id}/invoices/{invoice_id}`
	ReplacedInvoices []string `protobuf:"bytes,37,rep,name=replaced_invoices,json=replacedInvoices,proto3" json:"replaced_invoices,omitempty"`
	// Output only. The URL to a PDF copy of the invoice. Users need to pass in their OAuth
	// token to request the PDF with this URL.
	PdfUrl *string `protobuf:"bytes,38,opt,name=pdf_url,json=pdfUrl,proto3,oneof" json:"pdf_url,omitempty"`
	// Output only. The list of summarized account budget information associated with this
	// invoice.
	AccountBudgetSummaries []*Invoice_AccountBudgetSummary `protobuf:"bytes,18,rep,name=account_budget_summaries,json=accountBudgetSummaries,proto3" json:"account_budget_summaries,omitempty"`
}

func (x *Invoice) Reset() {
	*x = Invoice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Invoice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Invoice) ProtoMessage() {}

func (x *Invoice) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Invoice.ProtoReflect.Descriptor instead.
func (*Invoice) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_invoice_proto_rawDescGZIP(), []int{0}
}

func (x *Invoice) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Invoice) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *Invoice) GetType() enums.InvoiceTypeEnum_InvoiceType {
	if x != nil {
		return x.Type
	}
	return enums.InvoiceTypeEnum_UNSPECIFIED
}

func (x *Invoice) GetBillingSetup() string {
	if x != nil && x.BillingSetup != nil {
		return *x.BillingSetup
	}
	return ""
}

func (x *Invoice) GetPaymentsAccountId() string {
	if x != nil && x.PaymentsAccountId != nil {
		return *x.PaymentsAccountId
	}
	return ""
}

func (x *Invoice) GetPaymentsProfileId() string {
	if x != nil && x.PaymentsProfileId != nil {
		return *x.PaymentsProfileId
	}
	return ""
}

func (x *Invoice) GetIssueDate() string {
	if x != nil && x.IssueDate != nil {
		return *x.IssueDate
	}
	return ""
}

func (x *Invoice) GetDueDate() string {
	if x != nil && x.DueDate != nil {
		return *x.DueDate
	}
	return ""
}

func (x *Invoice) GetServiceDateRange() *common.DateRange {
	if x != nil {
		return x.ServiceDateRange
	}
	return nil
}

func (x *Invoice) GetCurrencyCode() string {
	if x != nil && x.CurrencyCode != nil {
		return *x.CurrencyCode
	}
	return ""
}

func (x *Invoice) GetAdjustmentsSubtotalAmountMicros() int64 {
	if x != nil {
		return x.AdjustmentsSubtotalAmountMicros
	}
	return 0
}

func (x *Invoice) GetAdjustmentsTaxAmountMicros() int64 {
	if x != nil {
		return x.AdjustmentsTaxAmountMicros
	}
	return 0
}

func (x *Invoice) GetAdjustmentsTotalAmountMicros() int64 {
	if x != nil {
		return x.AdjustmentsTotalAmountMicros
	}
	return 0
}

func (x *Invoice) GetRegulatoryCostsSubtotalAmountMicros() int64 {
	if x != nil {
		return x.RegulatoryCostsSubtotalAmountMicros
	}
	return 0
}

func (x *Invoice) GetRegulatoryCostsTaxAmountMicros() int64 {
	if x != nil {
		return x.RegulatoryCostsTaxAmountMicros
	}
	return 0
}

func (x *Invoice) GetRegulatoryCostsTotalAmountMicros() int64 {
	if x != nil {
		return x.RegulatoryCostsTotalAmountMicros
	}
	return 0
}

func (x *Invoice) GetSubtotalAmountMicros() int64 {
	if x != nil && x.SubtotalAmountMicros != nil {
		return *x.SubtotalAmountMicros
	}
	return 0
}

func (x *Invoice) GetTaxAmountMicros() int64 {
	if x != nil && x.TaxAmountMicros != nil {
		return *x.TaxAmountMicros
	}
	return 0
}

func (x *Invoice) GetTotalAmountMicros() int64 {
	if x != nil && x.TotalAmountMicros != nil {
		return *x.TotalAmountMicros
	}
	return 0
}

func (x *Invoice) GetCorrectedInvoice() string {
	if x != nil && x.CorrectedInvoice != nil {
		return *x.CorrectedInvoice
	}
	return ""
}

func (x *Invoice) GetReplacedInvoices() []string {
	if x != nil {
		return x.ReplacedInvoices
	}
	return nil
}

func (x *Invoice) GetPdfUrl() string {
	if x != nil && x.PdfUrl != nil {
		return *x.PdfUrl
	}
	return ""
}

func (x *Invoice) GetAccountBudgetSummaries() []*Invoice_AccountBudgetSummary {
	if x != nil {
		return x.AccountBudgetSummaries
	}
	return nil
}

// Represents a summarized account budget billable cost.
type Invoice_AccountBudgetSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the customer associated with this account budget.
	// This contains the customer ID, which appears on the invoice PDF as
	// "Account ID".
	// Customer resource names have the form:
	//
	// `customers/{customer_id}`
	Customer *string `protobuf:"bytes,10,opt,name=customer,proto3,oneof" json:"customer,omitempty"`
	// Output only. The descriptive name of the account budget’s customer. It appears on the
	// invoice PDF as "Account".
	CustomerDescriptiveName *string `protobuf:"bytes,11,opt,name=customer_descriptive_name,json=customerDescriptiveName,proto3,oneof" json:"customer_descriptive_name,omitempty"`
	// Output only. The resource name of the account budget associated with this summarized
	// billable cost.
	// AccountBudget resource names have the form:
	//
	// `customers/{customer_id}/accountBudgets/{account_budget_id}`
	AccountBudget *string `protobuf:"bytes,12,opt,name=account_budget,json=accountBudget,proto3,oneof" json:"account_budget,omitempty"`
	// Output only. The name of the account budget. It appears on the invoice PDF as "Account
	// budget".
	AccountBudgetName *string `protobuf:"bytes,13,opt,name=account_budget_name,json=accountBudgetName,proto3,oneof" json:"account_budget_name,omitempty"`
	// Output only. The purchase order number of the account budget. It appears on the
	// invoice PDF as "Purchase order".
	PurchaseOrderNumber *string `protobuf:"bytes,14,opt,name=purchase_order_number,json=purchaseOrderNumber,proto3,oneof" json:"purchase_order_number,omitempty"`
	// Output only. The pretax subtotal amount attributable to this budget during the service
	// period, in micros.
	SubtotalAmountMicros *int64 `protobuf:"varint,15,opt,name=subtotal_amount_micros,json=subtotalAmountMicros,proto3,oneof" json:"subtotal_amount_micros,omitempty"`
	// Output only. The tax amount attributable to this budget during the service period, in
	// micros.
	TaxAmountMicros *int64 `protobuf:"varint,16,opt,name=tax_amount_micros,json=taxAmountMicros,proto3,oneof" json:"tax_amount_micros,omitempty"`
	// Output only. The total amount attributable to this budget during the service period,
	// in micros. This equals the sum of the account budget subtotal amount and
	// the account budget tax amount.
	TotalAmountMicros *int64 `protobuf:"varint,17,opt,name=total_amount_micros,json=totalAmountMicros,proto3,oneof" json:"total_amount_micros,omitempty"`
	// Output only. The billable activity date range of the account budget, within the
	// service date range of this invoice. The end date is inclusive. This can
	// be different from the account budget's start and end time.
	BillableActivityDateRange *common.DateRange `protobuf:"bytes,9,opt,name=billable_activity_date_range,json=billableActivityDateRange,proto3" json:"billable_activity_date_range,omitempty"`
}

func (x *Invoice_AccountBudgetSummary) Reset() {
	*x = Invoice_AccountBudgetSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Invoice_AccountBudgetSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Invoice_AccountBudgetSummary) ProtoMessage() {}

func (x *Invoice_AccountBudgetSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Invoice_AccountBudgetSummary.ProtoReflect.Descriptor instead.
func (*Invoice_AccountBudgetSummary) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_invoice_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Invoice_AccountBudgetSummary) GetCustomer() string {
	if x != nil && x.Customer != nil {
		return *x.Customer
	}
	return ""
}

func (x *Invoice_AccountBudgetSummary) GetCustomerDescriptiveName() string {
	if x != nil && x.CustomerDescriptiveName != nil {
		return *x.CustomerDescriptiveName
	}
	return ""
}

func (x *Invoice_AccountBudgetSummary) GetAccountBudget() string {
	if x != nil && x.AccountBudget != nil {
		return *x.AccountBudget
	}
	return ""
}

func (x *Invoice_AccountBudgetSummary) GetAccountBudgetName() string {
	if x != nil && x.AccountBudgetName != nil {
		return *x.AccountBudgetName
	}
	return ""
}

func (x *Invoice_AccountBudgetSummary) GetPurchaseOrderNumber() string {
	if x != nil && x.PurchaseOrderNumber != nil {
		return *x.PurchaseOrderNumber
	}
	return ""
}

func (x *Invoice_AccountBudgetSummary) GetSubtotalAmountMicros() int64 {
	if x != nil && x.SubtotalAmountMicros != nil {
		return *x.SubtotalAmountMicros
	}
	return 0
}

func (x *Invoice_AccountBudgetSummary) GetTaxAmountMicros() int64 {
	if x != nil && x.TaxAmountMicros != nil {
		return *x.TaxAmountMicros
	}
	return 0
}

func (x *Invoice_AccountBudgetSummary) GetTotalAmountMicros() int64 {
	if x != nil && x.TotalAmountMicros != nil {
		return *x.TotalAmountMicros
	}
	return 0
}

func (x *Invoice_AccountBudgetSummary) GetBillableActivityDateRange() *common.DateRange {
	if x != nil {
		return x.BillableActivityDateRange
	}
	return nil
}

var File_google_ads_googleads_v6_resources_invoice_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v6_resources_invoice_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x14, 0x0a,
	0x07, 0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x0d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x13, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x1b, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52, 0x11, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x38, 0x0a, 0x13, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x03, 0x52, 0x11, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0a, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x04, 0x52, 0x09, 0x69, 0x73, 0x73, 0x75, 0x65, 0x44, 0x61, 0x74, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x23, 0x0a, 0x08, 0x64, 0x75, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x05, 0x52, 0x07, 0x64, 0x75, 0x65,
	0x44, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5c, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x06, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x22, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x5f, 0x73, 0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x53, 0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x46, 0x0a, 0x1d, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x74, 0x61, 0x78, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x1a, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54,
	0x61, 0x78, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x4a,
	0x0a, 0x1f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1c, 0x61, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x59, 0x0a, 0x27, 0x72, 0x65,
	0x67, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x73,
	0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x23, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x73, 0x74,
	0x73, 0x53, 0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x4f, 0x0a, 0x22, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x74, 0x61, 0x78, 0x5f, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x54, 0x61, 0x78, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x53, 0x0a, 0x24, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x72, 0x65, 0x67, 0x75, 0x6c,
	0x61, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x41,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x3e, 0x0a, 0x16, 0x73,
	0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x07, 0x52, 0x14, 0x73, 0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x11, 0x74,
	0x61, 0x78, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x22, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x08, 0x52, 0x0f, 0x74,
	0x61, 0x78, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x38, 0x0a, 0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x09, 0x52, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x63,
	0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65,
	0x18, 0x24, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x0a, 0x52, 0x10, 0x63,
	0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x30, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x69,
	0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18, 0x25, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x49, 0x6e, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x07, 0x70, 0x64, 0x66, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x26, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x0b, 0x52, 0x06, 0x70, 0x64,
	0x66, 0x55, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x7e, 0x0a, 0x18, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x49, 0x6e,
	0x76, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x16, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x85, 0x06, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x12, 0x24, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x0e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52, 0x0d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a,
	0x13, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x03, 0x52, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a, 0x15, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x13, 0x70,
	0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x16, 0x73, 0x75, 0x62, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x05, 0x52, 0x14, 0x73, 0x75,
	0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x11, 0x74, 0x61, 0x78, 0x5f, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x06, 0x52, 0x0f, 0x74, 0x61, 0x78, 0x41, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x13, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x07, 0x52,
	0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x6f, 0x0a, 0x1c, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x62, 0x69, 0x6c,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x18, 0x0a, 0x16,
	0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x73, 0x75, 0x62, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x74, 0x61, 0x78, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x3a,
	0x54, 0xea, 0x41, 0x51, 0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x2d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x7d, 0x42, 0x05, 0x0a, 0x03, 0x5f, 0x69, 0x64, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x42, 0x16,
	0x0a, 0x14, 0x5f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x70, 0x61, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x0b, 0x0a,
	0x09, 0x5f, 0x64, 0x75, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x19, 0x0a, 0x17,
	0x5f, 0x73, 0x75, 0x62, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x74, 0x61, 0x78, 0x5f,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x16, 0x0a,
	0x14, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f,
	0x70, 0x64, 0x66, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0xf9, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x42, 0x0c, 0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03,
	0x47, 0x41, 0x41, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x36, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56,
	0x36, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea, 0x02, 0x25, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x36, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v6_resources_invoice_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v6_resources_invoice_proto_rawDescData = file_google_ads_googleads_v6_resources_invoice_proto_rawDesc
)

func file_google_ads_googleads_v6_resources_invoice_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v6_resources_invoice_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v6_resources_invoice_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v6_resources_invoice_proto_rawDescData)
	})
	return file_google_ads_googleads_v6_resources_invoice_proto_rawDescData
}

var file_google_ads_googleads_v6_resources_invoice_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_ads_googleads_v6_resources_invoice_proto_goTypes = []interface{}{
	(*Invoice)(nil),                        // 0: google.ads.googleads.v6.resources.Invoice
	(*Invoice_AccountBudgetSummary)(nil),   // 1: google.ads.googleads.v6.resources.Invoice.AccountBudgetSummary
	(enums.InvoiceTypeEnum_InvoiceType)(0), // 2: google.ads.googleads.v6.enums.InvoiceTypeEnum.InvoiceType
	(*common.DateRange)(nil),               // 3: google.ads.googleads.v6.common.DateRange
}
var file_google_ads_googleads_v6_resources_invoice_proto_depIdxs = []int32{
	2, // 0: google.ads.googleads.v6.resources.Invoice.type:type_name -> google.ads.googleads.v6.enums.InvoiceTypeEnum.InvoiceType
	3, // 1: google.ads.googleads.v6.resources.Invoice.service_date_range:type_name -> google.ads.googleads.v6.common.DateRange
	1, // 2: google.ads.googleads.v6.resources.Invoice.account_budget_summaries:type_name -> google.ads.googleads.v6.resources.Invoice.AccountBudgetSummary
	3, // 3: google.ads.googleads.v6.resources.Invoice.AccountBudgetSummary.billable_activity_date_range:type_name -> google.ads.googleads.v6.common.DateRange
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v6_resources_invoice_proto_init() }
func file_google_ads_googleads_v6_resources_invoice_proto_init() {
	if File_google_ads_googleads_v6_resources_invoice_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Invoice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Invoice_AccountBudgetSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_resources_invoice_proto_msgTypes[1].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v6_resources_invoice_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v6_resources_invoice_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v6_resources_invoice_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v6_resources_invoice_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v6_resources_invoice_proto = out.File
	file_google_ads_googleads_v6_resources_invoice_proto_rawDesc = nil
	file_google_ads_googleads_v6_resources_invoice_proto_goTypes = nil
	file_google_ads_googleads_v6_resources_invoice_proto_depIdxs = nil
}
