// Copyright (c) 2020 Red Hat, Inc.
// Copyright Contributors to the Open Cluster Management project

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// Subject reference
type Subject struct {
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:Enum=policy.open-cluster-management.io
	APIGroup string `json:"apiGroup"`
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:Enum=Policy
	Kind string `json:"kind"`
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	Name string `json:"name"`
}

// PlacementSubject reference
type PlacementSubject struct {
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:Enum=apps.open-cluster-management.io;cluster.open-cluster-management.io
	APIGroup string `json:"apiGroup"`
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:Enum=PlacementRule;Placement
	Kind string `json:"kind"`
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MinLength=1
	Name string `json:"name"`
}

// PlacementBindingStatus defines the observed state of PlacementBinding
type PlacementBindingStatus struct{}

//+kubebuilder:object:root=true

// PlacementBinding is the Schema for the placementbindings API
// +kubebuilder:subresource:status
// +kubebuilder:resource:path=placementbindings,scope=Namespaced
// +kubebuilder:resource:path=placementbindings,shortName=pb
type PlacementBinding struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`
	// +kubebuilder:validation:Required
	PlacementRef PlacementSubject `json:"placementRef"`
	// +kubebuilder:validation:Required
	// +kubebuilder:validation:MaxItems=1
	// +kubebuilder:validation:MinItems=1
	Subjects []Subject              `json:"subjects"`
	Status   PlacementBindingStatus `json:"status,omitempty"`
}

//+kubebuilder:object:root=true

// PlacementBindingList contains a list of PlacementBinding
type PlacementBindingList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []PlacementBinding `json:"items"`
}

func init() {
	SchemeBuilder.Register(&PlacementBinding{}, &PlacementBindingList{})
}
