import { __extends } from 'tslib';
import globalThis from '@ungap/global-this';

var genericMessage = "Invariant Violation";
var _a = Object.setPrototypeOf, setPrototypeOf = _a === void 0 ? function (obj, proto) {
    obj.__proto__ = proto;
    return obj;
} : _a;
var InvariantError = /** @class */ (function (_super) {
    __extends(InvariantError, _super);
    function InvariantError(message) {
        if (message === void 0) { message = genericMessage; }
        var _this = _super.call(this, typeof message === "number"
            ? genericMessage + ": " + message + " (see https://github.com/apollographql/invariant-packages)"
            : message) || this;
        _this.framesToPop = 1;
        _this.name = genericMessage;
        setPrototypeOf(_this, InvariantError.prototype);
        return _this;
    }
    return InvariantError;
}(Error));
function invariant(condition, message) {
    if (!condition) {
        throw new InvariantError(message);
    }
}
var verbosityLevels = ["log", "warn", "error", "silent"];
var verbosityLevel = verbosityLevels.indexOf("log");
function wrapConsoleMethod(method) {
    return function () {
        if (verbosityLevels.indexOf(method) >= verbosityLevel) {
            return console[method].apply(console, arguments);
        }
    };
}
(function (invariant) {
    invariant.log = wrapConsoleMethod("log");
    invariant.warn = wrapConsoleMethod("warn");
    invariant.error = wrapConsoleMethod("error");
})(invariant || (invariant = {}));
function setVerbosity(level) {
    var old = verbosityLevels[verbosityLevel];
    verbosityLevel = Math.max(0, verbosityLevels.indexOf(level));
    return old;
}
var processStub = globalThis.process || { env: {} };
if (!globalThis.process)
    try {
        Object.defineProperty(globalThis, "process", {
            value: processStub,
        });
    }
    catch (_b) {
        // If this fails, it isn't the end of the world.
    }
var invariant$1 = invariant;

export default invariant$1;
export { InvariantError, invariant, processStub as process, setVerbosity };
//# sourceMappingURL=invariant.esm.js.map
