/// <reference types="node" />
import { IncomingMessage, ServerResponse } from "http"
import contentSecurityPolicy, { ContentSecurityPolicyOptions } from "./middlewares/content-security-policy"
import expectCt, { ExpectCtOptions } from "./middlewares/expect-ct"
import originAgentCluster from "./middlewares/origin-agent-cluster"
import referrerPolicy, { ReferrerPolicyOptions } from "./middlewares/referrer-policy"
import strictTransportSecurity, { StrictTransportSecurityOptions } from "./middlewares/strict-transport-security"
import xContentTypeOptions from "./middlewares/x-content-type-options"
import xDnsPrefetchControl, { XDnsPrefetchControlOptions } from "./middlewares/x-dns-prefetch-control"
import xDownloadOptions from "./middlewares/x-download-options"
import xFrameOptions, { XFrameOptionsOptions } from "./middlewares/x-frame-options"
import xPermittedCrossDomainPolicies, { XPermittedCrossDomainPoliciesOptions } from "./middlewares/x-permitted-cross-domain-policies"
import xPoweredBy from "./middlewares/x-powered-by"
import xXssProtection from "./middlewares/x-xss-protection"
interface HelmetOptions {
	contentSecurityPolicy?: MiddlewareOption<ContentSecurityPolicyOptions>
	dnsPrefetchControl?: MiddlewareOption<XDnsPrefetchControlOptions>
	expectCt?: MiddlewareOption<ExpectCtOptions>
	frameguard?: MiddlewareOption<XFrameOptionsOptions>
	hidePoweredBy?: MiddlewareOption<never>
	hsts?: MiddlewareOption<StrictTransportSecurityOptions>
	ieNoOpen?: MiddlewareOption<never>
	noSniff?: MiddlewareOption<never>
	originAgentCluster?: boolean
	permittedCrossDomainPolicies?: MiddlewareOption<XPermittedCrossDomainPoliciesOptions>
	referrerPolicy?: MiddlewareOption<ReferrerPolicyOptions>
	xssFilter?: MiddlewareOption<never>
}
declare type MiddlewareOption<T> = false | T
interface Helmet {
	(options?: Readonly<HelmetOptions>): (req: IncomingMessage, res: ServerResponse, next: (err?: unknown) => void) => void
	contentSecurityPolicy: typeof contentSecurityPolicy
	dnsPrefetchControl: typeof xDnsPrefetchControl
	expectCt: typeof expectCt
	frameguard: typeof xFrameOptions
	hidePoweredBy: typeof xPoweredBy
	hsts: typeof strictTransportSecurity
	ieNoOpen: typeof xDownloadOptions
	noSniff: typeof xContentTypeOptions
	permittedCrossDomainPolicies: typeof xPermittedCrossDomainPolicies
	referrerPolicy: typeof referrerPolicy
	xssFilter: typeof xXssProtection
	originAgentCluster: typeof originAgentCluster
	featurePolicy: () => never
	hpkp: () => never
	noCache: () => never
}
declare const helmet: Helmet
export = helmet
