"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmErrorBoundary = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var styles_1 = require("@material-ui/styles");
// eslint-disable-next-line @typescript-eslint/no-explicit-any
var styles = {
    card: {
        margin: '24px',
    },
    emptyState: {
        height: '100%',
        width: '100%',
        maxWidth: 'unset',
        '& .pf-c-empty-state__content': {
            width: '100%',
            maxWidth: 'unset',
        },
    },
    actions: {
        marginBottom: '12px',
    },
    emptyStateBody: {
        textAlign: 'left',
    },
    errorTitle: {
        marginBottom: '12px',
    },
    section: {
        marginBottom: '24px',
    },
    sectionTitle: {
        marginBottom: '8px',
    },
};
var ErrorBoundary = /** @class */ (function (_super) {
    __extends(ErrorBoundary, _super);
    function ErrorBoundary() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            hasError: false,
            error: {
                message: '',
                stack: '',
                name: '',
            },
            errorInfo: {
                componentStack: '',
            },
        };
        return _this;
    }
    ErrorBoundary.prototype.componentDidCatch = function (error, errorInfo) {
        this.setState({ error: error, errorInfo: errorInfo, hasError: true });
    };
    ErrorBoundary.prototype.render = function () {
        var classes = this.props.classes;
        if (this.state.hasError) {
            return (react_1.default.createElement(react_core_1.Card, { className: classes.card },
                react_1.default.createElement(react_core_1.EmptyState, { className: classes.emptyState, variant: react_core_1.EmptyStateVariant.large },
                    react_1.default.createElement(react_core_1.EmptyStateIcon, { icon: react_icons_1.ExclamationTriangleIcon }),
                    react_1.default.createElement(react_core_1.Title, { headingLevel: "h4", size: react_core_1.TitleSizes['2xl'] }, "Uh oh, something went wrong..."),
                    react_1.default.createElement(react_core_1.EmptyStateBody, { className: classes.emptyStateBody },
                        react_1.default.createElement(react_core_1.Bullseye, { className: classes.actions }, this.props.actions),
                        react_1.default.createElement(react_core_1.ExpandableSection, { toggleText: "See error details..." },
                            react_1.default.createElement("div", { className: classes.errorTitle },
                                react_1.default.createElement(react_core_1.Title, { headingLevel: "h5", size: react_core_1.TitleSizes.xl }, this.state.error.name)),
                            react_1.default.createElement("div", { className: classes.section },
                                react_1.default.createElement(react_core_1.Title, { headingLevel: "h6", size: react_core_1.TitleSizes.lg, className: classes.sectionTitle }, "Description:"),
                                react_1.default.createElement("p", null, this.state.error.message)),
                            react_1.default.createElement("div", { className: classes.section },
                                react_1.default.createElement(react_core_1.Title, { headingLevel: "h6", size: react_core_1.TitleSizes.lg, className: classes.sectionTitle }, "Component trace:"),
                                react_1.default.createElement(react_core_1.ClipboardCopy, { isReadOnly: true, isCode: true, isExpanded: true, variant: react_core_1.ClipboardCopyVariant.expansion }, this.state.errorInfo.componentStack)),
                            react_1.default.createElement("div", { className: classes.section },
                                react_1.default.createElement(react_core_1.Title, { headingLevel: "h6", size: react_core_1.TitleSizes.lg, className: classes.sectionTitle }, "Stack trace:"),
                                react_1.default.createElement(react_core_1.ClipboardCopy, { isReadOnly: true, isCode: true, isExpanded: true, variant: react_core_1.ClipboardCopyVariant.expansion }, this.state.error.stack)))))));
        }
        return this.props.children;
    };
    return ErrorBoundary;
}(react_1.default.Component));
exports.AcmErrorBoundary = styles_1.withStyles(styles)(ErrorBoundary);
//# sourceMappingURL=AcmErrorBoundary.js.map