import { Trie } from "@wry/trie";
export { bindContext, noContext, setTimeout, asyncFromGen, } from "./context";
export { dep, OptimisticDependencyFunction } from "./dep";
export declare type TCacheKey = any;
export declare function defaultMakeCacheKey(...args: any[]): any;
export { Trie as KeyTrie };
export declare type OptimisticWrapperFunction<TArgs extends any[], TResult, TKeyArgs extends any[] = TArgs> = ((...args: TArgs) => TResult) & {
    dirty: (...args: TKeyArgs) => void;
    peek: (...args: TKeyArgs) => TResult | undefined;
    forget: (...args: TKeyArgs) => boolean;
};
export declare type OptimisticWrapOptions<TArgs extends any[], TKeyArgs extends any[] = TArgs> = {
    max?: number;
    keyArgs?: (...args: TArgs) => TKeyArgs;
    makeCacheKey?: (...args: TKeyArgs) => TCacheKey;
    subscribe?: (...args: TArgs) => void | (() => any);
};
export declare function wrap<TArgs extends any[], TResult, TKeyArgs extends any[] = TArgs>(originalFunction: (...args: TArgs) => TResult, options?: OptimisticWrapOptions<TArgs, TKeyArgs>): OptimisticWrapperFunction<TArgs, TResult, TKeyArgs>;
