"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmSummaryList = exports.skeleton = void 0;
var react_1 = __importStar(require("react"));
var react_router_dom_1 = require("react-router-dom");
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var useStyles = styles_1.makeStyles({
    rightSplit: { alignSelf: 'center', paddingRight: '12px' },
    cardBody: { borderTop: '1px solid rgba(0,0,0,0.1)' },
});
var skeleton = function (title) {
    var useStyles = styles_1.makeStyles({
        divider: { marginBottom: '6px' },
    });
    var classes = useStyles();
    return (react_1.default.createElement(react_core_1.Card, null,
        react_1.default.createElement(react_core_1.Flex, null,
            react_1.default.createElement(react_core_1.FlexItem, null,
                react_1.default.createElement(react_core_1.CardTitle, null, title)),
            react_1.default.createElement(react_core_1.Divider, { isVertical: true, inset: { default: 'inset2xl' } }),
            react_1.default.createElement(react_core_1.FlexItem, null,
                react_1.default.createElement(react_core_1.Skeleton, { width: "150px" }))),
        react_1.default.createElement(react_core_1.Divider, null),
        react_1.default.createElement(react_core_1.Grid, { sm: 6, md: 4, lg: 2 }, [1, 2, 3, 4, 5, 6].map(function (i) { return (react_1.default.createElement(react_core_1.GridItem, { key: i },
            react_1.default.createElement(react_core_1.Card, null,
                react_1.default.createElement(react_core_1.CardBody, null,
                    react_1.default.createElement(react_core_1.Skeleton, { width: "50px", fontSize: "3xl", className: classes.divider }),
                    react_1.default.createElement(react_core_1.Skeleton, { width: "100px", fontSize: "sm" }))))); }))));
};
exports.skeleton = skeleton;
function AcmSummaryList(props) {
    var _a;
    var classes = useStyles();
    var primary = props.list.find(function (item) { return item.isPrimary; });
    var secondary = props.list.filter(function (item) { return !item.isPrimary; });
    if (props.loading)
        return exports.skeleton(props.title);
    return (react_1.default.createElement(react_core_1.Card, null,
        react_1.default.createElement(react_core_1.Split, null,
            react_1.default.createElement(react_core_1.SplitItem, null,
                react_1.default.createElement(react_core_1.Flex, null,
                    react_1.default.createElement(react_core_1.FlexItem, null,
                        react_1.default.createElement(react_core_1.CardTitle, null, props.title)), (_a = props.actions) === null || _a === void 0 ? void 0 :
                    _a.map(function (action, i) { return (react_1.default.createElement(react_1.Fragment, { key: "summary-action-" + i },
                        react_1.default.createElement(react_core_1.Divider, { isVertical: true, inset: { default: 'inset2xl' } }),
                        react_1.default.createElement(react_core_1.FlexItem, null, action))); }))),
            react_1.default.createElement(react_core_1.SplitItem, { isFilled: true }),
            react_1.default.createElement(react_core_1.SplitItem, { className: classes.rightSplit }, props.rightAction)),
        react_1.default.createElement("div", { className: classes.cardBody },
            react_1.default.createElement(react_core_1.Grid, { sm: 6, md: 4, lg: 2 },
                primary && (react_1.default.createElement(react_core_1.GridItem, { key: primary.description },
                    react_1.default.createElement(SummarySection, __assign({}, primary)))),
                secondary &&
                    secondary.map(function (item) { return (react_1.default.createElement(react_core_1.GridItem, { key: item.description },
                        react_1.default.createElement(SummarySection, __assign({}, item)))); })))));
}
exports.AcmSummaryList = AcmSummaryList;
var useSectionStyles = styles_1.makeStyles({
    card: {
        border: 'none !important',
        height: '100%',
        maxWidth: '185px',
        minWidth: '130px',
    },
    cardBody: {
        paddingLeft: '34px',
    },
    cardFooter: {
        height: '100%',
    },
    count: {
        lineHeight: function (_a) {
            var isPrimary = _a.isPrimary;
            return (isPrimary ? '2.55rem' : undefined);
        },
        fontSize: function (props) { return (props.isPrimary ? '36px' : '28px'); },
        fontColor: function (props) {
            return props.isPrimary ? 'var(--pf-global--primary-color--100)' : undefined;
        },
        '& a': {
            textDecoration: 'none !important',
            fontColor: 'var(--pf-global--Color--100) !important',
        },
    },
    description: {
        fontSize: '14px',
        fontWeight: 600,
    },
});
var SummarySection = function (props) {
    var classes = useSectionStyles(props);
    return (react_1.default.createElement(react_core_1.Card, { component: "div", className: classes.card, isFlat: true, id: props.description.toLowerCase().replace(/\s+/g, '-') + "-summary" },
        react_1.default.createElement(react_core_1.CardBody, { className: classes.cardBody },
            react_1.default.createElement(react_core_1.Text, { component: react_core_1.TextVariants.p, className: classes.count }, props.href ? react_1.default.createElement(react_router_dom_1.Link, { to: props.href }, props.count) : props.count),
            react_1.default.createElement(react_core_1.Text, { component: react_core_1.TextVariants.p, className: classes.description }, props.description))));
};
//# sourceMappingURL=AcmSummaryList.js.map