"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmInlineStatusGroup = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
function AcmInlineStatusGroup(props) {
    var show = function (count) {
        if (count === undefined) {
            return false;
        }
        else if (count === 0) {
            return props.showZeroes;
        }
        else {
            return true;
        }
    };
    return (react_1.default.createElement(react_core_1.LabelGroup, { defaultIsOpen: true, isClosable: false, numLabels: 10 },
        show(props.healthy) && (react_1.default.createElement(react_core_1.Label, { color: "green", icon: react_1.default.createElement(react_icons_1.CheckCircleIcon, null) }, props.healthy)),
        show(props.progress) && (react_1.default.createElement(react_core_1.Label, { color: "grey", icon: react_1.default.createElement(react_icons_1.InProgressIcon, null) }, props.progress)),
        show(props.warning) && (react_1.default.createElement(react_core_1.Label, { color: "orange", icon: react_1.default.createElement(react_icons_1.ExclamationTriangleIcon, null) }, props.warning)),
        show(props.danger) && (react_1.default.createElement(react_core_1.Label, { color: "red", icon: react_1.default.createElement(react_icons_1.ExclamationCircleIcon, null) }, props.danger)),
        show(props.unknown) && (react_1.default.createElement(react_core_1.Label, { variant: "outline", icon: react_1.default.createElement(react_icons_1.UnknownIcon, null) }, props.unknown))));
}
exports.AcmInlineStatusGroup = AcmInlineStatusGroup;
//# sourceMappingURL=AcmInlineStatusGroup.js.map