"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmHeaderPrototype = void 0;
/* istanbul ignore file */
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
function api(url) {
    return fetch(url).then(function (response) {
        if (!response.ok) {
            throw new Error(response.statusText);
        }
        return response.json();
    });
}
function DropdownName() {
    var _a = react_1.useState(''), name = _a[0], setName = _a[1];
    react_1.useEffect(function () {
        var dev = process.env.NODE_ENV !== 'production';
        var serverForTest = dev ? 'https://localhost:3000' : '';
        api(serverForTest + "/multicloud/common/username")
            .then(function (_a) {
            var username = _a.username;
            setName(username);
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
            setName('');
        });
    }, []);
    return react_1.default.createElement("span", { "aria-label": "dropdown-username" }, name);
}
function AcmHeaderPrototype(props) {
    var _a = react_1.useState(false), isOpen = _a[0], setOpen = _a[1];
    var _b = react_1.useState(false), dropIsOpen = _b[0], dropSetOpen = _b[1];
    function api(url) {
        return fetch(url).then(function (response) {
            if (!response.ok) {
                throw new Error(response.statusText);
            }
            return response.json();
        });
    }
    function configureClient() {
        api('/multicloud/common/configure')
            .then(function (_a) {
            var token_endpoint = _a.token_endpoint;
            window.open(token_endpoint + "/request", '_blank');
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
        });
    }
    function logout() {
        api('/multicloud/logout')
            .then(function (_a) {
            var admin = _a.admin, logoutPath = _a.logoutPath;
            var onLogout = function (delay) {
                if (delay === void 0) { delay = 0; }
                return setTimeout(function () {
                    location.reload(true);
                }, delay);
            };
            if (admin) {
                var form = document.createElement('form');
                form.target = 'hidden-form';
                form.method = 'POST';
                form.action = logoutPath;
                var iframe = document.createElement('iframe');
                iframe.setAttribute('type', 'hidden');
                iframe.name = 'hidden-form';
                iframe.onload = function () { return onLogout(500); };
                document.body.appendChild(iframe);
                document.body.appendChild(form);
                form.submit();
            }
            onLogout(500);
        })
            .catch(function (error) {
            // eslint-disable-next-line no-console
            console.error(error);
        });
    }
    var headerTools = (react_1.default.createElement(react_core_1.PageHeaderTools, null,
        react_1.default.createElement(react_core_1.PageHeaderToolsGroup, { visibility: {
                default: 'hidden',
                lg: 'visible',
            } },
            react_1.default.createElement(react_core_1.PageHeaderToolsItem, null,
                react_1.default.createElement(react_core_1.Dropdown, { toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "toggle-id", onToggle: function () { return dropSetOpen(!dropIsOpen); } },
                        react_1.default.createElement(DropdownName, null)), dropdownItems: [
                        react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return logout(); }, key: 'logoutbutton' }, "Logout"),
                        react_1.default.createElement(react_core_1.DropdownItem, { onClick: function () { return configureClient(); }, key: 'configurebutton' }, "Configure client"),
                    ], isOpen: dropIsOpen })))));
    var Header = (react_1.default.createElement(react_core_1.PageHeader, { logo: "RHACM", logoProps: props, headerTools: headerTools, showNavToggle: true, isNavOpen: isOpen, onNavToggle: function () { return setOpen(!isOpen); } }));
    var Sidebar = react_1.default.createElement(react_core_1.PageSidebar, { nav: "Navigation", isNavOpen: isOpen });
    return (react_1.default.createElement(react_core_1.Page, { header: Header, sidebar: Sidebar }, props.children));
}
exports.AcmHeaderPrototype = AcmHeaderPrototype;
//# sourceMappingURL=AcmHeaderPrototype.js.map