export declare class InvariantError extends Error {
    framesToPop: number;
    name: string;
    constructor(message?: string | number);
}
export declare function invariant(condition: any, message?: string | number): asserts condition;
declare const verbosityLevels: readonly ["log", "warn", "error", "silent"];
declare type VerbosityLevel = (typeof verbosityLevels)[number];
export declare namespace invariant {
    const log: (message?: any, ...optionalParams: any[]) => void;
    const warn: (message?: any, ...optionalParams: any[]) => void;
    const error: (message?: any, ...optionalParams: any[]) => void;
}
export declare function setVerbosity(level: VerbosityLevel): VerbosityLevel;
export declare const processStub: {
    env: Record<string, any>;
    [key: string]: any;
};
export { processStub as process };
export default invariant;
