/*!-----------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.26.0(69d9363bfed1fbfc1ccb914875a20299f46bcc2e)
 * Released under the MIT license
 * https://github.com/microsoft/vscode/blob/main/LICENSE.txt
 *-----------------------------------------------------------*/

define("vs/editor/editor.main.nls.it", {
	"vs/base/browser/ui/actionbar/actionViewItems": [
		"{0} ({1})",
	],
	"vs/base/browser/ui/findinput/findInput": [
		"input",
	],
	"vs/base/browser/ui/findinput/findInputCheckboxes": [
		"Maiuscole/minuscole",
		"Parola intera",
		"Usa espressione regolare",
	],
	"vs/base/browser/ui/findinput/replaceInput": [
		"input",
		"Mantieni maiuscole/minuscole",
	],
	"vs/base/browser/ui/iconLabel/iconLabelHover": [
		"Caricamento...",
	],
	"vs/base/browser/ui/inputbox/inputBox": [
		"Errore: {0}",
		"Avviso: {0}",
		"Info: {0}",
	],
	"vs/base/browser/ui/keybindingLabel/keybindingLabel": [
		"Non associato",
	],
	"vs/base/browser/ui/menu/menu": [
		"{0} ({1})",
	],
	"vs/base/browser/ui/tree/abstractTree": [
		"Cancella",
		"Disabilita filtro sul tipo",
		"Abilita filtro sul tipo",
		"Non sono stati trovati elementi",
		"Abbinamento di {0} su {1} elementi",
	],
	"vs/base/common/actions": [
		"(vuoto)",
	],
	"vs/base/common/errorMessage": [
		"{0}: {1}",
		"Si è verificato un errore di sistema ({0})",
		"Si è verificato un errore sconosciuto. Per altri dettagli, vedere il log.",
		"Si è verificato un errore sconosciuto. Per altri dettagli, vedere il log.",
		"{0} ({1} errori in totale)",
		"Si è verificato un errore sconosciuto. Per altri dettagli, vedere il log.",
	],
	"vs/base/common/keybindingLabels": [
		"CTRL",
		"MAIUSC",
		"ALT",
		"Windows",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Super",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Comando",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Windows",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Super",
	],
	"vs/base/parts/quickinput/browser/quickInput": [
		"Indietro",
		"Premere \'INVIO\' per confermare l\'input oppure \'ESC\' per annullare",
		"{0}/{1}",
		"Digitare per ridurre il numero di risultati.",
		"{0} risultati",
		"{0} selezionati",
		"OK",
		"Personalizzato",
		"Indietro ({0})",
		"Indietro",
	],
	"vs/base/parts/quickinput/browser/quickInputList": [
		"Input rapido",
	],
	"vs/editor/browser/controller/coreCommands": [
		"Si attiene alla fine anche quando si passa a righe più lunghe",
		"Si attiene alla fine anche quando si passa a righe più lunghe",
		"Cursori secondari rimossi",
	],
	"vs/editor/browser/controller/textAreaHandler": [
		"editor",
		"L\'editor non è accessibile in questo momento. Premere {0} per le opzioni.",
	],
	"vs/editor/browser/core/keybindingCancellation": [
		"Indica se l\'editor esegue un\'operazione annullabile, ad esempio \'Anteprima riferimenti\'",
	],
	"vs/editor/browser/editorExtensions": [
		"&&Annulla",
		"Annulla",
		"&&Ripeti",
		"Ripeti",
		"&&Seleziona tutto",
		"Seleziona tutto",
	],
	"vs/editor/browser/widget/codeEditorWidget": [
		"Il numero di cursori è stato limitato a {0}.",
	],
	"vs/editor/browser/widget/diffEditorWidget": [
		"Effetto di riga per gli inserimenti nell\'editor diff.",
		"Effetto di riga per le rimozioni nell\'editor diff.",
		"Non è possibile confrontare i file perché uno è troppo grande.",
	],
	"vs/editor/browser/widget/diffReview": [
		"Icona per \'Inserisci\' nella revisione diff.",
		"Icona per \'Rimuovi\' nella revisione diff.",
		"Icona per \'Chiudi\' nella revisione diff.",
		"Chiudi",
		"nessuna riga modificata",
		"1 riga modificata",
		"{0} righe modificate",
		"Differenza {0} di {1}: riga originale {2}, {3}, riga modificata {4}, {5}",
		"vuota",
		"{0} riga non modificata {1}",
		"{0} riga originale {1} riga modificata {2}",
		"+ {0} riga modificata {1}",
		"- {0} riga originale {1}",
		"Vai alla differenza successiva",
		"Vai alla differenza precedente",
	],
	"vs/editor/browser/widget/inlineDiffMargin": [
		"Copia le righe eliminate",
		"Copia la riga eliminata",
		"Copia la riga eliminata ({0})",
		"Ripristina questa modifica",
		"Copia la riga eliminata ({0})",
	],
	"vs/editor/common/config/commonEditorConfig": [
		"Editor",
		"Numero di spazi a cui equivale una tabulazione. Quando `#editor.detectIndentation#` è attivo, questa impostazione viene sostituita in base al contenuto del file.",
		"Inserisce spazi quando viene premuto TAB. Quando `#editor.detectIndentation#` è attivo, questa impostazione viene sostituita in base al contenuto del file.",
		"Controlla se `#editor.tabSize#` e `#editor.insertSpaces#` verranno rilevati automaticamente quando un file viene aperto in base al contenuto del file.",
		"Rimuovi gli spazi finali inseriti automaticamente.",
		"Gestione speciale dei file di grandi dimensioni per disabilitare alcune funzionalità che fanno un uso intensivo della memoria.",
		"Controlla se calcolare i completamenti in base alle parole presenti nel documento.",
		"Suggerisci parole solo dal documento attivo.",
		"Suggerisci parole da tutti i documenti aperti della stessa lingua.",
		"Suggerisci parole da tutti i documenti aperti.",
		"Controlla i documenti da cui vengono calcolati i completamenti basati su parole.",
		"L\'evidenziazione semantica è abilitata per tutti i temi colore.",
		"L\'evidenziazione semantica è disabilitata per tutti i temi colore.",
		"La configurazione dell\'evidenziazione semantica è gestita tramite l\'impostazione `semanticHighlighting` del tema colori corrente.",
		"Controlla se l\'evidenziazione semanticHighlighting è visualizzata per i linguaggi che la supportano.",
		"Mantiene aperti gli editor rapidi anche quando si fa doppio clic sul contenuto o si preme \'ESC\'.",
		"Per motivi di prestazioni le righe di lunghezza superiore non verranno tokenizzate",
		"Timeout in millisecondi dopo il quale il calcolo delle differenze viene annullato. Usare 0 per indicare nessun timeout.",
		"Controlla se l\'editor diff mostra le differenze affiancate o incorporate.",
		"Se abilitato, l\'editor differenze ignora le modifiche relative a spazi vuoti iniziali e finali.",
		"Controlla se l\'editor diff mostra gli indicatori +/- per le modifiche aggiunte/rimosse.",
		"Controlla se l\'editor visualizza CodeLens.",
		"Il ritorno a capo automatico delle righe non viene mai applicato.",
		"Il ritorno a capo automatico delle righe viene applicato in corrispondenza della larghezza del viewport.",
		"Il ritorno a capo automatico delle righe viene applicato in base all\'impostazione `#editor.wordWrap#`.",
	],
	"vs/editor/common/config/editorOptions": [
		"L\'editor userà le API della piattaforma per rilevare quando viene collegata un\'utilità per la lettura dello schermo.",
		"L\'editor verrà definitivamente ottimizzato per l\'utilizzo con un\'utilità per la lettura dello schermo. Il ritorno a capo automatico verrà disabilitato.",
		"L\'editor non verrà mai ottimizzato per l\'utilizzo con un\'utilità per la lettura dello schermo.",
		"Controlla se l\'editor deve essere eseguito in una modalità ottimizzata per le utilità per la lettura dello schermo. Se viene attivata, il ritorno a capo automatico verrà disabilitato.",
		"Consente di controllare se viene inserito uno spazio quando si aggiungono commenti.",
		"Controlla se ignorare le righe vuote con le opzioni per attivare/disattivare, aggiungere o rimuovere relative ai commenti di riga.",
		"Controlla se, quando si copia senza aver effettuato una selezione, viene copiata la riga corrente.",
		"Controlla se il cursore deve passare direttamente alla ricerca delle corrispondenze durante la digitazione.",
		"Controlla se inizializzare la stringa di ricerca nel Widget Trova con il testo selezionato nell\'editor.",
		"Non attivare mai automaticamente la funzione Trova nella selezione (impostazione predefinita).",
		"Attiva sempre automaticamente la funzione Trova nella selezione.",
		"Attiva automaticamente la funzione Trova nella selezione quando sono selezionate più righe di contenuto.",
		"Controlla la condizione per attivare automaticamente la funzione Trova nella selezione.",
		"Controlla se il widget Trova deve leggere o modificare gli appunti di ricerca condivisi in macOS.",
		"Controlla se il widget Trova deve aggiungere altre righe nella parte superiore dell\'editor. Quando è true, è possibile scorrere oltre la prima riga quando il widget Trova è visibile.",
		"Controlla se la ricerca viene riavviata automaticamente dall\'inizio o dalla fine quando non è possibile trovare ulteriori corrispondenze.",
		"Abilita/Disabilita i caratteri legatura (funzionalità dei tipi di carattere \'calt\' e \'liga\'). Impostare su una stringa per un controllo più specifico sulla proprietà CSS \'font-feature-settings\'.",
		"Proprietà CSS \'font-feature-settings\' esplicita. Se è necessario solo attivare/disattivare le legature, è possibile passare un valore booleano.",
		"Consente di configurare i caratteri legatura o le funzionalità dei tipi di carattere. Può essere un valore booleano per abilitare/disabilitare le legature o una stringa per il valore della proprietà CSS \'font-feature-settings\'.",
		"Controlla le dimensioni del carattere in pixel.",
		"Sono consentiti solo le parole chiave \"normal\" e \"bold\" o i numeri compresi tra 1 e 1000.",
		"Controlla lo spessore del carattere. Accetta le parole chiave \"normal\" e \"bold\" o i numeri compresi tra 1 e 1000.",
		"Mostra la visualizzazione rapida dei risultati (impostazione predefinita)",
		"Passa al risultato principale e mostra una visualizzazione rapida",
		"Passa al risultato principale e abilita l\'esplorazione senza anteprima per gli altri",
		"Questa impostazione è deprecata. In alternativa, usare impostazioni diverse, come \'editor.editor.gotoLocation.multipleDefinitions\' o \'editor.editor.gotoLocation.multipleImplementations\'.",
		"Controlla il comportamento del comando \'Vai alla definizione\' quando esistono più posizioni di destinazione.",
		"Controlla il comportamento del comando \'Vai alla definizione di tipo\' quando esistono più posizioni di destinazione.",
		"Controlla il comportamento del comando \'Vai a dichiarazione\' quando esistono più posizioni di destinazione.",
		"Controlla il comportamento del comando \'Vai a implementazioni\' quando esistono più posizioni di destinazione.",
		"Controlla il comportamento del comando \'Vai a riferimenti\' quando esistono più posizioni di destinazione.",
		"ID comando alternativo eseguito quando il risultato di \'Vai alla definizione\' è la posizione corrente.",
		"ID comando alternativo eseguito quando il risultato di \'Vai alla definizione di tipo\' è la posizione corrente.",
		"ID comando alternativo eseguito quando il risultato di \'Vai a dichiarazione\' è la posizione corrente.",
		"ID comando alternativo eseguito quando il risultato di \'Vai a implementazione\' è la posizione corrente.",
		"ID comando alternativo eseguito quando il risultato di \'Vai a riferimento\' è la posizione corrente.",
		"Controlla se mostrare l\'area sensibile al passaggio del mouse.",
		"Controlla il ritardo in millisecondi dopo il quale viene mostrato il passaggio del mouse.",
		"Controlla se l\'area sensibile al passaggio del mouse deve rimanere visibile quando vi si passa sopra con il puntatore del mouse.",
		"Abilita la lampadina delle azioni codice nell\'editor.",
		"Abilita i suggerimenti incorporati nell\'Editor.",
		"Controlla le dimensioni del carattere dei suggerimenti incorporati nell\'Editor. Quando è impostato su `0`, viene usato il 90% del valore di `#editor.fontSize#`.",
		"Controlla la famiglia di caratteri dei suggerimenti incorporati nell\'Editor.",
		"Controlla l\'altezza della riga. \r\n - Usare 0 per calcolare automaticamente l\'altezza della riga dalle dimensioni del carattere.\r\n - I valori compresi tra 0 e 8 verranno usati come moltiplicatore con le dimensioni del carattere.\r\n - I valori maggiori o uguali a 8 verranno usati come valori effettivi.",
		"Controlla se la minimappa è visualizzata.",
		"La minimappa ha le stesse dimensioni del contenuto dell\'editor (e potrebbe supportare lo scorrimento).",
		"Se necessario, la minimappa si ridurrà o si ingrandirà in modo da adattarsi all\'altezza dell\'editor (nessuno scorrimento).",
		"Se necessario, la minimappa si ridurrà in modo che la larghezza non superi mai quella dell\'editor (nessuno scorrimento).",
		"Controlla le dimensioni della minimappa.",
		"Definisce il lato in cui eseguire il rendering della minimappa.",
		"Controlla se il dispositivo di scorrimento della minimappa è visualizzato.",
		"Scala del contenuto disegnato nella minimappa: 1, 2 o 3.",
		"Esegue il rendering dei caratteri effettivi di una riga in contrapposizione ai blocchi colore.",
		"Limita la larghezza della minimappa in modo da eseguire il rendering al massimo di un certo numero di colonne.",
		"Controlla la quantità di spazio tra il bordo superiore dell\'editor e la prima riga.",
		"Controlla la quantità di spazio tra il bordo inferiore dell\'editor e l\'ultima riga.",
		"Abilita un popup che mostra documentazione sui parametri e informazioni sui tipi mentre si digita.",
		"Controlla se il menu dei suggerimenti per i parametri esegue un ciclo o si chiude quando viene raggiunta la fine dell\'elenco.",
		"Abilita i suggerimenti rapidi all\'interno di stringhe.",
		"Abilita i suggerimenti rapidi all\'interno di commenti.",
		"Abilita i suggerimenti rapidi all\'esterno di stringhe e commenti.",
		"Controlla se visualizzare automaticamente i suggerimenti durante la digitazione.",
		"I numeri di riga non vengono visualizzati.",
		"I numeri di riga vengono visualizzati come numeri assoluti.",
		"I numeri di riga vengono visualizzati come distanza in linee alla posizione del cursore.",
		"I numeri di riga vengono visualizzati ogni 10 righe.",
		"Controlla la visualizzazione dei numeri di riga.",
		"Numero di caratteri a spaziatura fissa in corrispondenza del quale verrà eseguito il rendering di questo righello dell\'editor.",
		"Colore di questo righello dell\'editor.",
		"Esegue il rendering dei righelli verticali dopo un certo numero di caratteri a spaziatura fissa. Usare più valori per più righelli. Se la matrice è vuota, non viene disegnato alcun righello.",
		"La barra di scorrimento verticale sarà visibile solo quando necessario.",
		"La barra di scorrimento verticale sarà sempre visibile.",
		"La barra di scorrimento verticale sarà sempre nascosta.",
		"Controlla la visibilità della barra di scorrimento verticale.",
		"La barra di scorrimento orizzontale sarà visibile solo quando necessario.",
		"La barra di scorrimento orizzontale sarà sempre visibile.",
		"La barra di scorrimento orizzontale sarà sempre nascosta.",
		"Controlla la visibilità della barra di scorrimento orizzontale.",
		"Larghezza della barra di scorrimento verticale.",
		"Altezza della barra di scorrimento orizzontale.",
		"Controlla se i clic consentono di attivare lo scorrimento per pagina o di passare direttamente alla posizione di clic.",
		"Controlla se visualizzare automaticamente i suggerimenti inline nell\'Editor.",
		"Eseguire il rendering di un suggerimento inline solo se il testo di sostituzione è un prefisso del testo di inserimento.",
		"Eseguire il rendering di un suggerimento inline solo se il testo di sostituzione è una parola secondaria del testo di inserimento.",
		"Verificare la modalità da utilizzare per eseguire il rendering dei suggerimenti inline.",
		"Inserisce il suggerimento senza sovrascrivere il testo a destra del cursore.",
		"Inserisce il suggerimento e sovrascrive il testo a destra del cursore.",
		"Controlla se le parole vengono sovrascritte quando si accettano i completamenti. Tenere presente che questa opzione dipende dalle estensioni che accettano esplicitamente questa funzionalità.",
		"Controlla se i suggerimenti di filtro e ordinamento valgono per piccoli errori di battitura.",
		"Controlla se l\'ordinamento privilegia le parole che appaiono più vicine al cursore.",
		"Controlla se condividere le selezioni dei suggerimenti memorizzati tra aree di lavoro e finestre (richiede `#editor.suggestSelection#`).",
		"Controlla se un frammento attivo impedisce i suggerimenti rapidi.",
		"Controlla se mostrare o nascondere le icone nei suggerimenti.",
		"Controlla la visibilità della barra di stato nella parte inferiore del widget dei suggerimenti.",
		"Controlla se visualizzare in anteprima il risultato del suggerimento nell\'Editor.",
		"Eseguire il rendering di un’anteprima solo se il testo di sostituzione è un prefisso del testo di inserimento.",
		"Eseguire il rendering di un’anteprima solo se il testo di sostituzione è una parola secondaria del testo di inserimento.",
		"Verificare la modalità da utilizzare per eseguire il rendering dell\'anteprima del suggerimento.",
		"Controlla se i dettagli del suggerimento vengono visualizzati inline con l\'etichetta o solo nel widget dei dettagli",
		"Questa impostazione è deprecata. Il widget dei suggerimenti può ora essere ridimensionato.",
		"Questa impostazione è deprecata. In alternativa, usare impostazioni diverse, come \'editor.suggest.showKeywords\' o \'editor.suggest.showSnippets\'.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `method`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `function`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `constructor`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `deprecated`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `field`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `variable`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `class`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `struct`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `interface`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `module`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `property`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `event`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `operator`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `unit`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `value`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `constant`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `enum`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `enumMember`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `keyword`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `text`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `color`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `file`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `reference`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `customcolor`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `folder`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `typeParameter`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `snippet`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `user`.",
		"Se è abilitata, IntelliSense mostra i suggerimenti relativi a `issues`.",
		"Indica se gli spazi vuoti iniziali e finali devono essere sempre selezionati.",
		"Controlla se accettare i suggerimenti con i caratteri di commit. Ad esempio, in JavaScript il punto e virgola (\';\') può essere un carattere di commit che accetta un suggerimento e digita tale carattere.",
		"Accetta un suggerimento con \'Invio\' solo quando si apporta una modifica al testo.",
		"Controlla se i suggerimenti devono essere accettati con \'INVIO\' in aggiunta a \'TAB\'. In questo modo è possibile evitare ambiguità tra l\'inserimento di nuove righe e l\'accettazione di suggerimenti.",
		"Controlla il numero di righe nell\'Editor che possono essere lette alla volta da un utilità per la lettura dello schermo. Quando viene rilevata un\'utilità per la lettura dello schermo, questo valore viene impostato su 500 per impostazione predefinita. Avviso: questa opzione può influire sulle prestazioni se il numero di righe è superiore a quello predefinito.",
		"Contenuto editor",
		"Usa le configurazioni del linguaggio per determinare la chiusura automatica delle parentesi.",
		"Chiudi automaticamente le parentesi solo quando il cursore si trova alla sinistra di uno spazio vuoto.",
		"Controlla se l\'editor deve chiudere automaticamente le parentesi quadre dopo che sono state aperte.",
		"Rimuove le virgolette o le parentesi quadre di chiusura adiacenti solo se sono state inserite automaticamente.",
		"Controlla se l\'editor deve rimuovere le virgolette o le parentesi quadre di chiusura adiacenti durante l\'eliminazione.",
		"Digita sopra le virgolette o le parentesi quadre di chiusura solo se sono state inserite automaticamente.",
		"Controlla se l\'editor deve digitare su virgolette o parentesi quadre.",
		"Usa le configurazioni del linguaggio per determinare la chiusura automatica delle virgolette.",
		"Chiudi automaticamente le virgolette solo quando il cursore si trova alla sinistra di uno spazio vuoto.",
		"Controlla se l\'editor deve chiudere automaticamente le citazioni dopo che sono state aperte.",
		"L\'editor non inserirà automaticamente il rientro.",
		"L\'editor manterrà il rientro della riga corrente.",
		"L\'editor manterrà il rientro della riga corrente e rispetterà le parentesi definite dalla lingua.",
		"L\'editor manterrà il rientro della riga corrente, rispetterà le parentesi definite dalla lingua e richiamerà le regole onEnterRules speciali definite dalle lingue.",
		"L\'editor manterrà il rientro della riga corrente, rispetterà le parentesi definite dalla lingua, richiamerà le regole onEnterRules speciali definite dalle lingue e rispetterà le regole indentationRules definite dalle lingue.",
		"Controlla se l\'editor deve regolare automaticamente il rientro quando gli utenti digitano, incollano, spostano le righe o applicano il rientro.",
		"Usa le configurazioni del linguaggio per determinare quando racchiudere automaticamente le selezioni tra parentesi quadre o virgolette.",
		"Racchiude la selezione tra virgolette ma non tra parentesi quadre.",
		"Racchiude la selezione tra parentesi quadre ma non tra virgolette.",
		"Controlla se l\'editor deve racchiudere automaticamente le selezioni quando si digitano virgolette o parentesi quadre.",
		"Emula il comportamento di selezione dei caratteri di tabulazione quando si usano gli spazi per il rientro. La selezione verrà applicata alle tabulazioni.",
		"Controlla se l\'editor visualizza CodeLens.",
		"Controlla la famiglia di caratteri per CodeLens.",
		"Controlla le dimensioni del carattere in pixel per CodeLens. Quando è impostata su `0`, viene usato il 90% del valore di `#editor.fontSize#`.",
		"Controlla se l\'editor deve eseguire il rendering della selezione colori e degli elementi Decorator di tipo colore inline.",
		"Abilita l\'uso di mouse e tasti per la selezione delle colonne.",
		"Controlla se l\'evidenziazione della sintassi deve essere copiata negli Appunti.",
		"Controllo dello stile di animazione del cursore.",
		"Controlla se l\'animazione del cursore con anti-aliasing deve essere abilitata.",
		"Controlla lo stile del cursore.",
		"Controlla il numero minimo di righe iniziali e finali visibili che circondano il cursore. Noto come \'scrollOff\' o \'scrollOffset\' in altri editor.",
		"`cursorSurroundingLines` viene applicato solo quando è attivato tramite la tastiera o l\'API.",
		"`cursorSurroundingLines` viene sempre applicato.",
		"Controlla quando deve essere applicato `cursorSurroundingLines`.",
		"Controlla la larghezza del cursore quando `#editor.cursorStyle#` è impostato su `line`.",
		"Controlla se l\'editor deve consentire lo spostamento di selezioni tramite trascinamento della selezione.",
		"Moltiplicatore della velocità di scorrimento quando si preme `Alt`.",
		"Controlla se per l\'editor è abilitata la riduzione del codice.",
		"Usa una strategia di riduzione specifica della lingua, se disponibile; altrimenti ne usa una basata sui rientri.",
		"Usa la strategia di riduzione basata sui rientri.",
		"Controlla la strategia per il calcolo degli intervalli di riduzione.",
		"Controlla se l\'editor deve evidenziare gli intervalli con riduzione del codice.",
		"Controlla se, facendo clic sul contenuto vuoto dopo una riga ridotta, la riga viene espansa.",
		"Controlla la famiglia di caratteri.",
		"Controlla se l\'editor deve formattare automaticamente il contenuto incollato. Deve essere disponibile un formattatore che deve essere in grado di formattare un intervallo in un documento.",
		"Controlla se l\'editor deve formattare automaticamente la riga dopo la digitazione.",
		"Controlla se l\'editor deve eseguire il rendering del margine verticale del glifo. Il margine del glifo viene usato principalmente per il debug.",
		"Controlla se il cursore deve essere nascosto nel righello delle annotazioni.",
		"Controlla se l\'editor deve evidenziare la guida con rientro attiva.",
		"Controlla la spaziatura tra le lettere in pixel.",
		"Controlla se la modifica collegata è abilitata per l\'editor. A seconda del linguaggio, i simboli correlati, ad esempio i tag HTML, vengono aggiornati durante la modifica.",
		"Controlla se l\'editor deve individuare i collegamenti e renderli selezionabili.",
		"Evidenzia le parentesi graffe corrispondenti.",
		"Moltiplicatore da usare sui valori `deltaX` e `deltaY` degli eventi di scorrimento della rotellina del mouse.",
		"Ingrandisce il carattere dell\'editor quando si usa la rotellina del mouse e si tiene premuto \'CTRL\'.",
		"Unire i cursori multipli se sovrapposti.",
		"Rappresenta il tasto \'Control\' in Windows e Linux e il tasto \'Comando\' in macOS.",
		"Rappresenta il tasto \'Alt\' in Windows e Linux e il tasto \'Opzione\' in macOS.",
		"Modificatore da usare per aggiungere più cursori con il mouse. I gesti del mouse Vai alla definizione e Apri il collegamento si adatteranno in modo da non entrare in conflitto con il modificatore di selezione multipla. [Altre informazioni](https://code.visualstudio.com/docs/editor/codebasics#_multicursor-modifier).",
		"Ogni cursore incolla una singola riga del testo.",
		"Ogni cursore incolla il testo completo.",
		"Controlla l\'operazione Incolla quando il conteggio delle righe del testo incollato corrisponde al conteggio dei cursori.",
		"Controlla se l\'editor deve evidenziare le occorrenze di simboli semantici.",
		"Controlla se deve essere disegnato un bordo intorno al righello delle annotazioni.",
		"Sposta lo stato attivo sull\'albero quando si apre l\'anteprima",
		"Sposta lo stato attivo sull\'editor quando si apre l\'anteprima",
		"Controlla se spostare lo stato attivo sull\'editor inline o sull\'albero nel widget di anteprima.",
		"Controlla se il movimento del mouse Vai alla definizione consente sempre di aprire il widget di anteprima.",
		"Controlla il ritardo in millisecondi dopo il quale verranno visualizzati i suggerimenti rapidi.",
		"Controlla se l\'editor viene rinominato automaticamente in base al tipo.",
		"Deprecata. In alternativa, usare `editor.linkedEditing`.",
		"Controlla se l\'editor deve eseguire il rendering dei caratteri di controllo.",
		"Controlla se l\'editor deve eseguire il rendering delle guide con rientro.",
		"Esegue il rendering dell\'ultimo numero di riga quando il file termina con un carattere di nuova riga.",
		"Mette in evidenza sia la barra di navigazione sia la riga corrente.",
		"Controlla in che modo l\'editor deve eseguire il rendering dell\'evidenziazione di riga corrente.",
		"Controlla se l\'editor deve eseguire il rendering dell\'evidenziazione della riga corrente solo quando l\'editor ha lo stato attivo.",
		"Esegue il rendering dei caratteri di spazio vuoto ad eccezione dei singoli spazi tra le parole.",
		"Esegui il rendering dei caratteri di spazio vuoto solo nel testo selezionato.",
		"Esegui il rendering solo dei caratteri di spazio vuoto finali.",
		"Controlla in che modo l\'editor deve eseguire il rendering dei caratteri di spazio vuoto.",
		"Controlla se le selezioni devono avere gli angoli arrotondati.",
		"Controlla il numero di caratteri aggiuntivi oltre i quali l\'editor scorrerà orizzontalmente.",
		"Controlla se l\'editor scorrerà oltre l\'ultima riga.",
		"Scorre solo lungo l\'asse predominante durante lo scorrimento verticale e orizzontale simultaneo. Impedisce la deviazione orizzontale quando si scorre in verticale su un trackpad.",
		"Controlla se gli appunti primari di Linux devono essere supportati.",
		"Controlla se l\'editor deve evidenziare gli elementi corrispondenti simili alla selezione.",
		"Mostra sempre i comandi di riduzione.",
		"Mostra i comandi di riduzione solo quando il mouse è posizionato sul margine della barra di scorrimento.",
		"Controlla se i controlli di riduzione sul margine della barra di scorrimento vengono visualizzati.",
		"Controllo dissolvenza del codice inutilizzato.",
		"Controlla le variabili deprecate barrate.",
		"Visualizza i suggerimenti del frammento prima degli altri suggerimenti.",
		"Visualizza i suggerimenti del frammento dopo gli altri suggerimenti.",
		"Visualizza i suggerimenti del frammento insieme agli altri suggerimenti.",
		"Non mostrare i suggerimenti del frammento.",
		"Controlla se i frammenti di codice sono visualizzati con altri suggerimenti e il modo in cui sono ordinati.",
		"Controlla se per lo scorrimento dell\'editor verrà usata un\'animazione.",
		"Dimensioni del carattere per il widget dei suggerimenti. Se impostato su `0`, viene usato il valore di `#editor.fontSize#`.",
		"Altezza della riga per il widget dei suggerimenti. Se impostato su `0`, viene usato il valore `editor.lineHeight#`. Il valore minimo è 8.",
		"Controlla se i suggerimenti devono essere visualizzati automaticamente durante la digitazione dei caratteri trigger.",
		"Consente di selezionare sempre il primo suggerimento.",
		"Consente di selezionare suggerimenti recenti a meno che continuando a digitare non ne venga selezionato uno, ad esempio `console.| ->; console.log` perché `log` è stato completato di recente.",
		"Consente di selezionare i suggerimenti in base a prefissi precedenti che hanno completato tali suggerimenti, ad esempio `co ->; console` e `con -> const`.",
		"Controlla la modalità di preselezione dei suggerimenti durante la visualizzazione dell\'elenco dei suggerimenti.",
		"La funzionalità di completamento con tasto TAB inserirà il migliore suggerimento alla pressione del tasto TAB.",
		"Disabilita le funzionalità di completamento con tasto TAB.",
		"Completa i frammenti con il tasto TAB quando i rispettivi prefissi corrispondono. Funziona in modo ottimale quando \'quickSuggestions\' non è abilitato.",
		"Abilità la funzionalità di completamento con tasto TAB.",
		"I caratteri di terminazione di riga insoliti vengono rimossi automaticamente.",
		"I caratteri di terminazione di riga insoliti vengono ignorati.",
		"Prompt per i caratteri di terminazione di riga insoliti da rimuovere.",
		"Rimuovi caratteri di terminazione di riga insoliti che potrebbero causare problemi.",
		"Inserimento ed eliminazione dello spazio vuoto dopo le tabulazioni.",
		"Caratteri che verranno usati come separatori di parola quando si eseguono operazioni o spostamenti correlati a parole.",
		"Il ritorno a capo automatico delle righe non viene mai applicato.",
		"Il ritorno a capo automatico delle righe viene applicato in corrispondenza della larghezza del viewport.",
		"Il ritorno a capo automatico delle righe viene applicato in corrispondenza di `#editor.wordWrapColumn#`.",
		"Il ritorno a capo automatico delle righe viene applicato in corrispondenza della larghezza minima del viewport e di `#editor.wordWrapColumn#`.",
		"Controlla il ritorno a capo automatico delle righe.",
		"Controlla la colonna per il ritorno a capo automatico dell\'editor quando il valore di `#editor.wordWrap#` è `wordWrapColumn` o `bounded`.",
		"Nessun rientro. Le righe con ritorno a capo iniziano dalla colonna 1. ",
		"Le righe con ritorno a capo hanno lo stesso rientro della riga padre.",
		"Le righe con ritorno a capo hanno un rientro di +1 rispetto alla riga padre.",
		"Le righe con ritorno a capo hanno un rientro di +2 rispetto alla riga padre.",
		"Controlla il rientro delle righe con ritorno a capo.",
		"Presuppone che la larghezza sia identica per tutti caratteri. Si tratta di un algoritmo veloce che funziona correttamente per i tipi di carattere a spaziatura fissa e determinati script (come i caratteri latini) in cui i glifi hanno larghezza identica.",
		"Delega il calcolo dei punti di ritorno a capo al browser. Si tratta di un algoritmo lento che potrebbe causare blocchi con file di grandi dimensioni, ma funziona correttamente in tutti gli altri casi.",
		"Controlla l\'algoritmo che calcola i punti di ritorno a capo.",
	],
	"vs/editor/common/editorContextKeys": [
		"Indica se il testo dell\'editor ha lo stato attivo (il cursore lampeggia)",
		"Indica se l\'editor o un widget dell\'editor ha lo stato attivo (ad esempio, lo stato attivo si trova nel widget di ricerca)",
		"Indica se un editor o un input RTF ha lo stato attivo (il cursore lampeggia)",
		"Indica se l\'editor è di sola lettura",
		"Indica se il contesto è un editor diff",
		"Indica se `editor.columnSelection` è abilitato",
		"Indica se per l\'editor esiste testo selezionato",
		"Indica se per l\'editor esistono più selezioni",
		"Indica se premendo `TAB`, lo stato attivo verrà spostato all\'esterno dell\'editor",
		"Indica se il passaggio del puntatore nell\'editor è visibile",
		"Indica se l\'editor fa parte di un editor più esteso (ad esempio notebook)",
		"Identificatore lingua dell\'editor",
		"Indica se per l\'editor esiste un provider di voci di completamento",
		"Indica se per l\'editor esiste un provider di azioni codice",
		"Indica se per l\'editor esiste un provider di CodeLens",
		"Indica se per l\'editor esiste un provider di definizioni",
		"Indica se per l\'editor esiste un provider di dichiarazioni",
		"Indica se per l\'editor esiste un provider di implementazioni",
		"Indica se per l\'editor esiste un provider di definizioni di tipo",
		"Indica se per l\'editor esiste un provider di passaggi del mouse",
		"Indica se per l\'editor esiste un provider di evidenziazione documenti",
		"Indica se per l\'editor esiste un provider di simboli di documenti",
		"Indica se per l\'editor esiste un provider di riferimenti",
		"Indica se per l\'editor esiste un provider di ridenominazione",
		"Indica se per l\'editor esiste un provider della guida per la firma",
		"Indica se per l\'editor esiste un provider di suggerimenti inline",
		"Indica se per l\'editor esiste un provider di formattazione documenti",
		"Indica se per l\'editor esiste un provider di formattazione di selezioni documento",
		"Indica se per l\'editor esistono più provider di formattazione documenti",
		"Indica se per l\'editor esistono più provider di formattazione di selezioni documento",
	],
	"vs/editor/common/model/editStack": [
		"Digitazione",
	],
	"vs/editor/common/modes/modesRegistry": [
		"Testo normale",
	],
	"vs/editor/common/standaloneStrings": [
		"Nessuna selezione",
		"Riga {0}, colonna {1} ({2} selezionate)",
		"Riga {0}, colonna {1}",
		"{0} selezioni ({1} caratteri selezionati)",
		"{0} selezioni",
		"Modifica dell\'impostazione `accessibilitySupport` in `on`.",
		"Apertura della pagina di documentazione sull\'accessibilità dell\'editor.",
		"in un riquadro di sola lettura di un editor diff.",
		"in un riquadro di un editor diff.",
		" in un editor di codice di sola lettura",
		" in un editor di codice",
		"Per configurare l\'editor da ottimizzare per l\'utilizzo con un\'utilità per la lettura dello schermo, premere Comando+E.",
		"Per configurare l\'editor da ottimizzare per l\'utilizzo con un\'utilità per la lettura dello schermo, premere CTRL+E.",
		"L\'editor è configurato per essere ottimizzato per l\'utilizzo con un\'utilità per la lettura dello schermo.",
		"L\'editor è configurato per non essere ottimizzato per l\'utilizzo con un\'utilità per la lettura dello schermo, che non viene usata in questo momento.",
		"Premere TAB nell\'editor corrente per spostare lo stato attivo sull\'elemento con stato attivabile successivo. Per attivare/disattivare questo comportamento, premere {0}.",
		"Premere TAB nell\'editor corrente per spostare lo stato attivo sull\'elemento con stato attivabile successivo. Il comando {0} non può essere attualmente attivato con un tasto di scelta rapida.",
		"Premere TAB nell\'editor corrente per inserire il carattere di tabulazione. Per attivare/disattivare questo comportamento, premere {0}.",
		"Premere TAB nell\'editor corrente per inserire il carattere di tabulazione. Il comando {0} non può essere attualmente attivato con un tasto di scelta rapida.",
		"Premere Comando+H per aprire una finestra del browser contenente maggiori informazioni correlate all\'accessibilità dell\'editor.",
		"Premere CTRL+H per aprire una finestra del browser contenente maggiori informazioni correlate all\'accessibilità dell\'editor.",
		"Per chiudere questa descrizione comando e tornare all\'editor, premere ESC o MAIUSC+ESC.",
		"Visualizza la Guida sull\'accessibilità",
		"Sviluppatore: Controlla token",
		"Vai a Riga/Colonna...",
		"Mostra tutti i provider di accesso rapido",
		"Riquadro comandi",
		"Mostra ed esegui comandi",
		"Vai al simbolo...",
		"Vai al simbolo per categoria...",
		"Contenuto editor",
		"Premere ALT+F1 per le opzioni di accessibilità.",
		"Attiva/disattiva tema a contrasto elevato",
		"Effettuate {0} modifiche in {1} file",
	],
	"vs/editor/common/view/editorColorRegistry": [
		"Colore di sfondo per l\'evidenziazione della riga alla posizione del cursore.",
		"Colore di sfondo per il bordo intorno alla riga alla posizione del cursore.",
		"Colore di sfondo degli intervalli evidenziati, ad esempio dalle funzionalità Quick Open e Trova. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo del bordo intorno agli intervalli selezionati.",
		"Colore di sfondo del simbolo evidenziato, ad esempio per passare alla definizione o al simbolo successivo/precedente. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo del bordo intorno ai simboli selezionati.",
		"Colore del cursore dell\'editor.",
		"Colore di sfondo del cursore editor. Permette di personalizzare il colore di un carattere quando sovrapposto da un blocco cursore.",
		"Colore dei caratteri di spazio vuoto nell\'editor.",
		"Colore delle guide per i rientri dell\'editor.",
		"Colore delle guide di indentazione dell\'editor attivo",
		"Colore dei numeri di riga dell\'editor.",
		"Colore del numero di riga attivo dell\'editor",
		"Id è deprecato. In alternativa usare \'editorLineNumber.activeForeground\'.",
		"Colore del numero di riga attivo dell\'editor",
		"Colore dei righelli dell\'editor.",
		"Colore primo piano delle finestre di CodeLens dell\'editor",
		"Colore di sfondo delle parentesi corrispondenti",
		"Colore delle caselle di parentesi corrispondenti",
		"Colore del bordo del righello delle annotazioni.",
		"Colore di sfondo del righello delle annotazioni dell\'editor. Viene usato solo quando la minimappa è abilitata e posizionata sul lato destro dell\'editor.",
		"Colore di sfondo della barra di navigazione dell\'editor. La barra contiene i margini di glifo e i numeri di riga.",
		"Colore del bordo del codice sorgente non necessario (non usato) nell\'editor.",
		"Opacità del codice sorgente non necessario (non usato) nell\'editor. Ad esempio, con \"#000000c0\" il rendering del codice verrà eseguito con il 75% di opacità. Per i temi a contrasto elevato, usare il colore del tema \'editorUnnecessaryCode.border\' per sottolineare il codice non necessario invece di opacizzarlo.",
		"Colore del bordo del testo fantasma nell\'Editor.",
		"Colore primo piano del testo fantasma nell\'Editor.",
		"Colore del marcatore del righello delle annotazioni per le evidenziazioni degli intervalli. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del marcatore del righello delle annotazioni per gli errori.",
		"Colore del marcatore del righello delle annotazioni per gli avvisi.",
		"Colore del marcatore del righello delle annotazioni per i messaggi di tipo informativo.",
	],
	"vs/editor/contrib/anchorSelect/anchorSelect": [
		"Ancoraggio della selezione",
		"Ancoraggio impostato alla posizione {0}:{1}",
		"Imposta ancoraggio della selezione",
		"Vai ad ancoraggio della selezione",
		"Seleziona da ancoraggio a cursore",
		"Annulla ancoraggio della selezione",
	],
	"vs/editor/contrib/bracketMatching/bracketMatching": [
		"Colore del marcatore del righello delle annotazioni per la corrispondenza delle parentesi.",
		"Vai alla parentesi quadra",
		"Seleziona fino alla parentesi",
		"Vai alla parentesi &&quadra",
	],
	"vs/editor/contrib/caretOperations/caretOperations": [
		"Sposta testo selezionato a sinistra",
		"Sposta testo selezionato a destra",
	],
	"vs/editor/contrib/caretOperations/transpose": [
		"Trasponi lettere",
	],
	"vs/editor/contrib/clipboard/clipboard": [
		"&&Taglia",
		"Taglia",
		"Taglia",
		"Taglia",
		"&&Copia",
		"Copia",
		"Copia",
		"Copia",
		"Copia con nome",
		"Copia con nome",
		"&&Incolla",
		"Incolla",
		"Incolla",
		"Incolla",
		"Copia con evidenziazione sintassi",
	],
	"vs/editor/contrib/codeAction/codeActionCommands": [
		"Tipo dell\'azione codice da eseguire.",
		"Controlla quando vengono applicate le azioni restituite.",
		"Applica sempre la prima azione codice restituita.",
		"Applica la prima azione codice restituita se è l\'unica.",
		"Non applicare le azioni codice restituite.",
		"Controlla se devono essere restituite solo le azioni codice preferite.",
		"Si è verificato un errore sconosciuto durante l\'applicazione dell\'azione del codice",
		"Correzione rapida...",
		"Azioni codice non disponibili",
		"Non sono disponibili azioni codice preferite per \'{0}\'",
		"Non sono disponibili azioni codice per \'{0}\'",
		"Non sono disponibili azioni codice preferite",
		"Azioni codice non disponibili",
		"Effettua refactoring...",
		"Non sono disponibili refactoring preferiti per \'{0}\'",
		"Non sono disponibili refactoring per \'{0}\'",
		"Non sono disponibili refactoring preferiti",
		"Refactoring non disponibili",
		"Azione origine...",
		"Non sono disponibili azioni origine preferite per \'{0}\'",
		"Non sono disponibili azioni origine per \'{0}\'",
		"Non sono disponibili azioni origine preferite",
		"Azioni origine non disponibili",
		"Organizza import",
		"Azioni di organizzazione Imports non disponibili",
		"Correggi tutto",
		"Non è disponibile alcuna azione Correggi tutto",
		"Correzione automatica...",
		"Non sono disponibili correzioni automatiche",
	],
	"vs/editor/contrib/codeAction/lightBulbWidget": [
		"Mostra correzioni. Correzione preferita disponibile ({0})",
		"Mostra correzioni ({0})",
		"Mostra correzioni",
	],
	"vs/editor/contrib/codelens/codelensController": [
		"Mostra comandi di CodeLens per la riga corrente",
	],
	"vs/editor/contrib/comment/comment": [
		"Attiva/disattiva commento per la riga",
		"Attiva/Disattiva commento per la &&riga",
		"Aggiungi commento per la riga",
		"Rimuovi commento per la riga",
		"Attiva/Disattiva commento per il blocco",
		"Attiva/Disattiva commento per il &&blocco",
	],
	"vs/editor/contrib/contextmenu/contextmenu": [
		"Mostra il menu di scelta rapida editor",
	],
	"vs/editor/contrib/cursorUndo/cursorUndo": [
		"Cursore - Annulla",
		"Cursore - Ripeti",
	],
	"vs/editor/contrib/find/findController": [
		"Trova",
		"&&Trova",
		"Trova con selezione",
		"Trova successivo",
		"Trova precedente",
		"Trova selezione successiva",
		"Trova selezione precedente",
		"Sostituisci",
		"&&Sostituisci",
	],
	"vs/editor/contrib/find/findWidget": [
		"Icona per \'Trova nella selezione\' nel widget di ricerca dell\'editor.",
		"Icona per indicare che il widget di ricerca dell\'editor è compresso.",
		"Icona per indicare che il widget di ricerca dell\'editor è espanso.",
		"Icona per \'Sostituisci\' nel widget di ricerca dell\'editor.",
		"Icona per \'Sostituisci tutto\' nel widget di ricerca dell\'editor.",
		"Icona per \'Trova precedente\' nel widget di ricerca dell\'editor.",
		"Icona per \'Trova successivo\' nel widget di ricerca dell\'editor.",
		"Trova",
		"Trova",
		"Corrispondenza precedente",
		"Corrispondenza successiva",
		"Trova nella selezione",
		"Chiudi",
		"Sostituisci",
		"Sostituisci",
		"Sostituisci",
		"Sostituisci tutto",
		"Attiva/Disattiva modalità sostituzione",
		"Solo i primi {0} risultati vengono evidenziati, ma tutte le operazioni di ricerca funzionano su tutto il testo.",
		"{0} di {1}",
		"Nessun risultato",
		"{0} trovato",
		"{0} trovati per \'{1}\'",
		"{0} trovati per \'{1}\' alla posizione {2}",
		"{0} trovati per \'{1}\'",
		"Il tasto di scelta rapida CTRL+INVIO ora consente di inserire l\'interruzione di linea invece di sostituire tutto. Per eseguire l\'override di questo comportamento, è possibile modificare il tasto di scelta rapida per editor.action.replaceAll.",
	],
	"vs/editor/contrib/folding/folding": [
		"Espandi",
		"Espandi in modo ricorsivo",
		"Riduci",
		"Attiva/Disattiva riduzione",
		"Riduci in modo ricorsivo",
		"Riduci tutti i blocchi commento",
		"Riduci tutte le regioni",
		"Espandi tutte le regioni",
		"Riduci tutte le regioni eccetto quelle selezionate",
		"Espandi tutte le regioni eccetto quelle selezionate",
		"Riduci tutto",
		"Espandi tutto",
		"Livello riduzione {0}",
		"Colore di sfondo degli intervalli con riduzione. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del controllo di riduzione nella barra di navigazione dell\'editor.",
	],
	"vs/editor/contrib/folding/foldingDecorations": [
		"Icona per gli intervalli espansi nel margine del glifo dell\'editor.",
		"Icona per gli intervalli compressi nel margine del glifo dell\'editor.",
	],
	"vs/editor/contrib/fontZoom/fontZoom": [
		"Zoom avanti tipo di carattere editor",
		"Zoom indietro tipo di carattere editor",
		"Reimpostazione zoom tipo di carattere editor",
	],
	"vs/editor/contrib/format/format": [
		"È stata apportata 1 modifica di formattazione a riga {0}",
		"Sono state apportate {0} modifiche di formattazione a riga {1}",
		"È stata apportata 1 modifica di formattazione tra le righe {0} e {1}",
		"Sono state apportate {0} modifiche di formattazione tra le righe {1} e {2}",
	],
	"vs/editor/contrib/format/formatActions": [
		"Formatta documento",
		"Formatta selezione",
	],
	"vs/editor/contrib/gotoError/gotoError": [
		"Vai al problema successivo (Errore, Avviso, Informazioni)",
		"Icona per il marcatore Vai a successivo.",
		"Vai al problema precedente (Errore, Avviso, Informazioni)",
		"Icona per il marcatore Vai a precedente.",
		"Vai al problema successivo nei file (Errore, Avviso, Informazioni)",
		"&&Problema successivo",
		"Vai al problema precedente nei file (Errore, Avviso, Informazioni)",
		"&&Problema precedente",
	],
	"vs/editor/contrib/gotoError/gotoErrorWidget": [
		"Errore",
		"Avviso",
		"Info",
		"Suggerimento",
		"{0} a {1}. ",
		"{0} di {1} problemi",
		"{0} di {1} problema",
		"Colore per gli errori del widget di spostamento tra marcatori dell\'editor.",
		"Colore per gli avvisi del widget di spostamento tra marcatori dell\'editor.",
		"Colore delle informazioni del widget di navigazione marcatori dell\'editor.",
		"Sfondo del widget di spostamento tra marcatori dell\'editor.",
	],
	"vs/editor/contrib/gotoSymbol/goToCommands": [
		"Anteprima",
		"Definizioni",
		"Non è stata trovata alcuna definizione per \'{0}\'",
		"Non è stata trovata alcuna definizione",
		"Vai alla definizione",
		"Vai alla &&definizione",
		"Apri definizione lateralmente",
		"Visualizza in anteprima la definizione",
		"Dichiarazioni",
		"Non è stata trovata alcuna dichiarazione per \'{0}\'",
		"Dichiarazione non trovata",
		"Vai a dichiarazione",
		"Vai a &&dichiarazione",
		"Non è stata trovata alcuna dichiarazione per \'{0}\'",
		"Dichiarazione non trovata",
		"Anteprima dichiarazione",
		"Definizioni di tipo",
		"Non sono state trovate definizioni di tipi per \'{0}\'",
		"Non sono state trovate definizioni di tipi",
		"Vai alla definizione di tipo",
		"Vai alla &&definizione di tipo",
		"Anteprima definizione di tipo",
		"Implementazioni",
		"Non sono state trovate implementazioni per \'{0}\'",
		"Non sono state trovate implementazioni",
		"Vai a implementazioni",
		"Vai a &&Implementazioni",
		"Visualizza implementazioni",
		"Non sono stati trovati riferimenti per \'{0}\'",
		"Non sono stati trovati riferimenti",
		"Vai a Riferimenti",
		"Vai a &&riferimenti",
		"Riferimenti",
		"Anteprima riferimenti",
		"Riferimenti",
		"Vai a qualsiasi simbolo",
		"Posizioni",
		"Nessun risultato per \'{0}\'",
		"Riferimenti",
	],
	"vs/editor/contrib/gotoSymbol/link/goToDefinitionAtPosition": [
		"Fare clic per visualizzare {0} definizioni.",
	],
	"vs/editor/contrib/gotoSymbol/peek/referencesController": [
		"Indica se l\'anteprima riferimenti è visibile, come \'Visualizza in anteprima riferimenti\' o \'Visualizza in anteprima la definizione\'",
		"Caricamento...",
		"{0} ({1})",
	],
	"vs/editor/contrib/gotoSymbol/peek/referencesTree": [
		"{0} riferimenti",
		"{0} riferimento",
		"Riferimenti",
	],
	"vs/editor/contrib/gotoSymbol/peek/referencesWidget": [
		"anteprima non disponibile",
		"Nessun risultato",
		"Riferimenti",
	],
	"vs/editor/contrib/gotoSymbol/referencesModel": [
		"simbolo in {0} alla riga {1} colonna {2}",
		"simbolo in {0} alla riga {1} colonna {2}, {3}",
		"1 simbolo in {0}, percorso completo {1}",
		"{0} simboli in {1}, percorso completo {2}",
		"Non sono stati trovati risultati",
		"Trovato 1 simbolo in {0}",
		"Trovati {0} simboli in {1}",
		"Trovati {0} simboli in {1} file",
	],
	"vs/editor/contrib/gotoSymbol/symbolNavigation": [
		"Indica se sono presenti posizioni dei simboli a cui è possibile passare solo tramite la tastiera.",
		"Simbolo {0} di {1}, {2} per il successivo",
		"Simbolo {0} di {1}",
	],
	"vs/editor/contrib/hover/hover": [
		"Visualizza passaggio del mouse",
		"Mostra anteprima definizione al passaggio del mouse",
	],
	"vs/editor/contrib/hover/markdownHoverParticipant": [
		"Caricamento...",
		"Per motivi di prestazioni la tokenizzazione viene ignorata per le righe lunghe. È possibile effettuare questa configurazione tramite `editor.maxTokenizationLineLength`.",
	],
	"vs/editor/contrib/hover/markerHoverParticipant": [
		"Visualizza problema",
		"Non sono disponibili correzioni rapide",
		"Verifica disponibilità correzioni rapide...",
		"Non sono disponibili correzioni rapide",
		"Correzione rapida...",
	],
	"vs/editor/contrib/inPlaceReplace/inPlaceReplace": [
		"Sostituisci con il valore precedente",
		"Sostituisci con il valore successivo",
	],
	"vs/editor/contrib/indentation/indentation": [
		"Converti rientro in spazi",
		"Converti rientro in tabulazioni",
		"Dimensione tabulazione configurata",
		"Seleziona dimensione tabulazione per il file corrente",
		"Imposta rientro con tabulazioni",
		"Imposta rientro con spazi",
		"Rileva rientro dal contenuto",
		"Imposta nuovo rientro per righe",
		"Re-Indenta le Linee Selezionate",
	],
	"vs/editor/contrib/inlineCompletions/ghostTextController": [
		"Se è visibile un suggerimento inline",
		"Se il suggerimento in linea inizia con spazi vuoti",
		"Mostrare suggerimento inline successivo",
		"Mostrare suggerimento inline precedente",
		"Trigger del suggerimento inline",
	],
	"vs/editor/contrib/inlineCompletions/inlineCompletionsHoverParticipant": [
		"Avanti",
		"Indietro",
		"Accettare",
	],
	"vs/editor/contrib/linesOperations/linesOperations": [
		"Copia la riga in alto",
		"&&Copia la riga in alto",
		"Copia la riga in basso",
		"Co&&pia la riga in basso",
		"Duplica selezione",
		"&&Duplica selezione",
		"Sposta la riga in alto",
		"Sposta la riga in &&alto",
		"Sposta la riga in basso",
		"Sposta la riga in &&basso",
		"Ordinamento righe crescente",
		"Ordinamento righe decrescente",
		"Taglia spazio vuoto finale",
		"Elimina riga",
		"Imposta un rientro per la riga",
		"Riduci il rientro per la riga",
		"Inserisci la riga sopra",
		"Inserisci la riga sotto",
		"Elimina tutto a sinistra",
		"Elimina tutto a destra",
		"Unisci righe",
		"Trasponi caratteri intorno al cursore",
		"Converti in maiuscolo",
		"Converti in minuscolo",
		"Trasforma in Tutte Iniziali Maiuscole",
		"Trasforma in snake case",
	],
	"vs/editor/contrib/linkedEditing/linkedEditing": [
		"Avvia modifica collegata",
		"Colore di sfondo quando l\'editor viene rinominato automaticamente in base al tipo.",
	],
	"vs/editor/contrib/links/links": [
		"Esegui il comando",
		"Visita il collegamento",
		"CMD+clic",
		"CTRL+clic",
		"Opzione+clic",
		"ALT+clic",
		"Esegue il comando {0}",
		"Non è stato possibile aprire questo collegamento perché il formato non è valido: {0}",
		"Non è stato possibile aprire questo collegamento perché manca la destinazione.",
		"Apri collegamento",
	],
	"vs/editor/contrib/message/messageController": [
		"Indica se l\'editor visualizza attualmente un messaggio inline",
		"Non è possibile modificare nell\'editor di sola lettura",
	],
	"vs/editor/contrib/multicursor/multicursor": [
		"Cursore aggiunto: {0}",
		"Cursori aggiunti: {0}",
		"Aggiungi cursore sopra",
		"&&Aggiungi cursore sopra",
		"Aggiungi cursore sotto",
		"A&&ggiungi cursore sotto",
		"Aggiungi cursori a fine riga",
		"Aggiungi c&&ursori a fine riga",
		"Aggiungi cursori alla fine",
		"Aggiungi cursori all\'inizio",
		"Aggiungi selezione a risultato ricerca successivo",
		"Aggiungi &&occorrenza successiva",
		"Aggiungi selezione a risultato ricerca precedente",
		"Aggiungi occorrenza &&precedente",
		"Sposta ultima selezione a risultato ricerca successivo",
		"Sposta ultima selezione a risultato ricerca precedente",
		"Seleziona tutte le occorrenze del risultato ricerca",
		"Seleziona &&tutte le occorrenze",
		"Cambia tutte le occorrenze",
	],
	"vs/editor/contrib/parameterHints/parameterHints": [
		"Attiva i suggerimenti per i parametri",
	],
	"vs/editor/contrib/parameterHints/parameterHintsWidget": [
		"Icona per visualizzare il suggerimento del parametro successivo.",
		"Icona per visualizzare il suggerimento del parametro precedente.",
		"{0}, suggerimento",
	],
	"vs/editor/contrib/peekView/peekView": [
		"Indica se l\'editor di codice corrente è incorporato nell\'anteprima",
		"Chiudi",
		"Colore di sfondo dell\'area del titolo della visualizzazione rapida.",
		"Colore del titolo della visualizzazione rapida.",
		"Colore delle informazioni del titolo della visualizzazione rapida.",
		"Colore dei bordi e della freccia della visualizzazione rapida.",
		"Colore di sfondo dell\'elenco risultati della visualizzazione rapida.",
		"Colore primo piano dei nodi riga nell\'elenco risultati della visualizzazione rapida.",
		"Colore primo piano dei nodi file nell\'elenco risultati della visualizzazione rapida.",
		"Colore di sfondo della voce selezionata nell\'elenco risultati della visualizzazione rapida.",
		"Colore primo piano della voce selezionata nell\'elenco risultati della visualizzazione rapida.",
		"Colore di sfondo dell\'editor di visualizzazioni rapide.",
		"Colore di sfondo della barra di navigazione nell\'editor visualizzazione rapida.",
		"Colore dell\'evidenziazione delle corrispondenze nell\'elenco risultati della visualizzazione rapida.",
		"Colore dell\'evidenziazione delle corrispondenze nell\'editor di visualizzazioni rapide.",
		"Bordo dell\'evidenziazione delle corrispondenze nell\'editor di visualizzazioni rapide.",
	],
	"vs/editor/contrib/quickAccess/gotoLineQuickAccess": [
		"Aprire prima un editor di testo per passare a una riga.",
		"Vai a riga {0} e carattere {1}.",
		"Vai alla riga {0}.",
		"Riga corrente: {0}, carattere: {1}. Digitare un numero di riga a cui passare compreso tra 1 e {2}.",
		"Riga corrente: {0}, Carattere: {1}. Digitare un numero di riga a cui passare.",
	],
	"vs/editor/contrib/quickAccess/gotoSymbolQuickAccess": [
		"Per passare a un simbolo, aprire prima un editor di testo con informazioni sui simboli.",
		"L\'editor di testo attivo non fornisce informazioni sui simboli.",
		"Non ci sono simboli dell\'editor corrispondenti",
		"Non ci sono simboli dell\'editor",
		"Apri lateralmente",
		"Apri in basso",
		"simboli ({0})",
		"proprietà ({0})",
		"metodi ({0})",
		"funzioni ({0})",
		"costruttori ({0})",
		"variabili ({0})",
		"classi ({0})",
		"struct ({0})",
		"eventi ({0})",
		"operatori ({0})",
		"interfacce ({0})",
		"spazi dei nomi ({0})",
		"pacchetti ({0})",
		"parametri di tipo ({0})",
		"moduli ({0})",
		"proprietà ({0})",
		"enumerazioni ({0})",
		"membri di enumerazione ({0})",
		"stringhe ({0})",
		"file ({0})",
		"matrici ({0})",
		"numeri ({0})",
		"valori booleani ({0})",
		"oggetti ({0})",
		"chiavi ({0})",
		"campi ({0})",
		"costanti ({0})",
	],
	"vs/editor/contrib/rename/rename": [
		"Nessun risultato.",
		"Si è verificato un errore sconosciuto durante la risoluzione del percorso di ridenominazione",
		"Ridenominazione di \'{0}\'",
		"Ridenominazione di {0}",
		"Correttamente rinominato \'{0}\' in \'{1}\'. Sommario: {2}",
		"La ridenominazione non è riuscita ad applicare le modifiche",
		"La ridenominazione non è riuscita a calcolare le modifiche",
		"Rinomina simbolo",
		"Abilita/Disabilita l\'opzione per visualizzare le modifiche in anteprima prima della ridenominazione",
	],
	"vs/editor/contrib/rename/renameInputField": [
		"Indica se il widget di ridenominazione input è visibile",
		"Consente di rinominare l\'input. Digitare il nuovo nome e premere INVIO per eseguire il commit.",
		"{0} per rinominare, {1} per visualizzare in anteprima",
	],
	"vs/editor/contrib/smartSelect/smartSelect": [
		"Espandi selezione",
		"Espan&&di selezione",
		"Riduci selezione",
		"&&Riduci selezione",
	],
	"vs/editor/contrib/snippet/snippetController2": [
		"Indica se l\'editor è quello corrente nella modalità frammenti",
		"Indica se è presente una tabulazione successiva in modalità frammenti",
		"Indica se è presente una tabulazione precedente in modalità frammenti",
	],
	"vs/editor/contrib/snippet/snippetVariables": [
		"Domenica",
		"Lunedì",
		"Martedì",
		"Mercoledì",
		"Giovedì",
		"Venerdì",
		"Sabato",
		"Dom",
		"Lun",
		"Mar",
		"Mer",
		"Gio",
		"Ven",
		"Sab",
		"Gennaio",
		"Febbraio",
		"Marzo",
		"Aprile",
		"Mag",
		"Giugno",
		"Luglio",
		"Agosto",
		"Settembre",
		"Ottobre",
		"Novembre",
		"Dicembre",
		"Gen",
		"Feb",
		"Mar",
		"Apr",
		"Mag",
		"Giu",
		"Lug",
		"Ago",
		"Set",
		"Ott",
		"Nov",
		"Dic",
	],
	"vs/editor/contrib/suggest/suggest": [
		"Indica se i suggerimenti sono visibili",
		"Indica se i dettagli dei suggerimenti sono visibili",
		"Indica se sono presenti più suggerimenti da cui scegliere",
		"Indica se l\'inserimento del suggerimento corrente comporta una modifica oppure se completa già l\'input",
		"Indica se i suggerimenti vengono inseriti quando si preme INVIO",
		"Indica se il suggerimento corrente include il comportamento di inserimento e sostituzione",
		"Indica se il comportamento predefinito è quello di inserimento o sostituzione",
		"Indica se il suggerimento corrente supporta la risoluzione di ulteriori dettagli",
	],
	"vs/editor/contrib/suggest/suggestController": [
		"In seguito all\'accettazione di \'{0}\' sono state apportate altre {1} modifiche",
		"Attiva suggerimento",
		"Inserisci",
		"Inserisci",
		"Sostituisci",
		"Sostituisci",
		"Inserisci",
		"nascondi dettagli",
		"mostra dettagli",
		"Reimposta le dimensioni del widget dei suggerimenti",
	],
	"vs/editor/contrib/suggest/suggestWidget": [
		"Colore di sfondo del widget dei suggerimenti.",
		"Colore del bordo del widget dei suggerimenti.",
		"Colore primo piano del widget dei suggerimenti.",
		"Colore primo piano della voce selezionata del widget dei suggerimenti.",
		"Colore primo piano dell’icona della voce selezionata del widget dei suggerimenti.",
		"Colore di sfondo della voce selezionata del widget dei suggerimenti.",
		"Colore delle evidenziazioni corrispondenze nel widget dei suggerimenti.",
		"Colore delle evidenziazioni corrispondenze nel widget dei suggerimenti quando lo stato attivo si trova su un elemento.",
		"Caricamento...",
		"Non ci sono suggerimenti.",
		"{0}, documenti: {1}",
		"Suggerisci",
	],
	"vs/editor/contrib/suggest/suggestWidgetDetails": [
		"Chiudi",
		"Caricamento...",
	],
	"vs/editor/contrib/suggest/suggestWidgetRenderer": [
		"Icona per visualizzare altre informazioni nel widget dei suggerimenti.",
		"Altre informazioni",
	],
	"vs/editor/contrib/suggest/suggestWidgetStatus": [
		"{0} ({1})",
	],
	"vs/editor/contrib/symbolIcons/symbolIcons": [
		"Colore primo piano per i simboli di matrice. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli booleani. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di classe. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di colore. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di costante. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di costruttore. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di enumeratore. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di membro di enumeratore. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di evento. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di campo. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di file. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di cartella. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di funzione. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di interfaccia. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di chiave. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di parola chiave. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di metodo. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di modulo. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di spazio dei nomi. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli Null. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli numerici. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di oggetto. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di operatore. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di pacchetto. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di proprietà. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di riferimento. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di frammento. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di stringa. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di struct. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di testo. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di parametro di tipo. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di unità. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
		"Colore primo piano per i simboli di variabile. Questi simboli vengono visualizzati nella struttura, nell\'elemento di navigazione e nel widget dei suggerimenti.",
	],
	"vs/editor/contrib/toggleTabFocusMode/toggleTabFocusMode": [
		"Attiva/Disattiva l\'uso di TAB per spostare lo stato attivo",
		"Se si preme TAB, lo stato attivo verrà spostato sull\'elemento con stato attivabile successivo.",
		"Se si preme TAB, verrà inserito il carattere di tabulazione",
	],
	"vs/editor/contrib/tokenization/tokenization": [
		"Sviluppatore: Forza retokenizzazione",
	],
	"vs/editor/contrib/unusualLineTerminators/unusualLineTerminators": [
		"Caratteri di terminazione di riga insoliti",
		"Sono stati rilevati caratteri di terminazione di riga insoliti",
		"Il file \"\r\n\" contiene uno o più caratteri di terminazione di riga insoliti, ad esempio separatore di riga (LS) o separatore di paragrafo (PS).{0}\r\nÈ consigliabile rimuoverli dal file. È possibile configurare questa opzione tramite `editor.unusualLineTerminators`.",
		"Rimuovi i caratteri di terminazione di riga insoliti",
		"Ignora",
	],
	"vs/editor/contrib/wordHighlighter/wordHighlighter": [
		"Colore di sfondo di un simbolo durante l\'accesso in lettura, ad esempio durante la lettura di una variabile. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo di un simbolo durante l\'accesso in scrittura, ad esempio durante la scrittura in una variabile. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del bordo di un simbolo durante l\'accesso in lettura, ad esempio durante la lettura di una variabile.",
		"Colore del bordo di un simbolo durante l\'accesso in scrittura, ad esempio durante la scrittura in una variabile.",
		"Colore del marcatore del righello delle annotazioni per le evidenziazioni dei simboli. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del marcatore del righello delle annotazioni per le evidenziazioni dei simboli di accesso in scrittura. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Vai al prossimo simbolo evidenziato",
		"Vai al precedente simbolo evidenziato",
		"Attiva/disattiva evidenziazione simbolo",
	],
	"vs/editor/contrib/wordOperations/wordOperations": [
		"Elimina parola",
	],
	"vs/platform/actions/browser/menuEntryActionViewItem": [
		"{0} ({1})",
		"{0} ({1})",
	],
	"vs/platform/configuration/common/configurationRegistry": [
		"Override configurazione predefinita del linguaggio",
		"Consente di configurare le impostazioni dell\'editor di cui eseguire l\'override per un linguaggio.",
		"Questa impostazione non supporta la configurazione per lingua.",
		"Non è possibile registrare una proprietà vuota",
		"Non è possibile registrare \'{0}\'. Corrisponde al criterio di proprietà \'\\\\[.*\\\\]$\' per la descrizione delle impostazioni dell\'editor specifiche del linguaggio. Usare il contributo \'configurationDefaults\'.",
		"Non è possibile registrare \'{0}\'. Questa proprietà è già registrata.",
	],
	"vs/platform/contextkey/browser/contextKeyService": [
		"Comando che restituisce informazioni sulle chiavi di contesto",
	],
	"vs/platform/contextkey/common/contextkeys": [
		"Indica se il sistema operativo è Windows",
	],
	"vs/platform/keybinding/common/abstractKeybindingService": [
		"È stato premuto ({0}). In attesa del secondo tasto...",
		"La combinazione di tasti ({0}, {1}) non è un comando.",
	],
	"vs/platform/list/browser/listService": [
		"Workbench",
		"Rappresenta il tasto \'Control\' in Windows e Linux e il tasto \'Comando\' in macOS.",
		"Rappresenta il tasto \'Alt\' in Windows e Linux e il tasto \'Opzione\' in macOS.",
		"Il modificatore da utilizzare per aggiungere un elemento di alberi e liste ad una selezione multipla con il mouse (ad esempio in Esplora Risorse, apre gli editor e le viste scm). Le gesture del mouse \'Apri a lato\' - se supportate - si adatteranno in modo da non creare conflitti con il modificatore di selezione multipla.",
		"Controlla l\'apertura degli elementi di alberi ed elenchi tramite il mouse (se supportato). Tenere presente che alcuni alberi ed elenchi potrebbero scegliere di ignorare questa impostazione se non è applicabile.",
		"Controlla se elenchi e alberi supportano lo scorrimento orizzontale nell\'area di lavoro. Avviso: l\'attivazione di questa impostazione può influire sulle prestazioni.",
		"Controlla il rientro dell\'albero in pixel.",
		"Controlla se l\'albero deve eseguire il rendering delle guide per i rientri.",
		"Controlla se elenchi e alberi prevedono lo scorrimento uniforme.",
		"Con lo stile di spostamento da tastiera simple lo stato attivo si trova sugli elementi che corrispondono all\'input da tastiera. L\'abbinamento viene effettuato solo in base ai prefissi.",
		"Con lo stile di spostamento da tastiera highlight vengono evidenziati gli elementi corrispondenti all\'input da tastiera. Spostandosi ulteriormente verso l\'alto o verso il basso ci si sposterà solo negli elementi evidenziati.",
		"Con lo stile di spostamento da tastiera filter verranno filtrati e nascosti tutti gli elementi che non corrispondono all\'input da tastiera.",
		"Controlla lo stile di spostamento da tastiera per elenchi e alberi nel workbench. Le opzioni sono: simple, highlight e filter.",
		"Controlla se gli spostamenti da tastiera per elenchi e alberi vengono attivati semplicemente premendo un tasto. Se è impostato su `false`, gli spostamenti da tastiera vengono attivati solo durante l\'esecuzione del comando `list.toggleKeyboardNavigation`, al quale è possibile assegnare un tasto di scelta rapida.",
		"Controlla l\'espansione delle cartelle di alberi quando si fa clic sui nomi delle cartelle. Tenere presente che alcuni alberi ed elenchi potrebbero scegliere di ignorare questa impostazione se non è applicabile.",
	],
	"vs/platform/markers/common/markers": [
		"Errore",
		"Avviso",
		"Info",
	],
	"vs/platform/quickinput/browser/commandsQuickAccess": [
		"{0}, {1}",
		"usate di recente",
		"altri comandi",
		"Il comando \'{0}\' ha restituito un errore ({1})",
	],
	"vs/platform/quickinput/browser/helpQuickAccess": [
		"comandi globali",
		"comandi dell\'editor",
		"{0}, {1}",
	],
	"vs/platform/theme/common/colorRegistry": [
		"Colore primo piano generale. Questo colore viene usato solo se non è sostituito da quello di un componente.",
		"Colore primo piano globale per i messaggi di errore. Questo colore viene usato solo se non è sostituito da quello di un componente.",
		"Colore predefinito per le icone nel workbench.",
		"Colore del bordo globale per gli elementi evidenziati. Questo colore viene usato solo se non è sostituito da quello di un componente.",
		"Un bordo supplementare attorno agli elementi per contrastarli maggiormente rispetto agli altri.",
		"Un bordo supplementare intorno agli elementi attivi per contrastarli maggiormente rispetto agli altri.",
		"Colore primo piano dei link nel testo.",
		"Colore primo piano per i collegamenti nel testo quando vengono selezionati o al passaggio del mouse.",
		"Colore di sfondo per i blocchi di codice nel testo.",
		"Colore ombreggiatura dei widget, ad es. Trova/Sostituisci all\'interno dell\'editor.",
		"Sfondo della casella di input.",
		"Primo piano della casella di input.",
		"Bordo della casella di input.",
		"Colore del bordo di opzioni attivate nei campi di input.",
		"Colore di sfondo di opzioni attivate nei campi di input.",
		"Colore primo piano di opzioni attivate nei campi di input.",
		"Colore di sfondo di convalida dell\'input di tipo Informazione.",
		"Colore primo piano di convalida dell\'input di tipo Informazione.",
		"Colore del bordo della convalida dell\'input di tipo Informazione.",
		"Colore di sfondo di convalida dell\'input di tipo Avviso.",
		"Colore primo piano di convalida dell\'input di tipo Avviso.",
		"Colore del bordo della convalida dell\'input di tipo Avviso.",
		"Colore di sfondo di convalida dell\'input di tipo Errore.",
		"Colore primo piano di convalida dell\'input di tipo Errore.",
		"Colore del bordo della convalida dell\'input di tipo Errore.",
		"Sfondo dell\'elenco a discesa.",
		"Primo piano dell\'elenco a discesa.",
		"Colore primo piano del pulsante.",
		"Colore di sfondo del pulsante.",
		"Colore di sfondo del pulsante al passaggio del mouse.",
		"Colore di sfondo del badge. I badge sono piccole etichette informative, ad esempio per mostrare il conteggio dei risultati della ricerca.",
		"Colore primo piano del badge. I badge sono piccole etichette informative, ad esempio per mostrare il conteggio dei risultati di una ricerca.",
		"Ombra della barra di scorrimento per indicare lo scorrimento della visualizzazione.",
		"Colore di sfondo del cursore della barra di scorrimento.",
		"Colore di sfondo del cursore della barra di scorrimento al passaggio del mouse.",
		"Colore di sfondo del cursore della barra di scorrimento quando si fa clic con il mouse.",
		"Colore di sfondo dell\'indicatore di stato che può essere mostrato per operazioni a esecuzione prolungata.",
		"Colore di sfondo del testo dell\'errore nell\'editor. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore primo piano degli indicatori di errore nell\'editor.",
		"Colore del bordo delle caselle di errore nell\'editor.",
		"Colore di sfondo del testo dell\'avviso nell\'editor. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore primo piano degli indicatori di avviso nell\'editor.",
		"Colore del bordo delle caselle di avviso nell\'editor.",
		"Colore di sfondo del testo delle informazioni nell\'editor. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore primo piano degli indicatori di informazioni nell\'editor.",
		"Colore del bordo delle caselle informative nell\'editor.",
		"Colore primo piano degli indicatori di suggerimento nell\'editor.",
		"Colore del bordo delle caselle dei suggerimenti nell\'editor.",
		"Colore di sfondo dell\'editor.",
		"Colore primo piano predefinito dell\'editor.",
		"Colore di sfondo dei widget dell\'editor, ad esempio Trova/Sostituisci.",
		"Colore primo piano dei widget dell\'editor, ad esempio Trova/Sostituisci.",
		"Colore del bordo dei widget dell\'editor. Il colore viene usato solo se il widget sceglie di avere un bordo e se il colore non è sottoposto a override da un widget.",
		"Colore del bordo della barra di ridimensionamento dei widget dell\'editor. Il colore viene usato solo se il widget sceglie di avere un bordo di ridimensionamento e se il colore non è sostituito da quello di un widget.",
		"Colore di sfondo di Selezione rapida. Il widget Selezione rapida è il contenitore di selezioni quali il riquadro comandi.",
		"Colore primo piano di Selezione rapida. Il widget Selezione rapida è il contenitore di selezioni quali il riquadro comandi.",
		"Colore di sfondo del titolo di Selezione rapida. Il widget Selezione rapida è il contenitore di selezioni quali il riquadro comandi.",
		"Colore di selezione rapida per il raggruppamento delle etichette.",
		"Colore di selezione rapida per il raggruppamento dei bordi.",
		"Colore di sfondo dell\'etichetta del tasto di scelta rapida. L\'etichetta del tasto di scelta rapida viene usata per rappresentare una scelta rapida da tastiera.",
		"Colore primo piano dell\'etichetta del tasto di scelta rapida. L\'etichetta del tasto di scelta rapida viene usata per rappresentare una scelta rapida da tastiera.",
		"Colore del bordo dell\'etichetta del tasto di scelta rapida. L\'etichetta del tasto di scelta rapida viene usata per rappresentare una scelta rapida da tastiera.",
		"Colore inferiore del bordo dell\'etichetta del tasto di scelta rapida. L\'etichetta del tasto di scelta rapida viene usata per rappresentare una scelta rapida da tastiera.",
		"Colore della selezione dell\'editor.",
		"Colore del testo selezionato per il contrasto elevato.",
		"Colore della selezione in un editor inattivo. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore delle aree con lo stesso contenuto della selezione. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del bordo delle regioni con lo stesso contenuto della selezione.",
		"Colore della corrispondenza di ricerca corrente.",
		"Colore degli altri risultati della ricerca. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore dell\'intervallo di limite della ricerca. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del bordo della corrispondenza della ricerca corrente.",
		"Colore del bordo delle altre corrispondenze della ricerca.",
		"Colore del bordo dell\'intervallo che limita la ricerca. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Evidenziazione sotto la parola per cui è visualizzata un\'area sensibile al passaggio del mouse. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo dell\'area sensibile al passaggio del mouse dell\'editor.",
		"Colore primo piano dell\'area sensibile al passaggio del mouse dell\'editor.",
		"Colore del bordo dell\'area sensibile al passaggio del mouse dell\'editor.",
		"Colore di sfondo della barra di stato sensibile al passaggio del mouse dell\'editor.",
		"Colore dei collegamenti attivi.",
		"Colore primo piano dei suggerimenti inline",
		"Colore di sfondo dei suggerimenti inline",
		"Colore usato per l\'icona delle azioni con lampadina.",
		"Colore usato per l\'icona delle azioni di correzione automatica con lampadina.",
		"Colore di sfondo per il testo che è stato inserito. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo per il testo che è stato rimosso. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del contorno del testo che è stato inserito.",
		"Colore del contorno del testo che è stato rimosso.",
		"Colore del bordo tra due editor di testo.",
		"Colore del riempimento diagonale dell\'editor diff. Il riempimento diagonale viene usato nelle visualizzazioni diff affiancate.",
		"Colore di sfondo dell\'elenco/albero per l\'elemento con lo stato attivo quando l\'elenco/albero è attivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore primo piano dell\'elenco/albero per l\'elemento con lo stato attivo quando l\'elenco/albero è attivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore del contorno dell\'elenco/albero per l\'elemento con lo stato attivo quando l\'elenco/albero è attivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore di sfondo dell\'elenco/albero per l\'elemento selezionato quando l\'elenco/albero è attivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore primo piano dell\'elenco/albero per l\'elemento selezionato quando l\'elenco/albero è attivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore primo piano dell’icona dell\'elenco/albero per l\'elemento selezionato quando l\'elenco/albero è attivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore di sfondo dell\'elenco/albero per l\'elemento selezionato quando l\'elenco/albero è inattivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore primo piano dell\'elenco/albero per l\'elemento selezionato quando l\'elenco/albero è inattivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore primo piano dell’icona dell\'elenco/albero per l\'elemento selezionato quando l\'elenco/albero è inattivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Colore di sfondo dell\'elenco/albero per l\'elemento con lo stato attivo quando l\'elenco/albero è inattivo. Un elenco/albero attivo ha lo stato attivo della tastiera, uno inattivo no.",
		"Colore del contorno dell\'elenco/albero per l\'elemento con lo stato attivo quando l\'elenco/albero è inattivo. Un elenco/albero attivo ha lo stato attivo della tastiera, a differenza di uno inattivo.",
		"Sfondo dell\'elenco/albero al passaggio del mouse sugli elementi.",
		"Primo piano dell\'elenco/albero al passaggio del mouse sugli elementi.",
		"Sfondo dell\'elenco/albero durante il trascinamento degli elementi selezionati.",
		"Colore primo piano Elenco/Struttura ad albero delle occorrenze trovate durante la ricerca nell\'Elenco/Struttura ad albero.",
		"Colore primo piano Elenco/Struttura ad albero delle occorrenze trovate in elementi con lo stato attivo durante la ricerca nell\'Elenco/Struttura ad albero.",
		"Colore di sfondo del widget del filtro per tipo in elenchi e alberi.",
		"Colore del contorno del widget del filtro per tipo in elenchi e alberi.",
		"Colore del contorno del widget del filtro per tipo in elenchi e alberi quando non sono presenti corrispondenze.",
		"Colore del tratto dell\'albero per le guide per i rientri.",
		"Colore del tratto dell\'albero per le guide per i rientri.",
		"In alternativa, usare quickInputList.focusBackground",
		"Colore primo piano di Selezione rapida per l\'elemento con lo stato attivo.",
		"Colore primo piano dell’icona di Selezione rapida per l\'elemento con lo stato attivo.",
		"Colore di sfondo di Selezione rapida per l\'elemento con lo stato attivo.",
		"Colore del bordo del menu.",
		"Colore primo piano delle voci di menu.",
		"Colore di sfondo delle voci di menu.",
		"Colore primo piano della voce di menu selezionata nei menu.",
		"Colore di sfondo della voce di menu selezionata nei menu.",
		"Colore del bordo della voce di menu selezionata nei menu.",
		"Colore di un elemento separatore delle voci di menu.",
		"Colore di sfondo dell\'evidenziazione della tabulazione di un frammento.",
		"Colore del bordo dell\'evidenziazione della tabulazione di un frammento.",
		"Colore di sfondo dell\'evidenziazione della tabulazione finale di un frammento.",
		"Colore del bordo dell\'evidenziazione della tabulazione finale di un frammento.",
		"Colore del marcatore del righello delle annotazioni per la ricerca di corrispondenze. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del marcatore del righello delle annotazioni per le evidenziazioni delle selezioni. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del marcatore della minimappa per la ricerca delle corrispondenze.",
		"Colore del marcatore della minimappa per la selezione dell\'editor.",
		"Colore del marcatore della minimappa per gli errori.",
		"Colore del marcatore della minimappa per gli avvisi.",
		"Colore di sfondo della minimappa.",
		"Colore di sfondo del dispositivo di scorrimento della minimappa.",
		"Colore di sfondo del dispositivo di scorrimento della minimappa al passaggio del mouse.",
		"Colore di sfondo del dispositivo di scorrimento della minimappa quando si fa clic con il mouse.",
		"Colore usato per l\'icona di errore dei problemi.",
		"Colore usato per l\'icona di avviso dei problemi.",
		"Colore usato per l\'icona informazioni dei problemi.",
	],
	"vs/platform/theme/common/iconRegistry": [
		"ID del tipo di carattere da usare. Se non è impostato, viene usato il tipo di carattere definito per primo.",
		"Tipo di carattere associato alla definizione di icona.",
		"Icona dell\'azione di chiusura nei widget.",
	],
	"vs/platform/undoRedo/common/undoRedoService": [
		"I file seguenti sono stati chiusi e modificati nel disco: {0}.",
		"I file seguenti sono stati modificati in modo incompatibile: {0}.",
		"Non è stato possibile annullare \'{0}\' in tutti i file. {1}",
		"Non è stato possibile annullare \'{0}\' in tutti i file. {1}",
		"Non è stato possibile annullare \'{0}\' in tutti i file perché sono state apportate modifiche a {1}",
		"Non è stato possibile annullare \'{0}\' su tutti i file perché è già in esecuzione un\'operazione di annullamento o ripetizione su {1}",
		"Non è stato possibile annullare \'{0}\' su tutti i file perché nel frattempo è stata eseguita un\'operazione di annullamento o ripetizione",
		"Annullare \'{0}\' in tutti i file?",
		"Annulla in {0} file",
		"Annulla questo file",
		"Annulla",
		"Non è stato possibile annullare \'{0}\' perché è già in esecuzione un\'operazione di annullamento o ripetizione.",
		"Annullare \'{0}\'?",
		"Sì",
		"Annulla",
		"Non è stato possibile ripetere \'{0}\' in tutti i file. {1}",
		"Non è stato possibile ripetere \'{0}\' in tutti i file. {1}",
		"Non è stato possibile ripetere \'{0}\' in tutti i file perché sono state apportate modifiche a {1}",
		"Non è stato possibile ripetere l\'operazione \'{0}\' su tutti i file perché è già in esecuzione un\'operazione di annullamento o ripetizione sull\'elenco di file {1}",
		"Non è stato possibile ripetere \'{0}\' su tutti i file perché nel frattempo è stata eseguita un\'operazione di annullamento o ripetizione",
		"Non è stato possibile ripetere \'{0}\' perché è già in esecuzione un\'operazione di annullamento o ripetizione.",
	]
});