import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryScatter } from 'victory-scatter';
import { ChartContainer } from '../ChartContainer';
import { ChartScatterStyles } from '../ChartTheme';
import { getTheme } from '../ChartUtils';
export var ChartScatterSortOrder;
(function (ChartScatterSortOrder) {
    ChartScatterSortOrder["ascending"] = "ascending";
    ChartScatterSortOrder["descending"] = "descending";
})(ChartScatterSortOrder || (ChartScatterSortOrder = {}));
export const ChartScatter = (_a) => {
    var { containerComponent = React.createElement(ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant), size = ({ active }) => (active ? ChartScatterStyles.activeSize : ChartScatterStyles.size) } = _a, rest = __rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme", "size"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(VictoryScatter, Object.assign({ containerComponent: container, size: size, theme: theme }, rest));
};
ChartScatter.displayName = 'ChartScatter';
// Note: VictoryLine.role must be hoisted
hoistNonReactStatics(ChartScatter, VictoryScatter);
//# sourceMappingURL=ChartScatter.js.map