"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmLabels = void 0;
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importStar(require("react"));
require("./AcmLabels.css");
function AcmLabels(props) {
    var _a, _b;
    var labelsRecord = react_1.useMemo(function () {
        if (props.labels === undefined)
            return {};
        else if (Array.isArray(props.labels))
            return props.labels.reduce(function (labels, label) {
                var parts = label.split('=');
                /* istanbul ignore if */
                if (parts.length === 1) {
                    labels[parts[0]] = '';
                }
                else {
                    labels[parts[0]] = parts.slice(1).join('=');
                }
                return labels;
            }, {});
        else
            return props.labels;
    }, [props.labels]);
    var labels = react_1.useMemo(function () {
        return Object.keys(labelsRecord)
            .filter(function (key) { var _a; return !((_a = props.collapse) === null || _a === void 0 ? void 0 : _a.includes(key)); })
            .map(function (key) { return (labelsRecord[key] ? key + "=" + labelsRecord[key] : "" + key); });
    }, [labelsRecord, props.collapse]);
    var hidden = react_1.useMemo(function () {
        if (props.labels === undefined)
            return [];
        return Object.keys(labelsRecord)
            .filter(function (key) { var _a; return (_a = props.collapse) === null || _a === void 0 ? void 0 : _a.includes(key); })
            .map(function (key) { return (labelsRecord[key] ? key + "=" + labelsRecord[key] : "" + key); });
    }, [labelsRecord, props.collapse]);
    if (props.labels === undefined)
        return react_1.default.createElement(react_1.Fragment, null);
    var _c = react_1.useState(false), showMore = _c[0], setShowMore = _c[1];
    /* istanbul ignore next */
    var collapsedText = (_a = props.collapsedText) !== null && _a !== void 0 ? _a : hidden.length + " more";
    if (hidden.length > 0 && labels.length === 0 && props.allCollapsedText) {
        collapsedText = props.allCollapsedText;
    }
    /* istanbul ignore next */
    var expandedText = (_b = props.expandedText) !== null && _b !== void 0 ? _b : 'Show less';
    var onClick = react_1.useCallback(function () { return setShowMore(function (showMore) { return !showMore; }); }, []);
    /* istanbul ignore next */
    var onKeyPress = react_1.useCallback(function (e) {
        if (e.key === 'Enter' || e.key === ' ') {
            setShowMore(!showMore);
            e.preventDefault();
        }
    }, []);
    return (react_1.default.createElement("span", { className: "acm-labels" },
        labels.map(function (label) { return (react_1.default.createElement(react_core_1.Tooltip, { key: label, content: label },
            react_1.default.createElement("span", { className: "acm-label" }, label))); }),
        hidden.length > 0 &&
            showMore &&
            hidden.map(function (label) { return (react_1.default.createElement(react_core_1.Tooltip, { key: label, content: label },
                react_1.default.createElement("span", { className: "acm-label" }, label))); }),
        hidden.length > 0 && showMore && (react_1.default.createElement("span", { className: "acm-label-button", tabIndex: 0, onClick: onClick, onKeyPress: onKeyPress }, expandedText)),
        hidden.length > 0 && !showMore && (react_1.default.createElement("span", { className: "acm-label-button", tabIndex: 0, onClick: onClick, onKeyPress: onKeyPress }, collapsedText))));
}
exports.AcmLabels = AcmLabels;
//# sourceMappingURL=AcmLabels.js.map