import { parse, isNonNullType, GraphQLError, Kind, valueFromAST, print, isObjectType, isListType, isSpecifiedDirective, astFromValue, isSpecifiedScalarType, isIntrospectionType, isInterfaceType, isUnionType, isInputObjectType, isEnumType, isScalarType, GraphQLDeprecatedDirective, specifiedRules, concatAST, validate, buildClientSchema, visit, TokenKind, Source, isTypeSystemDefinitionNode, getNamedType, GraphQLString, GraphQLNonNull, GraphQLList, GraphQLID, GraphQLBoolean, GraphQLFloat, GraphQLInt, GraphQLObjectType, GraphQLInterfaceType, GraphQLInputObjectType, GraphQLDirective, GraphQLUnionType, GraphQLEnumType, GraphQLScalarType, isNamedType, getNullableType, isLeafType, GraphQLSchema, isDirective, isCompositeType, doTypesOverlap, getDirectiveValues, GraphQLSkipDirective, GraphQLIncludeDirective, typeFromAST, isAbstractType, getOperationAST, getOperationRootType, TypeNameMetaFieldDef, buildASTSchema } from 'graphql';
import { __spreadArray, __read, __assign, __values, __extends, __awaiter, __generator } from 'tslib';

var asArray = function (fns) { return (Array.isArray(fns) ? fns : fns ? [fns] : []); };
var invalidDocRegex = /\.[a-z0-9]+$/i;
function isDocumentString(str) {
    if (typeof str !== 'string') {
        return false;
    }
    // XXX: is-valid-path or is-glob treat SDL as a valid path
    // (`scalar Date` for example)
    // this why checking the extension is fast enough
    // and prevent from parsing the string in order to find out
    // if the string is a SDL
    if (invalidDocRegex.test(str)) {
        return false;
    }
    try {
        parse(str);
        return true;
    }
    catch (e) { }
    return false;
}
var invalidPathRegex = /[‘“!%&^<=>`]/;
function isValidPath(str) {
    return typeof str === 'string' && !invalidPathRegex.test(str);
}
function compareStrings(a, b) {
    if (String(a) < String(b)) {
        return -1;
    }
    if (String(a) > String(b)) {
        return 1;
    }
    return 0;
}
function nodeToString(a) {
    var _a, _b;
    var name;
    if ('alias' in a) {
        name = (_a = a.alias) === null || _a === void 0 ? void 0 : _a.value;
    }
    if (name == null && 'name' in a) {
        name = (_b = a.name) === null || _b === void 0 ? void 0 : _b.value;
    }
    if (name == null) {
        name = a.kind;
    }
    return name;
}
function compareNodes(a, b, customFn) {
    var aStr = nodeToString(a);
    var bStr = nodeToString(b);
    if (typeof customFn === 'function') {
        return customFn(aStr, bStr);
    }
    return compareStrings(aStr, bStr);
}
function isSome(input) {
    return input != null;
}
function assertSome(input, message) {
    if (message === void 0) { message = 'Value should be something'; }
    if (input == null) {
        throw new Error(message);
    }
}

// Taken from graphql-js
// https://github.com/graphql/graphql-js/blob/main/src/jsutils/inspect.ts
/* eslint-disable @typescript-eslint/ban-types */
var MAX_ARRAY_LENGTH = 10;
var MAX_RECURSIVE_DEPTH = 2;
/**
 * Used to print values in error messages.
 */
function inspect(value) {
    return formatValue(value, []);
}
function formatValue(value, seenValues) {
    switch (typeof value) {
        case 'string':
            return JSON.stringify(value);
        case 'function':
            return value.name ? "[function " + value.name + "]" : '[function]';
        case 'object':
            return formatObjectValue(value, seenValues);
        default:
            return String(value);
    }
}
function formatObjectValue(value, previouslySeenValues) {
    if (value === null) {
        return 'null';
    }
    if (previouslySeenValues.includes(value)) {
        return '[Circular]';
    }
    var seenValues = __spreadArray(__spreadArray([], __read(previouslySeenValues), false), [value], false);
    if (isJSONable(value)) {
        var jsonValue = value.toJSON();
        // check for infinite recursion
        if (jsonValue !== value) {
            return typeof jsonValue === 'string' ? jsonValue : formatValue(jsonValue, seenValues);
        }
    }
    else if (Array.isArray(value)) {
        return formatArray(value, seenValues);
    }
    return formatObject(value, seenValues);
}
function isJSONable(value) {
    return typeof value.toJSON === 'function';
}
function formatObject(object, seenValues) {
    var entries = Object.entries(object);
    if (entries.length === 0) {
        return '{}';
    }
    if (seenValues.length > MAX_RECURSIVE_DEPTH) {
        return '[' + getObjectTag(object) + ']';
    }
    var properties = entries.map(function (_a) {
        var _b = __read(_a, 2), key = _b[0], value = _b[1];
        return key + ': ' + formatValue(value, seenValues);
    });
    return '{ ' + properties.join(', ') + ' }';
}
function formatArray(array, seenValues) {
    if (array.length === 0) {
        return '[]';
    }
    if (seenValues.length > MAX_RECURSIVE_DEPTH) {
        return '[Array]';
    }
    var len = Math.min(MAX_ARRAY_LENGTH, array.length);
    var remaining = array.length - len;
    var items = [];
    for (var i = 0; i < len; ++i) {
        items.push(formatValue(array[i], seenValues));
    }
    if (remaining === 1) {
        items.push('... 1 more item');
    }
    else if (remaining > 1) {
        items.push("... " + remaining + " more items");
    }
    return '[' + items.join(', ') + ']';
}
function getObjectTag(object) {
    var tag = Object.prototype.toString
        .call(object)
        .replace(/^\[object /, '')
        .replace(/]$/, '');
    if (tag === 'Object' && typeof object.constructor === 'function') {
        var name_1 = object.constructor.name;
        if (typeof name_1 === 'string' && name_1 !== '') {
            return name_1;
        }
    }
    return tag;
}

/**
 * Prepares an object map of argument values given a list of argument
 * definitions and list of argument AST nodes.
 *
 * Note: The returned value is a plain Object with a prototype, since it is
 * exposed to user code. Care should be taken to not pull values from the
 * Object prototype.
 */
function getArgumentValues(def, node, variableValues) {
    var e_1, _a;
    var _b;
    if (variableValues === void 0) { variableValues = {}; }
    var variableMap = Object.entries(variableValues).reduce(function (prev, _a) {
        var _b;
        var _c = __read(_a, 2), key = _c[0], value = _c[1];
        return (__assign(__assign({}, prev), (_b = {}, _b[key] = value, _b)));
    }, {});
    var coercedValues = {};
    // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
    var argumentNodes = (_b = node.arguments) !== null && _b !== void 0 ? _b : [];
    var argNodeMap = argumentNodes.reduce(function (prev, arg) {
        var _a;
        return (__assign(__assign({}, prev), (_a = {}, _a[arg.name.value] = arg, _a)));
    }, {});
    try {
        for (var _c = __values(def.args), _d = _c.next(); !_d.done; _d = _c.next()) {
            var _e = _d.value, name_1 = _e.name, argType = _e.type, defaultValue = _e.defaultValue;
            var argumentNode = argNodeMap[name_1];
            if (!argumentNode) {
                if (defaultValue !== undefined) {
                    coercedValues[name_1] = defaultValue;
                }
                else if (isNonNullType(argType)) {
                    throw new GraphQLError("Argument \"" + name_1 + "\" of required type \"" + inspect(argType) + "\" " + 'was not provided.', node);
                }
                continue;
            }
            var valueNode = argumentNode.value;
            var isNull = valueNode.kind === Kind.NULL;
            if (valueNode.kind === Kind.VARIABLE) {
                var variableName = valueNode.name.value;
                if (variableValues == null || !variableMap[variableName]) {
                    if (defaultValue !== undefined) {
                        coercedValues[name_1] = defaultValue;
                    }
                    else if (isNonNullType(argType)) {
                        throw new GraphQLError("Argument \"" + name_1 + "\" of required type \"" + inspect(argType) + "\" " +
                            ("was provided the variable \"$" + variableName + "\" which was not provided a runtime value."), valueNode);
                    }
                    continue;
                }
                isNull = variableValues[variableName] == null;
            }
            if (isNull && isNonNullType(argType)) {
                throw new GraphQLError("Argument \"" + name_1 + "\" of non-null type \"" + inspect(argType) + "\" " + 'must not be null.', valueNode);
            }
            var coercedValue = valueFromAST(valueNode, argType, variableValues);
            if (coercedValue === undefined) {
                // Note: ValuesOfCorrectTypeRule validation should catch this before
                // execution. This is a runtime check to ensure execution does not
                // continue with an invalid argument value.
                throw new GraphQLError("Argument \"" + name_1 + "\" has invalid value " + print(valueNode) + ".", valueNode);
            }
            coercedValues[name_1] = coercedValue;
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return coercedValues;
}

function getDirectivesInExtensions(node, pathToDirectivesInExtensions) {
    if (pathToDirectivesInExtensions === void 0) { pathToDirectivesInExtensions = ['directives']; }
    return pathToDirectivesInExtensions.reduce(function (acc, pathSegment) { return (acc == null ? acc : acc[pathSegment]); }, node === null || node === void 0 ? void 0 : node.extensions);
}
function _getDirectiveInExtensions(directivesInExtensions, directiveName) {
    var directiveInExtensions = directivesInExtensions.filter(function (directiveAnnotation) { return directiveAnnotation.name === directiveName; });
    if (!directiveInExtensions.length) {
        return undefined;
    }
    return directiveInExtensions.map(function (directive) { var _a; return (_a = directive.args) !== null && _a !== void 0 ? _a : {}; });
}
function getDirectiveInExtensions(node, directiveName, pathToDirectivesInExtensions) {
    var e_1, _a, e_2, _b;
    if (pathToDirectivesInExtensions === void 0) { pathToDirectivesInExtensions = ['directives']; }
    var directivesInExtensions = pathToDirectivesInExtensions.reduce(function (acc, pathSegment) { return (acc == null ? acc : acc[pathSegment]); }, node === null || node === void 0 ? void 0 : node.extensions);
    if (directivesInExtensions === undefined) {
        return undefined;
    }
    if (Array.isArray(directivesInExtensions)) {
        return _getDirectiveInExtensions(directivesInExtensions, directiveName);
    }
    // Support condensed format by converting to longer format
    // The condensed format does not preserve ordering of directives when  repeatable directives are used.
    // See https://github.com/ardatan/graphql-tools/issues/2534
    var reformattedDirectivesInExtensions = [];
    try {
        for (var _c = __values(Object.entries(directivesInExtensions)), _d = _c.next(); !_d.done; _d = _c.next()) {
            var _e = __read(_d.value, 2), name_1 = _e[0], argsOrArrayOfArgs = _e[1];
            if (Array.isArray(argsOrArrayOfArgs)) {
                try {
                    for (var argsOrArrayOfArgs_1 = (e_2 = void 0, __values(argsOrArrayOfArgs)), argsOrArrayOfArgs_1_1 = argsOrArrayOfArgs_1.next(); !argsOrArrayOfArgs_1_1.done; argsOrArrayOfArgs_1_1 = argsOrArrayOfArgs_1.next()) {
                        var args = argsOrArrayOfArgs_1_1.value;
                        reformattedDirectivesInExtensions.push({ name: name_1, args: args });
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (argsOrArrayOfArgs_1_1 && !argsOrArrayOfArgs_1_1.done && (_b = argsOrArrayOfArgs_1.return)) _b.call(argsOrArrayOfArgs_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
            else {
                reformattedDirectivesInExtensions.push({ name: name_1, args: argsOrArrayOfArgs });
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return _getDirectiveInExtensions(reformattedDirectivesInExtensions, directiveName);
}
function getDirectives(schema, node, pathToDirectivesInExtensions) {
    var e_3, _a, e_4, _b;
    if (pathToDirectivesInExtensions === void 0) { pathToDirectivesInExtensions = ['directives']; }
    var directivesInExtensions = getDirectivesInExtensions(node, pathToDirectivesInExtensions);
    if (directivesInExtensions != null && directivesInExtensions.length > 0) {
        return directivesInExtensions;
    }
    var schemaDirectives = schema && schema.getDirectives ? schema.getDirectives() : [];
    var schemaDirectiveMap = schemaDirectives.reduce(function (schemaDirectiveMap, schemaDirective) {
        schemaDirectiveMap[schemaDirective.name] = schemaDirective;
        return schemaDirectiveMap;
    }, {});
    var astNodes = [];
    if (node.astNode) {
        astNodes.push(node.astNode);
    }
    if ('extensionASTNodes' in node && node.extensionASTNodes) {
        astNodes = __spreadArray(__spreadArray([], __read(astNodes), false), __read(node.extensionASTNodes), false);
    }
    var result = [];
    try {
        for (var astNodes_1 = __values(astNodes), astNodes_1_1 = astNodes_1.next(); !astNodes_1_1.done; astNodes_1_1 = astNodes_1.next()) {
            var astNode = astNodes_1_1.value;
            if (astNode.directives) {
                try {
                    for (var _c = (e_4 = void 0, __values(astNode.directives)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var directiveNode = _d.value;
                        var schemaDirective = schemaDirectiveMap[directiveNode.name.value];
                        if (schemaDirective) {
                            result.push({ name: directiveNode.name.value, args: getArgumentValues(schemaDirective, directiveNode) });
                        }
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (astNodes_1_1 && !astNodes_1_1.done && (_a = astNodes_1.return)) _a.call(astNodes_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return result;
}
function getDirective(schema, node, directiveName, pathToDirectivesInExtensions) {
    var e_5, _a, e_6, _b;
    if (pathToDirectivesInExtensions === void 0) { pathToDirectivesInExtensions = ['directives']; }
    var directiveInExtensions = getDirectiveInExtensions(node, directiveName, pathToDirectivesInExtensions);
    if (directiveInExtensions != null) {
        return directiveInExtensions;
    }
    var schemaDirective = schema && schema.getDirective ? schema.getDirective(directiveName) : undefined;
    if (schemaDirective == null) {
        return undefined;
    }
    var astNodes = [];
    if (node.astNode) {
        astNodes.push(node.astNode);
    }
    if ('extensionASTNodes' in node && node.extensionASTNodes) {
        astNodes = __spreadArray(__spreadArray([], __read(astNodes), false), __read(node.extensionASTNodes), false);
    }
    var result = [];
    try {
        for (var astNodes_2 = __values(astNodes), astNodes_2_1 = astNodes_2.next(); !astNodes_2_1.done; astNodes_2_1 = astNodes_2.next()) {
            var astNode = astNodes_2_1.value;
            if (astNode.directives) {
                try {
                    for (var _c = (e_6 = void 0, __values(astNode.directives)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var directiveNode = _d.value;
                        if (directiveNode.name.value === directiveName) {
                            result.push(getArgumentValues(schemaDirective, directiveNode));
                        }
                    }
                }
                catch (e_6_1) { e_6 = { error: e_6_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                    }
                    finally { if (e_6) throw e_6.error; }
                }
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (astNodes_2_1 && !astNodes_2_1.done && (_a = astNodes_2.return)) _a.call(astNodes_2);
        }
        finally { if (e_5) throw e_5.error; }
    }
    if (!result.length) {
        return undefined;
    }
    return result;
}

function parseDirectiveValue(value) {
    switch (value.kind) {
        case Kind.INT:
            return parseInt(value.value);
        case Kind.FLOAT:
            return parseFloat(value.value);
        case Kind.BOOLEAN:
            return Boolean(value.value);
        case Kind.STRING:
        case Kind.ENUM:
            return value.value;
        case Kind.LIST:
            return value.values.map(function (v) { return parseDirectiveValue(v); });
        case Kind.OBJECT:
            return value.fields.reduce(function (prev, v) {
                var _a;
                return (__assign(__assign({}, prev), (_a = {}, _a[v.name.value] = parseDirectiveValue(v.value), _a)));
            }, {});
        case Kind.NULL:
            return null;
        default:
            return null;
    }
}
function getFieldsWithDirectives(documentNode, options) {
    var e_1, _a, e_2, _b;
    if (options === void 0) { options = {}; }
    var result = {};
    var selected = ['ObjectTypeDefinition', 'ObjectTypeExtension'];
    if (options.includeInputTypes) {
        selected = __spreadArray(__spreadArray([], __read(selected), false), ['InputObjectTypeDefinition', 'InputObjectTypeExtension'], false);
    }
    var allTypes = documentNode.definitions.filter(function (obj) { return selected.includes(obj.kind); });
    try {
        for (var allTypes_1 = __values(allTypes), allTypes_1_1 = allTypes_1.next(); !allTypes_1_1.done; allTypes_1_1 = allTypes_1.next()) {
            var type = allTypes_1_1.value;
            var typeName = type.name.value;
            if (type.fields == null) {
                continue;
            }
            try {
                for (var _c = (e_2 = void 0, __values(type.fields)), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var field = _d.value;
                    if (field.directives && field.directives.length > 0) {
                        var fieldName = field.name.value;
                        var key = typeName + "." + fieldName;
                        var directives = field.directives.map(function (d) { return ({
                            name: d.name.value,
                            args: (d.arguments || []).reduce(function (prev, arg) {
                                var _a;
                                return (__assign(__assign({}, prev), (_a = {}, _a[arg.name.value] = parseDirectiveValue(arg.value), _a)));
                            }, {}),
                        }); });
                        result[key] = directives;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (allTypes_1_1 && !allTypes_1_1.done && (_a = allTypes_1.return)) _a.call(allTypes_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}

function getImplementingTypes(interfaceName, schema) {
    var allTypesMap = schema.getTypeMap();
    var result = [];
    for (var graphqlTypeName in allTypesMap) {
        var graphqlType = allTypesMap[graphqlTypeName];
        if (isObjectType(graphqlType)) {
            var allInterfaces = graphqlType.getInterfaces();
            if (allInterfaces.find(function (int) { return int.name === interfaceName; })) {
                result.push(graphqlType.name);
            }
        }
    }
    return result;
}

function astFromType(type) {
    if (isNonNullType(type)) {
        var innerType = astFromType(type.ofType);
        if (innerType.kind === Kind.NON_NULL_TYPE) {
            throw new Error("Invalid type node " + inspect(type) + ". Inner type of non-null type cannot be a non-null type.");
        }
        return {
            kind: Kind.NON_NULL_TYPE,
            type: innerType,
        };
    }
    else if (isListType(type)) {
        return {
            kind: Kind.LIST_TYPE,
            type: astFromType(type.ofType),
        };
    }
    return {
        kind: Kind.NAMED_TYPE,
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
    };
}

/**
 * Produces a GraphQL Value AST given a JavaScript object.
 * Function will match JavaScript/JSON values to GraphQL AST schema format
 * by using the following mapping.
 *
 * | JSON Value    | GraphQL Value        |
 * | ------------- | -------------------- |
 * | Object        | Input Object         |
 * | Array         | List                 |
 * | Boolean       | Boolean              |
 * | String        | String               |
 * | Number        | Int / Float          |
 * | null          | NullValue            |
 *
 */
function astFromValueUntyped(value) {
    var e_1, _a;
    // only explicit null, not undefined, NaN
    if (value === null) {
        return { kind: Kind.NULL };
    }
    // undefined
    if (value === undefined) {
        return null;
    }
    // Convert JavaScript array to GraphQL list. If the GraphQLType is a list, but
    // the value is not an array, convert the value using the list's item type.
    if (Array.isArray(value)) {
        var valuesNodes = [];
        try {
            for (var value_1 = __values(value), value_1_1 = value_1.next(); !value_1_1.done; value_1_1 = value_1.next()) {
                var item = value_1_1.value;
                var itemNode = astFromValueUntyped(item);
                if (itemNode != null) {
                    valuesNodes.push(itemNode);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (value_1_1 && !value_1_1.done && (_a = value_1.return)) _a.call(value_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return { kind: Kind.LIST, values: valuesNodes };
    }
    if (typeof value === 'object') {
        var fieldNodes = [];
        for (var fieldName in value) {
            var fieldValue = value[fieldName];
            var ast = astFromValueUntyped(fieldValue);
            if (ast) {
                fieldNodes.push({
                    kind: Kind.OBJECT_FIELD,
                    name: { kind: Kind.NAME, value: fieldName },
                    value: ast,
                });
            }
        }
        return { kind: Kind.OBJECT, fields: fieldNodes };
    }
    // Others serialize based on their corresponding JavaScript scalar types.
    if (typeof value === 'boolean') {
        return { kind: Kind.BOOLEAN, value: value };
    }
    // JavaScript numbers can be Int or Float values.
    if (typeof value === 'number' && isFinite(value)) {
        var stringNum = String(value);
        return integerStringRegExp.test(stringNum)
            ? { kind: Kind.INT, value: stringNum }
            : { kind: Kind.FLOAT, value: stringNum };
    }
    if (typeof value === 'string') {
        return { kind: Kind.STRING, value: value };
    }
    throw new TypeError("Cannot convert value to AST: " + value + ".");
}
/**
 * IntValue:
 *   - NegativeSign? 0
 *   - NegativeSign? NonZeroDigit ( Digit+ )?
 */
var integerStringRegExp = /^-?(?:0|[1-9][0-9]*)$/;

function memoize1(fn) {
    var memoize1cache = new WeakMap();
    return function memoized(a1) {
        var cachedValue = memoize1cache.get(a1);
        if (cachedValue === undefined) {
            var newValue = fn(a1);
            memoize1cache.set(a1, newValue);
            return newValue;
        }
        return cachedValue;
    };
}
function memoize2(fn) {
    var memoize2cache = new WeakMap();
    return function memoized(a1, a2) {
        var cache2 = memoize2cache.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            memoize2cache.set(a1, cache2);
            var newValue = fn(a1, a2);
            cache2.set(a2, newValue);
            return newValue;
        }
        var cachedValue = cache2.get(a2);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2);
            cache2.set(a2, newValue);
            return newValue;
        }
        return cachedValue;
    };
}
function memoize3(fn) {
    var memoize3Cache = new WeakMap();
    return function memoized(a1, a2, a3) {
        var cache2 = memoize3Cache.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            memoize3Cache.set(a1, cache2);
            var cache3_1 = new WeakMap();
            cache2.set(a2, cache3_1);
            var newValue = fn(a1, a2, a3);
            cache3_1.set(a3, newValue);
            return newValue;
        }
        var cache3 = cache2.get(a2);
        if (!cache3) {
            cache3 = new WeakMap();
            cache2.set(a2, cache3);
            var newValue = fn(a1, a2, a3);
            cache3.set(a3, newValue);
            return newValue;
        }
        var cachedValue = cache3.get(a3);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3);
            cache3.set(a3, newValue);
            return newValue;
        }
        return cachedValue;
    };
}
function memoize4(fn) {
    var memoize4Cache = new WeakMap();
    return function memoized(a1, a2, a3, a4) {
        var cache2 = memoize4Cache.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            memoize4Cache.set(a1, cache2);
            var cache3_2 = new WeakMap();
            cache2.set(a2, cache3_2);
            var cache4_1 = new WeakMap();
            cache3_2.set(a3, cache4_1);
            var newValue = fn(a1, a2, a3, a4);
            cache4_1.set(a4, newValue);
            return newValue;
        }
        var cache3 = cache2.get(a2);
        if (!cache3) {
            cache3 = new WeakMap();
            cache2.set(a2, cache3);
            var cache4_2 = new WeakMap();
            cache3.set(a3, cache4_2);
            var newValue = fn(a1, a2, a3, a4);
            cache4_2.set(a4, newValue);
            return newValue;
        }
        var cache4 = cache3.get(a3);
        if (!cache4) {
            var cache4_3 = new WeakMap();
            cache3.set(a3, cache4_3);
            var newValue = fn(a1, a2, a3, a4);
            cache4_3.set(a4, newValue);
            return newValue;
        }
        var cachedValue = cache4.get(a4);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3, a4);
            cache4.set(a4, newValue);
            return newValue;
        }
        return cachedValue;
    };
}
function memoize5(fn) {
    var memoize5Cache = new WeakMap();
    return function memoized(a1, a2, a3, a4, a5) {
        var cache2 = memoize5Cache.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            memoize5Cache.set(a1, cache2);
            var cache3_3 = new WeakMap();
            cache2.set(a2, cache3_3);
            var cache4_4 = new WeakMap();
            cache3_3.set(a3, cache4_4);
            var cache5_1 = new WeakMap();
            cache4_4.set(a4, cache5_1);
            var newValue = fn(a1, a2, a3, a4, a5);
            cache5_1.set(a5, newValue);
            return newValue;
        }
        var cache3 = cache2.get(a2);
        if (!cache3) {
            cache3 = new WeakMap();
            cache2.set(a2, cache3);
            var cache4_5 = new WeakMap();
            cache3.set(a3, cache4_5);
            var cache5_2 = new WeakMap();
            cache4_5.set(a4, cache5_2);
            var newValue = fn(a1, a2, a3, a4, a5);
            cache5_2.set(a5, newValue);
            return newValue;
        }
        var cache4 = cache3.get(a3);
        if (!cache4) {
            cache4 = new WeakMap();
            cache3.set(a3, cache4);
            var cache5_3 = new WeakMap();
            cache4.set(a4, cache5_3);
            var newValue = fn(a1, a2, a3, a4, a5);
            cache5_3.set(a5, newValue);
            return newValue;
        }
        var cache5 = cache4.get(a4);
        if (!cache5) {
            cache5 = new WeakMap();
            cache4.set(a4, cache5);
            var newValue = fn(a1, a2, a3, a4, a5);
            cache5.set(a5, newValue);
            return newValue;
        }
        var cachedValue = cache5.get(a5);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3, a4, a5);
            cache5.set(a5, newValue);
            return newValue;
        }
        return cachedValue;
    };
}
var memoize2of4cache = new WeakMap();
function memoize2of4(fn) {
    return function memoized(a1, a2, a3, a4) {
        var cache2 = memoize2of4cache.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            memoize2of4cache.set(a1, cache2);
            var newValue = fn(a1, a2, a3, a4);
            cache2.set(a2, newValue);
            return newValue;
        }
        var cachedValue = cache2.get(a2);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3, a4);
            cache2.set(a2, newValue);
            return newValue;
        }
        return cachedValue;
    };
}

function getDefinedRootType(schema, operation) {
    var rootTypeMap = getRootTypeMap(schema);
    var rootType = rootTypeMap.get(operation);
    if (rootType == null) {
        throw new Error("Root type for operation \"" + operation + "\" not defined by the given schema.");
    }
    return rootType;
}
var getRootTypeNames = memoize1(function getRootTypeNames(schema) {
    var rootTypes = getRootTypes(schema);
    return new Set(__spreadArray([], __read(rootTypes), false).map(function (type) { return type.name; }));
});
var getRootTypes = memoize1(function getRootTypes(schema) {
    var rootTypeMap = getRootTypeMap(schema);
    return new Set(rootTypeMap.values());
});
var getRootTypeMap = memoize1(function getRootTypeMap(schema) {
    var rootTypeMap = new Map();
    var queryType = schema.getQueryType();
    if (queryType) {
        rootTypeMap.set('query', queryType);
    }
    var mutationType = schema.getMutationType();
    if (mutationType) {
        rootTypeMap.set('mutation', mutationType);
    }
    var subscriptionType = schema.getSubscriptionType();
    if (subscriptionType) {
        rootTypeMap.set('subscription', subscriptionType);
    }
    return rootTypeMap;
});

function getDocumentNodeFromSchema(schema, options) {
    var e_1, _a;
    if (options === void 0) { options = {}; }
    var pathToDirectivesInExtensions = options.pathToDirectivesInExtensions;
    var typesMap = schema.getTypeMap();
    var schemaNode = astFromSchema(schema, pathToDirectivesInExtensions);
    var definitions = schemaNode != null ? [schemaNode] : [];
    var directives = schema.getDirectives();
    try {
        for (var directives_1 = __values(directives), directives_1_1 = directives_1.next(); !directives_1_1.done; directives_1_1 = directives_1.next()) {
            var directive = directives_1_1.value;
            if (isSpecifiedDirective(directive)) {
                continue;
            }
            definitions.push(astFromDirective(directive, schema, pathToDirectivesInExtensions));
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (directives_1_1 && !directives_1_1.done && (_a = directives_1.return)) _a.call(directives_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    for (var typeName in typesMap) {
        var type = typesMap[typeName];
        var isPredefinedScalar = isSpecifiedScalarType(type);
        var isIntrospection = isIntrospectionType(type);
        if (isPredefinedScalar || isIntrospection) {
            continue;
        }
        if (isObjectType(type)) {
            definitions.push(astFromObjectType(type, schema, pathToDirectivesInExtensions));
        }
        else if (isInterfaceType(type)) {
            definitions.push(astFromInterfaceType(type, schema, pathToDirectivesInExtensions));
        }
        else if (isUnionType(type)) {
            definitions.push(astFromUnionType(type, schema, pathToDirectivesInExtensions));
        }
        else if (isInputObjectType(type)) {
            definitions.push(astFromInputObjectType(type, schema, pathToDirectivesInExtensions));
        }
        else if (isEnumType(type)) {
            definitions.push(astFromEnumType(type, schema, pathToDirectivesInExtensions));
        }
        else if (isScalarType(type)) {
            definitions.push(astFromScalarType(type, schema, pathToDirectivesInExtensions));
        }
        else {
            throw new Error("Unknown type " + type + ".");
        }
    }
    return {
        kind: Kind.DOCUMENT,
        definitions: definitions,
    };
}
// this approach uses the default schema printer rather than a custom solution, so may be more backwards compatible
// currently does not allow customization of printSchema options having to do with comments.
function printSchemaWithDirectives(schema, options) {
    if (options === void 0) { options = {}; }
    var documentNode = getDocumentNodeFromSchema(schema, options);
    return print(documentNode);
}
function astFromSchema(schema, pathToDirectivesInExtensions) {
    var e_2, _a, e_3, _b, e_4, _c, e_5, _d;
    var _e, _f;
    var operationTypeMap = new Map([
        ['query', undefined],
        ['mutation', undefined],
        ['subscription', undefined],
    ]);
    var nodes = [];
    if (schema.astNode != null) {
        nodes.push(schema.astNode);
    }
    if (schema.extensionASTNodes != null) {
        try {
            for (var _g = __values(schema.extensionASTNodes), _h = _g.next(); !_h.done; _h = _g.next()) {
                var extensionASTNode = _h.value;
                nodes.push(extensionASTNode);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_h && !_h.done && (_a = _g.return)) _a.call(_g);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    try {
        for (var nodes_1 = __values(nodes), nodes_1_1 = nodes_1.next(); !nodes_1_1.done; nodes_1_1 = nodes_1.next()) {
            var node = nodes_1_1.value;
            if (node.operationTypes) {
                try {
                    for (var _j = (e_4 = void 0, __values(node.operationTypes)), _k = _j.next(); !_k.done; _k = _j.next()) {
                        var operationTypeDefinitionNode = _k.value;
                        operationTypeMap.set(operationTypeDefinitionNode.operation, operationTypeDefinitionNode);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (nodes_1_1 && !nodes_1_1.done && (_b = nodes_1.return)) _b.call(nodes_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    var rootTypeMap = getRootTypeMap(schema);
    try {
        for (var operationTypeMap_1 = __values(operationTypeMap), operationTypeMap_1_1 = operationTypeMap_1.next(); !operationTypeMap_1_1.done; operationTypeMap_1_1 = operationTypeMap_1.next()) {
            var _l = __read(operationTypeMap_1_1.value, 2), operationTypeNode = _l[0], operationTypeDefinitionNode = _l[1];
            var rootType = rootTypeMap.get(operationTypeNode);
            if (rootType != null) {
                var rootTypeAST = astFromType(rootType);
                if (operationTypeDefinitionNode != null) {
                    operationTypeDefinitionNode.type = rootTypeAST;
                }
                else {
                    operationTypeMap.set(operationTypeNode, {
                        kind: Kind.OPERATION_TYPE_DEFINITION,
                        operation: operationTypeNode,
                        type: rootTypeAST,
                    });
                }
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (operationTypeMap_1_1 && !operationTypeMap_1_1.done && (_d = operationTypeMap_1.return)) _d.call(operationTypeMap_1);
        }
        finally { if (e_5) throw e_5.error; }
    }
    var operationTypes = __spreadArray([], __read(operationTypeMap.values()), false).filter(isSome);
    var directives = getDirectiveNodes(schema, schema, pathToDirectivesInExtensions);
    if (!operationTypes.length && !directives.length) {
        return null;
    }
    var schemaNode = {
        kind: operationTypes != null ? Kind.SCHEMA_DEFINITION : Kind.SCHEMA_EXTENSION,
        operationTypes: operationTypes,
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: directives,
    };
    // This code is so weird because it needs to support GraphQL.js 14
    // In GraphQL.js 14 there is no `description` value on schemaNode
    schemaNode.description =
        ((_f = (_e = schema.astNode) === null || _e === void 0 ? void 0 : _e.description) !== null && _f !== void 0 ? _f : schema.description != null)
            ? {
                kind: Kind.STRING,
                value: schema.description,
                block: true,
            }
            : undefined;
    return schemaNode;
}
function astFromDirective(directive, schema, pathToDirectivesInExtensions) {
    var _a, _b, _c, _d;
    return {
        kind: Kind.DIRECTIVE_DEFINITION,
        description: (_b = (_a = directive.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (directive.description
            ? {
                kind: Kind.STRING,
                value: directive.description,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: directive.name,
        },
        arguments: (_c = directive.args) === null || _c === void 0 ? void 0 : _c.map(function (arg) { return astFromArg(arg, schema, pathToDirectivesInExtensions); }),
        repeatable: directive.isRepeatable,
        locations: ((_d = directive.locations) === null || _d === void 0 ? void 0 : _d.map(function (location) { return ({
            kind: Kind.NAME,
            value: location,
        }); })) || [],
    };
}
function getDirectiveNodes(entity, schema, pathToDirectivesInExtensions) {
    var e_6, _a;
    var directivesInExtensions = getDirectivesInExtensions(entity, pathToDirectivesInExtensions);
    var nodes = [];
    if (entity.astNode != null) {
        nodes.push(entity.astNode);
    }
    if ('extensionASTNodes' in entity && entity.extensionASTNodes != null) {
        nodes = nodes.concat(entity.extensionASTNodes);
    }
    var directives;
    if (directivesInExtensions != null) {
        directives = makeDirectiveNodes(schema, directivesInExtensions);
    }
    else {
        directives = [];
        try {
            for (var nodes_2 = __values(nodes), nodes_2_1 = nodes_2.next(); !nodes_2_1.done; nodes_2_1 = nodes_2.next()) {
                var node = nodes_2_1.value;
                if (node.directives) {
                    directives.push.apply(directives, __spreadArray([], __read(node.directives), false));
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (nodes_2_1 && !nodes_2_1.done && (_a = nodes_2.return)) _a.call(nodes_2);
            }
            finally { if (e_6) throw e_6.error; }
        }
    }
    return directives;
}
function getDeprecatableDirectiveNodes(entity, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    var directiveNodesBesidesDeprecated = [];
    var deprecatedDirectiveNode = null;
    var directivesInExtensions = getDirectivesInExtensions(entity, pathToDirectivesInExtensions);
    var directives;
    if (directivesInExtensions != null) {
        directives = makeDirectiveNodes(schema, directivesInExtensions);
    }
    else {
        directives = (_a = entity.astNode) === null || _a === void 0 ? void 0 : _a.directives;
    }
    if (directives != null) {
        directiveNodesBesidesDeprecated = directives.filter(function (directive) { return directive.name.value !== 'deprecated'; });
        if (entity.deprecationReason != null) {
            deprecatedDirectiveNode = (_b = directives.filter(function (directive) { return directive.name.value === 'deprecated'; })) === null || _b === void 0 ? void 0 : _b[0];
        }
    }
    if (entity.deprecationReason != null &&
        deprecatedDirectiveNode == null) {
        deprecatedDirectiveNode = makeDeprecatedDirective(entity.deprecationReason);
    }
    return deprecatedDirectiveNode == null
        ? directiveNodesBesidesDeprecated
        : [deprecatedDirectiveNode].concat(directiveNodesBesidesDeprecated);
}
function astFromArg(arg, schema, pathToDirectivesInExtensions) {
    var _a, _b, _c;
    return {
        kind: Kind.INPUT_VALUE_DEFINITION,
        description: (_b = (_a = arg.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (arg.description
            ? {
                kind: Kind.STRING,
                value: arg.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: arg.name,
        },
        type: astFromType(arg.type),
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        defaultValue: arg.defaultValue !== undefined ? (_c = astFromValue(arg.defaultValue, arg.type)) !== null && _c !== void 0 ? _c : undefined : undefined,
        directives: getDeprecatableDirectiveNodes(arg, schema, pathToDirectivesInExtensions),
    };
}
function astFromObjectType(type, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    return {
        kind: Kind.OBJECT_TYPE_DEFINITION,
        description: (_b = (_a = type.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (type.description
            ? {
                kind: Kind.STRING,
                value: type.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
        fields: Object.values(type.getFields()).map(function (field) { return astFromField(field, schema, pathToDirectivesInExtensions); }),
        interfaces: Object.values(type.getInterfaces()).map(function (iFace) { return astFromType(iFace); }),
        directives: getDirectiveNodes(type, schema, pathToDirectivesInExtensions),
    };
}
function astFromInterfaceType(type, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    var node = {
        kind: Kind.INTERFACE_TYPE_DEFINITION,
        description: (_b = (_a = type.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (type.description
            ? {
                kind: Kind.STRING,
                value: type.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
        fields: Object.values(type.getFields()).map(function (field) { return astFromField(field, schema, pathToDirectivesInExtensions); }),
        directives: getDirectiveNodes(type, schema, pathToDirectivesInExtensions),
    };
    if ('getInterfaces' in type) {
        node.interfaces = Object.values(type.getInterfaces()).map(function (iFace) { return astFromType(iFace); });
    }
    return node;
}
function astFromUnionType(type, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    return {
        kind: Kind.UNION_TYPE_DEFINITION,
        description: (_b = (_a = type.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (type.description
            ? {
                kind: Kind.STRING,
                value: type.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: getDirectiveNodes(type, schema, pathToDirectivesInExtensions),
        types: type.getTypes().map(function (type) { return astFromType(type); }),
    };
}
function astFromInputObjectType(type, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    return {
        kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
        description: (_b = (_a = type.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (type.description
            ? {
                kind: Kind.STRING,
                value: type.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
        fields: Object.values(type.getFields()).map(function (field) {
            return astFromInputField(field, schema, pathToDirectivesInExtensions);
        }),
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: getDirectiveNodes(type, schema, pathToDirectivesInExtensions),
    };
}
function astFromEnumType(type, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    return {
        kind: Kind.ENUM_TYPE_DEFINITION,
        description: (_b = (_a = type.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (type.description
            ? {
                kind: Kind.STRING,
                value: type.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
        values: Object.values(type.getValues()).map(function (value) { return astFromEnumValue(value, schema, pathToDirectivesInExtensions); }),
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: getDirectiveNodes(type, schema, pathToDirectivesInExtensions),
    };
}
function astFromScalarType(type, schema, pathToDirectivesInExtensions) {
    var _a, _b, _c;
    var directivesInExtensions = getDirectivesInExtensions(type, pathToDirectivesInExtensions);
    var directives = directivesInExtensions
        ? makeDirectiveNodes(schema, directivesInExtensions)
        : ((_a = type.astNode) === null || _a === void 0 ? void 0 : _a.directives) || [];
    if (type['specifiedByUrl'] &&
        !directives.some(function (directiveNode) { return directiveNode.name.value === 'specifiedBy'; })) {
        var specifiedByArgs = {
            url: type['specifiedByUrl'],
        };
        directives.push(makeDirectiveNode('specifiedBy', specifiedByArgs));
    }
    return {
        kind: Kind.SCALAR_TYPE_DEFINITION,
        description: (_c = (_b = type.astNode) === null || _b === void 0 ? void 0 : _b.description) !== null && _c !== void 0 ? _c : (type.description
            ? {
                kind: Kind.STRING,
                value: type.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: type.name,
        },
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: directives,
    };
}
function astFromField(field, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    return {
        kind: Kind.FIELD_DEFINITION,
        description: (_b = (_a = field.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (field.description
            ? {
                kind: Kind.STRING,
                value: field.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: field.name,
        },
        arguments: field.args.map(function (arg) { return astFromArg(arg, schema, pathToDirectivesInExtensions); }),
        type: astFromType(field.type),
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: getDeprecatableDirectiveNodes(field, schema, pathToDirectivesInExtensions),
    };
}
function astFromInputField(field, schema, pathToDirectivesInExtensions) {
    var _a, _b, _c;
    return {
        kind: Kind.INPUT_VALUE_DEFINITION,
        description: (_b = (_a = field.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (field.description
            ? {
                kind: Kind.STRING,
                value: field.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: field.name,
        },
        type: astFromType(field.type),
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: getDeprecatableDirectiveNodes(field, schema, pathToDirectivesInExtensions),
        defaultValue: (_c = astFromValue(field.defaultValue, field.type)) !== null && _c !== void 0 ? _c : undefined,
    };
}
function astFromEnumValue(value, schema, pathToDirectivesInExtensions) {
    var _a, _b;
    return {
        kind: Kind.ENUM_VALUE_DEFINITION,
        description: (_b = (_a = value.astNode) === null || _a === void 0 ? void 0 : _a.description) !== null && _b !== void 0 ? _b : (value.description
            ? {
                kind: Kind.STRING,
                value: value.description,
                block: true,
            }
            : undefined),
        name: {
            kind: Kind.NAME,
            value: value.name,
        },
        // ConstXNode has been introduced in v16 but it is not compatible with XNode so we do `as any` for backwards compatibility
        directives: getDirectiveNodes(value, schema, pathToDirectivesInExtensions),
    };
}
function makeDeprecatedDirective(deprecationReason) {
    return makeDirectiveNode('deprecated', { reason: deprecationReason }, GraphQLDeprecatedDirective);
}
function makeDirectiveNode(name, args, directive) {
    var e_7, _a;
    var directiveArguments = [];
    if (directive != null) {
        try {
            for (var _b = __values(directive.args), _c = _b.next(); !_c.done; _c = _b.next()) {
                var arg = _c.value;
                var argName = arg.name;
                var argValue = args[argName];
                if (argValue !== undefined) {
                    var value = astFromValue(argValue, arg.type);
                    if (value) {
                        directiveArguments.push({
                            kind: Kind.ARGUMENT,
                            name: {
                                kind: Kind.NAME,
                                value: argName,
                            },
                            value: value,
                        });
                    }
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
    }
    else {
        for (var argName in args) {
            var argValue = args[argName];
            var value = astFromValueUntyped(argValue);
            if (value) {
                directiveArguments.push({
                    kind: Kind.ARGUMENT,
                    name: {
                        kind: Kind.NAME,
                        value: argName,
                    },
                    value: value,
                });
            }
        }
    }
    return {
        kind: Kind.DIRECTIVE,
        name: {
            kind: Kind.NAME,
            value: name,
        },
        arguments: directiveArguments,
    };
}
function makeDirectiveNodes(schema, directiveValues) {
    var e_8, _a;
    var directiveNodes = [];
    for (var directiveName in directiveValues) {
        var arrayOrSingleValue = directiveValues[directiveName];
        var directive = schema === null || schema === void 0 ? void 0 : schema.getDirective(directiveName);
        if (Array.isArray(arrayOrSingleValue)) {
            try {
                for (var arrayOrSingleValue_1 = (e_8 = void 0, __values(arrayOrSingleValue)), arrayOrSingleValue_1_1 = arrayOrSingleValue_1.next(); !arrayOrSingleValue_1_1.done; arrayOrSingleValue_1_1 = arrayOrSingleValue_1.next()) {
                    var value = arrayOrSingleValue_1_1.value;
                    directiveNodes.push(makeDirectiveNode(directiveName, value, directive));
                }
            }
            catch (e_8_1) { e_8 = { error: e_8_1 }; }
            finally {
                try {
                    if (arrayOrSingleValue_1_1 && !arrayOrSingleValue_1_1.done && (_a = arrayOrSingleValue_1.return)) _a.call(arrayOrSingleValue_1);
                }
                finally { if (e_8) throw e_8.error; }
            }
        }
        else {
            directiveNodes.push(makeDirectiveNode(directiveName, arrayOrSingleValue, directive));
        }
    }
    return directiveNodes;
}

var AggregateErrorImpl = globalThis.AggregateError;
if (typeof AggregateErrorImpl === 'undefined') {
    var AggregateErrorClass_1 = /** @class */ (function (_super) {
        __extends(AggregateErrorClass, _super);
        function AggregateErrorClass(errors, message) {
            if (message === void 0) { message = ''; }
            var _this = _super.call(this, message) || this;
            _this.errors = errors;
            _this.name = 'AggregateError';
            Error.captureStackTrace(_this, AggregateErrorClass);
            return _this;
        }
        return AggregateErrorClass;
    }(Error));
    AggregateErrorImpl = function (errors, message) {
        return new AggregateErrorClass_1(errors, message);
    };
}

function validateGraphQlDocuments(schema, documentFiles, effectiveRules) {
    return __awaiter(this, void 0, void 0, function () {
        var allFragmentMap, documentFileObjectsToValidate, documentFiles_1, documentFiles_1_1, documentFile, definitionsToValidate, _a, _b, definitionNode, allErrors, allFragmentsDocument;
        var e_1, _c, e_2, _d;
        var _this = this;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    effectiveRules = effectiveRules || createDefaultRules();
                    allFragmentMap = new Map();
                    documentFileObjectsToValidate = [];
                    try {
                        for (documentFiles_1 = __values(documentFiles), documentFiles_1_1 = documentFiles_1.next(); !documentFiles_1_1.done; documentFiles_1_1 = documentFiles_1.next()) {
                            documentFile = documentFiles_1_1.value;
                            if (documentFile.document) {
                                definitionsToValidate = [];
                                try {
                                    for (_a = (e_2 = void 0, __values(documentFile.document.definitions)), _b = _a.next(); !_b.done; _b = _a.next()) {
                                        definitionNode = _b.value;
                                        if (definitionNode.kind === Kind.FRAGMENT_DEFINITION) {
                                            allFragmentMap.set(definitionNode.name.value, definitionNode);
                                        }
                                        else {
                                            definitionsToValidate.push(definitionNode);
                                        }
                                    }
                                }
                                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                                finally {
                                    try {
                                        if (_b && !_b.done && (_d = _a.return)) _d.call(_a);
                                    }
                                    finally { if (e_2) throw e_2.error; }
                                }
                                documentFileObjectsToValidate.push({
                                    location: documentFile.location,
                                    document: {
                                        kind: Kind.DOCUMENT,
                                        definitions: definitionsToValidate,
                                    },
                                });
                            }
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (documentFiles_1_1 && !documentFiles_1_1.done && (_c = documentFiles_1.return)) _c.call(documentFiles_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    allErrors = [];
                    allFragmentsDocument = {
                        kind: Kind.DOCUMENT,
                        definitions: __spreadArray([], __read(allFragmentMap.values()), false),
                    };
                    return [4 /*yield*/, Promise.all(documentFileObjectsToValidate.map(function (documentFile) { return __awaiter(_this, void 0, void 0, function () {
                            var documentToValidate, errors;
                            return __generator(this, function (_a) {
                                documentToValidate = concatAST([allFragmentsDocument, documentFile.document]);
                                errors = validate(schema, documentToValidate, effectiveRules);
                                if (errors.length > 0) {
                                    allErrors.push({
                                        filePath: documentFile.location,
                                        errors: errors,
                                    });
                                }
                                return [2 /*return*/];
                            });
                        }); }))];
                case 1:
                    _e.sent();
                    return [2 /*return*/, allErrors];
            }
        });
    });
}
function checkValidationErrors(loadDocumentErrors) {
    var e_3, _a, e_4, _b, e_5, _c;
    if (loadDocumentErrors.length > 0) {
        var errors = [];
        try {
            for (var loadDocumentErrors_1 = __values(loadDocumentErrors), loadDocumentErrors_1_1 = loadDocumentErrors_1.next(); !loadDocumentErrors_1_1.done; loadDocumentErrors_1_1 = loadDocumentErrors_1.next()) {
                var loadDocumentError = loadDocumentErrors_1_1.value;
                try {
                    for (var _d = (e_4 = void 0, __values(loadDocumentError.errors)), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var graphQLError = _e.value;
                        var error = new Error();
                        error.name = 'GraphQLDocumentError';
                        error.message = error.name + ": " + graphQLError.message;
                        error.stack = error.message;
                        if (graphQLError.locations) {
                            try {
                                for (var _f = (e_5 = void 0, __values(graphQLError.locations)), _g = _f.next(); !_g.done; _g = _f.next()) {
                                    var location_1 = _g.value;
                                    error.stack += "\n    at " + loadDocumentError.filePath + ":" + location_1.line + ":" + location_1.column;
                                }
                            }
                            catch (e_5_1) { e_5 = { error: e_5_1 }; }
                            finally {
                                try {
                                    if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                                }
                                finally { if (e_5) throw e_5.error; }
                            }
                        }
                        errors.push(error);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (loadDocumentErrors_1_1 && !loadDocumentErrors_1_1.done && (_a = loadDocumentErrors_1.return)) _a.call(loadDocumentErrors_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        throw new AggregateErrorImpl(errors, "GraphQL Document Validation failed with " + errors.length + " errors;\n  " + errors.map(function (error, index) { return "Error " + index + ": " + error.stack; }).join('\n\n'));
    }
}
function createDefaultRules() {
    var ignored = ['NoUnusedFragmentsRule', 'NoUnusedVariablesRule', 'KnownDirectivesRule'];
    var v4ignored = ignored.map(function (rule) { return rule.replace(/Rule$/, ''); });
    return specifiedRules.filter(function (f) { return !ignored.includes(f.name) && !v4ignored.includes(f.name); });
}

function stripBOM(content) {
    content = content.toString();
    // Remove byte order marker. This catches EF BB BF (the UTF-8 BOM)
    // because the buffer-to-string conversion in `fs.readFileSync()`
    // translates it to FEFF, the UTF-16 BOM.
    if (content.charCodeAt(0) === 0xfeff) {
        content = content.slice(1);
    }
    return content;
}
function parseBOM(content) {
    return JSON.parse(stripBOM(content));
}
function parseGraphQLJSON(location, jsonContent, options) {
    var parsedJson = parseBOM(jsonContent);
    if (parsedJson.data) {
        parsedJson = parsedJson.data;
    }
    if (parsedJson.kind === 'Document') {
        return {
            location: location,
            document: parsedJson,
        };
    }
    else if (parsedJson.__schema) {
        var schema = buildClientSchema(parsedJson, options);
        return {
            location: location,
            schema: schema,
        };
    }
    else if (typeof parsedJson === 'string') {
        return {
            location: location,
            rawSDL: parsedJson,
        };
    }
    throw new Error("Not valid JSON content");
}

var MAX_LINE_LENGTH = 80;
var commentsRegistry = {};
function resetComments() {
    commentsRegistry = {};
}
function collectComment(node) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d;
    var entityName = (_d = node.name) === null || _d === void 0 ? void 0 : _d.value;
    if (entityName == null) {
        return;
    }
    pushComment(node, entityName);
    switch (node.kind) {
        case 'EnumTypeDefinition':
            if (node.values) {
                try {
                    for (var _e = __values(node.values), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var value = _f.value;
                        pushComment(value, entityName, value.name.value);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            break;
        case 'ObjectTypeDefinition':
        case 'InputObjectTypeDefinition':
        case 'InterfaceTypeDefinition':
            if (node.fields) {
                try {
                    for (var _g = __values(node.fields), _h = _g.next(); !_h.done; _h = _g.next()) {
                        var field = _h.value;
                        pushComment(field, entityName, field.name.value);
                        if (isFieldDefinitionNode(field) && field.arguments) {
                            try {
                                for (var _j = (e_3 = void 0, __values(field.arguments)), _k = _j.next(); !_k.done; _k = _j.next()) {
                                    var arg = _k.value;
                                    pushComment(arg, entityName, field.name.value, arg.name.value);
                                }
                            }
                            catch (e_3_1) { e_3 = { error: e_3_1 }; }
                            finally {
                                try {
                                    if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
                                }
                                finally { if (e_3) throw e_3.error; }
                            }
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
            break;
    }
}
function pushComment(node, entity, field, argument) {
    var comment = getComment(node);
    if (typeof comment !== 'string' || comment.length === 0) {
        return;
    }
    var keys = [entity];
    if (field) {
        keys.push(field);
        if (argument) {
            keys.push(argument);
        }
    }
    var path = keys.join('.');
    if (!commentsRegistry[path]) {
        commentsRegistry[path] = [];
    }
    commentsRegistry[path].push(comment);
}
function printComment(comment) {
    return '\n# ' + comment.replace(/\n/g, '\n# ');
}
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * NOTE: ==> This file has been modified just to add comments to the printed AST
 * This is a temp measure, we will move to using the original non modified printer.js ASAP.
 */
/**
 * Given maybeArray, print an empty string if it is null or empty, otherwise
 * print all items together separated by separator if provided
 */
function join(maybeArray, separator) {
    return maybeArray ? maybeArray.filter(function (x) { return x; }).join(separator || '') : '';
}
function hasMultilineItems(maybeArray) {
    var _a;
    return (_a = maybeArray === null || maybeArray === void 0 ? void 0 : maybeArray.some(function (str) { return str.includes('\n'); })) !== null && _a !== void 0 ? _a : false;
}
function addDescription(cb) {
    return function (node, _key, _parent, path, ancestors) {
        var _a;
        var keys = [];
        var parent = path.reduce(function (prev, key) {
            if (['fields', 'arguments', 'values'].includes(key) && prev.name) {
                keys.push(prev.name.value);
            }
            return prev[key];
        }, ancestors[0]);
        var key = __spreadArray(__spreadArray([], __read(keys), false), [(_a = parent === null || parent === void 0 ? void 0 : parent.name) === null || _a === void 0 ? void 0 : _a.value], false).filter(Boolean).join('.');
        var items = [];
        if (node.kind.includes('Definition') && commentsRegistry[key]) {
            items.push.apply(items, __spreadArray([], __read(commentsRegistry[key]), false));
        }
        return join(__spreadArray(__spreadArray([], __read(items.map(printComment)), false), [node.description, cb(node, _key, _parent, path, ancestors)], false), '\n');
    };
}
function indent(maybeString) {
    return maybeString && "  " + maybeString.replace(/\n/g, '\n  ');
}
/**
 * Given array, print each item on its own line, wrapped in an
 * indented "{ }" block.
 */
function block(array) {
    return array && array.length !== 0 ? "{\n" + indent(join(array, '\n')) + "\n}" : '';
}
/**
 * If maybeString is not null or empty, then wrap with start and end, otherwise
 * print an empty string.
 */
function wrap(start, maybeString, end) {
    return maybeString ? start + maybeString + (end || '') : '';
}
/**
 * Print a block string in the indented block form by adding a leading and
 * trailing blank line. However, if a block string starts with whitespace and is
 * a single-line, adding a leading blank line would strip that whitespace.
 */
function printBlockString(value, isDescription) {
    if (isDescription === void 0) { isDescription = false; }
    var escaped = value.replace(/"""/g, '\\"""');
    return (value[0] === ' ' || value[0] === '\t') && value.indexOf('\n') === -1
        ? "\"\"\"" + escaped.replace(/"$/, '"\n') + "\"\"\""
        : "\"\"\"\n" + (isDescription ? escaped : indent(escaped)) + "\n\"\"\"";
}
var printDocASTReducer = {
    Name: { leave: function (node) { return node.value; } },
    Variable: { leave: function (node) { return '$' + node.name; } },
    // Document
    Document: {
        leave: function (node) { return join(node.definitions, '\n\n'); },
    },
    OperationDefinition: {
        leave: function (node) {
            var varDefs = wrap('(', join(node.variableDefinitions, ', '), ')');
            var prefix = join([node.operation, join([node.name, varDefs]), join(node.directives, ' ')], ' ');
            // the query short form.
            return prefix + ' ' + node.selectionSet;
        },
    },
    VariableDefinition: {
        leave: function (_a) {
            var variable = _a.variable, type = _a.type, defaultValue = _a.defaultValue, directives = _a.directives;
            return variable + ': ' + type + wrap(' = ', defaultValue) + wrap(' ', join(directives, ' '));
        },
    },
    SelectionSet: { leave: function (_a) {
            var selections = _a.selections;
            return block(selections);
        } },
    Field: {
        leave: function (_a) {
            var alias = _a.alias, name = _a.name, args = _a.arguments, directives = _a.directives, selectionSet = _a.selectionSet;
            var prefix = wrap('', alias, ': ') + name;
            var argsLine = prefix + wrap('(', join(args, ', '), ')');
            if (argsLine.length > MAX_LINE_LENGTH) {
                argsLine = prefix + wrap('(\n', indent(join(args, '\n')), '\n)');
            }
            return join([argsLine, join(directives, ' '), selectionSet], ' ');
        },
    },
    Argument: { leave: function (_a) {
            var name = _a.name, value = _a.value;
            return name + ': ' + value;
        } },
    // Fragments
    FragmentSpread: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives;
            return '...' + name + wrap(' ', join(directives, ' '));
        },
    },
    InlineFragment: {
        leave: function (_a) {
            var typeCondition = _a.typeCondition, directives = _a.directives, selectionSet = _a.selectionSet;
            return join(['...', wrap('on ', typeCondition), join(directives, ' '), selectionSet], ' ');
        },
    },
    FragmentDefinition: {
        leave: function (_a) {
            var name = _a.name, typeCondition = _a.typeCondition, variableDefinitions = _a.variableDefinitions, directives = _a.directives, selectionSet = _a.selectionSet;
            // Note: fragment variable definitions are experimental and may be changed
            // or removed in the future.
            return "fragment " + name + wrap('(', join(variableDefinitions, ', '), ')') + " " +
                ("on " + typeCondition + " " + wrap('', join(directives, ' '), ' ')) +
                selectionSet;
        },
    },
    // Value
    IntValue: { leave: function (_a) {
            var value = _a.value;
            return value;
        } },
    FloatValue: { leave: function (_a) {
            var value = _a.value;
            return value;
        } },
    StringValue: {
        leave: function (_a) {
            var value = _a.value, isBlockString = _a.block;
            if (isBlockString) {
                return printBlockString(value);
            }
            return JSON.stringify(value);
        },
    },
    BooleanValue: { leave: function (_a) {
            var value = _a.value;
            return (value ? 'true' : 'false');
        } },
    NullValue: { leave: function () { return 'null'; } },
    EnumValue: { leave: function (_a) {
            var value = _a.value;
            return value;
        } },
    ListValue: { leave: function (_a) {
            var values = _a.values;
            return '[' + join(values, ', ') + ']';
        } },
    ObjectValue: { leave: function (_a) {
            var fields = _a.fields;
            return '{' + join(fields, ', ') + '}';
        } },
    ObjectField: { leave: function (_a) {
            var name = _a.name, value = _a.value;
            return name + ': ' + value;
        } },
    // Directive
    Directive: {
        leave: function (_a) {
            var name = _a.name, args = _a.arguments;
            return '@' + name + wrap('(', join(args, ', '), ')');
        },
    },
    // Type
    NamedType: { leave: function (_a) {
            var name = _a.name;
            return name;
        } },
    ListType: { leave: function (_a) {
            var type = _a.type;
            return '[' + type + ']';
        } },
    NonNullType: { leave: function (_a) {
            var type = _a.type;
            return type + '!';
        } },
    // Type System Definitions
    SchemaDefinition: {
        leave: function (_a) {
            var directives = _a.directives, operationTypes = _a.operationTypes;
            return join(['schema', join(directives, ' '), block(operationTypes)], ' ');
        },
    },
    OperationTypeDefinition: {
        leave: function (_a) {
            var operation = _a.operation, type = _a.type;
            return operation + ': ' + type;
        },
    },
    ScalarTypeDefinition: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives;
            return join(['scalar', name, join(directives, ' ')], ' ');
        },
    },
    ObjectTypeDefinition: {
        leave: function (_a) {
            var name = _a.name, interfaces = _a.interfaces, directives = _a.directives, fields = _a.fields;
            return join(['type', name, wrap('implements ', join(interfaces, ' & ')), join(directives, ' '), block(fields)], ' ');
        },
    },
    FieldDefinition: {
        leave: function (_a) {
            var name = _a.name, args = _a.arguments, type = _a.type, directives = _a.directives;
            return name +
                (hasMultilineItems(args)
                    ? wrap('(\n', indent(join(args, '\n')), '\n)')
                    : wrap('(', join(args, ', '), ')')) +
                ': ' +
                type +
                wrap(' ', join(directives, ' '));
        },
    },
    InputValueDefinition: {
        leave: function (_a) {
            var name = _a.name, type = _a.type, defaultValue = _a.defaultValue, directives = _a.directives;
            return join([name + ': ' + type, wrap('= ', defaultValue), join(directives, ' ')], ' ');
        },
    },
    InterfaceTypeDefinition: {
        leave: function (_a) {
            var name = _a.name, interfaces = _a.interfaces, directives = _a.directives, fields = _a.fields;
            return join(['interface', name, wrap('implements ', join(interfaces, ' & ')), join(directives, ' '), block(fields)], ' ');
        },
    },
    UnionTypeDefinition: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives, types = _a.types;
            return join(['union', name, join(directives, ' '), wrap('= ', join(types, ' | '))], ' ');
        },
    },
    EnumTypeDefinition: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives, values = _a.values;
            return join(['enum', name, join(directives, ' '), block(values)], ' ');
        },
    },
    EnumValueDefinition: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives;
            return join([name, join(directives, ' ')], ' ');
        },
    },
    InputObjectTypeDefinition: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives, fields = _a.fields;
            return join(['input', name, join(directives, ' '), block(fields)], ' ');
        },
    },
    DirectiveDefinition: {
        leave: function (_a) {
            var name = _a.name, args = _a.arguments, repeatable = _a.repeatable, locations = _a.locations;
            return 'directive @' +
                name +
                (hasMultilineItems(args)
                    ? wrap('(\n', indent(join(args, '\n')), '\n)')
                    : wrap('(', join(args, ', '), ')')) +
                (repeatable ? ' repeatable' : '') +
                ' on ' +
                join(locations, ' | ');
        },
    },
    SchemaExtension: {
        leave: function (_a) {
            var directives = _a.directives, operationTypes = _a.operationTypes;
            return join(['extend schema', join(directives, ' '), block(operationTypes)], ' ');
        },
    },
    ScalarTypeExtension: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives;
            return join(['extend scalar', name, join(directives, ' ')], ' ');
        },
    },
    ObjectTypeExtension: {
        leave: function (_a) {
            var name = _a.name, interfaces = _a.interfaces, directives = _a.directives, fields = _a.fields;
            return join(['extend type', name, wrap('implements ', join(interfaces, ' & ')), join(directives, ' '), block(fields)], ' ');
        },
    },
    InterfaceTypeExtension: {
        leave: function (_a) {
            var name = _a.name, interfaces = _a.interfaces, directives = _a.directives, fields = _a.fields;
            return join(['extend interface', name, wrap('implements ', join(interfaces, ' & ')), join(directives, ' '), block(fields)], ' ');
        },
    },
    UnionTypeExtension: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives, types = _a.types;
            return join(['extend union', name, join(directives, ' '), wrap('= ', join(types, ' | '))], ' ');
        },
    },
    EnumTypeExtension: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives, values = _a.values;
            return join(['extend enum', name, join(directives, ' '), block(values)], ' ');
        },
    },
    InputObjectTypeExtension: {
        leave: function (_a) {
            var name = _a.name, directives = _a.directives, fields = _a.fields;
            return join(['extend input', name, join(directives, ' '), block(fields)], ' ');
        },
    },
};
var printDocASTReducerWithComments = Object.keys(printDocASTReducer).reduce(function (prev, key) {
    var _a;
    return (__assign(__assign({}, prev), (_a = {}, _a[key] = {
        leave: addDescription(printDocASTReducer[key].leave),
    }, _a)));
}, {});
/**
 * Converts an AST into a string, using one set of reasonable
 * formatting rules.
 */
function printWithComments(ast) {
    return visit(ast, printDocASTReducerWithComments);
}
function isFieldDefinitionNode(node) {
    return node.kind === 'FieldDefinition';
}
// graphql < v13 and > v15 does not export getDescription
function getDescription(node, options) {
    if (node.description != null) {
        return node.description.value;
    }
    if (options === null || options === void 0 ? void 0 : options.commentDescriptions) {
        return getComment(node);
    }
}
function getComment(node) {
    var rawValue = getLeadingCommentBlock(node);
    if (rawValue !== undefined) {
        return dedentBlockStringValue("\n" + rawValue);
    }
}
function getLeadingCommentBlock(node) {
    var loc = node.loc;
    if (!loc) {
        return;
    }
    var comments = [];
    var token = loc.startToken.prev;
    while (token != null &&
        token.kind === TokenKind.COMMENT &&
        token.next != null &&
        token.prev != null &&
        token.line + 1 === token.next.line &&
        token.line !== token.prev.line) {
        var value = String(token.value);
        comments.push(value);
        token = token.prev;
    }
    return comments.length > 0 ? comments.reverse().join('\n') : undefined;
}
function dedentBlockStringValue(rawString) {
    // Expand a block string's raw value into independent lines.
    var lines = rawString.split(/\r\n|[\n\r]/g);
    // Remove common indentation from all lines but first.
    var commonIndent = getBlockStringIndentation(lines);
    if (commonIndent !== 0) {
        for (var i = 1; i < lines.length; i++) {
            lines[i] = lines[i].slice(commonIndent);
        }
    }
    // Remove leading and trailing blank lines.
    while (lines.length > 0 && isBlank(lines[0])) {
        lines.shift();
    }
    while (lines.length > 0 && isBlank(lines[lines.length - 1])) {
        lines.pop();
    }
    // Return a string of the lines joined with U+000A.
    return lines.join('\n');
}
/**
 * @internal
 */
function getBlockStringIndentation(lines) {
    var commonIndent = null;
    for (var i = 1; i < lines.length; i++) {
        var line = lines[i];
        var indent_1 = leadingWhitespace(line);
        if (indent_1 === line.length) {
            continue; // skip empty lines
        }
        if (commonIndent === null || indent_1 < commonIndent) {
            commonIndent = indent_1;
            if (commonIndent === 0) {
                break;
            }
        }
    }
    return commonIndent === null ? 0 : commonIndent;
}
function leadingWhitespace(str) {
    var i = 0;
    while (i < str.length && (str[i] === ' ' || str[i] === '\t')) {
        i++;
    }
    return i;
}
function isBlank(str) {
    return leadingWhitespace(str) === str.length;
}

function parseGraphQLSDL(location, rawSDL, options) {
    if (options === void 0) { options = {}; }
    var document;
    try {
        if (options.commentDescriptions && rawSDL.includes('#')) {
            document = transformCommentsToDescriptions(rawSDL, options);
            // If noLocation=true, we need to make sure to print and parse it again, to remove locations,
            // since `transformCommentsToDescriptions` must have locations set in order to transform the comments
            // into descriptions.
            if (options.noLocation) {
                document = parse(print(document), options);
            }
        }
        else {
            document = parse(new Source(rawSDL, location), options);
        }
    }
    catch (e) {
        if (e.message.includes('EOF') && rawSDL.replace(/(\#[^*]*)/g, '').trim() === '') {
            document = {
                kind: Kind.DOCUMENT,
                definitions: [],
            };
        }
        else {
            throw e;
        }
    }
    return {
        location: location,
        document: document,
    };
}
function transformCommentsToDescriptions(sourceSdl, options) {
    if (options === void 0) { options = {}; }
    var parsedDoc = parse(sourceSdl, __assign(__assign({}, options), { noLocation: false }));
    var modifiedDoc = visit(parsedDoc, {
        leave: function (node) {
            if (isDescribable(node)) {
                var rawValue = getLeadingCommentBlock(node);
                if (rawValue !== undefined) {
                    var commentsBlock = dedentBlockStringValue('\n' + rawValue);
                    var isBlock = commentsBlock.includes('\n');
                    if (!node.description) {
                        return __assign(__assign({}, node), { description: {
                                kind: Kind.STRING,
                                value: commentsBlock,
                                block: isBlock,
                            } });
                    }
                    else {
                        return __assign(__assign({}, node), { description: __assign(__assign({}, node.description), { value: node.description.value + '\n' + commentsBlock, block: true }) });
                    }
                }
            }
        },
    });
    return modifiedDoc;
}
function isDescribable(node) {
    return (isTypeSystemDefinitionNode(node) ||
        node.kind === Kind.FIELD_DEFINITION ||
        node.kind === Kind.INPUT_VALUE_DEFINITION ||
        node.kind === Kind.ENUM_VALUE_DEFINITION);
}

var operationVariables = [];
var fieldTypeMap = new Map();
function addOperationVariable(variable) {
    operationVariables.push(variable);
}
function resetOperationVariables() {
    operationVariables = [];
}
function resetFieldMap() {
    fieldTypeMap = new Map();
}
function buildOperationNodeForField(_a) {
    var schema = _a.schema, kind = _a.kind, field = _a.field, models = _a.models, _b = _a.ignore, ignore = _b === void 0 ? [] : _b, depthLimit = _a.depthLimit, circularReferenceDepth = _a.circularReferenceDepth, argNames = _a.argNames, _c = _a.selectedFields, selectedFields = _c === void 0 ? true : _c;
    resetOperationVariables();
    resetFieldMap();
    var rootTypeNames = getRootTypeNames(schema);
    var operationNode = buildOperationAndCollectVariables({
        schema: schema,
        fieldName: field,
        kind: kind,
        models: models || [],
        ignore: ignore,
        depthLimit: depthLimit || Infinity,
        circularReferenceDepth: circularReferenceDepth || 1,
        argNames: argNames,
        selectedFields: selectedFields,
        rootTypeNames: rootTypeNames,
    });
    // attach variables
    operationNode.variableDefinitions = __spreadArray([], __read(operationVariables), false);
    resetOperationVariables();
    resetFieldMap();
    return operationNode;
}
function buildOperationAndCollectVariables(_a) {
    var e_1, _b;
    var schema = _a.schema, fieldName = _a.fieldName, kind = _a.kind, models = _a.models, ignore = _a.ignore, depthLimit = _a.depthLimit, circularReferenceDepth = _a.circularReferenceDepth, argNames = _a.argNames, selectedFields = _a.selectedFields, rootTypeNames = _a.rootTypeNames;
    var type = getDefinedRootType(schema, kind);
    var field = type.getFields()[fieldName];
    var operationName = fieldName + "_" + kind;
    if (field.args) {
        try {
            for (var _c = __values(field.args), _d = _c.next(); !_d.done; _d = _c.next()) {
                var arg = _d.value;
                var argName = arg.name;
                if (!argNames || argNames.includes(argName)) {
                    addOperationVariable(resolveVariable(arg, argName));
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return {
        kind: Kind.OPERATION_DEFINITION,
        operation: kind,
        name: {
            kind: 'Name',
            value: operationName,
        },
        variableDefinitions: [],
        selectionSet: {
            kind: Kind.SELECTION_SET,
            selections: [
                resolveField({
                    type: type,
                    field: field,
                    models: models,
                    firstCall: true,
                    path: [],
                    ancestors: [],
                    ignore: ignore,
                    depthLimit: depthLimit,
                    circularReferenceDepth: circularReferenceDepth,
                    schema: schema,
                    depth: 0,
                    argNames: argNames,
                    selectedFields: selectedFields,
                    rootTypeNames: rootTypeNames,
                }),
            ],
        },
    };
}
function resolveSelectionSet(_a) {
    var parent = _a.parent, type = _a.type, models = _a.models, firstCall = _a.firstCall, path = _a.path, ancestors = _a.ancestors, ignore = _a.ignore, depthLimit = _a.depthLimit, circularReferenceDepth = _a.circularReferenceDepth, schema = _a.schema, depth = _a.depth, argNames = _a.argNames, selectedFields = _a.selectedFields, rootTypeNames = _a.rootTypeNames;
    if (typeof selectedFields === 'boolean' && depth > depthLimit) {
        return;
    }
    if (isUnionType(type)) {
        var types = type.getTypes();
        return {
            kind: Kind.SELECTION_SET,
            selections: types
                .filter(function (t) {
                return !hasCircularRef(__spreadArray(__spreadArray([], __read(ancestors), false), [t], false), {
                    depth: circularReferenceDepth,
                });
            })
                .map(function (t) {
                return {
                    kind: Kind.INLINE_FRAGMENT,
                    typeCondition: {
                        kind: Kind.NAMED_TYPE,
                        name: {
                            kind: Kind.NAME,
                            value: t.name,
                        },
                    },
                    selectionSet: resolveSelectionSet({
                        parent: type,
                        type: t,
                        models: models,
                        path: path,
                        ancestors: ancestors,
                        ignore: ignore,
                        depthLimit: depthLimit,
                        circularReferenceDepth: circularReferenceDepth,
                        schema: schema,
                        depth: depth,
                        argNames: argNames,
                        selectedFields: selectedFields,
                        rootTypeNames: rootTypeNames,
                    }),
                };
            })
                .filter(function (fragmentNode) { var _a, _b; return ((_b = (_a = fragmentNode === null || fragmentNode === void 0 ? void 0 : fragmentNode.selectionSet) === null || _a === void 0 ? void 0 : _a.selections) === null || _b === void 0 ? void 0 : _b.length) > 0; }),
        };
    }
    if (isInterfaceType(type)) {
        var types = Object.values(schema.getTypeMap()).filter(function (t) { return isObjectType(t) && t.getInterfaces().includes(type); });
        return {
            kind: Kind.SELECTION_SET,
            selections: types
                .filter(function (t) {
                return !hasCircularRef(__spreadArray(__spreadArray([], __read(ancestors), false), [t], false), {
                    depth: circularReferenceDepth,
                });
            })
                .map(function (t) {
                return {
                    kind: Kind.INLINE_FRAGMENT,
                    typeCondition: {
                        kind: Kind.NAMED_TYPE,
                        name: {
                            kind: Kind.NAME,
                            value: t.name,
                        },
                    },
                    selectionSet: resolveSelectionSet({
                        parent: type,
                        type: t,
                        models: models,
                        path: path,
                        ancestors: ancestors,
                        ignore: ignore,
                        depthLimit: depthLimit,
                        circularReferenceDepth: circularReferenceDepth,
                        schema: schema,
                        depth: depth,
                        argNames: argNames,
                        selectedFields: selectedFields,
                        rootTypeNames: rootTypeNames,
                    }),
                };
            })
                .filter(function (fragmentNode) { var _a, _b; return ((_b = (_a = fragmentNode === null || fragmentNode === void 0 ? void 0 : fragmentNode.selectionSet) === null || _a === void 0 ? void 0 : _a.selections) === null || _b === void 0 ? void 0 : _b.length) > 0; }),
        };
    }
    if (isObjectType(type) && !rootTypeNames.has(type.name)) {
        var isIgnored = ignore.includes(type.name) || ignore.includes(parent.name + "." + path[path.length - 1]);
        var isModel = models.includes(type.name);
        if (!firstCall && isModel && !isIgnored) {
            return {
                kind: Kind.SELECTION_SET,
                selections: [
                    {
                        kind: Kind.FIELD,
                        name: {
                            kind: Kind.NAME,
                            value: 'id',
                        },
                    },
                ],
            };
        }
        var fields_1 = type.getFields();
        return {
            kind: Kind.SELECTION_SET,
            selections: Object.keys(fields_1)
                .filter(function (fieldName) {
                return !hasCircularRef(__spreadArray(__spreadArray([], __read(ancestors), false), [getNamedType(fields_1[fieldName].type)], false), {
                    depth: circularReferenceDepth,
                });
            })
                .map(function (fieldName) {
                var selectedSubFields = typeof selectedFields === 'object' ? selectedFields[fieldName] : true;
                if (selectedSubFields) {
                    return resolveField({
                        type: type,
                        field: fields_1[fieldName],
                        models: models,
                        path: __spreadArray(__spreadArray([], __read(path), false), [fieldName], false),
                        ancestors: ancestors,
                        ignore: ignore,
                        depthLimit: depthLimit,
                        circularReferenceDepth: circularReferenceDepth,
                        schema: schema,
                        depth: depth,
                        argNames: argNames,
                        selectedFields: selectedSubFields,
                        rootTypeNames: rootTypeNames,
                    });
                }
                return null;
            })
                .filter(function (f) {
                var _a, _b;
                if (f == null) {
                    return false;
                }
                else if ('selectionSet' in f) {
                    return !!((_b = (_a = f.selectionSet) === null || _a === void 0 ? void 0 : _a.selections) === null || _b === void 0 ? void 0 : _b.length);
                }
                return true;
            }),
        };
    }
}
function resolveVariable(arg, name) {
    function resolveVariableType(type) {
        if (isListType(type)) {
            return {
                kind: Kind.LIST_TYPE,
                type: resolveVariableType(type.ofType),
            };
        }
        if (isNonNullType(type)) {
            return {
                kind: Kind.NON_NULL_TYPE,
                // for v16 compatibility
                type: resolveVariableType(type.ofType),
            };
        }
        return {
            kind: Kind.NAMED_TYPE,
            name: {
                kind: Kind.NAME,
                value: type.name,
            },
        };
    }
    return {
        kind: Kind.VARIABLE_DEFINITION,
        variable: {
            kind: Kind.VARIABLE,
            name: {
                kind: Kind.NAME,
                value: name || arg.name,
            },
        },
        type: resolveVariableType(arg.type),
    };
}
function getArgumentName(name, path) {
    return __spreadArray(__spreadArray([], __read(path), false), [name], false).join('_');
}
function resolveField(_a) {
    var type = _a.type, field = _a.field, models = _a.models, firstCall = _a.firstCall, path = _a.path, ancestors = _a.ancestors, ignore = _a.ignore, depthLimit = _a.depthLimit, circularReferenceDepth = _a.circularReferenceDepth, schema = _a.schema, depth = _a.depth, argNames = _a.argNames, selectedFields = _a.selectedFields, rootTypeNames = _a.rootTypeNames;
    var namedType = getNamedType(field.type);
    var args = [];
    var removeField = false;
    if (field.args && field.args.length) {
        args = field.args
            .map(function (arg) {
            var argumentName = getArgumentName(arg.name, path);
            if (argNames && !argNames.includes(argumentName)) {
                if (isNonNullType(arg.type)) {
                    removeField = true;
                }
                return null;
            }
            if (!firstCall) {
                addOperationVariable(resolveVariable(arg, argumentName));
            }
            return {
                kind: Kind.ARGUMENT,
                name: {
                    kind: Kind.NAME,
                    value: arg.name,
                },
                value: {
                    kind: Kind.VARIABLE,
                    name: {
                        kind: Kind.NAME,
                        value: getArgumentName(arg.name, path),
                    },
                },
            };
        })
            .filter(Boolean);
    }
    if (removeField) {
        return null;
    }
    var fieldPath = __spreadArray(__spreadArray([], __read(path), false), [field.name], false);
    var fieldPathStr = fieldPath.join('.');
    var fieldName = field.name;
    if (fieldTypeMap.has(fieldPathStr) && fieldTypeMap.get(fieldPathStr) !== field.type.toString()) {
        fieldName += field.type.toString().replace('!', 'NonNull');
    }
    fieldTypeMap.set(fieldPathStr, field.type.toString());
    if (!isScalarType(namedType) && !isEnumType(namedType)) {
        return __assign(__assign({ kind: Kind.FIELD, name: {
                kind: Kind.NAME,
                value: field.name,
            } }, (fieldName !== field.name && { alias: { kind: Kind.NAME, value: fieldName } })), { selectionSet: resolveSelectionSet({
                parent: type,
                type: namedType,
                models: models,
                firstCall: firstCall,
                path: fieldPath,
                ancestors: __spreadArray(__spreadArray([], __read(ancestors), false), [type], false),
                ignore: ignore,
                depthLimit: depthLimit,
                circularReferenceDepth: circularReferenceDepth,
                schema: schema,
                depth: depth + 1,
                argNames: argNames,
                selectedFields: selectedFields,
                rootTypeNames: rootTypeNames,
            }) || undefined, arguments: args });
    }
    return __assign(__assign({ kind: Kind.FIELD, name: {
            kind: Kind.NAME,
            value: field.name,
        } }, (fieldName !== field.name && { alias: { kind: Kind.NAME, value: fieldName } })), { arguments: args });
}
function hasCircularRef(types, config) {
    if (config === void 0) { config = {
        depth: 1,
    }; }
    var type = types[types.length - 1];
    if (isScalarType(type)) {
        return false;
    }
    var size = types.filter(function (t) { return t.name === type.name; }).length;
    return size > config.depth;
}

var MapperKind;
(function (MapperKind) {
    MapperKind["TYPE"] = "MapperKind.TYPE";
    MapperKind["SCALAR_TYPE"] = "MapperKind.SCALAR_TYPE";
    MapperKind["ENUM_TYPE"] = "MapperKind.ENUM_TYPE";
    MapperKind["COMPOSITE_TYPE"] = "MapperKind.COMPOSITE_TYPE";
    MapperKind["OBJECT_TYPE"] = "MapperKind.OBJECT_TYPE";
    MapperKind["INPUT_OBJECT_TYPE"] = "MapperKind.INPUT_OBJECT_TYPE";
    MapperKind["ABSTRACT_TYPE"] = "MapperKind.ABSTRACT_TYPE";
    MapperKind["UNION_TYPE"] = "MapperKind.UNION_TYPE";
    MapperKind["INTERFACE_TYPE"] = "MapperKind.INTERFACE_TYPE";
    MapperKind["ROOT_OBJECT"] = "MapperKind.ROOT_OBJECT";
    MapperKind["QUERY"] = "MapperKind.QUERY";
    MapperKind["MUTATION"] = "MapperKind.MUTATION";
    MapperKind["SUBSCRIPTION"] = "MapperKind.SUBSCRIPTION";
    MapperKind["DIRECTIVE"] = "MapperKind.DIRECTIVE";
    MapperKind["FIELD"] = "MapperKind.FIELD";
    MapperKind["COMPOSITE_FIELD"] = "MapperKind.COMPOSITE_FIELD";
    MapperKind["OBJECT_FIELD"] = "MapperKind.OBJECT_FIELD";
    MapperKind["ROOT_FIELD"] = "MapperKind.ROOT_FIELD";
    MapperKind["QUERY_ROOT_FIELD"] = "MapperKind.QUERY_ROOT_FIELD";
    MapperKind["MUTATION_ROOT_FIELD"] = "MapperKind.MUTATION_ROOT_FIELD";
    MapperKind["SUBSCRIPTION_ROOT_FIELD"] = "MapperKind.SUBSCRIPTION_ROOT_FIELD";
    MapperKind["INTERFACE_FIELD"] = "MapperKind.INTERFACE_FIELD";
    MapperKind["INPUT_OBJECT_FIELD"] = "MapperKind.INPUT_OBJECT_FIELD";
    MapperKind["ARGUMENT"] = "MapperKind.ARGUMENT";
    MapperKind["ENUM_VALUE"] = "MapperKind.ENUM_VALUE";
})(MapperKind || (MapperKind = {}));

function getObjectTypeFromTypeMap(typeMap, type) {
    if (type) {
        var maybeObjectType = typeMap[type.name];
        if (isObjectType(maybeObjectType)) {
            return maybeObjectType;
        }
    }
}

function createNamedStub(name, type) {
    var constructor;
    if (type === 'object') {
        constructor = GraphQLObjectType;
    }
    else if (type === 'interface') {
        constructor = GraphQLInterfaceType;
    }
    else {
        constructor = GraphQLInputObjectType;
    }
    return new constructor({
        name: name,
        fields: {
            _fake: {
                type: GraphQLString,
            },
        },
    });
}
function createStub(node, type) {
    switch (node.kind) {
        case Kind.LIST_TYPE:
            return new GraphQLList(createStub(node.type, type));
        case Kind.NON_NULL_TYPE:
            return new GraphQLNonNull(createStub(node.type, type));
        default:
            if (type === 'output') {
                return createNamedStub(node.name.value, 'object');
            }
            return createNamedStub(node.name.value, 'input');
    }
}
function isNamedStub(type) {
    if ('getFields' in type) {
        var fields = type.getFields();
        // eslint-disable-next-line no-unreachable-loop
        for (var fieldName in fields) {
            var field = fields[fieldName];
            return field.name === '_fake';
        }
    }
    return false;
}
function getBuiltInForStub(type) {
    switch (type.name) {
        case GraphQLInt.name:
            return GraphQLInt;
        case GraphQLFloat.name:
            return GraphQLFloat;
        case GraphQLString.name:
            return GraphQLString;
        case GraphQLBoolean.name:
            return GraphQLBoolean;
        case GraphQLID.name:
            return GraphQLID;
        default:
            return type;
    }
}

function rewireTypes(originalTypeMap, directives) {
    var referenceTypeMap = Object.create(null);
    for (var typeName in originalTypeMap) {
        referenceTypeMap[typeName] = originalTypeMap[typeName];
    }
    var newTypeMap = Object.create(null);
    for (var typeName in referenceTypeMap) {
        var namedType = referenceTypeMap[typeName];
        if (namedType == null || typeName.startsWith('__')) {
            continue;
        }
        var newName = namedType.name;
        if (newName.startsWith('__')) {
            continue;
        }
        if (newTypeMap[newName] != null) {
            throw new Error("Duplicate schema type name " + newName);
        }
        newTypeMap[newName] = namedType;
    }
    for (var typeName in newTypeMap) {
        newTypeMap[typeName] = rewireNamedType(newTypeMap[typeName]);
    }
    var newDirectives = directives.map(function (directive) { return rewireDirective(directive); });
    return {
        typeMap: newTypeMap,
        directives: newDirectives,
    };
    function rewireDirective(directive) {
        if (isSpecifiedDirective(directive)) {
            return directive;
        }
        var directiveConfig = directive.toConfig();
        directiveConfig.args = rewireArgs(directiveConfig.args);
        return new GraphQLDirective(directiveConfig);
    }
    function rewireArgs(args) {
        var rewiredArgs = {};
        for (var argName in args) {
            var arg = args[argName];
            var rewiredArgType = rewireType(arg.type);
            if (rewiredArgType != null) {
                arg.type = rewiredArgType;
                rewiredArgs[argName] = arg;
            }
        }
        return rewiredArgs;
    }
    function rewireNamedType(type) {
        if (isObjectType(type)) {
            var config_1 = type.toConfig();
            var newConfig = __assign(__assign({}, config_1), { fields: function () { return rewireFields(config_1.fields); }, interfaces: function () { return rewireNamedTypes(config_1.interfaces); } });
            return new GraphQLObjectType(newConfig);
        }
        else if (isInterfaceType(type)) {
            var config_2 = type.toConfig();
            var newConfig = __assign(__assign({}, config_2), { fields: function () { return rewireFields(config_2.fields); } });
            if ('interfaces' in newConfig) {
                newConfig.interfaces = function () {
                    return rewireNamedTypes(config_2.interfaces);
                };
            }
            return new GraphQLInterfaceType(newConfig);
        }
        else if (isUnionType(type)) {
            var config_3 = type.toConfig();
            var newConfig = __assign(__assign({}, config_3), { types: function () { return rewireNamedTypes(config_3.types); } });
            return new GraphQLUnionType(newConfig);
        }
        else if (isInputObjectType(type)) {
            var config_4 = type.toConfig();
            var newConfig = __assign(__assign({}, config_4), { fields: function () { return rewireInputFields(config_4.fields); } });
            return new GraphQLInputObjectType(newConfig);
        }
        else if (isEnumType(type)) {
            var enumConfig = type.toConfig();
            return new GraphQLEnumType(enumConfig);
        }
        else if (isScalarType(type)) {
            if (isSpecifiedScalarType(type)) {
                return type;
            }
            var scalarConfig = type.toConfig();
            return new GraphQLScalarType(scalarConfig);
        }
        throw new Error("Unexpected schema type: " + type);
    }
    function rewireFields(fields) {
        var rewiredFields = {};
        for (var fieldName in fields) {
            var field = fields[fieldName];
            var rewiredFieldType = rewireType(field.type);
            if (rewiredFieldType != null && field.args) {
                field.type = rewiredFieldType;
                field.args = rewireArgs(field.args);
                rewiredFields[fieldName] = field;
            }
        }
        return rewiredFields;
    }
    function rewireInputFields(fields) {
        var rewiredFields = {};
        for (var fieldName in fields) {
            var field = fields[fieldName];
            var rewiredFieldType = rewireType(field.type);
            if (rewiredFieldType != null) {
                field.type = rewiredFieldType;
                rewiredFields[fieldName] = field;
            }
        }
        return rewiredFields;
    }
    function rewireNamedTypes(namedTypes) {
        var e_1, _a;
        var rewiredTypes = [];
        try {
            for (var namedTypes_1 = __values(namedTypes), namedTypes_1_1 = namedTypes_1.next(); !namedTypes_1_1.done; namedTypes_1_1 = namedTypes_1.next()) {
                var namedType = namedTypes_1_1.value;
                var rewiredType = rewireType(namedType);
                if (rewiredType != null) {
                    rewiredTypes.push(rewiredType);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (namedTypes_1_1 && !namedTypes_1_1.done && (_a = namedTypes_1.return)) _a.call(namedTypes_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return rewiredTypes;
    }
    function rewireType(type) {
        if (isListType(type)) {
            var rewiredType = rewireType(type.ofType);
            return rewiredType != null ? new GraphQLList(rewiredType) : null;
        }
        else if (isNonNullType(type)) {
            var rewiredType = rewireType(type.ofType);
            return rewiredType != null ? new GraphQLNonNull(rewiredType) : null;
        }
        else if (isNamedType(type)) {
            var rewiredType = referenceTypeMap[type.name];
            if (rewiredType === undefined) {
                rewiredType = isNamedStub(type) ? getBuiltInForStub(type) : rewireNamedType(type);
                newTypeMap[rewiredType.name] = referenceTypeMap[type.name] = rewiredType;
            }
            return rewiredType != null ? newTypeMap[rewiredType.name] : null;
        }
        return null;
    }
}

function transformInputValue(type, value, inputLeafValueTransformer, inputObjectValueTransformer) {
    if (inputLeafValueTransformer === void 0) { inputLeafValueTransformer = null; }
    if (inputObjectValueTransformer === void 0) { inputObjectValueTransformer = null; }
    if (value == null) {
        return value;
    }
    var nullableType = getNullableType(type);
    if (isLeafType(nullableType)) {
        return inputLeafValueTransformer != null ? inputLeafValueTransformer(nullableType, value) : value;
    }
    else if (isListType(nullableType)) {
        return value.map(function (listMember) {
            return transformInputValue(nullableType.ofType, listMember, inputLeafValueTransformer, inputObjectValueTransformer);
        });
    }
    else if (isInputObjectType(nullableType)) {
        var fields = nullableType.getFields();
        var newValue = {};
        for (var key in value) {
            var field = fields[key];
            if (field != null) {
                newValue[key] = transformInputValue(field.type, value[key], inputLeafValueTransformer, inputObjectValueTransformer);
            }
        }
        return inputObjectValueTransformer != null ? inputObjectValueTransformer(nullableType, newValue) : newValue;
    }
    // unreachable, no other possible return value
}
function serializeInputValue(type, value) {
    return transformInputValue(type, value, function (t, v) { return t.serialize(v); });
}
function parseInputValue(type, value) {
    return transformInputValue(type, value, function (t, v) { return t.parseValue(v); });
}
function parseInputValueLiteral(type, value) {
    return transformInputValue(type, value, function (t, v) { return t.parseLiteral(v, {}); });
}

function mapSchema(schema, schemaMapper) {
    if (schemaMapper === void 0) { schemaMapper = {}; }
    var newTypeMap = mapArguments(mapFields(mapTypes(mapDefaultValues(mapEnumValues(mapTypes(mapDefaultValues(schema.getTypeMap(), schema, serializeInputValue), schema, schemaMapper, function (type) {
        return isLeafType(type);
    }), schema, schemaMapper), schema, parseInputValue), schema, schemaMapper, function (type) { return !isLeafType(type); }), schema, schemaMapper), schema, schemaMapper);
    var originalDirectives = schema.getDirectives();
    var newDirectives = mapDirectives(originalDirectives, schema, schemaMapper);
    var _a = rewireTypes(newTypeMap, newDirectives), typeMap = _a.typeMap, directives = _a.directives;
    return new GraphQLSchema(__assign(__assign({}, schema.toConfig()), { query: getObjectTypeFromTypeMap(typeMap, getObjectTypeFromTypeMap(newTypeMap, schema.getQueryType())), mutation: getObjectTypeFromTypeMap(typeMap, getObjectTypeFromTypeMap(newTypeMap, schema.getMutationType())), subscription: getObjectTypeFromTypeMap(typeMap, getObjectTypeFromTypeMap(newTypeMap, schema.getSubscriptionType())), types: Object.values(typeMap), directives: directives }));
}
function mapTypes(originalTypeMap, schema, schemaMapper, testFn) {
    if (testFn === void 0) { testFn = function () { return true; }; }
    var newTypeMap = {};
    for (var typeName in originalTypeMap) {
        if (!typeName.startsWith('__')) {
            var originalType = originalTypeMap[typeName];
            if (originalType == null || !testFn(originalType)) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            var typeMapper = getTypeMapper(schema, schemaMapper, typeName);
            if (typeMapper == null) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            var maybeNewType = typeMapper(originalType, schema);
            if (maybeNewType === undefined) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            newTypeMap[typeName] = maybeNewType;
        }
    }
    return newTypeMap;
}
function mapEnumValues(originalTypeMap, schema, schemaMapper) {
    var _a;
    var enumValueMapper = getEnumValueMapper(schemaMapper);
    if (!enumValueMapper) {
        return originalTypeMap;
    }
    return mapTypes(originalTypeMap, schema, (_a = {},
        _a[MapperKind.ENUM_TYPE] = function (type) {
            var config = type.toConfig();
            var originalEnumValueConfigMap = config.values;
            var newEnumValueConfigMap = {};
            for (var externalValue in originalEnumValueConfigMap) {
                var originalEnumValueConfig = originalEnumValueConfigMap[externalValue];
                var mappedEnumValue = enumValueMapper(originalEnumValueConfig, type.name, schema, externalValue);
                if (mappedEnumValue === undefined) {
                    newEnumValueConfigMap[externalValue] = originalEnumValueConfig;
                }
                else if (Array.isArray(mappedEnumValue)) {
                    var _a = __read(mappedEnumValue, 2), newExternalValue = _a[0], newEnumValueConfig = _a[1];
                    newEnumValueConfigMap[newExternalValue] =
                        newEnumValueConfig === undefined ? originalEnumValueConfig : newEnumValueConfig;
                }
                else if (mappedEnumValue !== null) {
                    newEnumValueConfigMap[externalValue] = mappedEnumValue;
                }
            }
            return correctASTNodes(new GraphQLEnumType(__assign(__assign({}, config), { values: newEnumValueConfigMap })));
        },
        _a), function (type) { return isEnumType(type); });
}
function mapDefaultValues(originalTypeMap, schema, fn) {
    var _a, _b;
    var newTypeMap = mapArguments(originalTypeMap, schema, (_a = {},
        _a[MapperKind.ARGUMENT] = function (argumentConfig) {
            if (argumentConfig.defaultValue === undefined) {
                return argumentConfig;
            }
            var maybeNewType = getNewType(originalTypeMap, argumentConfig.type);
            if (maybeNewType != null) {
                return __assign(__assign({}, argumentConfig), { defaultValue: fn(maybeNewType, argumentConfig.defaultValue) });
            }
        },
        _a));
    return mapFields(newTypeMap, schema, (_b = {},
        _b[MapperKind.INPUT_OBJECT_FIELD] = function (inputFieldConfig) {
            if (inputFieldConfig.defaultValue === undefined) {
                return inputFieldConfig;
            }
            var maybeNewType = getNewType(newTypeMap, inputFieldConfig.type);
            if (maybeNewType != null) {
                return __assign(__assign({}, inputFieldConfig), { defaultValue: fn(maybeNewType, inputFieldConfig.defaultValue) });
            }
        },
        _b));
}
function getNewType(newTypeMap, type) {
    if (isListType(type)) {
        var newType = getNewType(newTypeMap, type.ofType);
        return newType != null ? new GraphQLList(newType) : null;
    }
    else if (isNonNullType(type)) {
        var newType = getNewType(newTypeMap, type.ofType);
        return newType != null ? new GraphQLNonNull(newType) : null;
    }
    else if (isNamedType(type)) {
        var newType = newTypeMap[type.name];
        return newType != null ? newType : null;
    }
    return null;
}
function mapFields(originalTypeMap, schema, schemaMapper) {
    var newTypeMap = {};
    for (var typeName in originalTypeMap) {
        if (!typeName.startsWith('__')) {
            var originalType = originalTypeMap[typeName];
            if (!isObjectType(originalType) && !isInterfaceType(originalType) && !isInputObjectType(originalType)) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            var fieldMapper = getFieldMapper(schema, schemaMapper, typeName);
            if (fieldMapper == null) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            var config = originalType.toConfig();
            var originalFieldConfigMap = config.fields;
            var newFieldConfigMap = {};
            for (var fieldName in originalFieldConfigMap) {
                var originalFieldConfig = originalFieldConfigMap[fieldName];
                var mappedField = fieldMapper(originalFieldConfig, fieldName, typeName, schema);
                if (mappedField === undefined) {
                    newFieldConfigMap[fieldName] = originalFieldConfig;
                }
                else if (Array.isArray(mappedField)) {
                    var _a = __read(mappedField, 2), newFieldName = _a[0], newFieldConfig = _a[1];
                    if (newFieldConfig.astNode != null) {
                        newFieldConfig.astNode = __assign(__assign({}, newFieldConfig.astNode), { name: __assign(__assign({}, newFieldConfig.astNode.name), { value: newFieldName }) });
                    }
                    newFieldConfigMap[newFieldName] = newFieldConfig === undefined ? originalFieldConfig : newFieldConfig;
                }
                else if (mappedField !== null) {
                    newFieldConfigMap[fieldName] = mappedField;
                }
            }
            if (isObjectType(originalType)) {
                newTypeMap[typeName] = correctASTNodes(new GraphQLObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap })));
            }
            else if (isInterfaceType(originalType)) {
                newTypeMap[typeName] = correctASTNodes(new GraphQLInterfaceType(__assign(__assign({}, config), { fields: newFieldConfigMap })));
            }
            else {
                newTypeMap[typeName] = correctASTNodes(new GraphQLInputObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap })));
            }
        }
    }
    return newTypeMap;
}
function mapArguments(originalTypeMap, schema, schemaMapper) {
    var e_1, _a;
    var newTypeMap = {};
    for (var typeName in originalTypeMap) {
        if (!typeName.startsWith('__')) {
            var originalType = originalTypeMap[typeName];
            if (!isObjectType(originalType) && !isInterfaceType(originalType)) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            var argumentMapper = getArgumentMapper(schemaMapper);
            if (argumentMapper == null) {
                newTypeMap[typeName] = originalType;
                continue;
            }
            var config = originalType.toConfig();
            var originalFieldConfigMap = config.fields;
            var newFieldConfigMap = {};
            for (var fieldName in originalFieldConfigMap) {
                var originalFieldConfig = originalFieldConfigMap[fieldName];
                var originalArgumentConfigMap = originalFieldConfig.args;
                if (originalArgumentConfigMap == null) {
                    newFieldConfigMap[fieldName] = originalFieldConfig;
                    continue;
                }
                var argumentNames = Object.keys(originalArgumentConfigMap);
                if (!argumentNames.length) {
                    newFieldConfigMap[fieldName] = originalFieldConfig;
                    continue;
                }
                var newArgumentConfigMap = {};
                try {
                    for (var argumentNames_1 = (e_1 = void 0, __values(argumentNames)), argumentNames_1_1 = argumentNames_1.next(); !argumentNames_1_1.done; argumentNames_1_1 = argumentNames_1.next()) {
                        var argumentName = argumentNames_1_1.value;
                        var originalArgumentConfig = originalArgumentConfigMap[argumentName];
                        var mappedArgument = argumentMapper(originalArgumentConfig, fieldName, typeName, schema);
                        if (mappedArgument === undefined) {
                            newArgumentConfigMap[argumentName] = originalArgumentConfig;
                        }
                        else if (Array.isArray(mappedArgument)) {
                            var _b = __read(mappedArgument, 2), newArgumentName = _b[0], newArgumentConfig = _b[1];
                            newArgumentConfigMap[newArgumentName] = newArgumentConfig;
                        }
                        else if (mappedArgument !== null) {
                            newArgumentConfigMap[argumentName] = mappedArgument;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (argumentNames_1_1 && !argumentNames_1_1.done && (_a = argumentNames_1.return)) _a.call(argumentNames_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                newFieldConfigMap[fieldName] = __assign(__assign({}, originalFieldConfig), { args: newArgumentConfigMap });
            }
            if (isObjectType(originalType)) {
                newTypeMap[typeName] = new GraphQLObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap }));
            }
            else if (isInterfaceType(originalType)) {
                newTypeMap[typeName] = new GraphQLInterfaceType(__assign(__assign({}, config), { fields: newFieldConfigMap }));
            }
            else {
                newTypeMap[typeName] = new GraphQLInputObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap }));
            }
        }
    }
    return newTypeMap;
}
function mapDirectives(originalDirectives, schema, schemaMapper) {
    var e_2, _a;
    var directiveMapper = getDirectiveMapper(schemaMapper);
    if (directiveMapper == null) {
        return originalDirectives.slice();
    }
    var newDirectives = [];
    try {
        for (var originalDirectives_1 = __values(originalDirectives), originalDirectives_1_1 = originalDirectives_1.next(); !originalDirectives_1_1.done; originalDirectives_1_1 = originalDirectives_1.next()) {
            var directive = originalDirectives_1_1.value;
            var mappedDirective = directiveMapper(directive, schema);
            if (mappedDirective === undefined) {
                newDirectives.push(directive);
            }
            else if (mappedDirective !== null) {
                newDirectives.push(mappedDirective);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (originalDirectives_1_1 && !originalDirectives_1_1.done && (_a = originalDirectives_1.return)) _a.call(originalDirectives_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return newDirectives;
}
function getTypeSpecifiers(schema, typeName) {
    var _a, _b, _c;
    var type = schema.getType(typeName);
    var specifiers = [MapperKind.TYPE];
    if (isObjectType(type)) {
        specifiers.push(MapperKind.COMPOSITE_TYPE, MapperKind.OBJECT_TYPE);
        if (typeName === ((_a = schema.getQueryType()) === null || _a === void 0 ? void 0 : _a.name)) {
            specifiers.push(MapperKind.ROOT_OBJECT, MapperKind.QUERY);
        }
        else if (typeName === ((_b = schema.getMutationType()) === null || _b === void 0 ? void 0 : _b.name)) {
            specifiers.push(MapperKind.ROOT_OBJECT, MapperKind.MUTATION);
        }
        else if (typeName === ((_c = schema.getSubscriptionType()) === null || _c === void 0 ? void 0 : _c.name)) {
            specifiers.push(MapperKind.ROOT_OBJECT, MapperKind.SUBSCRIPTION);
        }
    }
    else if (isInputObjectType(type)) {
        specifiers.push(MapperKind.INPUT_OBJECT_TYPE);
    }
    else if (isInterfaceType(type)) {
        specifiers.push(MapperKind.COMPOSITE_TYPE, MapperKind.ABSTRACT_TYPE, MapperKind.INTERFACE_TYPE);
    }
    else if (isUnionType(type)) {
        specifiers.push(MapperKind.COMPOSITE_TYPE, MapperKind.ABSTRACT_TYPE, MapperKind.UNION_TYPE);
    }
    else if (isEnumType(type)) {
        specifiers.push(MapperKind.ENUM_TYPE);
    }
    else if (isScalarType(type)) {
        specifiers.push(MapperKind.SCALAR_TYPE);
    }
    return specifiers;
}
function getTypeMapper(schema, schemaMapper, typeName) {
    var specifiers = getTypeSpecifiers(schema, typeName);
    var typeMapper;
    var stack = __spreadArray([], __read(specifiers), false);
    while (!typeMapper && stack.length > 0) {
        // It is safe to use the ! operator here as we check the length.
        var next = stack.pop();
        typeMapper = schemaMapper[next];
    }
    return typeMapper != null ? typeMapper : null;
}
function getFieldSpecifiers(schema, typeName) {
    var _a, _b, _c;
    var type = schema.getType(typeName);
    var specifiers = [MapperKind.FIELD];
    if (isObjectType(type)) {
        specifiers.push(MapperKind.COMPOSITE_FIELD, MapperKind.OBJECT_FIELD);
        if (typeName === ((_a = schema.getQueryType()) === null || _a === void 0 ? void 0 : _a.name)) {
            specifiers.push(MapperKind.ROOT_FIELD, MapperKind.QUERY_ROOT_FIELD);
        }
        else if (typeName === ((_b = schema.getMutationType()) === null || _b === void 0 ? void 0 : _b.name)) {
            specifiers.push(MapperKind.ROOT_FIELD, MapperKind.MUTATION_ROOT_FIELD);
        }
        else if (typeName === ((_c = schema.getSubscriptionType()) === null || _c === void 0 ? void 0 : _c.name)) {
            specifiers.push(MapperKind.ROOT_FIELD, MapperKind.SUBSCRIPTION_ROOT_FIELD);
        }
    }
    else if (isInterfaceType(type)) {
        specifiers.push(MapperKind.COMPOSITE_FIELD, MapperKind.INTERFACE_FIELD);
    }
    else if (isInputObjectType(type)) {
        specifiers.push(MapperKind.INPUT_OBJECT_FIELD);
    }
    return specifiers;
}
function getFieldMapper(schema, schemaMapper, typeName) {
    var specifiers = getFieldSpecifiers(schema, typeName);
    var fieldMapper;
    var stack = __spreadArray([], __read(specifiers), false);
    while (!fieldMapper && stack.length > 0) {
        // It is safe to use the ! operator here as we check the length.
        var next = stack.pop();
        // TODO: fix this as unknown cast
        fieldMapper = schemaMapper[next];
    }
    return fieldMapper !== null && fieldMapper !== void 0 ? fieldMapper : null;
}
function getArgumentMapper(schemaMapper) {
    var argumentMapper = schemaMapper[MapperKind.ARGUMENT];
    return argumentMapper != null ? argumentMapper : null;
}
function getDirectiveMapper(schemaMapper) {
    var directiveMapper = schemaMapper[MapperKind.DIRECTIVE];
    return directiveMapper != null ? directiveMapper : null;
}
function getEnumValueMapper(schemaMapper) {
    var enumValueMapper = schemaMapper[MapperKind.ENUM_VALUE];
    return enumValueMapper != null ? enumValueMapper : null;
}
function correctASTNodes(type) {
    if (isObjectType(type)) {
        var config = type.toConfig();
        if (config.astNode != null) {
            var fields = [];
            for (var fieldName in config.fields) {
                var fieldConfig = config.fields[fieldName];
                if (fieldConfig.astNode != null) {
                    fields.push(fieldConfig.astNode);
                }
            }
            config.astNode = __assign(__assign({}, config.astNode), { kind: Kind.OBJECT_TYPE_DEFINITION, fields: fields });
        }
        if (config.extensionASTNodes != null) {
            config.extensionASTNodes = config.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { kind: Kind.OBJECT_TYPE_EXTENSION, fields: undefined })); });
        }
        return new GraphQLObjectType(config);
    }
    else if (isInterfaceType(type)) {
        var config = type.toConfig();
        if (config.astNode != null) {
            var fields = [];
            for (var fieldName in config.fields) {
                var fieldConfig = config.fields[fieldName];
                if (fieldConfig.astNode != null) {
                    fields.push(fieldConfig.astNode);
                }
            }
            config.astNode = __assign(__assign({}, config.astNode), { kind: Kind.INTERFACE_TYPE_DEFINITION, fields: fields });
        }
        if (config.extensionASTNodes != null) {
            config.extensionASTNodes = config.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { kind: Kind.INTERFACE_TYPE_EXTENSION, fields: undefined })); });
        }
        return new GraphQLInterfaceType(config);
    }
    else if (isInputObjectType(type)) {
        var config = type.toConfig();
        if (config.astNode != null) {
            var fields = [];
            for (var fieldName in config.fields) {
                var fieldConfig = config.fields[fieldName];
                if (fieldConfig.astNode != null) {
                    fields.push(fieldConfig.astNode);
                }
            }
            config.astNode = __assign(__assign({}, config.astNode), { kind: Kind.INPUT_OBJECT_TYPE_DEFINITION, fields: fields });
        }
        if (config.extensionASTNodes != null) {
            config.extensionASTNodes = config.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { kind: Kind.INPUT_OBJECT_TYPE_EXTENSION, fields: undefined })); });
        }
        return new GraphQLInputObjectType(config);
    }
    else if (isEnumType(type)) {
        var config = type.toConfig();
        if (config.astNode != null) {
            var values = [];
            for (var enumKey in config.values) {
                var enumValueConfig = config.values[enumKey];
                if (enumValueConfig.astNode != null) {
                    values.push(enumValueConfig.astNode);
                }
            }
            config.astNode = __assign(__assign({}, config.astNode), { values: values });
        }
        if (config.extensionASTNodes != null) {
            config.extensionASTNodes = config.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { values: undefined })); });
        }
        return new GraphQLEnumType(config);
    }
    else {
        return type;
    }
}

function filterSchema(_a) {
    var _b;
    var schema = _a.schema, _c = _a.typeFilter, typeFilter = _c === void 0 ? function () { return true; } : _c, _d = _a.fieldFilter, fieldFilter = _d === void 0 ? undefined : _d, _e = _a.rootFieldFilter, rootFieldFilter = _e === void 0 ? undefined : _e, _f = _a.objectFieldFilter, objectFieldFilter = _f === void 0 ? undefined : _f, _g = _a.interfaceFieldFilter, interfaceFieldFilter = _g === void 0 ? undefined : _g, _h = _a.inputObjectFieldFilter, inputObjectFieldFilter = _h === void 0 ? undefined : _h, _j = _a.argumentFilter, argumentFilter = _j === void 0 ? undefined : _j;
    var filteredSchema = mapSchema(schema, (_b = {},
        _b[MapperKind.QUERY] = function (type) { return filterRootFields(type, 'Query', rootFieldFilter, argumentFilter); },
        _b[MapperKind.MUTATION] = function (type) {
            return filterRootFields(type, 'Mutation', rootFieldFilter, argumentFilter);
        },
        _b[MapperKind.SUBSCRIPTION] = function (type) {
            return filterRootFields(type, 'Subscription', rootFieldFilter, argumentFilter);
        },
        _b[MapperKind.OBJECT_TYPE] = function (type) {
            return typeFilter(type.name, type)
                ? filterElementFields(GraphQLObjectType, type, objectFieldFilter || fieldFilter, argumentFilter)
                : null;
        },
        _b[MapperKind.INTERFACE_TYPE] = function (type) {
            return typeFilter(type.name, type)
                ? filterElementFields(GraphQLInterfaceType, type, interfaceFieldFilter || fieldFilter, argumentFilter)
                : null;
        },
        _b[MapperKind.INPUT_OBJECT_TYPE] = function (type) {
            return typeFilter(type.name, type)
                ? filterElementFields(GraphQLInputObjectType, type, inputObjectFieldFilter || fieldFilter)
                : null;
        },
        _b[MapperKind.UNION_TYPE] = function (type) { return (typeFilter(type.name, type) ? undefined : null); },
        _b[MapperKind.ENUM_TYPE] = function (type) { return (typeFilter(type.name, type) ? undefined : null); },
        _b[MapperKind.SCALAR_TYPE] = function (type) { return (typeFilter(type.name, type) ? undefined : null); },
        _b));
    return filteredSchema;
}
function filterRootFields(type, operation, rootFieldFilter, argumentFilter) {
    if (rootFieldFilter || argumentFilter) {
        var config = type.toConfig();
        for (var fieldName in config.fields) {
            var field = config.fields[fieldName];
            if (rootFieldFilter && !rootFieldFilter(operation, fieldName, config.fields[fieldName])) {
                delete config.fields[fieldName];
            }
            else if (argumentFilter && field.args) {
                for (var argName in field.args) {
                    if (!argumentFilter(operation, fieldName, argName, field.args[argName])) {
                        delete field.args[argName];
                    }
                }
            }
        }
        return new GraphQLObjectType(config);
    }
    return type;
}
function filterElementFields(ElementConstructor, type, fieldFilter, argumentFilter) {
    if (fieldFilter || argumentFilter) {
        var config = type.toConfig();
        for (var fieldName in config.fields) {
            var field = config.fields[fieldName];
            if (fieldFilter && !fieldFilter(type.name, fieldName, config.fields[fieldName])) {
                delete config.fields[fieldName];
            }
            else if (argumentFilter && 'args' in field) {
                for (var argName in field.args) {
                    if (!argumentFilter(type.name, fieldName, argName, field.args[argName])) {
                        delete field.args[argName];
                    }
                }
            }
        }
        return new ElementConstructor(config);
    }
}

// Update any references to named schema types that disagree with the named
// types found in schema.getTypeMap().
//
// healSchema and its callers (visitSchema/visitSchemaDirectives) all modify the schema in place.
// Therefore, private variables (such as the stored implementation map and the proper root types)
// are not updated.
//
// If this causes issues, the schema could be more aggressively healed as follows:
//
// healSchema(schema);
// const config = schema.toConfig()
// const healedSchema = new GraphQLSchema({
//   ...config,
//   query: schema.getType('<desired new root query type name>'),
//   mutation: schema.getType('<desired new root mutation type name>'),
//   subscription: schema.getType('<desired new root subscription type name>'),
// });
//
// One can then also -- if necessary --  assign the correct private variables to the initial schema
// as follows:
// Object.assign(schema, healedSchema);
//
// These steps are not taken automatically to preserve backwards compatibility with graphql-tools v4.
// See https://github.com/ardatan/graphql-tools/issues/1462
//
// They were briefly taken in v5, but can now be phased out as they were only required when other
// areas of the codebase were using healSchema and visitSchema more extensively.
//
function healSchema(schema) {
    healTypes(schema.getTypeMap(), schema.getDirectives());
    return schema;
}
function healTypes(originalTypeMap, directives) {
    var e_1, _a;
    var actualNamedTypeMap = Object.create(null);
    // If any of the .name properties of the GraphQLNamedType objects in
    // schema.getTypeMap() have changed, the keys of the type map need to
    // be updated accordingly.
    for (var typeName in originalTypeMap) {
        var namedType = originalTypeMap[typeName];
        if (namedType == null || typeName.startsWith('__')) {
            continue;
        }
        var actualName = namedType.name;
        if (actualName.startsWith('__')) {
            continue;
        }
        if (actualName in actualNamedTypeMap) {
            throw new Error("Duplicate schema type name " + actualName);
        }
        actualNamedTypeMap[actualName] = namedType;
        // Note: we are deliberately leaving namedType in the schema by its
        // original name (which might be different from actualName), so that
        // references by that name can be healed.
    }
    // Now add back every named type by its actual name.
    for (var typeName in actualNamedTypeMap) {
        var namedType = actualNamedTypeMap[typeName];
        originalTypeMap[typeName] = namedType;
    }
    try {
        // Directive declaration argument types can refer to named types.
        for (var directives_1 = __values(directives), directives_1_1 = directives_1.next(); !directives_1_1.done; directives_1_1 = directives_1.next()) {
            var decl = directives_1_1.value;
            decl.args = decl.args.filter(function (arg) {
                arg.type = healType(arg.type);
                return arg.type !== null;
            });
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (directives_1_1 && !directives_1_1.done && (_a = directives_1.return)) _a.call(directives_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    for (var typeName in originalTypeMap) {
        var namedType = originalTypeMap[typeName];
        // Heal all named types, except for dangling references, kept only to redirect.
        if (!typeName.startsWith('__') && typeName in actualNamedTypeMap) {
            if (namedType != null) {
                healNamedType(namedType);
            }
        }
    }
    for (var typeName in originalTypeMap) {
        if (!typeName.startsWith('__') && !(typeName in actualNamedTypeMap)) {
            delete originalTypeMap[typeName];
        }
    }
    function healNamedType(type) {
        if (isObjectType(type)) {
            healFields(type);
            healInterfaces(type);
            return;
        }
        else if (isInterfaceType(type)) {
            healFields(type);
            if ('getInterfaces' in type) {
                healInterfaces(type);
            }
            return;
        }
        else if (isUnionType(type)) {
            healUnderlyingTypes(type);
            return;
        }
        else if (isInputObjectType(type)) {
            healInputFields(type);
            return;
        }
        else if (isLeafType(type)) {
            return;
        }
        throw new Error("Unexpected schema type: " + type);
    }
    function healFields(type) {
        var e_2, _a;
        var fieldMap = type.getFields();
        try {
            for (var _b = __values(Object.entries(fieldMap)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), key = _d[0], field = _d[1];
                field.args
                    .map(function (arg) {
                    arg.type = healType(arg.type);
                    return arg.type === null ? null : arg;
                })
                    .filter(Boolean);
                field.type = healType(field.type);
                if (field.type === null) {
                    delete fieldMap[key];
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    function healInterfaces(type) {
        if ('getInterfaces' in type) {
            var interfaces = type.getInterfaces();
            interfaces.push.apply(interfaces, __spreadArray([], __read(interfaces
                .splice(0)
                .map(function (iface) { return healType(iface); })
                .filter(Boolean)), false));
        }
    }
    function healInputFields(type) {
        var e_3, _a;
        var fieldMap = type.getFields();
        try {
            for (var _b = __values(Object.entries(fieldMap)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), key = _d[0], field = _d[1];
                field.type = healType(field.type);
                if (field.type === null) {
                    delete fieldMap[key];
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
    }
    function healUnderlyingTypes(type) {
        var types = type.getTypes();
        types.push.apply(types, __spreadArray([], __read(types
            .splice(0)
            .map(function (t) { return healType(t); })
            .filter(Boolean)), false));
    }
    function healType(type) {
        // Unwrap the two known wrapper types
        if (isListType(type)) {
            var healedType = healType(type.ofType);
            return healedType != null ? new GraphQLList(healedType) : null;
        }
        else if (isNonNullType(type)) {
            var healedType = healType(type.ofType);
            return healedType != null ? new GraphQLNonNull(healedType) : null;
        }
        else if (isNamedType(type)) {
            // If a type annotation on a field or an argument or a union member is
            // any `GraphQLNamedType` with a `name`, then it must end up identical
            // to `schema.getType(name)`, since `schema.getTypeMap()` is the source
            // of truth for all named schema types.
            // Note that new types can still be simply added by adding a field, as
            // the official type will be undefined, not null.
            var officialType = originalTypeMap[type.name];
            if (officialType && type !== officialType) {
                return officialType;
            }
        }
        return type;
    }
}

function getResolversFromSchema(schema) {
    var e_1, _a;
    var _b, _c;
    var resolvers = Object.create(null);
    var typeMap = schema.getTypeMap();
    for (var typeName in typeMap) {
        if (!typeName.startsWith('__')) {
            var type = typeMap[typeName];
            if (isScalarType(type)) {
                if (!isSpecifiedScalarType(type)) {
                    var config = type.toConfig();
                    delete config.astNode; // avoid AST duplication elsewhere
                    resolvers[typeName] = new GraphQLScalarType(config);
                }
            }
            else if (isEnumType(type)) {
                resolvers[typeName] = {};
                var values = type.getValues();
                try {
                    for (var values_1 = (e_1 = void 0, __values(values)), values_1_1 = values_1.next(); !values_1_1.done; values_1_1 = values_1.next()) {
                        var value = values_1_1.value;
                        resolvers[typeName][value.name] = value.value;
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (values_1_1 && !values_1_1.done && (_a = values_1.return)) _a.call(values_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            else if (isInterfaceType(type)) {
                if (type.resolveType != null) {
                    resolvers[typeName] = {
                        __resolveType: type.resolveType,
                    };
                }
            }
            else if (isUnionType(type)) {
                if (type.resolveType != null) {
                    resolvers[typeName] = {
                        __resolveType: type.resolveType,
                    };
                }
            }
            else if (isObjectType(type)) {
                resolvers[typeName] = {};
                if (type.isTypeOf != null) {
                    resolvers[typeName].__isTypeOf = type.isTypeOf;
                }
                var fields = type.getFields();
                for (var fieldName in fields) {
                    var field = fields[fieldName];
                    if (field.subscribe != null) {
                        resolvers[typeName][fieldName] = resolvers[typeName][fieldName] || {};
                        resolvers[typeName][fieldName].subscribe = field.subscribe;
                    }
                    if (field.resolve != null &&
                        ((_b = field.resolve) === null || _b === void 0 ? void 0 : _b.name) !== 'defaultFieldResolver' &&
                        ((_c = field.resolve) === null || _c === void 0 ? void 0 : _c.name) !== 'defaultMergedResolver') {
                        resolvers[typeName][fieldName] = resolvers[typeName][fieldName] || {};
                        resolvers[typeName][fieldName].resolve = field.resolve;
                    }
                }
            }
        }
    }
    return resolvers;
}

function forEachField(schema, fn) {
    var typeMap = schema.getTypeMap();
    for (var typeName in typeMap) {
        var type = typeMap[typeName];
        // TODO: maybe have an option to include these?
        if (!getNamedType(type).name.startsWith('__') && isObjectType(type)) {
            var fields = type.getFields();
            for (var fieldName in fields) {
                var field = fields[fieldName];
                fn(field, typeName, fieldName);
            }
        }
    }
}

function forEachDefaultValue(schema, fn) {
    var e_1, _a;
    var typeMap = schema.getTypeMap();
    for (var typeName in typeMap) {
        var type = typeMap[typeName];
        if (!getNamedType(type).name.startsWith('__')) {
            if (isObjectType(type)) {
                var fields = type.getFields();
                for (var fieldName in fields) {
                    var field = fields[fieldName];
                    try {
                        for (var _b = (e_1 = void 0, __values(field.args)), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var arg = _c.value;
                            arg.defaultValue = fn(arg.type, arg.defaultValue);
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                }
            }
            else if (isInputObjectType(type)) {
                var fields = type.getFields();
                for (var fieldName in fields) {
                    var field = fields[fieldName];
                    field.defaultValue = fn(field.type, field.defaultValue);
                }
            }
        }
    }
}

// addTypes uses toConfig to create a new schema with a new or replaced
function addTypes(schema, newTypesOrDirectives) {
    var e_1, _a, e_2, _b, e_3, _c;
    var config = schema.toConfig();
    var originalTypeMap = {};
    try {
        for (var _d = __values(config.types), _e = _d.next(); !_e.done; _e = _d.next()) {
            var type = _e.value;
            originalTypeMap[type.name] = type;
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var originalDirectiveMap = {};
    try {
        for (var _f = __values(config.directives), _g = _f.next(); !_g.done; _g = _f.next()) {
            var directive = _g.value;
            originalDirectiveMap[directive.name] = directive;
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
        }
        finally { if (e_2) throw e_2.error; }
    }
    try {
        for (var newTypesOrDirectives_1 = __values(newTypesOrDirectives), newTypesOrDirectives_1_1 = newTypesOrDirectives_1.next(); !newTypesOrDirectives_1_1.done; newTypesOrDirectives_1_1 = newTypesOrDirectives_1.next()) {
            var newTypeOrDirective = newTypesOrDirectives_1_1.value;
            if (isNamedType(newTypeOrDirective)) {
                originalTypeMap[newTypeOrDirective.name] = newTypeOrDirective;
            }
            else if (isDirective(newTypeOrDirective)) {
                originalDirectiveMap[newTypeOrDirective.name] = newTypeOrDirective;
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (newTypesOrDirectives_1_1 && !newTypesOrDirectives_1_1.done && (_c = newTypesOrDirectives_1.return)) _c.call(newTypesOrDirectives_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    var _h = rewireTypes(originalTypeMap, Object.values(originalDirectiveMap)), typeMap = _h.typeMap, directives = _h.directives;
    return new GraphQLSchema(__assign(__assign({}, config), { query: getObjectTypeFromTypeMap(typeMap, schema.getQueryType()), mutation: getObjectTypeFromTypeMap(typeMap, schema.getMutationType()), subscription: getObjectTypeFromTypeMap(typeMap, schema.getSubscriptionType()), types: Object.values(typeMap), directives: directives }));
}

/**
 * Prunes the provided schema, removing unused and empty types
 * @param schema The schema to prune
 * @param options Additional options for removing unused types from the schema
 */
function pruneSchema(schema, options) {
    var e_1, _a, _b;
    if (options === void 0) { options = {}; }
    var pruningContext = {
        schema: schema,
        unusedTypes: Object.create(null),
        implementations: Object.create(null),
    };
    for (var typeName in schema.getTypeMap()) {
        var type = schema.getType(typeName);
        if (type && 'getInterfaces' in type) {
            try {
                for (var _c = (e_1 = void 0, __values(type.getInterfaces())), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var iface = _d.value;
                    var implementations = getImplementations(pruningContext, iface);
                    if (implementations == null) {
                        pruningContext.implementations[iface.name] = Object.create(null);
                    }
                    pruningContext.implementations[iface.name][type.name] = true;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    }
    visitTypes(pruningContext, schema);
    return mapSchema(schema, (_b = {},
        _b[MapperKind.TYPE] = function (type) {
            // If we should NOT prune the type, return it immediately as unmodified
            if (options.skipPruning && options.skipPruning(type)) {
                return type;
            }
            if (isObjectType(type) || isInputObjectType(type)) {
                if ((!Object.keys(type.getFields()).length && !options.skipEmptyCompositeTypePruning) ||
                    (pruningContext.unusedTypes[type.name] && !options.skipUnusedTypesPruning)) {
                    return null;
                }
            }
            else if (isUnionType(type)) {
                if ((!type.getTypes().length && !options.skipEmptyUnionPruning) ||
                    (pruningContext.unusedTypes[type.name] && !options.skipUnusedTypesPruning)) {
                    return null;
                }
            }
            else if (isInterfaceType(type)) {
                var implementations = getImplementations(pruningContext, type);
                if ((!Object.keys(type.getFields()).length && !options.skipEmptyCompositeTypePruning) ||
                    (implementations && !Object.keys(implementations).length && !options.skipUnimplementedInterfacesPruning) ||
                    (pruningContext.unusedTypes[type.name] && !options.skipUnusedTypesPruning)) {
                    return null;
                }
            }
            else {
                if (pruningContext.unusedTypes[type.name] && !options.skipUnusedTypesPruning) {
                    return null;
                }
            }
        },
        _b));
}
function visitOutputType(visitedTypes, pruningContext, type) {
    var e_2, _a, e_3, _b, e_4, _c;
    if (visitedTypes[type.name]) {
        return;
    }
    visitedTypes[type.name] = true;
    pruningContext.unusedTypes[type.name] = false;
    if (isObjectType(type) || isInterfaceType(type)) {
        var fields = type.getFields();
        for (var fieldName in fields) {
            var field = fields[fieldName];
            var namedType = getNamedType(field.type);
            visitOutputType(visitedTypes, pruningContext, namedType);
            try {
                for (var _d = (e_2 = void 0, __values(field.args)), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var arg = _e.value;
                    var type_1 = getNamedType(arg.type);
                    visitInputType(visitedTypes, pruningContext, type_1);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        if (isInterfaceType(type)) {
            var implementations = getImplementations(pruningContext, type);
            if (implementations) {
                for (var typeName in implementations) {
                    visitOutputType(visitedTypes, pruningContext, pruningContext.schema.getType(typeName));
                }
            }
        }
        if ('getInterfaces' in type) {
            try {
                for (var _f = __values(type.getInterfaces()), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var iFace = _g.value;
                    visitOutputType(visitedTypes, pruningContext, iFace);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    else if (isUnionType(type)) {
        var types = type.getTypes();
        try {
            for (var types_1 = __values(types), types_1_1 = types_1.next(); !types_1_1.done; types_1_1 = types_1.next()) {
                var type_2 = types_1_1.value;
                visitOutputType(visitedTypes, pruningContext, type_2);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (types_1_1 && !types_1_1.done && (_c = types_1.return)) _c.call(types_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
    }
}
/**
 * Get the implementations of an interface. May return undefined.
 */
function getImplementations(pruningContext, type) {
    return pruningContext.implementations[type.name];
}
function visitInputType(visitedTypes, pruningContext, type) {
    if (visitedTypes[type.name]) {
        return;
    }
    pruningContext.unusedTypes[type.name] = false;
    visitedTypes[type.name] = true;
    if (isInputObjectType(type)) {
        var fields = type.getFields();
        for (var fieldName in fields) {
            var field = fields[fieldName];
            var namedType = getNamedType(field.type);
            visitInputType(visitedTypes, pruningContext, namedType);
        }
    }
}
function visitTypes(pruningContext, schema) {
    var e_5, _a, e_6, _b, e_7, _c;
    for (var typeName in schema.getTypeMap()) {
        if (!typeName.startsWith('__')) {
            pruningContext.unusedTypes[typeName] = true;
        }
    }
    var visitedTypes = Object.create(null);
    var rootTypes = getRootTypes(schema);
    try {
        for (var rootTypes_1 = __values(rootTypes), rootTypes_1_1 = rootTypes_1.next(); !rootTypes_1_1.done; rootTypes_1_1 = rootTypes_1.next()) {
            var rootType = rootTypes_1_1.value;
            visitOutputType(visitedTypes, pruningContext, rootType);
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (rootTypes_1_1 && !rootTypes_1_1.done && (_a = rootTypes_1.return)) _a.call(rootTypes_1);
        }
        finally { if (e_5) throw e_5.error; }
    }
    try {
        for (var _d = __values(schema.getDirectives()), _e = _d.next(); !_e.done; _e = _d.next()) {
            var directive = _e.value;
            try {
                for (var _f = (e_7 = void 0, __values(directive.args)), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var arg = _g.value;
                    var type = getNamedType(arg.type);
                    visitInputType(visitedTypes, pruningContext, type);
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                }
                finally { if (e_7) throw e_7.error; }
            }
        }
    }
    catch (e_6_1) { e_6 = { error: e_6_1 }; }
    finally {
        try {
            if (_e && !_e.done && (_b = _d.return)) _b.call(_d);
        }
        finally { if (e_6) throw e_6.error; }
    }
}

// eslint-disable-next-line @typescript-eslint/ban-types
function mergeDeep(sources, respectPrototype) {
    var e_1, _a, e_2, _b, _c, _d;
    if (respectPrototype === void 0) { respectPrototype = false; }
    var target = sources[0] || {};
    var output = {};
    if (respectPrototype) {
        Object.setPrototypeOf(output, Object.create(Object.getPrototypeOf(target)));
    }
    try {
        for (var sources_1 = __values(sources), sources_1_1 = sources_1.next(); !sources_1_1.done; sources_1_1 = sources_1.next()) {
            var source = sources_1_1.value;
            if (isObject(target) && isObject(source)) {
                if (respectPrototype) {
                    var outputPrototype = Object.getPrototypeOf(output);
                    var sourcePrototype = Object.getPrototypeOf(source);
                    if (sourcePrototype) {
                        try {
                            for (var _e = (e_2 = void 0, __values(Object.getOwnPropertyNames(sourcePrototype))), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var key = _f.value;
                                var descriptor = Object.getOwnPropertyDescriptor(sourcePrototype, key);
                                if (isSome(descriptor)) {
                                    Object.defineProperty(outputPrototype, key, descriptor);
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                }
                for (var key in source) {
                    if (isObject(source[key])) {
                        if (!(key in output)) {
                            Object.assign(output, (_c = {}, _c[key] = source[key], _c));
                        }
                        else {
                            output[key] = mergeDeep([output[key], source[key]], respectPrototype);
                        }
                    }
                    else {
                        Object.assign(output, (_d = {}, _d[key] = source[key], _d));
                    }
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (sources_1_1 && !sources_1_1.done && (_a = sources_1.return)) _a.call(sources_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return output;
}
function isObject(item) {
    return item && typeof item === 'object' && !Array.isArray(item);
}

function parseSelectionSet(selectionSet, options) {
    var query = parse(selectionSet, options).definitions[0];
    return query.selectionSet;
}

/**
 * Get the key under which the result of this resolver will be placed in the response JSON. Basically, just
 * resolves aliases.
 * @param info The info argument to the resolver.
 */
function getResponseKeyFromInfo(info) {
    return info.fieldNodes[0].alias != null ? info.fieldNodes[0].alias.value : info.fieldName;
}

function appendObjectFields(schema, typeName, additionalFields) {
    var _a;
    if (schema.getType(typeName) == null) {
        return addTypes(schema, [
            new GraphQLObjectType({
                name: typeName,
                fields: additionalFields,
            }),
        ]);
    }
    return mapSchema(schema, (_a = {},
        _a[MapperKind.OBJECT_TYPE] = function (type) {
            if (type.name === typeName) {
                var config = type.toConfig();
                var originalFieldConfigMap = config.fields;
                var newFieldConfigMap = {};
                for (var fieldName in originalFieldConfigMap) {
                    newFieldConfigMap[fieldName] = originalFieldConfigMap[fieldName];
                }
                for (var fieldName in additionalFields) {
                    newFieldConfigMap[fieldName] = additionalFields[fieldName];
                }
                return correctASTNodes(new GraphQLObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap })));
            }
        },
        _a));
}
function removeObjectFields(schema, typeName, testFn) {
    var _a;
    var removedFields = {};
    var newSchema = mapSchema(schema, (_a = {},
        _a[MapperKind.OBJECT_TYPE] = function (type) {
            if (type.name === typeName) {
                var config = type.toConfig();
                var originalFieldConfigMap = config.fields;
                var newFieldConfigMap = {};
                for (var fieldName in originalFieldConfigMap) {
                    var originalFieldConfig = originalFieldConfigMap[fieldName];
                    if (testFn(fieldName, originalFieldConfig)) {
                        removedFields[fieldName] = originalFieldConfig;
                    }
                    else {
                        newFieldConfigMap[fieldName] = originalFieldConfig;
                    }
                }
                return correctASTNodes(new GraphQLObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap })));
            }
        },
        _a));
    return [newSchema, removedFields];
}
function selectObjectFields(schema, typeName, testFn) {
    var _a;
    var selectedFields = {};
    mapSchema(schema, (_a = {},
        _a[MapperKind.OBJECT_TYPE] = function (type) {
            if (type.name === typeName) {
                var config = type.toConfig();
                var originalFieldConfigMap = config.fields;
                for (var fieldName in originalFieldConfigMap) {
                    var originalFieldConfig = originalFieldConfigMap[fieldName];
                    if (testFn(fieldName, originalFieldConfig)) {
                        selectedFields[fieldName] = originalFieldConfig;
                    }
                }
            }
            return undefined;
        },
        _a));
    return selectedFields;
}
function modifyObjectFields(schema, typeName, testFn, newFields) {
    var _a;
    var removedFields = {};
    var newSchema = mapSchema(schema, (_a = {},
        _a[MapperKind.OBJECT_TYPE] = function (type) {
            if (type.name === typeName) {
                var config = type.toConfig();
                var originalFieldConfigMap = config.fields;
                var newFieldConfigMap = {};
                for (var fieldName in originalFieldConfigMap) {
                    var originalFieldConfig = originalFieldConfigMap[fieldName];
                    if (testFn(fieldName, originalFieldConfig)) {
                        removedFields[fieldName] = originalFieldConfig;
                    }
                    else {
                        newFieldConfigMap[fieldName] = originalFieldConfig;
                    }
                }
                for (var fieldName in newFields) {
                    var fieldConfig = newFields[fieldName];
                    newFieldConfigMap[fieldName] = fieldConfig;
                }
                return correctASTNodes(new GraphQLObjectType(__assign(__assign({}, config), { fields: newFieldConfigMap })));
            }
        },
        _a));
    return [newSchema, removedFields];
}

function renameType(type, newTypeName) {
    if (isObjectType(type)) {
        return new GraphQLObjectType(__assign(__assign({}, type.toConfig()), { name: newTypeName, astNode: type.astNode == null
                ? type.astNode
                : __assign(__assign({}, type.astNode), { name: __assign(__assign({}, type.astNode.name), { value: newTypeName }) }), extensionASTNodes: type.extensionASTNodes == null
                ? type.extensionASTNodes
                : type.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { name: __assign(__assign({}, node.name), { value: newTypeName }) })); }) }));
    }
    else if (isInterfaceType(type)) {
        return new GraphQLInterfaceType(__assign(__assign({}, type.toConfig()), { name: newTypeName, astNode: type.astNode == null
                ? type.astNode
                : __assign(__assign({}, type.astNode), { name: __assign(__assign({}, type.astNode.name), { value: newTypeName }) }), extensionASTNodes: type.extensionASTNodes == null
                ? type.extensionASTNodes
                : type.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { name: __assign(__assign({}, node.name), { value: newTypeName }) })); }) }));
    }
    else if (isUnionType(type)) {
        return new GraphQLUnionType(__assign(__assign({}, type.toConfig()), { name: newTypeName, astNode: type.astNode == null
                ? type.astNode
                : __assign(__assign({}, type.astNode), { name: __assign(__assign({}, type.astNode.name), { value: newTypeName }) }), extensionASTNodes: type.extensionASTNodes == null
                ? type.extensionASTNodes
                : type.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { name: __assign(__assign({}, node.name), { value: newTypeName }) })); }) }));
    }
    else if (isInputObjectType(type)) {
        return new GraphQLInputObjectType(__assign(__assign({}, type.toConfig()), { name: newTypeName, astNode: type.astNode == null
                ? type.astNode
                : __assign(__assign({}, type.astNode), { name: __assign(__assign({}, type.astNode.name), { value: newTypeName }) }), extensionASTNodes: type.extensionASTNodes == null
                ? type.extensionASTNodes
                : type.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { name: __assign(__assign({}, node.name), { value: newTypeName }) })); }) }));
    }
    else if (isEnumType(type)) {
        return new GraphQLEnumType(__assign(__assign({}, type.toConfig()), { name: newTypeName, astNode: type.astNode == null
                ? type.astNode
                : __assign(__assign({}, type.astNode), { name: __assign(__assign({}, type.astNode.name), { value: newTypeName }) }), extensionASTNodes: type.extensionASTNodes == null
                ? type.extensionASTNodes
                : type.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { name: __assign(__assign({}, node.name), { value: newTypeName }) })); }) }));
    }
    else if (isScalarType(type)) {
        return new GraphQLScalarType(__assign(__assign({}, type.toConfig()), { name: newTypeName, astNode: type.astNode == null
                ? type.astNode
                : __assign(__assign({}, type.astNode), { name: __assign(__assign({}, type.astNode.name), { value: newTypeName }) }), extensionASTNodes: type.extensionASTNodes == null
                ? type.extensionASTNodes
                : type.extensionASTNodes.map(function (node) { return (__assign(__assign({}, node), { name: __assign(__assign({}, node.name), { value: newTypeName }) })); }) }));
    }
    throw new Error("Unknown type " + type + ".");
}

/**
 * Given an AsyncIterable and a callback function, return an AsyncIterator
 * which produces values mapped via calling the callback function.
 */
function mapAsyncIterator(iterator, callback, rejectCallback) {
    var _a;
    var $return;
    var abruptClose;
    if (typeof iterator.return === 'function') {
        $return = iterator.return;
        abruptClose = function (error) {
            var rethrow = function () { return Promise.reject(error); };
            return $return.call(iterator).then(rethrow, rethrow);
        };
    }
    function mapResult(result) {
        return result.done ? result : asyncMapValue(result.value, callback).then(iteratorResult, abruptClose);
    }
    var mapReject;
    if (rejectCallback) {
        // Capture rejectCallback to ensure it cannot be null.
        var reject_1 = rejectCallback;
        mapReject = function (error) { return asyncMapValue(error, reject_1).then(iteratorResult, abruptClose); };
    }
    return _a = {
            next: function () {
                return iterator.next().then(mapResult, mapReject);
            },
            return: function () {
                return $return
                    ? $return.call(iterator).then(mapResult, mapReject)
                    : Promise.resolve({ value: undefined, done: true });
            },
            throw: function (error) {
                if (typeof iterator.throw === 'function') {
                    return iterator.throw(error).then(mapResult, mapReject);
                }
                return Promise.reject(error).catch(abruptClose);
            }
        },
        _a[Symbol.asyncIterator] = function () {
            return this;
        },
        _a;
}
function asyncMapValue(value, callback) {
    return new Promise(function (resolve) { return resolve(callback(value)); });
}
function iteratorResult(value) {
    return { value: value, done: false };
}

function updateArgument(argumentNodes, variableDefinitionsMap, variableValues, argName, varName, type, value) {
    argumentNodes[argName] = {
        kind: Kind.ARGUMENT,
        name: {
            kind: Kind.NAME,
            value: argName,
        },
        value: {
            kind: Kind.VARIABLE,
            name: {
                kind: Kind.NAME,
                value: varName,
            },
        },
    };
    variableDefinitionsMap[varName] = {
        kind: Kind.VARIABLE_DEFINITION,
        variable: {
            kind: Kind.VARIABLE,
            name: {
                kind: Kind.NAME,
                value: varName,
            },
        },
        type: astFromType(type),
    };
    if (value !== undefined) {
        variableValues[varName] = value;
        return;
    }
    // including the variable in the map with value of `undefined`
    // will actually be translated by graphql-js into `null`
    // see https://github.com/graphql/graphql-js/issues/2533
    if (varName in variableValues) {
        delete variableValues[varName];
    }
}
function createVariableNameGenerator(variableDefinitionMap) {
    var varCounter = 0;
    return function (argName) {
        var varName;
        do {
            varName = "_v" + (varCounter++).toString() + "_" + argName;
        } while (varName in variableDefinitionMap);
        return varName;
    };
}

function implementsAbstractType(schema, typeA, typeB) {
    if (typeB == null || typeA == null) {
        return false;
    }
    else if (typeA === typeB) {
        return true;
    }
    else if (isCompositeType(typeA) && isCompositeType(typeB)) {
        return doTypesOverlap(schema, typeA, typeB);
    }
    return false;
}

function relocatedError(originalError, path) {
    return new GraphQLError(originalError.message, originalError.nodes, originalError.source, originalError.positions, path === null ? undefined : path === undefined ? originalError.path : path, originalError.originalError, originalError.extensions);
}

function observableToAsyncIterable(observable) {
    var _a;
    var pullQueue = [];
    var pushQueue = [];
    var listening = true;
    var pushValue = function (value) {
        if (pullQueue.length !== 0) {
            // It is safe to use the ! operator here as we check the length.
            pullQueue.shift()({ value: value, done: false });
        }
        else {
            pushQueue.push({ value: value, done: false });
        }
    };
    var pushError = function (error) {
        if (pullQueue.length !== 0) {
            // It is safe to use the ! operator here as we check the length.
            pullQueue.shift()({ value: { errors: [error] }, done: false });
        }
        else {
            pushQueue.push({ value: { errors: [error] }, done: false });
        }
    };
    var pushDone = function () {
        if (pullQueue.length !== 0) {
            // It is safe to use the ! operator here as we check the length.
            pullQueue.shift()({ done: true });
        }
        else {
            pushQueue.push({ done: true });
        }
    };
    var pullValue = function () {
        return new Promise(function (resolve) {
            if (pushQueue.length !== 0) {
                var element = pushQueue.shift();
                // either {value: {errors: [...]}} or {value: ...}
                resolve(element);
            }
            else {
                pullQueue.push(resolve);
            }
        });
    };
    var subscription = observable.subscribe({
        next: function (value) {
            pushValue(value);
        },
        error: function (err) {
            pushError(err);
        },
        complete: function () {
            pushDone();
        },
    });
    var emptyQueue = function () {
        var e_1, _a;
        if (listening) {
            listening = false;
            subscription.unsubscribe();
            try {
                for (var pullQueue_1 = __values(pullQueue), pullQueue_1_1 = pullQueue_1.next(); !pullQueue_1_1.done; pullQueue_1_1 = pullQueue_1.next()) {
                    var resolve = pullQueue_1_1.value;
                    resolve({ value: undefined, done: true });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (pullQueue_1_1 && !pullQueue_1_1.done && (_a = pullQueue_1.return)) _a.call(pullQueue_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            pullQueue.length = 0;
            pushQueue.length = 0;
        }
    };
    return _a = {
            next: function () {
                // return is a defined method, so it is safe to call it.
                return listening ? pullValue() : this.return();
            },
            return: function () {
                emptyQueue();
                return Promise.resolve({ value: undefined, done: true });
            },
            throw: function (error) {
                emptyQueue();
                return Promise.reject(error);
            }
        },
        _a[Symbol.asyncIterator] = function () {
            return this;
        },
        _a;
}

// Taken from GraphQL-JS v16 for backwards compat
function collectFields(schema, fragments, variableValues, runtimeType, selectionSet, fields, visitedFragmentNames) {
    var e_1, _a;
    try {
        for (var _b = __values(selectionSet.selections), _c = _b.next(); !_c.done; _c = _b.next()) {
            var selection = _c.value;
            switch (selection.kind) {
                case Kind.FIELD: {
                    if (!shouldIncludeNode(variableValues, selection)) {
                        continue;
                    }
                    var name_1 = getFieldEntryKey(selection);
                    var fieldList = fields.get(name_1);
                    if (fieldList !== undefined) {
                        fieldList.push(selection);
                    }
                    else {
                        fields.set(name_1, [selection]);
                    }
                    break;
                }
                case Kind.INLINE_FRAGMENT: {
                    if (!shouldIncludeNode(variableValues, selection) ||
                        !doesFragmentConditionMatch(schema, selection, runtimeType)) {
                        continue;
                    }
                    collectFields(schema, fragments, variableValues, runtimeType, selection.selectionSet, fields, visitedFragmentNames);
                    break;
                }
                case Kind.FRAGMENT_SPREAD: {
                    var fragName = selection.name.value;
                    if (visitedFragmentNames.has(fragName) || !shouldIncludeNode(variableValues, selection)) {
                        continue;
                    }
                    visitedFragmentNames.add(fragName);
                    var fragment = fragments[fragName];
                    if (!fragment || !doesFragmentConditionMatch(schema, fragment, runtimeType)) {
                        continue;
                    }
                    collectFields(schema, fragments, variableValues, runtimeType, fragment.selectionSet, fields, visitedFragmentNames);
                    break;
                }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return fields;
}
/**
 * Determines if a field should be included based on the `@include` and `@skip`
 * directives, where `@skip` has higher precedence than `@include`.
 */
function shouldIncludeNode(variableValues, node) {
    var skip = getDirectiveValues(GraphQLSkipDirective, node, variableValues);
    if ((skip === null || skip === void 0 ? void 0 : skip['if']) === true) {
        return false;
    }
    var include = getDirectiveValues(GraphQLIncludeDirective, node, variableValues);
    if ((include === null || include === void 0 ? void 0 : include['if']) === false) {
        return false;
    }
    return true;
}
/**
 * Determines if a fragment is applicable to the given type.
 */
function doesFragmentConditionMatch(schema, fragment, type) {
    var typeConditionNode = fragment.typeCondition;
    if (!typeConditionNode) {
        return true;
    }
    var conditionalType = typeFromAST(schema, typeConditionNode);
    if (conditionalType === type) {
        return true;
    }
    if (isAbstractType(conditionalType)) {
        var possibleTypes = schema.getPossibleTypes(conditionalType);
        return possibleTypes.includes(type);
    }
    return false;
}
/**
 * Implements the logic to compute the key of a given field's entry
 */
function getFieldEntryKey(node) {
    return node.alias ? node.alias.value : node.name.value;
}
var collectSubFields = memoize5(function collectSubFields(schema, fragments, variableValues, type, fieldNodes) {
    var e_2, _a;
    var subFieldNodes = new Map();
    var visitedFragmentNames = new Set();
    try {
        for (var fieldNodes_1 = __values(fieldNodes), fieldNodes_1_1 = fieldNodes_1.next(); !fieldNodes_1_1.done; fieldNodes_1_1 = fieldNodes_1.next()) {
            var fieldNode = fieldNodes_1_1.value;
            if (fieldNode.selectionSet) {
                collectFields(schema, fragments, variableValues, type, fieldNode.selectionSet, subFieldNodes, visitedFragmentNames);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (fieldNodes_1_1 && !fieldNodes_1_1.done && (_a = fieldNodes_1.return)) _a.call(fieldNodes_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return subFieldNodes;
});

function visitData(data, enter, leave) {
    if (Array.isArray(data)) {
        return data.map(function (value) { return visitData(value, enter, leave); });
    }
    else if (typeof data === 'object') {
        var newData = enter != null ? enter(data) : data;
        if (newData != null) {
            for (var key in newData) {
                var value = newData[key];
                newData[key] = visitData(value, enter, leave);
            }
        }
        return leave != null ? leave(newData) : newData;
    }
    return data;
}
function visitErrors(errors, visitor) {
    return errors.map(function (error) { return visitor(error); });
}
function visitResult(result, request, schema, resultVisitorMap, errorVisitorMap) {
    var fragments = request.document.definitions.reduce(function (acc, def) {
        if (def.kind === Kind.FRAGMENT_DEFINITION) {
            acc[def.name.value] = def;
        }
        return acc;
    }, {});
    var variableValues = request.variables || {};
    var errorInfo = {
        segmentInfoMap: new Map(),
        unpathedErrors: new Set(),
    };
    var data = result.data;
    var errors = result.errors;
    var visitingErrors = errors != null && errorVisitorMap != null;
    var operationDocumentNode = getOperationAST(request.document, undefined);
    if (data != null && operationDocumentNode != null) {
        result.data = visitRoot(data, operationDocumentNode, schema, fragments, variableValues, resultVisitorMap, visitingErrors ? errors : undefined, errorInfo);
    }
    if (errors != null && errorVisitorMap) {
        result.errors = visitErrorsByType(errors, errorVisitorMap, errorInfo);
    }
    return result;
}
function visitErrorsByType(errors, errorVisitorMap, errorInfo) {
    var segmentInfoMap = errorInfo.segmentInfoMap;
    var unpathedErrors = errorInfo.unpathedErrors;
    var unpathedErrorVisitor = errorVisitorMap['__unpathed'];
    return errors.map(function (originalError) {
        var pathSegmentsInfo = segmentInfoMap.get(originalError);
        var newError = pathSegmentsInfo == null
            ? originalError
            : pathSegmentsInfo.reduceRight(function (acc, segmentInfo) {
                var typeName = segmentInfo.type.name;
                var typeVisitorMap = errorVisitorMap[typeName];
                if (typeVisitorMap == null) {
                    return acc;
                }
                var errorVisitor = typeVisitorMap[segmentInfo.fieldName];
                return errorVisitor == null ? acc : errorVisitor(acc, segmentInfo.pathIndex);
            }, originalError);
        if (unpathedErrorVisitor && unpathedErrors.has(originalError)) {
            return unpathedErrorVisitor(newError);
        }
        return newError;
    });
}
function visitRoot(root, operation, schema, fragments, variableValues, resultVisitorMap, errors, errorInfo) {
    var operationRootType = getOperationRootType(schema, operation);
    var collectedFields = collectFields(schema, fragments, variableValues, operationRootType, operation.selectionSet, new Map(), new Set());
    return visitObjectValue(root, operationRootType, collectedFields, schema, fragments, variableValues, resultVisitorMap, 0, errors, errorInfo);
}
function visitObjectValue(object, type, fieldNodeMap, schema, fragments, variableValues, resultVisitorMap, pathIndex, errors, errorInfo) {
    var e_1, _a, e_2, _b, e_3, _c;
    var fieldMap = type.getFields();
    var typeVisitorMap = resultVisitorMap === null || resultVisitorMap === void 0 ? void 0 : resultVisitorMap[type.name];
    var enterObject = typeVisitorMap === null || typeVisitorMap === void 0 ? void 0 : typeVisitorMap.__enter;
    var newObject = enterObject != null ? enterObject(object) : object;
    var sortedErrors;
    var errorMap = null;
    if (errors != null) {
        sortedErrors = sortErrorsByPathSegment(errors, pathIndex);
        errorMap = sortedErrors.errorMap;
        try {
            for (var _d = __values(sortedErrors.unpathedErrors), _e = _d.next(); !_e.done; _e = _d.next()) {
                var error = _e.value;
                errorInfo.unpathedErrors.add(error);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    try {
        for (var fieldNodeMap_1 = __values(fieldNodeMap), fieldNodeMap_1_1 = fieldNodeMap_1.next(); !fieldNodeMap_1_1.done; fieldNodeMap_1_1 = fieldNodeMap_1.next()) {
            var _f = __read(fieldNodeMap_1_1.value, 2), responseKey = _f[0], subFieldNodes = _f[1];
            var fieldName = subFieldNodes[0].name.value;
            var fieldType = fieldName === '__typename' ? TypeNameMetaFieldDef.type : fieldMap[fieldName].type;
            var newPathIndex = pathIndex + 1;
            var fieldErrors = void 0;
            if (errorMap) {
                fieldErrors = errorMap[responseKey];
                if (fieldErrors != null) {
                    delete errorMap[responseKey];
                }
                addPathSegmentInfo(type, fieldName, newPathIndex, fieldErrors, errorInfo);
            }
            var newValue = visitFieldValue(object[responseKey], fieldType, subFieldNodes, schema, fragments, variableValues, resultVisitorMap, newPathIndex, fieldErrors, errorInfo);
            updateObject(newObject, responseKey, newValue, typeVisitorMap, fieldName);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (fieldNodeMap_1_1 && !fieldNodeMap_1_1.done && (_b = fieldNodeMap_1.return)) _b.call(fieldNodeMap_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    var oldTypename = newObject.__typename;
    if (oldTypename != null) {
        updateObject(newObject, '__typename', oldTypename, typeVisitorMap, '__typename');
    }
    if (errorMap) {
        for (var errorsKey in errorMap) {
            var errors_2 = errorMap[errorsKey];
            try {
                for (var errors_1 = (e_3 = void 0, __values(errors_2)), errors_1_1 = errors_1.next(); !errors_1_1.done; errors_1_1 = errors_1.next()) {
                    var error = errors_1_1.value;
                    errorInfo.unpathedErrors.add(error);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (errors_1_1 && !errors_1_1.done && (_c = errors_1.return)) _c.call(errors_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    var leaveObject = typeVisitorMap === null || typeVisitorMap === void 0 ? void 0 : typeVisitorMap.__leave;
    return leaveObject != null ? leaveObject(newObject) : newObject;
}
function updateObject(object, responseKey, newValue, typeVisitorMap, fieldName) {
    if (typeVisitorMap == null) {
        object[responseKey] = newValue;
        return;
    }
    var fieldVisitor = typeVisitorMap[fieldName];
    if (fieldVisitor == null) {
        object[responseKey] = newValue;
        return;
    }
    var visitedValue = fieldVisitor(newValue);
    if (visitedValue === undefined) {
        delete object[responseKey];
        return;
    }
    object[responseKey] = visitedValue;
}
function visitListValue(list, returnType, fieldNodes, schema, fragments, variableValues, resultVisitorMap, pathIndex, errors, errorInfo) {
    return list.map(function (listMember) {
        return visitFieldValue(listMember, returnType, fieldNodes, schema, fragments, variableValues, resultVisitorMap, pathIndex + 1, errors, errorInfo);
    });
}
function visitFieldValue(value, returnType, fieldNodes, schema, fragments, variableValues, resultVisitorMap, pathIndex, errors, errorInfo) {
    if (errors === void 0) { errors = []; }
    if (value == null) {
        return value;
    }
    var nullableType = getNullableType(returnType);
    if (isListType(nullableType)) {
        return visitListValue(value, nullableType.ofType, fieldNodes, schema, fragments, variableValues, resultVisitorMap, pathIndex, errors, errorInfo);
    }
    else if (isAbstractType(nullableType)) {
        var finalType = schema.getType(value.__typename);
        var collectedFields = collectSubFields(schema, fragments, variableValues, finalType, fieldNodes);
        return visitObjectValue(value, finalType, collectedFields, schema, fragments, variableValues, resultVisitorMap, pathIndex, errors, errorInfo);
    }
    else if (isObjectType(nullableType)) {
        var collectedFields = collectSubFields(schema, fragments, variableValues, nullableType, fieldNodes);
        return visitObjectValue(value, nullableType, collectedFields, schema, fragments, variableValues, resultVisitorMap, pathIndex, errors, errorInfo);
    }
    var typeVisitorMap = resultVisitorMap === null || resultVisitorMap === void 0 ? void 0 : resultVisitorMap[nullableType.name];
    if (typeVisitorMap == null) {
        return value;
    }
    var visitedValue = typeVisitorMap(value);
    return visitedValue === undefined ? value : visitedValue;
}
function sortErrorsByPathSegment(errors, pathIndex) {
    var e_4, _a;
    var _b;
    var errorMap = Object.create(null);
    var unpathedErrors = new Set();
    try {
        for (var errors_3 = __values(errors), errors_3_1 = errors_3.next(); !errors_3_1.done; errors_3_1 = errors_3.next()) {
            var error = errors_3_1.value;
            var pathSegment = (_b = error.path) === null || _b === void 0 ? void 0 : _b[pathIndex];
            if (pathSegment == null) {
                unpathedErrors.add(error);
                continue;
            }
            if (pathSegment in errorMap) {
                errorMap[pathSegment].push(error);
            }
            else {
                errorMap[pathSegment] = [error];
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (errors_3_1 && !errors_3_1.done && (_a = errors_3.return)) _a.call(errors_3);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return {
        errorMap: errorMap,
        unpathedErrors: unpathedErrors,
    };
}
function addPathSegmentInfo(type, fieldName, pathIndex, errors, errorInfo) {
    var e_5, _a;
    if (errors === void 0) { errors = []; }
    try {
        for (var errors_4 = __values(errors), errors_4_1 = errors_4.next(); !errors_4_1.done; errors_4_1 = errors_4.next()) {
            var error = errors_4_1.value;
            var segmentInfo = {
                type: type,
                fieldName: fieldName,
                pathIndex: pathIndex,
            };
            var pathSegmentsInfo = errorInfo.segmentInfoMap.get(error);
            if (pathSegmentsInfo == null) {
                errorInfo.segmentInfoMap.set(error, [segmentInfo]);
            }
            else {
                pathSegmentsInfo.push(segmentInfo);
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (errors_4_1 && !errors_4_1.done && (_a = errors_4.return)) _a.call(errors_4);
        }
        finally { if (e_5) throw e_5.error; }
    }
}

function valueMatchesCriteria(value, criteria) {
    if (value == null) {
        return value === criteria;
    }
    else if (Array.isArray(value)) {
        return Array.isArray(criteria) && value.every(function (val, index) { return valueMatchesCriteria(val, criteria[index]); });
    }
    else if (typeof value === 'object') {
        return (typeof criteria === 'object' &&
            criteria &&
            Object.keys(criteria).every(function (propertyName) { return valueMatchesCriteria(value[propertyName], criteria[propertyName]); }));
    }
    else if (criteria instanceof RegExp) {
        return criteria.test(value);
    }
    return value === criteria;
}

function isAsyncIterable(value) {
    return typeof value === 'object' && value != null && Symbol.asyncIterator in value;
}

function isDocumentNode(object) {
    return object && typeof object === 'object' && 'kind' in object && object.kind === Kind.DOCUMENT;
}

function withCancel(asyncIteratorLike, onCancel) {
    var asyncIterator = asyncIteratorLike[Symbol.asyncIterator]();
    if (!asyncIterator.return) {
        asyncIterator.return = function () { return Promise.resolve({ value: undefined, done: true }); };
    }
    var savedReturn = asyncIterator.return.bind(asyncIterator);
    asyncIterator.return = function () {
        onCancel();
        return savedReturn();
    };
    return asyncIterator;
}

function buildFixedSchema(schema, options) {
    var document = getDocumentNodeFromSchema(schema);
    return buildASTSchema(document, __assign({}, (options || {})));
}
function fixSchemaAst(schema, options) {
    // eslint-disable-next-line no-undef-init
    var schemaWithValidAst = undefined;
    if (!schema.astNode || !schema.extensionASTNodes) {
        schemaWithValidAst = buildFixedSchema(schema, options);
    }
    if (!schema.astNode && (schemaWithValidAst === null || schemaWithValidAst === void 0 ? void 0 : schemaWithValidAst.astNode)) {
        schema.astNode = schemaWithValidAst.astNode;
    }
    if (!schema.extensionASTNodes && (schemaWithValidAst === null || schemaWithValidAst === void 0 ? void 0 : schemaWithValidAst.astNode)) {
        schema.extensionASTNodes = schemaWithValidAst.extensionASTNodes;
    }
    return schema;
}

export { AggregateErrorImpl as AggregateError, MapperKind, addTypes, appendObjectFields, asArray, assertSome, astFromArg, astFromDirective, astFromEnumType, astFromEnumValue, astFromField, astFromInputField, astFromInputObjectType, astFromInterfaceType, astFromObjectType, astFromScalarType, astFromSchema, astFromUnionType, astFromValueUntyped, buildOperationNodeForField, checkValidationErrors, collectComment, collectFields, collectSubFields, compareNodes, compareStrings, correctASTNodes, createNamedStub, createStub, createVariableNameGenerator, dedentBlockStringValue, filterSchema, fixSchemaAst, forEachDefaultValue, forEachField, getArgumentValues, getBlockStringIndentation, getBuiltInForStub, getComment, getDefinedRootType, getDeprecatableDirectiveNodes, getDescription, getDirective, getDirectiveInExtensions, getDirectiveNodes, getDirectives, getDirectivesInExtensions, getDocumentNodeFromSchema, getFieldsWithDirectives, getImplementingTypes, getLeadingCommentBlock, getResolversFromSchema, getResponseKeyFromInfo, getRootTypeMap, getRootTypeNames, getRootTypes, healSchema, healTypes, implementsAbstractType, inspect, isAsyncIterable, isDescribable, isDocumentNode, isDocumentString, isNamedStub, isSome, isValidPath, makeDeprecatedDirective, makeDirectiveNode, makeDirectiveNodes, mapAsyncIterator, mapSchema, memoize1, memoize2, memoize2of4, memoize3, memoize4, memoize5, mergeDeep, modifyObjectFields, nodeToString, observableToAsyncIterable, parseGraphQLJSON, parseGraphQLSDL, parseInputValue, parseInputValueLiteral, parseSelectionSet, printComment, printSchemaWithDirectives, printWithComments, pruneSchema, pushComment, relocatedError, removeObjectFields, renameType, resetComments, rewireTypes, selectObjectFields, serializeInputValue, transformCommentsToDescriptions, transformInputValue, updateArgument, validateGraphQlDocuments, valueMatchesCriteria, visitData, visitErrors, visitResult, withCancel };
