import { __values, __spreadArray, __read, __assign, __awaiter, __generator } from 'tslib';
import { Kind, isAbstractType, isInterfaceType, TypeInfo, visit, visitWithTypeInfo, getNamedType, isObjectType, versionInfo, TypeNameMetaFieldDef, responsePathAsArray, GraphQLError, locatedError, getNullableType, isCompositeType, isListType, typeFromAST, defaultFieldResolver, getOperationAST, validate, subscribe, execute } from 'graphql';
import { memoize2, implementsAbstractType, getRootTypeNames, getDefinedRootType, createVariableNameGenerator, updateArgument, serializeInputValue, inspect, collectFields, relocatedError, AggregateError, getResponseKeyFromInfo, isAsyncIterable, mapAsyncIterator, memoize1 } from '@graphql-tools/utils/es5';
import { ValueOrPromise } from 'value-or-promise';
import { getBatchingExecutor } from '@graphql-tools/batch-execute/es5';

function applySchemaTransforms(originalWrappingSchema, subschemaConfig, transformedSchema) {
    var schemaTransforms = subschemaConfig.transforms;
    if (schemaTransforms == null) {
        return originalWrappingSchema;
    }
    return schemaTransforms.reduce(function (schema, transform) {
        return transform.transformSchema != null
            ? transform.transformSchema(schema, subschemaConfig, transformedSchema)
            : schema;
    }, originalWrappingSchema);
}

function isSubschema(value) {
    return Boolean(value.transformedSchema);
}
var Subschema = /** @class */ (function () {
    function Subschema(config) {
        var _a;
        this.schema = config.schema;
        this.executor = config.executor;
        this.batch = config.batch;
        this.batchingOptions = config.batchingOptions;
        this.createProxyingResolver = config.createProxyingResolver;
        this.transforms = (_a = config.transforms) !== null && _a !== void 0 ? _a : [];
        this.transformedSchema = applySchemaTransforms(this.schema, config);
        this.merge = config.merge;
    }
    return Subschema;
}());

function getDocumentMetadata(document) {
    var operations = [];
    var fragments = [];
    var fragmentNames = new Set();
    for (var i = 0; i < document.definitions.length; i++) {
        var def = document.definitions[i];
        if (def.kind === Kind.FRAGMENT_DEFINITION) {
            fragments.push(def);
            fragmentNames.add(def.name.value);
        }
        else if (def.kind === Kind.OPERATION_DEFINITION) {
            operations.push(def);
        }
    }
    return {
        operations: operations,
        fragments: fragments,
        fragmentNames: fragmentNames,
    };
}

function prepareGatewayDocument(originalDocument, transformedSchema, returnType, infoSchema) {
    var _a;
    var wrappedConcreteTypesDocument = wrapConcreteTypes(returnType, transformedSchema, originalDocument);
    if (infoSchema == null) {
        return wrappedConcreteTypesDocument;
    }
    var _b = getSchemaMetaData(infoSchema, transformedSchema), possibleTypesMap = _b.possibleTypesMap, reversePossibleTypesMap = _b.reversePossibleTypesMap, interfaceExtensionsMap = _b.interfaceExtensionsMap, fieldNodesByType = _b.fieldNodesByType, fieldNodesByField = _b.fieldNodesByField, dynamicSelectionSetsByField = _b.dynamicSelectionSetsByField;
    var _c = getDocumentMetadata(wrappedConcreteTypesDocument), operations = _c.operations, fragments = _c.fragments, fragmentNames = _c.fragmentNames;
    var _d = getExpandedFragments(fragments, fragmentNames, possibleTypesMap), expandedFragments = _d.expandedFragments, fragmentReplacements = _d.fragmentReplacements;
    var typeInfo = new TypeInfo(transformedSchema);
    var expandedDocument = {
        kind: Kind.DOCUMENT,
        definitions: __spreadArray(__spreadArray(__spreadArray([], __read(operations), false), __read(fragments), false), __read(expandedFragments), false),
    };
    var visitorKeyMap = {
        Document: ['definitions'],
        OperationDefinition: ['selectionSet'],
        SelectionSet: ['selections'],
        Field: ['selectionSet'],
        InlineFragment: ['selectionSet'],
        FragmentDefinition: ['selectionSet'],
    };
    return visit(expandedDocument, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            return visitSelectionSet(node, fragmentReplacements, transformedSchema, typeInfo, possibleTypesMap, reversePossibleTypesMap, interfaceExtensionsMap, fieldNodesByType, fieldNodesByField, dynamicSelectionSetsByField);
        },
        _a)), 
    // visitorKeys argument usage a la https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
    // empty keys cannot be removed only because of typescript errors
    // will hopefully be fixed in future version of graphql-js to be optional
    visitorKeyMap);
}
function visitSelectionSet(node, fragmentReplacements, schema, typeInfo, possibleTypesMap, reversePossibleTypesMap, interfaceExtensionsMap, fieldNodesByType, fieldNodesByField, dynamicSelectionSetsByField) {
    var e_1, _a, e_2, _b, e_3, _c, e_4, _d, e_5, _e, e_6, _f, e_7, _g, e_8, _h;
    var _j, _k;
    var newSelections = new Set();
    var maybeType = typeInfo.getParentType();
    if (maybeType != null) {
        var parentType = getNamedType(maybeType);
        var parentTypeName = parentType.name;
        var fieldNodes = fieldNodesByType[parentTypeName];
        if (fieldNodes) {
            try {
                for (var fieldNodes_1 = __values(fieldNodes), fieldNodes_1_1 = fieldNodes_1.next(); !fieldNodes_1_1.done; fieldNodes_1_1 = fieldNodes_1.next()) {
                    var fieldNode = fieldNodes_1_1.value;
                    newSelections.add(fieldNode);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (fieldNodes_1_1 && !fieldNodes_1_1.done && (_a = fieldNodes_1.return)) _a.call(fieldNodes_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        var interfaceExtensions = interfaceExtensionsMap[parentType.name];
        var interfaceExtensionFields = [];
        try {
            for (var _l = __values(node.selections), _m = _l.next(); !_m.done; _m = _l.next()) {
                var selection = _m.value;
                if (selection.kind === Kind.INLINE_FRAGMENT) {
                    if (selection.typeCondition != null) {
                        var possibleTypes = possibleTypesMap[selection.typeCondition.name.value];
                        if (possibleTypes == null) {
                            newSelections.add(selection);
                            continue;
                        }
                        try {
                            for (var possibleTypes_1 = (e_3 = void 0, __values(possibleTypes)), possibleTypes_1_1 = possibleTypes_1.next(); !possibleTypes_1_1.done; possibleTypes_1_1 = possibleTypes_1.next()) {
                                var possibleTypeName = possibleTypes_1_1.value;
                                var maybePossibleType = schema.getType(possibleTypeName);
                                if (maybePossibleType != null && implementsAbstractType(schema, parentType, maybePossibleType)) {
                                    newSelections.add(generateInlineFragment(possibleTypeName, selection.selectionSet));
                                }
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (possibleTypes_1_1 && !possibleTypes_1_1.done && (_c = possibleTypes_1.return)) _c.call(possibleTypes_1);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                    }
                }
                else if (selection.kind === Kind.FRAGMENT_SPREAD) {
                    var fragmentName = selection.name.value;
                    if (!fragmentReplacements[fragmentName]) {
                        newSelections.add(selection);
                        continue;
                    }
                    try {
                        for (var _o = (e_4 = void 0, __values(fragmentReplacements[fragmentName])), _p = _o.next(); !_p.done; _p = _o.next()) {
                            var replacement = _p.value;
                            var typeName = replacement.typeName;
                            var maybeReplacementType = schema.getType(typeName);
                            if (maybeReplacementType != null && implementsAbstractType(schema, parentType, maybeType)) {
                                newSelections.add({
                                    kind: Kind.FRAGMENT_SPREAD,
                                    name: {
                                        kind: Kind.NAME,
                                        value: replacement.fragmentName,
                                    },
                                });
                            }
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (_p && !_p.done && (_d = _o.return)) _d.call(_o);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                }
                else {
                    var fieldName = selection.name.value;
                    var fieldNodes_3 = (_j = fieldNodesByField[parentTypeName]) === null || _j === void 0 ? void 0 : _j[fieldName];
                    if (fieldNodes_3 != null) {
                        try {
                            for (var fieldNodes_2 = (e_5 = void 0, __values(fieldNodes_3)), fieldNodes_2_1 = fieldNodes_2.next(); !fieldNodes_2_1.done; fieldNodes_2_1 = fieldNodes_2.next()) {
                                var fieldNode = fieldNodes_2_1.value;
                                newSelections.add(fieldNode);
                            }
                        }
                        catch (e_5_1) { e_5 = { error: e_5_1 }; }
                        finally {
                            try {
                                if (fieldNodes_2_1 && !fieldNodes_2_1.done && (_e = fieldNodes_2.return)) _e.call(fieldNodes_2);
                            }
                            finally { if (e_5) throw e_5.error; }
                        }
                    }
                    var dynamicSelectionSets = (_k = dynamicSelectionSetsByField[parentTypeName]) === null || _k === void 0 ? void 0 : _k[fieldName];
                    if (dynamicSelectionSets != null) {
                        try {
                            for (var dynamicSelectionSets_1 = (e_6 = void 0, __values(dynamicSelectionSets)), dynamicSelectionSets_1_1 = dynamicSelectionSets_1.next(); !dynamicSelectionSets_1_1.done; dynamicSelectionSets_1_1 = dynamicSelectionSets_1.next()) {
                                var selectionSetFn = dynamicSelectionSets_1_1.value;
                                var selectionSet = selectionSetFn(selection);
                                if (selectionSet != null) {
                                    try {
                                        for (var _q = (e_7 = void 0, __values(selectionSet.selections)), _r = _q.next(); !_r.done; _r = _q.next()) {
                                            var selection_1 = _r.value;
                                            newSelections.add(selection_1);
                                        }
                                    }
                                    catch (e_7_1) { e_7 = { error: e_7_1 }; }
                                    finally {
                                        try {
                                            if (_r && !_r.done && (_g = _q.return)) _g.call(_q);
                                        }
                                        finally { if (e_7) throw e_7.error; }
                                    }
                                }
                            }
                        }
                        catch (e_6_1) { e_6 = { error: e_6_1 }; }
                        finally {
                            try {
                                if (dynamicSelectionSets_1_1 && !dynamicSelectionSets_1_1.done && (_f = dynamicSelectionSets_1.return)) _f.call(dynamicSelectionSets_1);
                            }
                            finally { if (e_6) throw e_6.error; }
                        }
                    }
                    if (interfaceExtensions === null || interfaceExtensions === void 0 ? void 0 : interfaceExtensions[fieldName]) {
                        interfaceExtensionFields.push(selection);
                    }
                    else {
                        newSelections.add(selection);
                    }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_m && !_m.done && (_b = _l.return)) _b.call(_l);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (reversePossibleTypesMap[parentType.name]) {
            newSelections.add({
                kind: Kind.FIELD,
                name: {
                    kind: Kind.NAME,
                    value: '__typename',
                },
            });
        }
        if (interfaceExtensionFields.length) {
            var possibleTypes = possibleTypesMap[parentType.name];
            if (possibleTypes != null) {
                try {
                    for (var possibleTypes_2 = __values(possibleTypes), possibleTypes_2_1 = possibleTypes_2.next(); !possibleTypes_2_1.done; possibleTypes_2_1 = possibleTypes_2.next()) {
                        var possibleType = possibleTypes_2_1.value;
                        newSelections.add(generateInlineFragment(possibleType, {
                            kind: Kind.SELECTION_SET,
                            selections: interfaceExtensionFields,
                        }));
                    }
                }
                catch (e_8_1) { e_8 = { error: e_8_1 }; }
                finally {
                    try {
                        if (possibleTypes_2_1 && !possibleTypes_2_1.done && (_h = possibleTypes_2.return)) _h.call(possibleTypes_2);
                    }
                    finally { if (e_8) throw e_8.error; }
                }
            }
        }
        return __assign(__assign({}, node), { selections: Array.from(newSelections) });
    }
    return node;
}
function generateInlineFragment(typeName, selectionSet) {
    return {
        kind: Kind.INLINE_FRAGMENT,
        typeCondition: {
            kind: Kind.NAMED_TYPE,
            name: {
                kind: Kind.NAME,
                value: typeName,
            },
        },
        selectionSet: selectionSet,
    };
}
var getSchemaMetaData = memoize2(function (sourceSchema, targetSchema) {
    var e_9, _a;
    var _b, _c, _d, _e;
    var typeMap = sourceSchema.getTypeMap();
    var targetTypeMap = targetSchema.getTypeMap();
    var possibleTypesMap = Object.create(null);
    var interfaceExtensionsMap = Object.create(null);
    for (var typeName in typeMap) {
        var type = typeMap[typeName];
        if (isAbstractType(type)) {
            var targetType = targetTypeMap[typeName];
            if (isInterfaceType(type) && isInterfaceType(targetType)) {
                var targetTypeFields = targetType.getFields();
                var sourceTypeFields = type.getFields();
                var extensionFields = Object.create(null);
                var isExtensionFieldsEmpty = true;
                for (var fieldName in sourceTypeFields) {
                    if (!targetTypeFields[fieldName]) {
                        extensionFields[fieldName] = true;
                        isExtensionFieldsEmpty = false;
                    }
                }
                if (!isExtensionFieldsEmpty) {
                    interfaceExtensionsMap[typeName] = extensionFields;
                }
            }
            if (interfaceExtensionsMap[typeName] || !isAbstractType(targetType)) {
                var implementations = sourceSchema.getPossibleTypes(type);
                possibleTypesMap[typeName] = [];
                try {
                    for (var implementations_1 = (e_9 = void 0, __values(implementations)), implementations_1_1 = implementations_1.next(); !implementations_1_1.done; implementations_1_1 = implementations_1.next()) {
                        var impl = implementations_1_1.value;
                        if (targetTypeMap[impl.name]) {
                            possibleTypesMap[typeName].push(impl.name);
                        }
                    }
                }
                catch (e_9_1) { e_9 = { error: e_9_1 }; }
                finally {
                    try {
                        if (implementations_1_1 && !implementations_1_1.done && (_a = implementations_1.return)) _a.call(implementations_1);
                    }
                    finally { if (e_9) throw e_9.error; }
                }
            }
        }
    }
    var stitchingInfo = (_b = sourceSchema.extensions) === null || _b === void 0 ? void 0 : _b['stitchingInfo'];
    return {
        possibleTypesMap: possibleTypesMap,
        reversePossibleTypesMap: reversePossibleTypesMap(possibleTypesMap),
        interfaceExtensionsMap: interfaceExtensionsMap,
        fieldNodesByType: (_c = stitchingInfo === null || stitchingInfo === void 0 ? void 0 : stitchingInfo.fieldNodesByType) !== null && _c !== void 0 ? _c : {},
        fieldNodesByField: (_d = stitchingInfo === null || stitchingInfo === void 0 ? void 0 : stitchingInfo.fieldNodesByField) !== null && _d !== void 0 ? _d : {},
        dynamicSelectionSetsByField: (_e = stitchingInfo === null || stitchingInfo === void 0 ? void 0 : stitchingInfo.dynamicSelectionSetsByField) !== null && _e !== void 0 ? _e : {},
    };
});
function reversePossibleTypesMap(possibleTypesMap) {
    var e_10, _a;
    var result = Object.create(null);
    for (var typeName in possibleTypesMap) {
        var toTypeNames = possibleTypesMap[typeName];
        try {
            for (var toTypeNames_1 = (e_10 = void 0, __values(toTypeNames)), toTypeNames_1_1 = toTypeNames_1.next(); !toTypeNames_1_1.done; toTypeNames_1_1 = toTypeNames_1.next()) {
                var toTypeName = toTypeNames_1_1.value;
                if (!result[toTypeName]) {
                    result[toTypeName] = [];
                }
                result[toTypeName].push(typeName);
            }
        }
        catch (e_10_1) { e_10 = { error: e_10_1 }; }
        finally {
            try {
                if (toTypeNames_1_1 && !toTypeNames_1_1.done && (_a = toTypeNames_1.return)) _a.call(toTypeNames_1);
            }
            finally { if (e_10) throw e_10.error; }
        }
    }
    return result;
}
function getExpandedFragments(fragments, fragmentNames, possibleTypesMap) {
    var e_11, _a, e_12, _b;
    var fragmentCounter = 0;
    function generateFragmentName(typeName) {
        var fragmentName;
        do {
            fragmentName = "_" + typeName + "_Fragment" + fragmentCounter.toString();
            fragmentCounter++;
        } while (fragmentNames.has(fragmentName));
        return fragmentName;
    }
    var expandedFragments = [];
    var fragmentReplacements = Object.create(null);
    try {
        for (var fragments_1 = __values(fragments), fragments_1_1 = fragments_1.next(); !fragments_1_1.done; fragments_1_1 = fragments_1.next()) {
            var fragment = fragments_1_1.value;
            var possibleTypes = possibleTypesMap[fragment.typeCondition.name.value];
            if (possibleTypes != null) {
                var fragmentName = fragment.name.value;
                fragmentReplacements[fragmentName] = [];
                try {
                    for (var possibleTypes_3 = (e_12 = void 0, __values(possibleTypes)), possibleTypes_3_1 = possibleTypes_3.next(); !possibleTypes_3_1.done; possibleTypes_3_1 = possibleTypes_3.next()) {
                        var possibleTypeName = possibleTypes_3_1.value;
                        var name_1 = generateFragmentName(possibleTypeName);
                        fragmentNames.add(name_1);
                        expandedFragments.push({
                            kind: Kind.FRAGMENT_DEFINITION,
                            name: {
                                kind: Kind.NAME,
                                value: name_1,
                            },
                            typeCondition: {
                                kind: Kind.NAMED_TYPE,
                                name: {
                                    kind: Kind.NAME,
                                    value: possibleTypeName,
                                },
                            },
                            selectionSet: fragment.selectionSet,
                        });
                        fragmentReplacements[fragmentName].push({
                            fragmentName: name_1,
                            typeName: possibleTypeName,
                        });
                    }
                }
                catch (e_12_1) { e_12 = { error: e_12_1 }; }
                finally {
                    try {
                        if (possibleTypes_3_1 && !possibleTypes_3_1.done && (_b = possibleTypes_3.return)) _b.call(possibleTypes_3);
                    }
                    finally { if (e_12) throw e_12.error; }
                }
            }
        }
    }
    catch (e_11_1) { e_11 = { error: e_11_1 }; }
    finally {
        try {
            if (fragments_1_1 && !fragments_1_1.done && (_a = fragments_1.return)) _a.call(fragments_1);
        }
        finally { if (e_11) throw e_11.error; }
    }
    return {
        expandedFragments: expandedFragments,
        fragmentReplacements: fragmentReplacements,
    };
}
function wrapConcreteTypes(returnType, targetSchema, document) {
    var _a;
    var namedType = getNamedType(returnType);
    if (!isObjectType(namedType)) {
        return document;
    }
    var rootTypeNames = getRootTypeNames(targetSchema);
    var typeInfo = new TypeInfo(targetSchema);
    var visitorKeys = {
        Document: ['definitions'],
        OperationDefinition: ['selectionSet'],
        SelectionSet: ['selections'],
        InlineFragment: ['selectionSet'],
        FragmentDefinition: ['selectionSet'],
    };
    return visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.FRAGMENT_DEFINITION] = function (node) {
            var typeName = node.typeCondition.name.value;
            if (!rootTypeNames.has(typeName)) {
                return false;
            }
        },
        _a[Kind.FIELD] = function (node) {
            var type = typeInfo.getType();
            if (type != null && isAbstractType(getNamedType(type))) {
                return __assign(__assign({}, node), { selectionSet: {
                        kind: Kind.SELECTION_SET,
                        selections: [
                            {
                                kind: Kind.INLINE_FRAGMENT,
                                typeCondition: {
                                    kind: Kind.NAMED_TYPE,
                                    name: {
                                        kind: Kind.NAME,
                                        value: namedType.name,
                                    },
                                },
                                selectionSet: node.selectionSet,
                            },
                        ],
                    } });
            }
        },
        _a)), 
    // visitorKeys argument usage a la https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
    // empty keys cannot be removed only because of typescript errors
    // will hopefully be fixed in future version of graphql-js to be optional
    visitorKeys);
}

function finalizeGatewayDocument(targetSchema, fragments, operations) {
    var e_1, _a, e_2, _b;
    var _c;
    var usedVariables = [];
    var usedFragments = [];
    var newOperations = [];
    var newFragments = [];
    var validFragments = [];
    var validFragmentsWithType = Object.create(null);
    try {
        for (var fragments_1 = __values(fragments), fragments_1_1 = fragments_1.next(); !fragments_1_1.done; fragments_1_1 = fragments_1.next()) {
            var fragment = fragments_1_1.value;
            var typeName = fragment.typeCondition.name.value;
            var type = targetSchema.getType(typeName);
            if (type != null) {
                validFragments.push(fragment);
                validFragmentsWithType[fragment.name.value] = type;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (fragments_1_1 && !fragments_1_1.done && (_a = fragments_1.return)) _a.call(fragments_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var fragmentSet = Object.create(null);
    var _loop_1 = function (operation) {
        var type = getDefinedRootType(targetSchema, operation.operation);
        var _d = finalizeSelectionSet(targetSchema, type, validFragmentsWithType, operation.selectionSet), selectionSet = _d.selectionSet, operationUsedFragments = _d.usedFragments, operationUsedVariables = _d.usedVariables;
        usedFragments = union(usedFragments, operationUsedFragments);
        var _e = collectFragmentVariables(targetSchema, fragmentSet, validFragments, validFragmentsWithType, usedFragments), collectedUsedVariables = _e.usedVariables, collectedNewFragments = _e.newFragments, collectedFragmentSet = _e.fragmentSet;
        var operationOrFragmentVariables = union(operationUsedVariables, collectedUsedVariables);
        usedVariables = union(usedVariables, operationOrFragmentVariables);
        newFragments = collectedNewFragments;
        fragmentSet = collectedFragmentSet;
        var variableDefinitions = ((_c = operation.variableDefinitions) !== null && _c !== void 0 ? _c : []).filter(function (variable) { return operationOrFragmentVariables.indexOf(variable.variable.name.value) !== -1; });
        newOperations.push({
            kind: Kind.OPERATION_DEFINITION,
            operation: operation.operation,
            name: operation.name,
            directives: operation.directives,
            variableDefinitions: variableDefinitions,
            selectionSet: selectionSet,
        });
    };
    try {
        for (var operations_1 = __values(operations), operations_1_1 = operations_1.next(); !operations_1_1.done; operations_1_1 = operations_1.next()) {
            var operation = operations_1_1.value;
            _loop_1(operation);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (operations_1_1 && !operations_1_1.done && (_b = operations_1.return)) _b.call(operations_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return {
        usedVariables: usedVariables,
        newDocument: {
            kind: Kind.DOCUMENT,
            definitions: __spreadArray(__spreadArray([], __read(newOperations), false), __read(newFragments), false),
        },
    };
}
function finalizeGatewayRequest(originalRequest, delegationContext) {
    var e_3, _a;
    var document = originalRequest.document, variables = originalRequest.variables;
    var _b = getDocumentMetadata(document), operations = _b.operations, fragments = _b.fragments;
    var targetSchema = delegationContext.targetSchema, args = delegationContext.args;
    if (args) {
        var requestWithNewVariables = addVariablesToRootFields(targetSchema, operations, args);
        operations = requestWithNewVariables.newOperations;
        variables = Object.assign({}, variables !== null && variables !== void 0 ? variables : {}, requestWithNewVariables.newVariables);
    }
    var _c = finalizeGatewayDocument(targetSchema, fragments, operations), usedVariables = _c.usedVariables, newDocument = _c.newDocument;
    var newVariables = {};
    if (variables != null) {
        try {
            for (var usedVariables_1 = __values(usedVariables), usedVariables_1_1 = usedVariables_1.next(); !usedVariables_1_1.done; usedVariables_1_1 = usedVariables_1.next()) {
                var variableName = usedVariables_1_1.value;
                var variableValue = variables[variableName];
                if (variableValue !== undefined) {
                    newVariables[variableName] = variableValue;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (usedVariables_1_1 && !usedVariables_1_1.done && (_a = usedVariables_1.return)) _a.call(usedVariables_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
    }
    return __assign(__assign({}, originalRequest), { document: newDocument, variables: newVariables });
}
function addVariablesToRootFields(targetSchema, operations, args) {
    var newVariables = Object.create(null);
    var newOperations = operations.map(function (operation) {
        var e_4, _a;
        var _b, _c;
        var variableDefinitionMap = ((_b = operation.variableDefinitions) !== null && _b !== void 0 ? _b : []).reduce(function (prev, def) {
            var _a;
            return (__assign(__assign({}, prev), (_a = {}, _a[def.variable.name.value] = def, _a)));
        }, {});
        var type = getDefinedRootType(targetSchema, operation.operation);
        var newSelectionSet = [];
        try {
            for (var _d = __values(operation.selectionSet.selections), _e = _d.next(); !_e.done; _e = _d.next()) {
                var selection = _e.value;
                if (selection.kind === Kind.FIELD) {
                    var argumentNodes = (_c = selection.arguments) !== null && _c !== void 0 ? _c : [];
                    var argumentNodeMap = argumentNodes.reduce(function (prev, argument) {
                        var _a;
                        return (__assign(__assign({}, prev), (_a = {}, _a[argument.name.value] = argument, _a)));
                    }, {});
                    var targetField = type.getFields()[selection.name.value];
                    // excludes __typename
                    if (targetField != null) {
                        updateArguments(targetField, argumentNodeMap, variableDefinitionMap, newVariables, args);
                    }
                    newSelectionSet.push(__assign(__assign({}, selection), { arguments: Object.values(argumentNodeMap) }));
                }
                else {
                    newSelectionSet.push(selection);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return __assign(__assign({}, operation), { variableDefinitions: Object.values(variableDefinitionMap), selectionSet: {
                kind: Kind.SELECTION_SET,
                selections: newSelectionSet,
            } });
    });
    return {
        newOperations: newOperations,
        newVariables: newVariables,
    };
}
function updateArguments(targetField, argumentNodeMap, variableDefinitionMap, variableValues, newArgs) {
    var e_5, _a;
    var generateVariableName = createVariableNameGenerator(variableDefinitionMap);
    try {
        for (var _b = __values(targetField.args), _c = _b.next(); !_c.done; _c = _b.next()) {
            var argument = _c.value;
            var argName = argument.name;
            var argType = argument.type;
            if (argName in newArgs) {
                updateArgument(argumentNodeMap, variableDefinitionMap, variableValues, argName, generateVariableName(argName), argType, serializeInputValue(argType, newArgs[argName]));
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_5) throw e_5.error; }
    }
}
function collectFragmentVariables(targetSchema, fragmentSet, validFragments, validFragmentsWithType, usedFragments) {
    var remainingFragments = usedFragments.slice();
    var usedVariables = [];
    var newFragments = [];
    var _loop_2 = function () {
        var nextFragmentName = remainingFragments.pop();
        var fragment = validFragments.find(function (fr) { return fr.name.value === nextFragmentName; });
        if (fragment != null) {
            var name_1 = nextFragmentName;
            var typeName = fragment.typeCondition.name.value;
            var type = targetSchema.getType(typeName);
            if (type == null) {
                throw new Error("Fragment reference type \"" + typeName + "\", but the type is not contained within the target schema.");
            }
            var _a = finalizeSelectionSet(targetSchema, type, validFragmentsWithType, fragment.selectionSet), selectionSet = _a.selectionSet, fragmentUsedFragments = _a.usedFragments, fragmentUsedVariables = _a.usedVariables;
            remainingFragments = union(remainingFragments, fragmentUsedFragments);
            usedVariables = union(usedVariables, fragmentUsedVariables);
            if (name_1 && !(name_1 in fragmentSet)) {
                fragmentSet[name_1] = true;
                newFragments.push({
                    kind: Kind.FRAGMENT_DEFINITION,
                    name: {
                        kind: Kind.NAME,
                        value: name_1,
                    },
                    typeCondition: fragment.typeCondition,
                    selectionSet: selectionSet,
                });
            }
        }
    };
    while (remainingFragments.length !== 0) {
        _loop_2();
    }
    return {
        usedVariables: usedVariables,
        newFragments: newFragments,
        fragmentSet: fragmentSet,
    };
}
var filteredSelectionSetVisitorKeys = {
    SelectionSet: ['selections'],
    Field: ['selectionSet'],
    InlineFragment: ['selectionSet'],
    FragmentDefinition: ['selectionSet'],
};
var variablesVisitorKeys = {
    SelectionSet: ['selections'],
    Field: ['arguments', 'directives', 'selectionSet'],
    Argument: ['value'],
    InlineFragment: ['directives', 'selectionSet'],
    FragmentSpread: ['directives'],
    FragmentDefinition: ['selectionSet'],
    ObjectValue: ['fields'],
    ObjectField: ['name', 'value'],
    Directive: ['arguments'],
    ListValue: ['values'],
};
function finalizeSelectionSet(schema, type, validFragments, selectionSet) {
    var _a, _b;
    var usedFragments = [];
    var usedVariables = [];
    var typeInfo = versionInfo.major < 16 ? new TypeInfo(schema, undefined, type) : new TypeInfo(schema, type);
    var filteredSelectionSet = visit(selectionSet, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.FIELD] = {
            enter: function (node) {
                var e_6, _a, e_7, _b;
                var parentType = typeInfo.getParentType();
                if (isObjectType(parentType) || isInterfaceType(parentType)) {
                    var fields = parentType.getFields();
                    var field = node.name.value === '__typename' ? TypeNameMetaFieldDef : fields[node.name.value];
                    if (!field) {
                        return null;
                    }
                    var args = field.args != null ? field.args : [];
                    var argsMap = Object.create(null);
                    try {
                        for (var args_1 = __values(args), args_1_1 = args_1.next(); !args_1_1.done; args_1_1 = args_1.next()) {
                            var arg = args_1_1.value;
                            argsMap[arg.name] = arg;
                        }
                    }
                    catch (e_6_1) { e_6 = { error: e_6_1 }; }
                    finally {
                        try {
                            if (args_1_1 && !args_1_1.done && (_a = args_1.return)) _a.call(args_1);
                        }
                        finally { if (e_6) throw e_6.error; }
                    }
                    if (node.arguments != null) {
                        var newArgs = [];
                        try {
                            for (var _c = __values(node.arguments), _d = _c.next(); !_d.done; _d = _c.next()) {
                                var arg = _d.value;
                                if (arg.name.value in argsMap) {
                                    newArgs.push(arg);
                                }
                            }
                        }
                        catch (e_7_1) { e_7 = { error: e_7_1 }; }
                        finally {
                            try {
                                if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                            }
                            finally { if (e_7) throw e_7.error; }
                        }
                        if (newArgs.length !== node.arguments.length) {
                            return __assign(__assign({}, node), { arguments: newArgs });
                        }
                    }
                }
            },
            leave: function (node) {
                var type = typeInfo.getType();
                if (type == null) {
                    throw new Error("No type was found for field node " + inspect(node) + ".");
                }
                var namedType = getNamedType(type);
                if (!schema.getType(namedType.name) == null) {
                    return null;
                }
                if (isObjectType(namedType) || isInterfaceType(namedType)) {
                    var selections = node.selectionSet != null ? node.selectionSet.selections : null;
                    if (selections == null || selections.length === 0) {
                        return null;
                    }
                }
            },
        },
        _a[Kind.FRAGMENT_SPREAD] = {
            enter: function (node) {
                if (!(node.name.value in validFragments)) {
                    return null;
                }
                var parentType = typeInfo.getParentType();
                var innerType = validFragments[node.name.value];
                if (!implementsAbstractType(schema, parentType, innerType)) {
                    return null;
                }
                usedFragments.push(node.name.value);
            },
        },
        _a[Kind.INLINE_FRAGMENT] = {
            enter: function (node) {
                if (node.typeCondition != null) {
                    var parentType = typeInfo.getParentType();
                    var innerType = schema.getType(node.typeCondition.name.value);
                    if (!implementsAbstractType(schema, parentType, innerType)) {
                        return null;
                    }
                }
            },
        },
        _a[Kind.SELECTION_SET] = {
            leave: function (node) {
                var parentType = typeInfo.getParentType();
                if (parentType != null && isAbstractType(parentType)) {
                    var selections = node.selections.concat([
                        {
                            kind: Kind.FIELD,
                            name: {
                                kind: Kind.NAME,
                                value: '__typename',
                            },
                        },
                    ]);
                    return __assign(__assign({}, node), { selections: selections });
                }
            },
        },
        _a)), 
    // visitorKeys argument usage a la https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
    // empty keys cannot be removed only because of typescript errors
    // will hopefully be fixed in future version of graphql-js to be optional
    filteredSelectionSetVisitorKeys);
    visit(filteredSelectionSet, (_b = {},
        _b[Kind.VARIABLE] = function (variableNode) {
            usedVariables.push(variableNode.name.value);
        },
        _b), 
    // visitorKeys argument usage a la https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
    // empty keys cannot be removed only because of typescript errors
    // will hopefully be fixed in future version of graphql-js to be optional
    variablesVisitorKeys);
    return {
        selectionSet: filteredSelectionSet,
        usedFragments: usedFragments,
        usedVariables: usedVariables,
    };
}
function union() {
    var e_8, _a, e_9, _b;
    var arrays = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        arrays[_i] = arguments[_i];
    }
    var cache = Object.create(null);
    var result = [];
    try {
        for (var arrays_1 = __values(arrays), arrays_1_1 = arrays_1.next(); !arrays_1_1.done; arrays_1_1 = arrays_1.next()) {
            var array = arrays_1_1.value;
            try {
                for (var array_1 = (e_9 = void 0, __values(array)), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
                    var item = array_1_1.value;
                    if (!(item in cache)) {
                        cache[item] = true;
                        result.push(item);
                    }
                }
            }
            catch (e_9_1) { e_9 = { error: e_9_1 }; }
            finally {
                try {
                    if (array_1_1 && !array_1_1.done && (_b = array_1.return)) _b.call(array_1);
                }
                finally { if (e_9) throw e_9.error; }
            }
        }
    }
    catch (e_8_1) { e_8 = { error: e_8_1 }; }
    finally {
        try {
            if (arrays_1_1 && !arrays_1_1.done && (_a = arrays_1.return)) _a.call(arrays_1);
        }
        finally { if (e_8) throw e_8.error; }
    }
    return result;
}

var UNPATHED_ERRORS_SYMBOL = Symbol('subschemaErrors');
var OBJECT_SUBSCHEMA_SYMBOL = Symbol('initialSubschema');
var FIELD_SUBSCHEMA_MAP_SYMBOL = Symbol('subschemaMap');

function isExternalObject(data) {
    return data[UNPATHED_ERRORS_SYMBOL] !== undefined;
}
function annotateExternalObject(object, errors, subschema, subschemaMap) {
    var _a;
    Object.defineProperties(object, (_a = {},
        _a[OBJECT_SUBSCHEMA_SYMBOL] = { value: subschema },
        _a[FIELD_SUBSCHEMA_MAP_SYMBOL] = { value: subschemaMap },
        _a[UNPATHED_ERRORS_SYMBOL] = { value: errors },
        _a));
    return object;
}
function getSubschema(object, responseKey) {
    var _a;
    return (_a = object[FIELD_SUBSCHEMA_MAP_SYMBOL][responseKey]) !== null && _a !== void 0 ? _a : object[OBJECT_SUBSCHEMA_SYMBOL];
}
function getUnpathedErrors(object) {
    return object[UNPATHED_ERRORS_SYMBOL];
}
var EMPTY_ARRAY = [];
var EMPTY_OBJECT = Object.create(null);
function mergeFields(mergedTypeInfo, object, sourceSubschema, context, info) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var delegationMaps, delegationMaps_1, delegationMaps_1_1, delegationMap, e_1_1;
        var e_1, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    delegationMaps = mergedTypeInfo.delegationPlanBuilder(info.schema, sourceSubschema, info.variableValues != null && Object.keys(info.variableValues).length > 0 ? info.variableValues : EMPTY_OBJECT, info.fragments != null && Object.keys(info.fragments).length > 0 ? info.fragments : EMPTY_OBJECT, ((_a = info.fieldNodes) === null || _a === void 0 ? void 0 : _a.length) ? info.fieldNodes : EMPTY_ARRAY);
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, 6, 7, 8]);
                    delegationMaps_1 = __values(delegationMaps), delegationMaps_1_1 = delegationMaps_1.next();
                    _c.label = 2;
                case 2:
                    if (!!delegationMaps_1_1.done) return [3 /*break*/, 5];
                    delegationMap = delegationMaps_1_1.value;
                    return [4 /*yield*/, executeDelegationStage(mergedTypeInfo, delegationMap, object, context, info)];
                case 3:
                    _c.sent();
                    _c.label = 4;
                case 4:
                    delegationMaps_1_1 = delegationMaps_1.next();
                    return [3 /*break*/, 2];
                case 5: return [3 /*break*/, 8];
                case 6:
                    e_1_1 = _c.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 8];
                case 7:
                    try {
                        if (delegationMaps_1_1 && !delegationMaps_1_1.done && (_b = delegationMaps_1.return)) _b.call(delegationMaps_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 8: return [2 /*return*/, object];
            }
        });
    });
}
function executeDelegationStage(mergedTypeInfo, delegationMap, object, context, info) {
    return __awaiter(this, void 0, void 0, function () {
        var combinedErrors, path, combinedFieldSubschemaMap, type;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    combinedErrors = object[UNPATHED_ERRORS_SYMBOL];
                    path = responsePathAsArray(info.path);
                    combinedFieldSubschemaMap = object[FIELD_SUBSCHEMA_MAP_SYMBOL];
                    type = info.schema.getType(object.__typename);
                    return [4 /*yield*/, Promise.all(__spreadArray([], __read(delegationMap.entries()), false).map(function (_a) {
                            var _b = __read(_a, 2), s = _b[0], selectionSet = _b[1];
                            return __awaiter(_this, void 0, void 0, function () {
                                var resolver, source, error_1, fieldNodeResponseKeyMap, nullResult, fieldNodeResponseKeyMap_1, fieldNodeResponseKeyMap_1_1, _c, responseKey, fieldNodes, combinedPath, objectSubschema, fieldSubschemaMap, responseKey;
                                var e_2, _d;
                                var _e;
                                return __generator(this, function (_f) {
                                    switch (_f.label) {
                                        case 0:
                                            resolver = mergedTypeInfo.resolvers.get(s);
                                            if (!resolver) return [3 /*break*/, 5];
                                            source = void 0;
                                            _f.label = 1;
                                        case 1:
                                            _f.trys.push([1, 3, , 4]);
                                            return [4 /*yield*/, resolver(object, context, info, s, selectionSet)];
                                        case 2:
                                            source = _f.sent();
                                            return [3 /*break*/, 4];
                                        case 3:
                                            error_1 = _f.sent();
                                            source = error_1;
                                            return [3 /*break*/, 4];
                                        case 4:
                                            if (source instanceof Error || source == null) {
                                                fieldNodeResponseKeyMap = collectFields(info.schema, {}, {}, type, selectionSet, new Map(), new Set());
                                                nullResult = {};
                                                try {
                                                    for (fieldNodeResponseKeyMap_1 = __values(fieldNodeResponseKeyMap), fieldNodeResponseKeyMap_1_1 = fieldNodeResponseKeyMap_1.next(); !fieldNodeResponseKeyMap_1_1.done; fieldNodeResponseKeyMap_1_1 = fieldNodeResponseKeyMap_1.next()) {
                                                        _c = __read(fieldNodeResponseKeyMap_1_1.value, 2), responseKey = _c[0], fieldNodes = _c[1];
                                                        combinedPath = __spreadArray(__spreadArray([], __read(path), false), [responseKey], false);
                                                        if (source instanceof GraphQLError) {
                                                            nullResult[responseKey] = relocatedError(source, combinedPath);
                                                        }
                                                        else if (source instanceof Error) {
                                                            nullResult[responseKey] = locatedError(source, fieldNodes, combinedPath);
                                                        }
                                                        else {
                                                            nullResult[responseKey] = null;
                                                        }
                                                    }
                                                }
                                                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                                                finally {
                                                    try {
                                                        if (fieldNodeResponseKeyMap_1_1 && !fieldNodeResponseKeyMap_1_1.done && (_d = fieldNodeResponseKeyMap_1.return)) _d.call(fieldNodeResponseKeyMap_1);
                                                    }
                                                    finally { if (e_2) throw e_2.error; }
                                                }
                                                source = nullResult;
                                            }
                                            else {
                                                if (source[UNPATHED_ERRORS_SYMBOL]) {
                                                    combinedErrors.push.apply(combinedErrors, __spreadArray([], __read(source[UNPATHED_ERRORS_SYMBOL]), false));
                                                }
                                            }
                                            objectSubschema = source[OBJECT_SUBSCHEMA_SYMBOL];
                                            fieldSubschemaMap = source[FIELD_SUBSCHEMA_MAP_SYMBOL];
                                            for (responseKey in source) {
                                                object[responseKey] = source[responseKey];
                                                combinedFieldSubschemaMap[responseKey] = (_e = fieldSubschemaMap === null || fieldSubschemaMap === void 0 ? void 0 : fieldSubschemaMap[responseKey]) !== null && _e !== void 0 ? _e : objectSubschema;
                                            }
                                            _f.label = 5;
                                        case 5: return [2 /*return*/];
                                    }
                                });
                            });
                        }))];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}

function resolveExternalValue(result, unpathedErrors, subschema, context, info, returnType, skipTypeMerging) {
    if (returnType === void 0) { returnType = getReturnType(info); }
    var type = getNullableType(returnType);
    if (result instanceof Error) {
        return result;
    }
    if (result == null) {
        return reportUnpathedErrorsViaNull(unpathedErrors);
    }
    if ('parseValue' in type) {
        return type.parseValue(result);
    }
    else if (isCompositeType(type)) {
        return resolveExternalObject(type, result, unpathedErrors, subschema, context, info, skipTypeMerging);
    }
    else if (isListType(type)) {
        return resolveExternalList(type, result, unpathedErrors, subschema, context, info, skipTypeMerging);
    }
}
function resolveExternalObject(type, object, unpathedErrors, subschema, context, info, skipTypeMerging) {
    var _a;
    // if we have already resolved this object, for example, when the identical object appears twice
    // in a list, see https://github.com/ardatan/graphql-tools/issues/2304
    if (!isExternalObject(object)) {
        annotateExternalObject(object, unpathedErrors, subschema, Object.create(null));
    }
    if (skipTypeMerging || info == null) {
        return object;
    }
    var stitchingInfo = (_a = info.schema.extensions) === null || _a === void 0 ? void 0 : _a['stitchingInfo'];
    if (stitchingInfo == null) {
        return object;
    }
    var typeName;
    if (isAbstractType(type)) {
        var resolvedType = info.schema.getType(object.__typename);
        if (resolvedType == null) {
            throw new Error("Unable to resolve type '" + object.__typename + "'. Did you forget to include a transform that renames types? Did you delegate to the original subschema rather that the subschema config object containing the transform?");
        }
        typeName = resolvedType.name;
    }
    else {
        typeName = type.name;
    }
    var mergedTypeInfo = stitchingInfo.mergedTypes[typeName];
    var targetSubschemas;
    // Within the stitching context, delegation to a stitched GraphQLSchema or SubschemaConfig
    // will be redirected to the appropriate Subschema object, from which merge targets can be queried.
    if (mergedTypeInfo != null) {
        targetSubschemas = mergedTypeInfo.targetSubschemas.get(subschema);
    }
    // If there are no merge targets from the subschema, return.
    if (!targetSubschemas || !targetSubschemas.length) {
        return object;
    }
    return mergeFields(mergedTypeInfo, object, subschema, context, info);
}
function resolveExternalList(type, list, unpathedErrors, subschema, context, info, skipTypeMerging) {
    return list.map(function (listMember) {
        return resolveExternalListMember(getNullableType(type.ofType), listMember, unpathedErrors, subschema, context, info, skipTypeMerging);
    });
}
function resolveExternalListMember(type, listMember, unpathedErrors, subschema, context, info, skipTypeMerging) {
    if (listMember instanceof Error) {
        return listMember;
    }
    if (listMember == null) {
        return reportUnpathedErrorsViaNull(unpathedErrors);
    }
    if ('parseValue' in type) {
        return type.parseValue(listMember);
    }
    else if (isCompositeType(type)) {
        return resolveExternalObject(type, listMember, unpathedErrors, subschema, context, info, skipTypeMerging);
    }
    else if (isListType(type)) {
        return resolveExternalList(type, listMember, unpathedErrors, subschema, context, info, skipTypeMerging);
    }
}
var reportedErrors = new WeakMap();
function reportUnpathedErrorsViaNull(unpathedErrors) {
    var e_1, _a;
    if (unpathedErrors.length) {
        var unreportedErrors = [];
        try {
            for (var unpathedErrors_1 = __values(unpathedErrors), unpathedErrors_1_1 = unpathedErrors_1.next(); !unpathedErrors_1_1.done; unpathedErrors_1_1 = unpathedErrors_1.next()) {
                var error = unpathedErrors_1_1.value;
                if (!reportedErrors.has(error)) {
                    unreportedErrors.push(error);
                    reportedErrors.set(error, true);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (unpathedErrors_1_1 && !unpathedErrors_1_1.done && (_a = unpathedErrors_1.return)) _a.call(unpathedErrors_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (unreportedErrors.length) {
            if (unreportedErrors.length === 1) {
                return unreportedErrors[0];
            }
            var combinedError = new AggregateError(unreportedErrors);
            // We cast path as any for GraphQL.js 14 compat
            // locatedError path argument must be defined, but it is just forwarded to a constructor that allows a undefined value
            // https://github.com/graphql/graphql-js/blob/b4bff0ba9c15c9d7245dd68556e754c41f263289/src/error/locatedError.js#L25
            // https://github.com/graphql/graphql-js/blob/b4bff0ba9c15c9d7245dd68556e754c41f263289/src/error/GraphQLError.js#L19
            return locatedError(combinedError, undefined, unreportedErrors[0].path);
        }
    }
    return null;
}
function getReturnType(info) {
    if (info == null) {
        throw new Error("Return type cannot be inferred without a source schema.");
    }
    return info.returnType;
}

function checkResultAndHandleErrors(result, delegationContext) {
    var context = delegationContext.context, info = delegationContext.info, _a = delegationContext.fieldName, responseKey = _a === void 0 ? getResponseKey(info) : _a, subschema = delegationContext.subschema, _b = delegationContext.returnType, returnType = _b === void 0 ? getReturnType$1(info) : _b, skipTypeMerging = delegationContext.skipTypeMerging, onLocatedError = delegationContext.onLocatedError;
    var _c = mergeDataAndErrors(result.data == null ? undefined : result.data[responseKey], result.errors == null ? [] : result.errors, info != null && info.path ? responsePathAsArray(info.path) : undefined, onLocatedError), data = _c.data, unpathedErrors = _c.unpathedErrors;
    return resolveExternalValue(data, unpathedErrors, subschema, context, info, returnType, skipTypeMerging);
}
function mergeDataAndErrors(data, errors, path, onLocatedError, index) {
    var e_1, _a, e_2, _b;
    var _c;
    if (index === void 0) { index = 1; }
    if (data == null) {
        if (!errors.length) {
            return { data: null, unpathedErrors: [] };
        }
        if (errors.length === 1) {
            var error = onLocatedError ? onLocatedError(errors[0]) : errors[0];
            var newPath = path === undefined ? error.path : error.path === undefined ? path : path.concat(error.path.slice(1));
            return { data: relocatedError(errors[0], newPath), unpathedErrors: [] };
        }
        // We cast path as any for GraphQL.js 14 compat
        // locatedError path argument must be defined, but it is just forwarded to a constructor that allows a undefined value
        // https://github.com/graphql/graphql-js/blob/b4bff0ba9c15c9d7245dd68556e754c41f263289/src/error/locatedError.js#L25
        // https://github.com/graphql/graphql-js/blob/b4bff0ba9c15c9d7245dd68556e754c41f263289/src/error/GraphQLError.js#L19
        var newError = locatedError(new AggregateError(errors), undefined, path);
        return { data: newError, unpathedErrors: [] };
    }
    if (!errors.length) {
        return { data: data, unpathedErrors: [] };
    }
    var unpathedErrors = [];
    var errorMap = new Map();
    try {
        for (var errors_1 = __values(errors), errors_1_1 = errors_1.next(); !errors_1_1.done; errors_1_1 = errors_1.next()) {
            var error = errors_1_1.value;
            var pathSegment = (_c = error.path) === null || _c === void 0 ? void 0 : _c[index];
            if (pathSegment != null) {
                var pathSegmentErrors = errorMap.get(pathSegment);
                if (pathSegmentErrors === undefined) {
                    pathSegmentErrors = [error];
                    errorMap.set(pathSegment, pathSegmentErrors);
                }
                else {
                    pathSegmentErrors.push(error);
                }
            }
            else {
                unpathedErrors.push(error);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (errors_1_1 && !errors_1_1.done && (_a = errors_1.return)) _a.call(errors_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    try {
        for (var errorMap_1 = __values(errorMap), errorMap_1_1 = errorMap_1.next(); !errorMap_1_1.done; errorMap_1_1 = errorMap_1.next()) {
            var _d = __read(errorMap_1_1.value, 2), pathSegment = _d[0], pathSegmentErrors = _d[1];
            if (data[pathSegment] !== undefined) {
                var _e = mergeDataAndErrors(data[pathSegment], pathSegmentErrors, path, onLocatedError, index + 1), newData = _e.data, newErrors = _e.unpathedErrors;
                data[pathSegment] = newData;
                unpathedErrors.push.apply(unpathedErrors, __spreadArray([], __read(newErrors), false));
            }
            else {
                unpathedErrors.push.apply(unpathedErrors, __spreadArray([], __read(pathSegmentErrors), false));
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (errorMap_1_1 && !errorMap_1_1.done && (_b = errorMap_1.return)) _b.call(errorMap_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return { data: data, unpathedErrors: unpathedErrors };
}
function getResponseKey(info) {
    if (info == null) {
        throw new Error("Data cannot be extracted from result without an explicit key or source schema.");
    }
    return getResponseKeyFromInfo(info);
}
function getReturnType$1(info) {
    if (info == null) {
        throw new Error("Return type cannot be inferred without a source schema.");
    }
    return info.returnType;
}

var Transformer = /** @class */ (function () {
    function Transformer(context) {
        var e_1, _a;
        this.transformations = [];
        this.delegationContext = context;
        var transforms = context.transforms;
        var delegationTransforms = transforms.slice().reverse();
        try {
            for (var delegationTransforms_1 = __values(delegationTransforms), delegationTransforms_1_1 = delegationTransforms_1.next(); !delegationTransforms_1_1.done; delegationTransforms_1_1 = delegationTransforms_1.next()) {
                var transform = delegationTransforms_1_1.value;
                this.addTransform(transform, {});
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (delegationTransforms_1_1 && !delegationTransforms_1_1.done && (_a = delegationTransforms_1.return)) _a.call(delegationTransforms_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    Transformer.prototype.addTransform = function (transform, context) {
        if (context === void 0) { context = {}; }
        this.transformations.push({ transform: transform, context: context });
    };
    Transformer.prototype.transformRequest = function (originalRequest) {
        var e_2, _a;
        var _b;
        var request = __assign(__assign({}, originalRequest), { document: prepareGatewayDocument(originalRequest.document, this.delegationContext.transformedSchema, this.delegationContext.returnType, (_b = this.delegationContext.info) === null || _b === void 0 ? void 0 : _b.schema) });
        try {
            for (var _c = __values(this.transformations), _d = _c.next(); !_d.done; _d = _c.next()) {
                var transformation = _d.value;
                if (transformation.transform.transformRequest) {
                    request = transformation.transform.transformRequest(request, this.delegationContext, transformation.context);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return finalizeGatewayRequest(request, this.delegationContext);
    };
    Transformer.prototype.transformResult = function (originalResult) {
        var result = originalResult;
        // from rigth to left
        for (var i = this.transformations.length - 1; i >= 0; i--) {
            var transformation = this.transformations[i];
            if (transformation.transform.transformResult) {
                result = transformation.transform.transformResult(result, this.delegationContext, transformation.context);
            }
        }
        return checkResultAndHandleErrors(result, this.delegationContext);
    };
    return Transformer;
}());

function getDelegatingOperation(parentType, schema) {
    if (parentType === schema.getMutationType()) {
        return 'mutation';
    }
    else if (parentType === schema.getSubscriptionType()) {
        return 'subscription';
    }
    return 'query';
}
function createRequestFromInfo(_a) {
    var info = _a.info, rootValue = _a.rootValue, operationName = _a.operationName, _b = _a.operation, operation = _b === void 0 ? getDelegatingOperation(info.parentType, info.schema) : _b, _c = _a.fieldName, fieldName = _c === void 0 ? info.fieldName : _c, selectionSet = _a.selectionSet, _d = _a.fieldNodes, fieldNodes = _d === void 0 ? info.fieldNodes : _d, context = _a.context;
    return createRequest({
        sourceSchema: info.schema,
        sourceParentType: info.parentType,
        sourceFieldName: info.fieldName,
        fragments: info.fragments,
        variableDefinitions: info.operation.variableDefinitions,
        variableValues: info.variableValues,
        targetRootValue: rootValue,
        targetOperationName: operationName,
        targetOperation: operation,
        targetFieldName: fieldName,
        selectionSet: selectionSet,
        fieldNodes: fieldNodes,
        context: context,
        info: info,
    });
}
function createRequest(_a) {
    var e_1, _b, e_2, _c, e_3, _d, e_4, _e;
    var _f, _g;
    var sourceSchema = _a.sourceSchema, sourceParentType = _a.sourceParentType, sourceFieldName = _a.sourceFieldName, fragments = _a.fragments, variableDefinitions = _a.variableDefinitions, variableValues = _a.variableValues, targetRootValue = _a.targetRootValue, targetOperationName = _a.targetOperationName, targetOperation = _a.targetOperation, targetFieldName = _a.targetFieldName, selectionSet = _a.selectionSet, fieldNodes = _a.fieldNodes, context = _a.context, info = _a.info;
    var newSelectionSet;
    var argumentNodeMap = Object.create(null);
    if (selectionSet != null) {
        newSelectionSet = selectionSet;
    }
    else {
        var selections = [];
        try {
            for (var _h = __values(fieldNodes || []), _j = _h.next(); !_j.done; _j = _h.next()) {
                var fieldNode = _j.value;
                if (fieldNode.selectionSet) {
                    try {
                        for (var _k = (e_2 = void 0, __values(fieldNode.selectionSet.selections)), _l = _k.next(); !_l.done; _l = _k.next()) {
                            var selection = _l.value;
                            selections.push(selection);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (_l && !_l.done && (_c = _k.return)) _c.call(_k);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_j && !_j.done && (_b = _h.return)) _b.call(_h);
            }
            finally { if (e_1) throw e_1.error; }
        }
        newSelectionSet = selections.length
            ? {
                kind: Kind.SELECTION_SET,
                selections: selections,
            }
            : undefined;
        var args = (_f = fieldNodes === null || fieldNodes === void 0 ? void 0 : fieldNodes[0]) === null || _f === void 0 ? void 0 : _f.arguments;
        if (args) {
            try {
                for (var args_1 = __values(args), args_1_1 = args_1.next(); !args_1_1.done; args_1_1 = args_1.next()) {
                    var argNode = args_1_1.value;
                    argumentNodeMap[argNode.name.value] = argNode;
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (args_1_1 && !args_1_1.done && (_d = args_1.return)) _d.call(args_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    var newVariables = Object.create(null);
    var variableDefinitionMap = Object.create(null);
    if (sourceSchema != null && variableDefinitions != null) {
        try {
            for (var variableDefinitions_1 = __values(variableDefinitions), variableDefinitions_1_1 = variableDefinitions_1.next(); !variableDefinitions_1_1.done; variableDefinitions_1_1 = variableDefinitions_1.next()) {
                var def = variableDefinitions_1_1.value;
                var varName = def.variable.name.value;
                variableDefinitionMap[varName] = def;
                var varType = typeFromAST(sourceSchema, def.type);
                var serializedValue = serializeInputValue(varType, variableValues === null || variableValues === void 0 ? void 0 : variableValues[varName]);
                if (serializedValue !== undefined) {
                    newVariables[varName] = serializedValue;
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (variableDefinitions_1_1 && !variableDefinitions_1_1.done && (_e = variableDefinitions_1.return)) _e.call(variableDefinitions_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
    }
    if (sourceParentType != null && sourceFieldName != null) {
        updateArgumentsWithDefaults(sourceParentType, sourceFieldName, argumentNodeMap, variableDefinitionMap, newVariables);
    }
    var rootFieldName = targetFieldName !== null && targetFieldName !== void 0 ? targetFieldName : (_g = fieldNodes === null || fieldNodes === void 0 ? void 0 : fieldNodes[0]) === null || _g === void 0 ? void 0 : _g.name.value;
    if (rootFieldName === undefined) {
        throw new Error("Either \"targetFieldName\" or a non empty \"fieldNodes\" array must be provided.");
    }
    var rootfieldNode = {
        kind: Kind.FIELD,
        arguments: Object.values(argumentNodeMap),
        name: {
            kind: Kind.NAME,
            value: rootFieldName,
        },
        selectionSet: newSelectionSet,
    };
    var operationName = targetOperationName
        ? {
            kind: Kind.NAME,
            value: targetOperationName,
        }
        : undefined;
    var operationDefinition = {
        kind: Kind.OPERATION_DEFINITION,
        name: operationName,
        operation: targetOperation,
        variableDefinitions: Object.values(variableDefinitionMap),
        selectionSet: {
            kind: Kind.SELECTION_SET,
            selections: [rootfieldNode],
        },
    };
    var definitions = [operationDefinition];
    if (fragments != null) {
        for (var fragmentName in fragments) {
            var fragment = fragments[fragmentName];
            definitions.push(fragment);
        }
    }
    var document = {
        kind: Kind.DOCUMENT,
        definitions: definitions,
    };
    return {
        document: document,
        variables: newVariables,
        rootValue: targetRootValue,
        operationName: targetOperationName,
        operationType: targetOperation,
        context: context,
        info: info,
    };
}
function updateArgumentsWithDefaults(sourceParentType, sourceFieldName, argumentNodeMap, variableDefinitionMap, variableValues) {
    var e_5, _a;
    var generateVariableName = createVariableNameGenerator(variableDefinitionMap);
    var sourceField = sourceParentType.getFields()[sourceFieldName];
    try {
        for (var _b = __values(sourceField.args), _c = _b.next(); !_c.done; _c = _b.next()) {
            var argument = _c.value;
            var argName = argument.name;
            var sourceArgType = argument.type;
            if (argumentNodeMap[argName] === undefined) {
                var defaultValue = argument.defaultValue;
                if (defaultValue !== undefined) {
                    updateArgument(argumentNodeMap, variableDefinitionMap, variableValues, argName, generateVariableName(argName), sourceArgType, serializeInputValue(sourceArgType, defaultValue));
                }
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_5) throw e_5.error; }
    }
}

/**
 * Resolver that knows how to:
 * a) handle aliases for proxied schemas
 * b) handle errors from proxied schemas
 * c) handle external to internal enum conversion
 */
function defaultMergedResolver(parent, args, context, info) {
    if (!parent) {
        return null;
    }
    var responseKey = getResponseKeyFromInfo(info);
    // check to see if parent is not a proxied result, i.e. if parent resolver was manually overwritten
    // See https://github.com/ardatan/graphql-tools/issues/967
    if (!isExternalObject(parent)) {
        return defaultFieldResolver(parent, args, context, info);
    }
    var data = parent[responseKey];
    var unpathedErrors = getUnpathedErrors(parent);
    var subschema = getSubschema(parent, responseKey);
    return resolveExternalValue(data, unpathedErrors, subschema, context, info);
}

function isSubschemaConfig(value) {
    return Boolean(value === null || value === void 0 ? void 0 : value.schema);
}
function cloneSubschemaConfig(subschemaConfig) {
    var _a, _b;
    var newSubschemaConfig = __assign(__assign({}, subschemaConfig), { transforms: subschemaConfig.transforms != null ? __spreadArray([], __read(subschemaConfig.transforms), false) : undefined });
    if (newSubschemaConfig.merge != null) {
        newSubschemaConfig.merge = __assign({}, subschemaConfig.merge);
        for (var typeName in newSubschemaConfig.merge) {
            var mergedTypeConfig = (newSubschemaConfig.merge[typeName] = __assign({}, ((_b = (_a = subschemaConfig.merge) === null || _a === void 0 ? void 0 : _a[typeName]) !== null && _b !== void 0 ? _b : {})));
            if (mergedTypeConfig.entryPoints != null) {
                mergedTypeConfig.entryPoints = mergedTypeConfig.entryPoints.map(function (entryPoint) { return (__assign({}, entryPoint)); });
            }
            if (mergedTypeConfig.fields != null) {
                var fields = (mergedTypeConfig.fields = __assign({}, mergedTypeConfig.fields));
                for (var fieldName in fields) {
                    fields[fieldName] = __assign({}, fields[fieldName]);
                }
            }
        }
    }
    return newSubschemaConfig;
}

function delegateToSchema(options) {
    var info = options.info, schema = options.schema, rootValue = options.rootValue, operationName = options.operationName, _a = options.operation, operation = _a === void 0 ? getDelegatingOperation(info.parentType, info.schema) : _a, _b = options.fieldName, fieldName = _b === void 0 ? info.fieldName : _b, selectionSet = options.selectionSet, fieldNodes = options.fieldNodes, context = options.context;
    var request = createRequestFromInfo({
        info: info,
        operation: operation,
        fieldName: fieldName,
        selectionSet: selectionSet,
        fieldNodes: fieldNodes,
        rootValue: rootValue !== null && rootValue !== void 0 ? rootValue : schema.rootValue,
        operationName: operationName,
        context: context,
    });
    return delegateRequest(__assign(__assign({}, options), { request: request }));
}
function getDelegationReturnType(targetSchema, operation, fieldName) {
    var rootType = getDefinedRootType(targetSchema, operation);
    return rootType.getFields()[fieldName].type;
}
function delegateRequest(options) {
    var delegationContext = getDelegationContext(options);
    var transformer = new Transformer(delegationContext);
    var processedRequest = transformer.transformRequest(options.request);
    if (options.validateRequest) {
        validateRequest(delegationContext, processedRequest.document);
    }
    var executor = getExecutor(delegationContext);
    return new ValueOrPromise(function () { return executor(processedRequest); })
        .then(function (originalResult) {
        if (isAsyncIterable(originalResult)) {
            // "subscribe" to the subscription result and map the result through the transforms
            return mapAsyncIterator(originalResult, function (result) { return transformer.transformResult(result); });
        }
        return transformer.transformResult(originalResult);
    })
        .resolve();
}
function getDelegationContext(_a) {
    var _b, _c, _d, _e;
    var request = _a.request, schema = _a.schema, fieldName = _a.fieldName, returnType = _a.returnType, args = _a.args, info = _a.info, _f = _a.transforms, transforms = _f === void 0 ? [] : _f, transformedSchema = _a.transformedSchema, _g = _a.skipTypeMerging, skipTypeMerging = _g === void 0 ? false : _g;
    var operation = request.operationType, context = request.context, operationName = request.operationName, document = request.document;
    var operationDefinition;
    var targetFieldName;
    if (fieldName == null) {
        operationDefinition = getOperationAST(document, operationName);
        if (operationDefinition == null) {
            throw new Error('Cannot infer main operation from the provided document.');
        }
        targetFieldName = (operationDefinition === null || operationDefinition === void 0 ? void 0 : operationDefinition.selectionSet.selections[0]).name.value;
    }
    else {
        targetFieldName = fieldName;
    }
    var stitchingInfo = (_b = info === null || info === void 0 ? void 0 : info.schema.extensions) === null || _b === void 0 ? void 0 : _b['stitchingInfo'];
    var subschemaOrSubschemaConfig = (_c = stitchingInfo === null || stitchingInfo === void 0 ? void 0 : stitchingInfo.subschemaMap.get(schema)) !== null && _c !== void 0 ? _c : schema;
    if (isSubschemaConfig(subschemaOrSubschemaConfig)) {
        var targetSchema = subschemaOrSubschemaConfig.schema;
        return {
            subschema: schema,
            subschemaConfig: subschemaOrSubschemaConfig,
            targetSchema: targetSchema,
            operation: operation,
            fieldName: targetFieldName,
            args: args,
            context: context,
            info: info,
            returnType: (_d = returnType !== null && returnType !== void 0 ? returnType : info === null || info === void 0 ? void 0 : info.returnType) !== null && _d !== void 0 ? _d : getDelegationReturnType(targetSchema, operation, targetFieldName),
            transforms: subschemaOrSubschemaConfig.transforms != null
                ? subschemaOrSubschemaConfig.transforms.concat(transforms)
                : transforms,
            transformedSchema: transformedSchema !== null && transformedSchema !== void 0 ? transformedSchema : (subschemaOrSubschemaConfig instanceof Subschema ? subschemaOrSubschemaConfig.transformedSchema : targetSchema),
            skipTypeMerging: skipTypeMerging,
        };
    }
    return {
        subschema: schema,
        subschemaConfig: undefined,
        targetSchema: subschemaOrSubschemaConfig,
        operation: operation,
        fieldName: targetFieldName,
        args: args,
        context: context,
        info: info,
        returnType: (_e = returnType !== null && returnType !== void 0 ? returnType : info === null || info === void 0 ? void 0 : info.returnType) !== null && _e !== void 0 ? _e : getDelegationReturnType(subschemaOrSubschemaConfig, operation, targetFieldName),
        transforms: transforms,
        transformedSchema: transformedSchema !== null && transformedSchema !== void 0 ? transformedSchema : subschemaOrSubschemaConfig,
        skipTypeMerging: skipTypeMerging,
    };
}
function validateRequest(delegationContext, document) {
    var errors = validate(delegationContext.targetSchema, document);
    if (errors.length > 0) {
        if (errors.length > 1) {
            var combinedError = new AggregateError(errors);
            throw combinedError;
        }
        var error = errors[0];
        throw error.originalError || error;
    }
}
function getExecutor(delegationContext) {
    var _a, _b;
    var subschemaConfig = delegationContext.subschemaConfig, targetSchema = delegationContext.targetSchema, context = delegationContext.context;
    var executor = (subschemaConfig === null || subschemaConfig === void 0 ? void 0 : subschemaConfig.executor) || createDefaultExecutor(targetSchema);
    if (subschemaConfig === null || subschemaConfig === void 0 ? void 0 : subschemaConfig.batch) {
        var batchingOptions = subschemaConfig === null || subschemaConfig === void 0 ? void 0 : subschemaConfig.batchingOptions;
        executor = getBatchingExecutor((_b = (_a = context !== null && context !== void 0 ? context : globalThis) !== null && _a !== void 0 ? _a : window) !== null && _b !== void 0 ? _b : global, executor, batchingOptions === null || batchingOptions === void 0 ? void 0 : batchingOptions.dataLoaderOptions, batchingOptions === null || batchingOptions === void 0 ? void 0 : batchingOptions.extensionsReducer);
    }
    return executor;
}
var createDefaultExecutor = memoize1(function createDefaultExecutor(schema) {
    return function defaultExecutor(_a) {
        var document = _a.document, context = _a.context, variables = _a.variables, rootValue = _a.rootValue, operationName = _a.operationName, operationType = _a.operationType;
        var executionArgs = {
            schema: schema,
            document: document,
            contextValue: context,
            variableValues: variables,
            rootValue: rootValue,
            operationName: operationName,
        };
        if (operationType === 'subscription') {
            return subscribe(executionArgs);
        }
        return execute(executionArgs);
    };
});

export { Subschema, Transformer, annotateExternalObject, applySchemaTransforms, cloneSubschemaConfig, createDefaultExecutor, createRequest, createRequestFromInfo, defaultMergedResolver, delegateRequest, delegateToSchema, getDelegatingOperation, getSubschema, getUnpathedErrors, isExternalObject, isSubschema, isSubschemaConfig, mergeFields, resolveExternalValue };
