"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStyle = exports.getCornerRadius = exports.getBarWidth = void 0;

var _isPlainObject2 = _interopRequireDefault(require("lodash/isPlainObject"));

var _isNil2 = _interopRequireDefault(require("lodash/isNil"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getBarWidth = function (barWidth, props) {
  var scale = props.scale,
      data = props.data,
      defaultBarWidth = props.defaultBarWidth,
      style = props.style;

  if (barWidth) {
    return _victoryCore.Helpers.evaluateProp(barWidth, props);
  } else if (style.width) {
    return style.width;
  }

  var range = scale.x.range();
  var extent = Math.abs(range[1] - range[0]);
  var bars = data.length + 2;
  var barRatio = props.barRatio || 0.5;
  var defaultWidth = barRatio * (data.length < 2 ? defaultBarWidth : extent / bars);
  return Math.max(1, defaultWidth);
};

exports.getBarWidth = getBarWidth;

var getCornerRadiusFromObject = function (cornerRadius, props) {
  var realCornerRadius = {
    topLeft: 0,
    topRight: 0,
    bottomLeft: 0,
    bottomRight: 0
  };

  var updateCornerRadius = function (corner, fallback) {
    if (!(0, _isNil2.default)(cornerRadius[corner])) {
      realCornerRadius[corner] = _victoryCore.Helpers.evaluateProp(cornerRadius[corner], props);
    } else if (!(0, _isNil2.default)(cornerRadius[fallback])) {
      realCornerRadius[corner] = _victoryCore.Helpers.evaluateProp(cornerRadius[fallback], props);
    }
  };

  updateCornerRadius("topLeft", "top");
  updateCornerRadius("topRight", "top");
  updateCornerRadius("bottomLeft", "bottom");
  updateCornerRadius("bottomRight", "bottom");
  return realCornerRadius;
};

var getCornerRadius = function (cornerRadius, props) {
  var realCornerRadius = {
    topLeft: 0,
    topRight: 0,
    bottomLeft: 0,
    bottomRight: 0
  };

  if (!cornerRadius) {
    return realCornerRadius;
  }

  if ((0, _isPlainObject2.default)(cornerRadius)) {
    return getCornerRadiusFromObject(cornerRadius, props);
  } else {
    realCornerRadius.topLeft = _victoryCore.Helpers.evaluateProp(cornerRadius, props);
    realCornerRadius.topRight = _victoryCore.Helpers.evaluateProp(cornerRadius, props);
    return realCornerRadius;
  }
};

exports.getCornerRadius = getCornerRadius;

var getStyle = function () {
  var style = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var props = arguments.length > 1 ? arguments[1] : undefined;

  if (props.disableInlineStyles) {
    return {};
  }

  var stroke = style.fill || "black";
  var baseStyle = {
    fill: "black",
    stroke: stroke
  };
  return _victoryCore.Helpers.evaluateStyle((0, _assign2.default)(baseStyle, style), props);
};

exports.getStyle = getStyle;