"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmSearchbar = void 0;
var react_1 = __importStar(require("react"));
var react_tag_autocomplete_1 = __importDefault(require("react-tag-autocomplete"));
var times_circle_icon_1 = __importDefault(require("@patternfly/react-icons/dist/js/icons/times-circle-icon"));
var help_icon_1 = __importDefault(require("@patternfly/react-icons/dist/js/icons/help-icon"));
var search_icon_1 = __importDefault(require("@patternfly/react-icons/dist/js/icons/search-icon"));
require("./AcmSearchbar.css");
var helper_1 = require("./helper");
var operators = ['=', '<', '>', '<=', '>=', '!=', '!'];
function AcmSearchbar(props) {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
    var reactTags = react_1.default.createRef();
    var loadingSuggestions = props.loadingSuggestions, suggestions = props.suggestions, queryString = props.queryString, currentQueryCallback = props.currentQueryCallback, toggleInfoModal = props.toggleInfoModal;
    var _a = react_1.useState(queryString), currentQuery = _a[0], setCurrentQuery = _a[1];
    var _b = react_1.useState(helper_1.convertStringToTags(currentQuery)), searchbarTags = _b[0], setSearchbarTags = _b[1];
    // rerender component with new props after initial load
    react_1.useEffect(function () {
        setCurrentQuery(queryString);
        setSearchbarTags(helper_1.convertStringToTags(queryString));
    }, [queryString]);
    return (react_1.default.createElement("div", { className: 'searchbar-container' },
        react_1.default.createElement(react_tag_autocomplete_1.default, { ref: reactTags, placeholderText: currentQuery === '' ? 'Search items' : '', tags: searchbarTags, suggestions: loadingSuggestions !== true ? suggestions : [{ id: 'loading', name: 'Loading...', disabled: true }], suggestionsFilter: function (suggestion, query) {
                return suggestion.name.toLowerCase().includes(query.toLowerCase());
            }, onDelete: function (idx) {
                if (idx >= 0) {
                    // need to check if there are 2+ values @ tag[idx] - if there are we only delete the last one
                    var tagToDelete = searchbarTags[idx];
                    if (tagToDelete.name.includes(',')) {
                        var values = tagToDelete.name.split(',');
                        values.splice(values.length - 1, 1);
                        tagToDelete.name = values.join(',');
                    }
                    else {
                        searchbarTags.splice(idx, 1);
                    }
                    setCurrentQuery(searchbarTags.map(function (tag) { return tag.name; }).join(' '));
                    currentQueryCallback(searchbarTags.map(function (tag) { return tag.name; }).join(' '));
                    setSearchbarTags(searchbarTags);
                }
            }, onAddition: function (tag) {
                if ((!tag.id && tag.name === '') ||
                    (operators.some(function (operator) { return currentQuery.endsWith(operator); }) &&
                        isNaN(parseInt(tag.name, 10)))) {
                    // don't allow blank tags to be added to searchbar
                    // don't allow non-ints to be added when using an operator
                    return;
                }
                if (tag.kind === 'filter') {
                    var newQueryString = "" + (currentQuery === '' ? '' : currentQuery + " ") + tag.name + ":";
                    setCurrentQuery(newQueryString);
                    currentQueryCallback(newQueryString);
                    setSearchbarTags(helper_1.convertStringToTags(newQueryString));
                }
                else if (tag.kind === 'value' || currentQuery.endsWith(':')) {
                    var newQueryString = "" + currentQuery + tag.name;
                    var tags_1 = helper_1.convertStringToTags(newQueryString);
                    if (tags_1.length > 1) {
                        var lastTag_1 = tags_1[tags_1.length - 1];
                        tags_1.forEach(function (t, idx) {
                            if (idx !== tags_1.length - 1 &&
                                lastTag_1 &&
                                t.name.split(':')[0] === lastTag_1.name.split(':')[0]) {
                                t.name = t.name + "," + lastTag_1.name.split(':')[1];
                                tags_1.pop();
                            }
                            return t;
                        });
                    }
                    setCurrentQuery(tags_1.map(function (t) { return t.name; }).join(' '));
                    currentQueryCallback(tags_1.map(function (t) { return t.name; }).join(' '));
                    setSearchbarTags(tags_1);
                }
                else if (operators.some(function (operator) { return currentQuery.endsWith(operator); }) &&
                    !isNaN(parseInt(tag.name, 10))) {
                    // case for user adding a number after operator
                    var newQueryString = "" + currentQuery + tag.name;
                    var tags = helper_1.convertStringToTags(newQueryString);
                    setCurrentQuery(tags.map(function (t) { return t.name; }).join(' '));
                    currentQueryCallback(tags.map(function (t) { return t.name; }).join(' '));
                    setSearchbarTags(tags);
                }
                else {
                    // adding a keyword - not an item from dropdown suggestions
                    var newQueryString = "" + (currentQuery === '' ? '' : currentQuery + " ") + tag.name;
                    setCurrentQuery(newQueryString);
                    currentQueryCallback(newQueryString);
                    setSearchbarTags(helper_1.convertStringToTags(newQueryString));
                }
            }, noSuggestionsText: 'No matching filters', autoresize: true, minQueryLength: 0, allowNew: true, delimiters: [' ', ':', ',', 'Enter'], maxSuggestionsLength: Number.MAX_SAFE_INTEGER }),
        react_1.default.createElement(times_circle_icon_1.default, { id: 'clear-all-search-tags-button', className: 'clear-button', onClick: function () {
                setCurrentQuery('');
                currentQueryCallback('');
                setSearchbarTags([]);
                reactTags.current.clearInput();
            }, noVerticalAlign: true, title: 'Remove current search tags' }),
        react_1.default.createElement(help_icon_1.default, { id: 'toggle-searchbar-help-button', className: 'help-button', onClick: toggleInfoModal, noVerticalAlign: true, title: 'Open help modal' }),
        react_1.default.createElement(search_icon_1.default, { className: 'search-icon', noVerticalAlign: true })));
}
exports.AcmSearchbar = AcmSearchbar;
//# sourceMappingURL=AcmSearchbar.js.map